/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.EntityParseHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class WriteOffRecordHelper {
    public static BackWriteOffDetail getWfInfo(DynamicObject record) {
        String headWfInfo = record.getString("headwfinfo_tag");
        BackWriteOffDetail backWriteOffDetail = (BackWriteOffDetail)JSONObject.parseObject((String)headWfInfo, BackWriteOffDetail.class);
        return backWriteOffDetail;
    }

    public static Boolean hasAutoBill(DynamicObject record, List<Object> ids) {
        String headWfInfo = record.getString("headwfinfo_tag");
        BackWriteOffDetail backWriteOffDetail = (BackWriteOffDetail)JSONObject.parseObject((String)headWfInfo, BackWriteOffDetail.class);
        if (backWriteOffDetail == null || backWriteOffDetail.getAutoList() == null) {
            return Boolean.FALSE;
        }
        List collect = backWriteOffDetail.getAutoList().stream().filter(n -> ids.contains(n.getBillId())).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(collect);
    }

    public static WriteoffTemplateTypeEnum getWfTemplateTypeByChildEntity(String recordTypeName) {
        MainEntityType inheritEntity = EntityParseHelper.getInheritEntity(recordTypeName);
        if (inheritEntity != null) {
            return WriteOffRecordHelper.getWfTemplateTypeByEntity(inheritEntity.getName());
        }
        return null;
    }

    public static WriteoffTemplateTypeEnum getWfTemplateTypeByEntity(String entity) {
        if ("msmod_leftrighwfrecordtpl".equals(entity) || "msmod_leftrtamounttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT;
        }
        if ("msmod_updownwfrecordtpl".equals(entity) || "msmod_updownamounttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN;
        }
        if ("msmod_mainassisttpl".equals(entity)) {
            return WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST;
        }
        return null;
    }

    public static Collection<String> getAllWFRecordEntity() {
        String sql = "select   a.fnumber   from t_meta_formdesign  a  where a.finheritpath in (select  b.fid from t_meta_formdesign b where  b.fnumber in ('msmod_updownwfrecordtpl','msmod_leftrighwfrecordtpl','msmod_leftrtamounttpl','msmod_mainassisttpl','msmod_updownamounttpl'))";
        DataSet data = DB.queryDataSet((String)WriteOffRecordHelper.class.getName(), (DBRoute)DBRoute.meta, (String)sql);
        ArrayList<String> list = new ArrayList<String>(16);
        while (data.hasNext()) {
            String billType = data.next().getString("fnumber");
            list.add(billType);
        }
        return list;
    }

    public static DynamicObject cloneRecord(DynamicObject oldRecordInfo, String recordEntityNum) {
        DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)recordEntityNum);
        DynamicObjectUtil.copy(oldRecordInfo, newRecord);
        return newRecord;
    }
}

