/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteBackRuleConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.EntryBackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.WriteBackSqlEntity;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class WriteOffWriteBackHelper {
    public static WriteBackSqlEntity writeBack(WriteBackRuleConfig writeBackRuleConfig, WriteOffObjectBase writeOffObject, DynamicObject recordEntry, EntryBackWriteOffDetail.BackWriteDetail detail) {
        String sourceColumn = writeBackRuleConfig.getSourceColumn();
        String[] sourceColumnSegments = sourceColumn.split("\\.");
        String columnSegment = sourceColumnSegments[sourceColumnSegments.length - 1];
        if (writeBackRuleConfig.getAssignType().equals("0")) {
            return WriteOffWriteBackHelper.writeBackByColumn(writeBackRuleConfig, recordEntry, writeOffObject, columnSegment, detail);
        }
        return WriteOffWriteBackHelper.writeBackByExpression(writeBackRuleConfig, recordEntry, writeOffObject, columnSegment, detail);
    }

    private static WriteBackSqlEntity writeBackByColumn(WriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, WriteOffObjectBase srcObject, String columnSegment, EntryBackWriteOffDetail.BackWriteDetail detail) {
        String[] recordColumnSegments = writeBackConfig.getRecordColumn().split("\\.");
        if (recordEntry.getParent() == null) {
            return WriteOffWriteBackHelper.buildMainAssWriteSqls(writeBackConfig, recordEntry, srcObject, columnSegment, detail);
        }
        Object value = WriteOffWriteBackHelper.getEntryRecordValue(recordEntry, recordColumnSegments);
        return WriteOffWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
    }

    private static WriteBackSqlEntity buildMainAssWriteSqls(WriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, WriteOffObjectBase srcObject, String columnSegment, EntryBackWriteOffDetail.BackWriteDetail detail) {
        Object value = WriteOffWriteBackHelper.getHeadRecordValue(recordEntry, writeBackConfig.getRecordColumn());
        if (value instanceof Object[]) {
            Object[] results = (Object[])value;
            String writeBackType = writeBackConfig.getWriteBackType();
            Object mergeResult = WriteOffWriteBackHelper.mergeValueByWbType(writeBackType, results);
            return WriteOffWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, mergeResult, detail);
        }
        return WriteOffWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
    }

    public static Object mergeValueByWbType(String writeBackType, Object ... results) {
        if (results.length == 0) {
            return null;
        }
        if (results.length == 1) {
            return results[0];
        }
        if (results.length > 1) {
            if (writeBackType.equals("0") || writeBackType.equals("1")) {
                BigDecimal count = BigDecimal.ZERO;
                for (Object object : results) {
                    if (!(object instanceof BigDecimal)) continue;
                    count = count.add((BigDecimal)object);
                }
                return count;
            }
            return results[results.length - 1];
        }
        return null;
    }

    private static Object getHeadRecordValue(DynamicObject recordEntry, String recordColumnSegments) {
        RowDataModel billEntry = CommonUtils.getBillEntry(recordEntry);
        return billEntry.getValue(recordColumnSegments);
    }

    private static Object getEntryRecordValue(DynamicObject recordEntry, String[] recordColumnSegments) {
        Object value;
        if (recordColumnSegments.length > 1) {
            value = recordEntry.get(recordColumnSegments[1]);
        } else {
            DynamicObject parent = (DynamicObject)recordEntry.getParent();
            value = parent.get(recordColumnSegments[0]);
        }
        return value;
    }

    private static WriteBackSqlEntity writeBackByExpression(WriteBackRuleConfig writeBackConfig, DynamicObject recordEntry, WriteOffObjectBase srcObject, String columnSegment, EntryBackWriteOffDetail.BackWriteDetail detail) {
        Object value = WriteOffWriteBackHelper.buildValue(writeBackConfig, recordEntry);
        return WriteOffWriteBackHelper.writeBackMethod(writeBackConfig, srcObject, columnSegment, value, detail);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WriteBackSqlEntity writeBackMethod(WriteBackRuleConfig writeBackConfig, WriteOffObjectBase writeOffObjectBase, String columnSegment, Object value, EntryBackWriteOffDetail.BackWriteDetail detail) {
        Object pkValue;
        String pkField;
        String tableName = writeBackConfig.getWbBillTableName();
        IDataEntityProperty property = writeBackConfig.getWbBillProperty();
        String tableGroup = property.getTableGroup();
        String alias = property.getAlias();
        if (writeBackConfig.isWbBillHeadProp()) {
            pkField = writeOffObjectBase.getBillPkField();
            pkValue = writeOffObjectBase.getWfBillPk();
        } else {
            pkField = writeOffObjectBase.getPkField();
            pkValue = writeOffObjectBase.getPkValue();
        }
        if (StringUtils.isNotEmpty((CharSequence)tableGroup)) {
            tableName = tableName + "_" + tableGroup;
        }
        String writeBackType = writeBackConfig.getWriteBackType();
        if (value instanceof BigDecimal) {
            BigDecimal writeBackValue = (BigDecimal)value;
            if (detail.isRedBlue()) {
                writeBackValue = BigDecimal.ZERO.subtract(writeBackValue);
            }
            if (writeBackType.equals("0")) {
                if ("1".equals(detail.getFlag())) {
                    String rollbackSql = "update " + tableName + " set " + alias + " = " + alias + " -  ?  where " + pkField + " = ? ;";
                    detail.setRollbackSql(rollbackSql);
                    Object[] objects = new Object[]{writeBackValue, pkValue};
                    detail.setSqlParam(objects);
                }
                detail.setBillField(columnSegment);
                detail.setValue(writeBackValue);
                detail.setWriteBackType("0");
                return new WriteBackSqlEntity(tableName, alias, value, writeBackType, pkField, pkValue);
            } else if (writeBackType.equals("1")) {
                if ("1".equals(detail.getFlag())) {
                    String rollbackSql = "update " + tableName + " set " + alias + " = " + alias + " + ?  where " + pkField + " = ? ;";
                    detail.setRollbackSql(rollbackSql);
                    Object[] objects = new Object[]{writeBackValue, pkValue};
                    detail.setSqlParam(objects);
                }
                detail.setBillField(columnSegment);
                detail.setValue(writeBackValue);
                detail.setWriteBackType("1");
                return new WriteBackSqlEntity(tableName, alias, value, writeBackType, pkField, pkValue);
            } else {
                if (!writeBackType.equals("2")) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5199\u65b9\u5f0f(%s)\u4e0d\u5b58\u5728\u3002", (String)"WfSnapShootHolder_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), writeBackType));
                Object srcValue = writeOffObjectBase.getValue(columnSegment);
                if ("1".equals(detail.getFlag())) {
                    Object[] param = new Object[]{srcValue, pkValue};
                    String sql = "update " + tableName + " set " + alias + " = ? where " + pkField + " = ?;";
                    detail.setRollbackSql(sql);
                    detail.setSqlParam(param);
                }
                detail.setCoverOldValue(srcValue);
                detail.setBillField(columnSegment);
                detail.setCoverValue(writeBackValue.toPlainString());
                detail.setWriteBackType("2");
            }
            return new WriteBackSqlEntity(tableName, alias, value, writeBackType, pkField, pkValue);
        } else {
            if (!writeBackType.equals("2")) throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6570\u5b57\u7c7b\u578b\u5b57\u6bb5\u4e0d\u80fd\u4f7f\u7528\u7d2f\u52a0\u3001\u7d2f\u51cf\u53cd\u5199\u65b9\u5f0f\u3002", (String)"WfSnapShootHolder_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            Object writeBackValue = WriteOffWriteBackHelper.getFieldValue(value);
            Object srcValue = writeOffObjectBase.getValue(columnSegment);
            Object oldWriteBackValue = WriteOffWriteBackHelper.getFieldValue(srcValue);
            if ("1".equals(detail.getFlag())) {
                String sql = "update " + tableName + " set " + alias + " = ? where " + pkField + " = ?;";
                Object[] param = new Object[]{oldWriteBackValue, pkValue};
                detail.setRollbackSql(sql);
                detail.setSqlParam(param);
            }
            detail.setCoverOldValue(oldWriteBackValue);
            detail.setBillField(columnSegment);
            detail.setCoverValue(writeBackValue);
            detail.setWriteBackType("2");
        }
        return new WriteBackSqlEntity(tableName, alias, value, writeBackType, pkField, pkValue);
    }

    private static Object getFieldValue(Object value) {
        Object writeBackValue = value;
        if (value instanceof DynamicObject) {
            writeBackValue = ((DynamicObject)value).getPkValue();
        }
        return writeBackValue;
    }

    private static Object buildValue(WriteBackRuleConfig writeBackConfig, DynamicObject recordEntry) {
        String expression = writeBackConfig.getExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)expression, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        for (String column : columns) {
            String entryName = recordEntry.getDataEntityType().getName();
            DynamicObject parent = (DynamicObject)recordEntry.getParent();
            BillEntityType type = (BillEntityType)parent.getDataEntityType();
            RowDataModel rowDataModel = new RowDataModel(entryName, (MainEntityType)type);
            rowDataModel.setRowContext(recordEntry);
            args.put(column, rowDataModel.getValue(column));
        }
        Object result = FormulaEngine.execExcelFormula((String)condition.getExpression(), args);
        return result;
    }
}

