/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.lock;

import java.util.Collection;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffNLogInfo;
import kd.mpscmm.mscommon.writeoff.common.lock.MutexLockUtils;

public class BizLocker
implements AutoCloseable {
    private final Collection<String> needLockIds;
    private WriteOffNLogInfo writeOffLog;
    private boolean isNetCtr = true;

    public BizLocker(Collection<String> needLockIds, WriteOffNLogInfo writeOffLog, boolean isNetCtr) {
        this.needLockIds = needLockIds;
        this.writeOffLog = writeOffLog;
        this.isNetCtr = isNetCtr;
    }

    public static BizLocker create(Collection<String> needLockIds, WriteOffNLogInfo writeOffLog, boolean isNetCtr) {
        BizLocker locker = new BizLocker(needLockIds, writeOffLog, isNetCtr);
        locker.doLock();
        return locker;
    }

    private void doLock() {
        if (this.isNetCtr) {
            MutexLockUtils.doLock(this.needLockIds, this.writeOffLog);
        }
    }

    public void doLock(Collection<String> needLockIds) {
        if (this.isNetCtr) {
            needLockIds.removeAll(this.needLockIds);
            if (!needLockIds.isEmpty()) {
                MutexLockUtils.doLock(needLockIds, this.writeOffLog);
            }
            this.needLockIds.addAll(needLockIds);
        }
    }

    @Override
    public void close() {
        this.doRelease();
    }

    public void doRelease() {
        MutexLockUtils.releaseLock(this.needLockIds);
    }
}

