/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.lock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.mpscmm.mscommon.writeoff.common.util.WfConnectUtil;

public class MutexLockHelper {
    private static final Log logger = LogFactory.getLog(MutexLockHelper.class);
    private static final String DATA_OBJ_ID = "dataObjId";
    private static final String GROUP_ID = "groupId";
    private static final String ENTITY_KEY = "entityKey";
    private static final String OPERATION_KEY = "operationKey";
    private static final String IS_STRICT = "isStrict";
    private static final String GROUP_ID_DEFAULT = "default_netctrl";

    public static void requireMutex(String entityKey, Set<Long> billIds, String operationKey, boolean isStrict, Set<Long> failIdSet, Map<String, Set<Long>> successIds, String errorInfo) {
        ArrayList mutexRequireList = new ArrayList(billIds.size());
        for (Long billId : billIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(DATA_OBJ_ID, billId.toString());
            requireParam.put(GROUP_ID, GROUP_ID_DEFAULT);
            requireParam.put(ENTITY_KEY, entityKey);
            requireParam.put(OPERATION_KEY, operationKey);
            requireParam.put(IS_STRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();
             TXHandle tx = TX.requiresNew();){
            boolean isLockError = false;
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean required = (Boolean)mutexItem.getValue();
                if (!required.booleanValue()) {
                    failIdSet.add(Long.parseLong(objId));
                    logger.info("\u52a0\u9501\u5931\u8d25: key:" + objId);
                    isLockError = true;
                    continue;
                }
                successIds.get(entityKey).add(Long.parseLong(objId));
            }
            if (isLockError) {
                throw new KDBizException(errorInfo);
            }
        }
        catch (IOException exception) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", WfConnectUtil.strConnect(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:", (String)"MutexLockHelper_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), exception.getMessage()));
            throw new KDException((Throwable)exception, ec, new Object[0]);
        }
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs, String operationKey) {
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityNumber;
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(DATA_OBJ_ID, lockID.toString());
                requireParam.put(GROUP_ID, GROUP_ID_DEFAULT);
                requireParam.put(ENTITY_KEY, entityNumber);
                requireParam.put(OPERATION_KEY, operationKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();
                 TXHandle tx = TX.requiresNew();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException exception) {
                throw new KDException((Throwable)exception, new ErrorCode("MUTEX_RELEASE_ERROR", WfConnectUtil.strConnect(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519.", (String)"MutexLockHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), exception.getMessage())), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean requireMutex(String entityName, String key, String operationKey) {
        DataMutex dataMutex = null;
        try {
            boolean bl;
            Throwable throwable;
            TXHandle tx;
            block24: {
                block25: {
                    tx = TX.requiresNew();
                    throwable = null;
                    dataMutex = DataMutex.create();
                    bl = dataMutex.require(key, RuntimeMetaType.NetCtrlOperate + "." + entityName, entityName, operationKey);
                    if (tx == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                tx.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    logger.info("require mutex lock error :" + e);
                }
            }
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.info("mutex lock close error :" + e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean releaseMutex(String entityName, String key, String operationKey) {
        DataMutex dataMutex = null;
        try {
            boolean bl;
            Throwable throwable;
            TXHandle tx;
            block24: {
                block25: {
                    tx = TX.requiresNew();
                    throwable = null;
                    dataMutex = DataMutex.create();
                    bl = dataMutex.release(key, entityName, operationKey);
                    if (tx == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                tx.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    logger.info("require mutex release error :" + e);
                }
            }
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.info("mutex release lock close error :" + e);
                }
            }
        }
        return false;
    }
}

