/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class WriteOffExeucteInfo {
    private Map<Long, String> schemeInfos = new HashMap<Long, String>(16);
    private Map<String, Map<String, Set<Object>>> erroInfoEntryIds = new HashMap<String, Map<String, Set<Object>>>(16);
    private Map<String, List<String>> executeFailInfos = new HashMap<String, List<String>>(16);

    public void addInfo(List<WriteOffObject> wfObjs, Long schemeId, String failReason) {
        for (WriteOffObject wfObj : wfObjs) {
            this.addInfo(wfObj.getWriteOffBillPk(), wfObj.getTypeConfig().getId(), wfObj.getWriteOffObjectPk(), schemeId, failReason);
        }
    }

    public void addInfo(List<WriteOffObject> wfObjs, String failReason) {
        this.addInfo(wfObjs, (Long)0L, failReason);
    }

    public void addInfos(DynamicObject[] objs, String failReason) {
        for (DynamicObject obj : objs) {
            this.addInfo(obj.getPkValue(), 0L, 0L, 0L, failReason);
        }
    }

    public void addInfos(Collection<Object> billIds, String failReason) {
        for (Object objId : billIds) {
            this.addInfo(objId, 0L, 0L, 0L, failReason);
        }
    }

    public void addInfo(Object billId, String failReason) {
        this.addInfo(billId, 0L, 0L, 0L, failReason);
    }

    public void addInfo(Object billId, Long wftTypeId, String failReason) {
        this.addInfo(billId, wftTypeId, 0L, 0L, failReason);
    }

    public void addInfo(Object billId, Long wfTypeId, Object wfObjId, Long wfSchemeId, String failReason) {
        if (Long.compare(wfSchemeId, 0L) != 0) {
            this.schemeInfos.put(wfSchemeId, failReason);
            return;
        }
        String key = this.buildKey(billId, wfTypeId);
        if (wfObjId != null && Long.compare((Long)wfObjId, 0L) != 0) {
            Map<String, Set<Object>> erroInfos = MapUtils.mapGetMapValue(this.erroInfoEntryIds, key);
            MapUtils.mapGetSetValue(erroInfos, failReason).add(wfObjId);
        } else {
            MapUtils.mapGetListValue(this.executeFailInfos, key).add(failReason);
        }
    }

    public List<String> getBillInfoByBillId(Object billId) {
        return this.executeFailInfos.get(this.buildKey(billId, 0L));
    }

    public List<String> getInfoByBillId(Object billId) {
        ArrayList<String> infos = new ArrayList<String>(16);
        for (Map.Entry<String, List<String>> infoEntry : this.executeFailInfos.entrySet()) {
            if (!infoEntry.getKey().startsWith(String.valueOf(billId))) continue;
            infos.addAll((Collection<String>)infoEntry.getValue());
        }
        return infos;
    }

    private String buildKey(Object billId, Long wfTypeId) {
        StringBuilder str = new StringBuilder();
        str.append(String.valueOf(billId));
        str.append("-");
        str.append(wfTypeId);
        return str.toString();
    }

    public Map<Long, String> getSchemeInfos() {
        return this.schemeInfos;
    }

    public Map<String, List<String>> getExecuteFailInfos() {
        return this.executeFailInfos;
    }

    public Map<String, Map<String, Set<Object>>> getErroInfoEntryIds() {
        return this.erroInfoEntryIds;
    }

    public String exportErroInfo() {
        Map<Long, String> map;
        Map<String, Map<String, Set<Object>>> erroInfoEntryIds;
        StringBuilder str = new StringBuilder();
        Map<String, List<String>> exeucteFailInfos = this.getExecuteFailInfos();
        if (!exeucteFailInfos.isEmpty()) {
            str.append("billId - wftypeId\n");
            for (Map.Entry<String, List<String>> entry : exeucteFailInfos.entrySet()) {
                str.append(entry.getKey());
                str.append(" : ");
                str.append(String.valueOf(entry.getValue()));
                str.append("\n");
            }
        }
        if (!(erroInfoEntryIds = this.getErroInfoEntryIds()).isEmpty()) {
            str.append("billId - wftypeId - erroInfo - entryInfo\n");
            for (Map.Entry<String, Map<String, Set<Object>>> entry : erroInfoEntryIds.entrySet()) {
                for (Map.Entry<String, Set<Object>> erroInfo : entry.getValue().entrySet()) {
                    str.append(entry.getKey());
                    str.append(" - ");
                    str.append(erroInfo.getKey());
                    str.append(" : ");
                    Set<Object> erroEntryIds = erroInfo.getValue();
                    if (erroEntryIds.size() > 100) {
                        HashSet<Object> preEntryIds = new HashSet<Object>(100);
                        for (Object erroEntry : erroEntryIds) {
                            if (preEntryIds.size() >= 100) break;
                            preEntryIds.add(erroEntry);
                        }
                        str.append(String.valueOf(preEntryIds));
                        str.append("\u2026\u2026pre 100");
                    } else {
                        str.append(String.valueOf(erroEntryIds));
                    }
                    str.append("\n");
                }
            }
        }
        if (!(map = this.getSchemeInfos()).isEmpty()) {
            str.append("schemeId - erroInfo\n");
            for (Map.Entry<Long, String> schemeInfo : map.entrySet()) {
                str.append(schemeInfo.getKey());
                str.append(" : ");
                str.append(schemeInfo.getValue());
                str.append("\n");
            }
        }
        return str.toString();
    }
}

