/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;

public class BotpLinkHelper {
    private static final Log logger = LogFactory.getLog(BotpLinkHelper.class);

    public static void addBillLink(DynamicObject sourceBill, DynamicObject targetBill) {
        BotpLinkHelper.buildBillLink(sourceBill, targetBill, false);
    }

    public static void buildBillLink(DynamicObject sourceBill, DynamicObject targetBill, boolean isClear) {
        String name;
        if (sourceBill == null || targetBill == null) {
            return;
        }
        Object sourceBillid = sourceBill.getPkValue();
        BillEntityType dataEntityType = (BillEntityType)targetBill.getDataEntityType();
        String lkName = BotpLinkHelper.getLkName(dataEntityType, name = dataEntityType.getName());
        if (lkName == null) {
            return;
        }
        logger.info(name + "\u7684lk\u8868\u4e3a" + lkName);
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBill.get(lkName);
        if (isClear) {
            BotpLinkHelper.clearBillLink(targetBill);
            BotpLinkHelper.clearBillEntryLink(targetBill, "billentry");
        }
        DynamicObject linkRow = linkRows.addNew();
        linkRow.set("billhead_lk_sbillid", sourceBillid);
        linkRow.set("billhead_lk_sid", sourceBillid);
    }

    public static String buildUpBillId(DynamicObject sourceBill, String entryKey) {
        HashSet<String> ids = new HashSet<String>(16);
        if (sourceBill == null) {
            return "";
        }
        String billEntity = sourceBill.getDataEntityType().getName();
        if (billEntity.equals(entryKey)) {
            return "";
        }
        DynamicObjectCollection billentry = sourceBill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : billentry) {
            String name = entry.getDynamicObjectType().getName();
            BillEntityType parent = (BillEntityType)entry.getDynamicObjectType().getParent();
            String entryLkName = BotpLinkHelper.getLkName(parent, name);
            if (entryLkName == null) {
                logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
                return "";
            }
            DynamicObjectCollection billentryLk = (DynamicObjectCollection)entry.get(entryLkName);
            for (DynamicObject lk : billentryLk) {
                Object pkValue = lk.get("billentry_lk_sbillid");
                String writeOffKey = CommonUtils.getWfBillKey(billEntity, pkValue);
                ids.add(writeOffKey);
            }
        }
        if (ids.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u539f\u59cb\u5355\u636e\u3002", (String)"WfSnapShootHolder_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        if (ids.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u5355\u8054\u5408\u4e0b\u63a8\u3002", (String)"notsupportmultipush", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        String[] keys = ids.toArray(new String[ids.size()]);
        return keys[0];
    }

    public static void clearBillLink(DynamicObject targetBill) {
        String name;
        BillEntityType dataEntityType = (BillEntityType)targetBill.getDataEntityType();
        String lkName = BotpLinkHelper.getLkName(dataEntityType, name = dataEntityType.getName());
        if (lkName == null) {
            logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
            return;
        }
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBill.get(lkName);
        linkRows.clear();
    }

    private static String getLkName(BillEntityType dataEntityType, String entryName) {
        Map entities = dataEntityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            String parentName;
            if (!(entryEntityType instanceof LinkEntryType) || !entryName.equals(parentName = entryEntityType.getParent().getName())) continue;
            return entryEntityType.getName();
        }
        return null;
    }

    public static void clearBillEntryLink(DynamicObject targetBill, String entryKey) {
        DynamicObjectCollection billentries = targetBill.getDynamicObjectCollection(entryKey);
        BotpLinkHelper.clearBillEntryLink(billentries);
    }

    public static void clearBillEntryLink(DynamicObjectCollection billentries) {
        String name = billentries.getDynamicObjectType().getName();
        BillEntityType parent = (BillEntityType)billentries.getDynamicObjectType().getParent();
        String lkName = BotpLinkHelper.getLkName(parent, name);
        if (lkName == null) {
            logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
            return;
        }
        for (DynamicObject billentry : billentries) {
            DynamicObjectCollection linkEntryRows = (DynamicObjectCollection)billentry.get(lkName);
            linkEntryRows.clear();
        }
    }

    @Deprecated
    public static boolean isUplinkedBillByCurBillId(Long curId, String curEntity, Long srcId, String srcEntity) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)srcEntity, (String)srcEntity);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)"", (Long[])new Long[]{curId});
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return false;
        }
        List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(curId) == 0).collect(Collectors.toList());
        for (BFRowLinkUpNode node : nodes) {
            List<BFRowLinkUpNode> sourceNodes = BotpLinkHelper.findSourceNodes(node, upTableId, curId);
            Set ids = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toSet());
            if (!ids.contains(srcId)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static Set<String> findSrcBillid2TargetBillidSet(Long[] curIds, String curEntity, String srcEntity) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)srcEntity, (String)srcEntity);
        Long upTableId = tableDefine.getTableId();
        HashSet<String> resultSet = new HashSet<String>(16);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (Long[])curIds, (OperateOption)OperateOption.create());
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultSet;
        }
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRowLinkUpNodes) {
            Long curId = bfRowLinkUpNode.getRowId().getBillId();
            List<BFRowLinkUpNode> sourceNodes = BotpLinkHelper.findSourceNodes(bfRowLinkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                resultSet.add(sourceNode.getRowId().getBillId() + "#" + curId);
            }
        }
        return resultSet;
    }

    public static Set<String> findSrcBillid2TargetBillidSet(Long[] curIds, Long[] curEntryIds, String curEntity, String srcEntity) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)srcEntity, (String)srcEntity);
        Long upTableId = tableDefine.getTableId();
        HashSet<String> resultSet = new HashSet<String>(16);
        String curEntryKey = BotpLinkHelper.getCurEntryKey(curEntity);
        logger.info("curEntryKey" + curEntryKey);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])curIds, (Long[])curEntryIds, null);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultSet;
        }
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRowLinkUpNodes) {
            Long curId = bfRowLinkUpNode.getRowId().getBillId();
            List<BFRowLinkUpNode> sourceNodes = BotpLinkHelper.findSourceNodes(bfRowLinkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                resultSet.add(sourceNode.getRowId().getBillId() + "#" + curId);
            }
        }
        logger.info("resultSet" + resultSet);
        return resultSet;
    }

    public static Map<Long, Set<String>> findSrcBillid2TargetBillAndEntryIdSet(Long[] curIds, Long[] curEntryIds, String curEntity, String srcEntity) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)srcEntity, (String)srcEntity);
        Long upTableId = tableDefine.getTableId();
        HashMap<Long, Set<String>> srcTargetIdMap = new HashMap<Long, Set<String>>(16);
        String curEntryKey = BotpLinkHelper.getCurEntryKey(curEntity);
        logger.info("curEntryKey" + curEntryKey);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])curIds, (Long[])curEntryIds, null);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return srcTargetIdMap;
        }
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRowLinkUpNodes) {
            Long curId = bfRowLinkUpNode.getRowId().getBillId();
            List<BFRowLinkUpNode> sourceNodes = BotpLinkHelper.findSourceNodes(bfRowLinkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                HashSet<String> srcIdSet = (HashSet<String>)srcTargetIdMap.get(curId);
                if (srcIdSet == null) {
                    srcIdSet = new HashSet<String>(16);
                }
                srcIdSet.add(sourceNode.getRowId().getBillId() + "#" + sourceNode.getRowId().getEntryId());
                srcTargetIdMap.put(curId, srcIdSet);
            }
        }
        logger.info("srcTargetIdMap" + srcTargetIdMap);
        return srcTargetIdMap;
    }

    private static String getCurEntryKey(String curEntity) {
        if (StringUtils.isEmpty((CharSequence)curEntity)) {
            return "";
        }
        switch (curEntity) {
            case "ap_finapbill": {
                return "detailentry";
            }
            case "ar_revcfmbill": {
                return "entry";
            }
            case "im_purinbill": 
            case "im_ospurinbill": 
            case "im_purreceivebill": 
            case "im_mdc_purreceivebill": 
            case "im_saloutbill": 
            case "im_mdc_ominbill": 
            case "im_mdc_omfeedorder": 
            case "im_mdc_omreturnorder": 
            case "im_mdc_omproorder": 
            case "im_mdc_omcmplinbill": 
            case "im_osmaterialreqoutbill": {
                return "billentry";
            }
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)curEntity);
        Map allFields = dataEntityType.getAllFields();
        if (curEntity.startsWith("im") && allFields.containsKey("billentry")) {
            return "billentry";
        }
        if (allFields.containsKey("billentry")) {
            return "billentry";
        }
        if (allFields.containsKey("entry")) {
            return "entry";
        }
        if (allFields.containsKey("detailentry")) {
            return "detailentry";
        }
        for (Map.Entry entry : allFields.entrySet()) {
            if (!(entry.getValue() instanceof EntryProp) || entry.getValue() instanceof SubEntryProp) continue;
            return (String)entry.getKey();
        }
        return "";
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(BotpLinkHelper.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    public static Map<Object, Set<Object>> getLinkInfo(List<DynamicObject> bills, ConvertRuleElement cre) {
        String botptgtEntryKey = cre.getLinkEntityPolicy().getTargetEntryKey();
        HashMap<Object, Set<Object>> linkInfos = new HashMap<Object, Set<Object>>(16);
        for (DynamicObject bill : bills) {
            if (StringUtils.isEmpty((CharSequence)botptgtEntryKey)) continue;
            DynamicObjectCollection entires = bill.getDynamicObjectCollection(botptgtEntryKey);
            for (DynamicObject entry : entires) {
                DynamicObjectCollection linkInfo = entry.getDynamicObjectCollection("billentry_lk");
                for (DynamicObject link : linkInfo) {
                    Object linkId = link.get("billentry_lk_sid");
                    MapUtils.mapGetSetValue(linkInfos, entry.getPkValue()).add(linkId);
                }
            }
        }
        return linkInfos;
    }

    public static Map<Object, Set<Object>> getSrcLinkInfo(List<DynamicObject> bills, ConvertRuleElement cre) {
        Map<Object, Set<Object>> linkInfo = BotpLinkHelper.getLinkInfo(bills, cre);
        HashMap<Object, Set<Object>> srcLinkInfo = new HashMap<Object, Set<Object>>(16);
        for (Map.Entry<Object, Set<Object>> linkInfoEntry : linkInfo.entrySet()) {
            Object id = linkInfoEntry.getKey();
            Set<Object> srcIds = linkInfoEntry.getValue();
            for (Object srcId : srcIds) {
                MapUtils.mapGetSetValue(srcLinkInfo, srcId).add(id);
            }
        }
        return srcLinkInfo;
    }
}

