/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OperationUtil {
    public static OperationResult invokeOperation(DynamicObject obj, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(new DynamicObject[]{obj}, operation);
    }

    private static String getOperationUtilNullStr() {
        return ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"OperationUtil_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation, OperateOption option) throws KDBizException {
        if (objs == null || objs.length == 0) {
            throw new KDBizException(OperationUtil.getOperationUtilNullStr());
        }
        String entityName = objs[0].getDataEntityType().getName();
        ArrayList<DynamicObject> pkList = new ArrayList<DynamicObject>(16);
        for (DynamicObject obj : objs) {
            pkList.add(obj);
        }
        Object[] pks = pkList.toArray(new Object[pkList.size()]);
        return OperationUtil.invokeOperation(pks, operation, entityName, option);
    }

    public static OperationResult invokeOperation(Object[] pks, String operation, String entityName, OperateOption option) throws KDBizException {
        OperationResult result;
        if (pks == null || pks.length == 0) {
            throw new KDBizException(OperationUtil.getOperationUtilNullStr());
        }
        if (option == null) {
            option = OperateOption.create();
            option.setVariableValue("", "");
        }
        if (!(result = OperationServiceHelper.executeOperate((String)operation, (String)entityName, (Object[])pks, (OperateOption)option)).isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                List allErrorInfo = validation.getAllErrorInfo();
                for (OperateErrorInfo info : allErrorInfo) {
                    sb.append(info.getMessage());
                    sb.append(',');
                }
            }
            throw new KDBizException(MessageFormat.format("{0} - {1}", result.getMessage(), sb));
        }
        return result;
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(objs, operation, OperateOption.create());
    }

    public static StringBuilder getErroInfo(OperationResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append(result.getMessage()).append(",");
        List validResultList = result.getValidateResult().getValidateErrors();
        for (ValidateResult validation : validResultList) {
            List allErrorInfo = validation.getAllErrorInfo();
            for (OperateErrorInfo info : allErrorInfo) {
                sb.append(info.getMessage());
                sb.append(',');
            }
        }
        return sb;
    }

    public static OperateOption getOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WRITEOFF_OPERATE", String.valueOf(true));
        option.setVariableValue("isIgnoreVirualBillValidate", String.valueOf(true));
        option.setVariableValue("isshowmessage", "false");
        option.setVariableValue("skipbillnovalidator", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("WF", String.valueOf(false));
        return option;
    }

    public static OperationResult saveBillOp(DynamicObject[] autoBills) {
        if (autoBills == null || autoBills.length == 0) {
            return null;
        }
        String billType = autoBills[0].getDataEntityType().getName();
        OperateOption option = OperationUtil.getOption();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)billType, (DynamicObject[])autoBills, (OperateOption)option);
        return operationResult;
    }
}

