/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class WfManualUtil {
    public static Set<String> getExpressionField(String billType, String wfMainField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        HashSet<String> fieldSet = new HashSet<String>(12);
        for (String column : columns) {
            IDataEntityProperty property = dataEntityType.findProperty(column);
            String parent = property.getParent().getName();
            if (billType.equals(parent)) {
                fieldSet.add(column);
                continue;
            }
            fieldSet.add(parent + "." + column);
        }
        return fieldSet;
    }

    public static String getEntryKey(String entityNumber, String wfMainField, Long writeOffTypeEntyId) {
        String[] split = wfMainField.split("@@");
        if (split.length > 1 && "B".equals(split[1])) {
            return WfManualUtil.getFormulaEntryKey(entityNumber, wfMainField);
        }
        if (split.length > 1 && "C".equals(split[1])) {
            IWriteOffMainFieldCalPlugin mainFieldCal = WfPluginExtFactory.getWfMainFiledPlugin(split[0], writeOffTypeEntyId);
            String entry = mainFieldCal.mainFieldEntry();
            return entityNumber.equals(entry) ? "id" : entry + ".id";
        }
        return WfManualUtil.getFieldEntryKey(entityNumber, wfMainField);
    }

    private static String getFormulaEntryKey(String entityNumber, String wfMainField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        IDataEntityProperty property = dataEntityType.findProperty(columns[0]);
        String entryName = property.getParent().getName();
        if (!dataEntityType.getName().equals(entryName)) {
            return entryName + ".id";
        }
        return "id";
    }

    public static String getFieldEntryKey(String entityNumber, String wfMainField) {
        int lastPointIndex;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entryId = null;
        entryId = wfMainField != null ? ((lastPointIndex = wfMainField.lastIndexOf(46)) == -1 ? dataEntityType.getPrimaryKey().getName() : wfMainField.substring(0, lastPointIndex) + ".id") : dataEntityType.getPrimaryKey().getName();
        return entryId;
    }

    public static WriteoffTemplateTypeEnum getWfTemplateType(String recordTypeName) {
        String inheritPath = EntityMetadataCache.getDataEntityType((String)recordTypeName).getInheritPath();
        if (inheritPath != null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)inheritPath);
            if ("msmod_leftrighwfrecordtpl".equals(dataEntityType.getName()) || "msmod_leftrtamounttpl".equals(dataEntityType.getName())) {
                return WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT;
            }
            if ("msmod_updownwfrecordtpl".equals(dataEntityType.getName()) || "msmod_updownamounttpl".equals(dataEntityType.getName())) {
                return WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN;
            }
            if ("msmod_mainassisttpl".equals(dataEntityType.getName())) {
                return WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST;
            }
        }
        return null;
    }

    public static StringBuilder addFormFields(Set<String> formFields, String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map billAllFields = dataEntityType.getAllFields();
        StringBuilder selectFieldSb = new StringBuilder();
        for (String item : formFields) {
            IDataEntityProperty prop = (IDataEntityProperty)billAllFields.get(item);
            if (null == prop) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53:{0}\u5b57\u6bb5:{1}\u4e0d\u5b58\u5728\u3002", (String)"WfManualUtil_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{entityNumber, item}));
            }
            IDataEntityType parentProp = prop.getParent();
            String field = WfManualUtil.getFieldPath(item, parentProp);
            selectFieldSb.append(field);
            selectFieldSb.append(" as ");
            selectFieldSb.append(item);
            selectFieldSb.append(",");
        }
        return selectFieldSb;
    }

    private static String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return WfManualUtil.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    public static Set<String> changeField(List<String> wfPluginFields) {
        HashSet<String> changeFields = new HashSet<String>(16);
        for (String field : wfPluginFields) {
            String[] changeField = field.split("\\.");
            changeFields.add(changeField[changeField.length - 1]);
        }
        return changeFields;
    }

    public static String changeField(String wfPluginFields) {
        String[] changeField = wfPluginFields.split("\\.");
        return changeField[changeField.length - 1];
    }
}

