/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.AbstractWFPluginProxy;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;

public class CheckPluginProxy
extends AbstractWFPluginProxy<IWriteOffCheckPlugin> {
    public CheckPluginProxy(WriteOffParamManager paramManager) {
        super(paramManager);
    }

    public boolean check(DynamicObject recordBill) {
        List allPlugins = this.getAllPlugins("check");
        for (IWriteOffCheckPlugin plugin : allPlugins) {
            if (plugin.check(recordBill)) continue;
            throw new KDBizException(EngineLang.writeOffValidateFail());
        }
        return true;
    }

    public boolean checkWithoutException(DynamicObject recordBill) {
        List allPlugins = this.getAllPlugins("checkWithoutException");
        for (IWriteOffCheckPlugin plugin : allPlugins) {
            if (plugin.checkWithoutException(recordBill)) continue;
            return false;
        }
        return true;
    }

    public void batchCheckRecords(List<WriteOffRecordMapper> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> recordObjs = new ArrayList<DynamicObject>(records.size());
        for (WriteOffRecordMapper writeOffRecordMapper : records) {
            recordObjs.add(writeOffRecordMapper.getRecordBill());
        }
        List allPlugins = this.getAllPluginsWithLog("batchCheck");
        try (TraceSpan trace = Tracer.create((String)"WriteOffPlugin-IWriteOffCheckPlugin-batchCheck", (String)"batchCheck");){
            for (IWriteOffCheckPlugin plugin : allPlugins) {
                if (plugin.batchCheck(recordObjs)) continue;
                log.info("\u6838\u9500\u6821\u9a8c\u63d2\u4ef6\uff1a" + plugin.getClass().getSimpleName() + "");
                throw new KDBizException(EngineLang.writeOffValidateFail());
            }
        }
    }
}

