/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.MutablePair;

public class BookDateHelper {
    public static void setVerifyDate(List<DynamicObject> verifyRecords, boolean isAr) {
        Date operationDate = new Date();
        Map<Long, MutablePair<Date, Date>> dateScopeMap = BookDateHelper.getDateScopeMap(verifyRecords.toArray(new DynamicObject[0]), isAr);
        for (DynamicObject verifyRecord : verifyRecords) {
            DynamicObjectCollection entrys = verifyRecord.getDynamicObjectCollection("entry");
            Date maxBookDate = BookDateHelper.getMaxBookDate(entrys);
            Date tempVerifyDate = null;
            long orgId = verifyRecord.getLong("org.id");
            MutablePair<Date, Date> dateScope = dateScopeMap.get(orgId);
            Date dateScopeLeft = null;
            Date dateScopeRight = null;
            if (dateScope != null) {
                dateScopeLeft = (Date)dateScope.getLeft();
                dateScopeRight = (Date)dateScope.getRight();
            }
            if (maxBookDate == null && dateScopeLeft == null) {
                tempVerifyDate = operationDate;
            } else if (maxBookDate == null && dateScopeLeft != null) {
                tempVerifyDate = dateScopeLeft;
            } else if (maxBookDate != null && dateScopeLeft == null) {
                tempVerifyDate = maxBookDate;
            } else if (dateScopeLeft != null && dateScopeRight != null) {
                tempVerifyDate = dateScopeLeft.before(operationDate) && operationDate.before(dateScopeRight) ? operationDate : dateScopeLeft;
                Date date = tempVerifyDate = tempVerifyDate.before(maxBookDate) ? maxBookDate : tempVerifyDate;
            }
            if (ObjectUtils.isEmpty((Object)tempVerifyDate)) {
                tempVerifyDate = operationDate;
            }
            verifyRecord.set("createtime", (Object)tempVerifyDate);
        }
    }

    public static void setVerifyBookAndBillDate(List<DynamicObject> verifyRecords, boolean isAr) {
        Date operationDate = new Date();
        Map<Long, MutablePair<Date, Date>> dateScopeMap = BookDateHelper.getDateScopeMap(verifyRecords.toArray(new DynamicObject[0]), isAr);
        for (DynamicObject verifyRecord : verifyRecords) {
            DynamicObjectCollection entrys = verifyRecord.getDynamicObjectCollection("entry");
            Date maxBookDate = BookDateHelper.getMaxBookAndBillDate(entrys);
            Date tempVerifyDate = null;
            long orgId = verifyRecord.getLong("org.id");
            MutablePair<Date, Date> dateScope = dateScopeMap.get(orgId);
            Date dateScopeLeft = null;
            Date dateScopeRight = null;
            if (dateScope != null) {
                dateScopeLeft = (Date)dateScope.getLeft();
                dateScopeRight = (Date)dateScope.getRight();
            }
            if (maxBookDate == null && dateScopeLeft == null) {
                tempVerifyDate = operationDate;
            } else if (maxBookDate == null && dateScopeLeft != null) {
                tempVerifyDate = dateScopeLeft;
            } else if (maxBookDate != null && dateScopeLeft == null) {
                tempVerifyDate = maxBookDate;
            } else if (dateScopeLeft != null && dateScopeRight != null) {
                tempVerifyDate = dateScopeLeft.before(operationDate) && operationDate.before(dateScopeRight) ? operationDate : dateScopeLeft;
                Date date = tempVerifyDate = tempVerifyDate.before(maxBookDate) ? maxBookDate : tempVerifyDate;
            }
            if (ObjectUtils.isEmpty((Object)tempVerifyDate)) {
                tempVerifyDate = operationDate;
            }
            verifyRecord.set("createtime", (Object)tempVerifyDate);
        }
    }

    private static Date getMaxBookDate(DynamicObjectCollection entrys) {
        Date maxBookDate = null;
        for (DynamicObject entry : entrys) {
            Date asstBookDate;
            Date tempDate;
            Date mainBookDate = entry.getDate("bookdate");
            Date date = tempDate = mainBookDate.after(asstBookDate = entry.getDate("assbookdate")) ? mainBookDate : asstBookDate;
            if (maxBookDate == null) {
                maxBookDate = tempDate;
                continue;
            }
            maxBookDate = maxBookDate.after(tempDate) ? maxBookDate : tempDate;
        }
        return maxBookDate;
    }

    private static Date getMaxBookAndBillDate(DynamicObjectCollection entrys) {
        Date maxBookDate = null;
        for (DynamicObject entry : entrys) {
            Date asstBookDate;
            Date tempDate;
            Date mainBookDate = entry.getDate("bookdate");
            Date date = tempDate = mainBookDate.after(asstBookDate = entry.getDate("assbizdate")) ? mainBookDate : asstBookDate;
            if (maxBookDate == null) {
                maxBookDate = tempDate;
                continue;
            }
            maxBookDate = maxBookDate.after(tempDate) ? maxBookDate : tempDate;
        }
        return maxBookDate;
    }

    private static Map<Long, MutablePair<Date, Date>> getDateScopeMap(DynamicObject[] datas, boolean isAr) {
        String closeAccountEntity = isAr ? "ar_closeaccount" : "ap_closeaccount";
        String initEntity = isAr ? "ar_init" : "ap_init";
        HashMap<Long, MutablePair<Date, Date>> openAccountDateScope = new HashMap<Long, MutablePair<Date, Date>>(8);
        Set orgIds = Stream.of(datas).map(data -> data.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection closeAccounts = QueryServiceHelper.query((String)closeAccountEntity, (String)"org.id,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        closeAccounts.stream().forEach(closeAccount -> openAccountDateScope.put(closeAccount.getLong("org.id"), new MutablePair((Object)closeAccount.getDate("currentdate"), null)));
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)initEntity, (String)"org,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> periodCacheMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject init : inits) {
            Date beginDate;
            DynamicObject period;
            DynamicObject periodtype;
            DynamicObject periodCache = (DynamicObject)periodCacheMap.get(init.getLong("org.id"));
            if (periodCache != null || ObjectUtils.isEmpty((Object)(periodtype = init.getDynamicObject("periodtype")))) continue;
            long periodTypeId = periodtype.getLong("id");
            MutablePair dateScope = (MutablePair)openAccountDateScope.get(init.getLong("org.id"));
            if (ObjectUtils.isEmpty((Object)dateScope) || (period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{new QFilter("begindate", "<=", (Object)(beginDate = (Date)dateScope.getLeft())), new QFilter("enddate", ">=", (Object)beginDate), new QFilter("periodtype", "=", (Object)periodTypeId)})) == null) continue;
            dateScope.setRight((Object)period.getDate("enddate"));
            periodCacheMap.put(init.getLong("org.id"), period);
        }
        return openAccountDateScope;
    }
}

