/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.vo.VerifyRecordVO;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class ArOriginalUnWFRecordWriteOffPlugin
implements IUnWriteOffCheckPlugin,
IUnWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(ArOriginalUnWFRecordWriteOffPlugin.class);
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_CORE = 1678144407779420160L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693748335779055616L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693749472343164928L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE = 1678148494499522560L;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(HXLB_AR_ORIGINAL_VERIFY_QTY_CORE, HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP, HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP, HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("ar_originalwfrecord", new HashSet<String>(Arrays.asList("isvoucher", "writeofftypeid", "entry.e_hadwrittenoff", "entry.e_iswrittenoff", "entry.assinvoiceno", "entry.assinvoicecode", "entry.billid", "entry.billentryid", "entry.verifyqty", "entry.verifypricetax", "entry.verifylocpricetax", "entry.assverifyamt", "entry.assverifylocamt", "entry.assverifytax", "entry.assverifyloctax", "entry.assverifypricetax", "entry.assverifylocpricetax", "entry.assverifyqty", "entry.assbillid", "entry.assbillentryid", "entry.mainwfinfo_tag", "entry.asswfinfo_tag")));
        return fieldMap;
    }

    @Override
    public boolean check(DynamicObject record) {
        if (record.getBoolean("isvoucher")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArOriginalUnWFRecordWriteOffPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            if (!entry.getBoolean("e_hadwrittenoff")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5e94\u6536\u5f00\u7968\u6838\u9500\u8bb0\u5f55\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ArOriginalUnWFRecordWriteOffPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return true;
    }

    @Override
    public void beforeWfRecordDelete(List<DynamicObject> records) {
        logger.info("------ArOriginalUnWFRecordWriteOffPlugin.beforeWfRecordDelete.begin------");
        if (records == null || records.size() < 1) {
            return;
        }
        HashSet<Long> hxlbSet = new HashSet<Long>(8);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_CORE);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
        List<DynamicObject> arOriginalRecords = records.stream().filter(e -> hxlbSet.contains(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        if (arOriginalRecords.size() < 1) {
            return;
        }
        ArrayList<Long> recordsForFinArBillIds = new ArrayList<Long>(8);
        for (DynamicObject arOriRecord : arOriginalRecords) {
            DynamicObjectCollection entrys = arOriRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                recordsForFinArBillIds.add(entry.getLong("billid"));
            }
        }
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,invoicecode,invoiceno,entry.id,entry.e_invoicecode,entry.e_invoiceno,entry.e_iswrittenoff,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", recordsForFinArBillIds)});
        this.disposeFinBill(finArBills, arOriginalRecords);
        logger.info("------ArOriginalUnWFRecordWriteOffPlugin.beforeWfRecordDelete.end------");
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>();
        if (ObjectUtils.isEmpty(records)) {
            return sqlListMaps;
        }
        HashSet<Long> hxlbSet = new HashSet<Long>(8);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_CORE);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE);
        List<DynamicObject> coreRecordList = records.stream().filter(e -> hxlbSet.contains(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(coreRecordList)) {
            return sqlListMaps;
        }
        ArrayList<DynamicObject> requireCodeWriteBackRecordList = new ArrayList<DynamicObject>(8);
        this.getCodeWriteBackRecordList(requireCodeWriteBackRecordList, coreRecordList);
        if (ObjectUtils.isEmpty(requireCodeWriteBackRecordList)) {
            return sqlListMaps;
        }
        logger.info("ArOriginalUnWFRecordWriteOffPlugin-\u51c6\u5907\u6784\u5efa\u53cd\u5199sql-records_size\uff1a" + records.size());
        ArrayList<VerifyRecordVO> disMainParamByQtyList = new ArrayList<VerifyRecordVO>(8);
        ArrayList<VerifyRecordVO> disMainParamByAmtList = new ArrayList<VerifyRecordVO>(8);
        ArrayList<VerifyRecordVO> disAsstParamByQtyList = new ArrayList<VerifyRecordVO>(8);
        ArrayList<VerifyRecordVO> disAsstParamByAmtList = new ArrayList<VerifyRecordVO>(8);
        for (DynamicObject recordBill : requireCodeWriteBackRecordList) {
            long verifyTypeId = recordBill.getLong("writeofftypeid.id");
            DynamicObjectCollection recordEntrys = recordBill.getDynamicObjectCollection("entry");
            if (recordEntrys == null || recordEntrys.isEmpty()) continue;
            this.buildDisBillInfo(disMainParamByQtyList, disMainParamByAmtList, disAsstParamByQtyList, disAsstParamByAmtList, verifyTypeId, recordEntrys);
        }
        Map<String, List<Object[]>> finBackSql = this.buildFinBackSql(disMainParamByQtyList, disMainParamByAmtList, disAsstParamByQtyList, disAsstParamByAmtList);
        Map<String, List<Object[]>> originalBackSql = this.buildOriginalBackSql(disAsstParamByQtyList, disAsstParamByAmtList);
        logger.info("ArOriginalVerifyUnWriteOffPlugin-\u6784\u5efa\u53cd\u5199fin sql\u5b8c\u6bd5\uff0csqlLists_size\uff1a" + finBackSql.size());
        logger.info("ArOriginalVerifyUnWriteOffPlugin-\u6784\u5efa\u53cd\u5199original sql\u5b8c\u6bd5\uff0csqlLists_size\uff1a" + originalBackSql.size());
        sqlListMaps.put("fi", finBackSql);
        sqlListMaps.put("taxc", originalBackSql);
        return sqlListMaps;
    }

    private void getCodeWriteBackRecordList(List<DynamicObject> requireCodeWriteBackRecordList, List<DynamicObject> coreRecordList) {
        for (DynamicObject record : coreRecordList) {
            boolean isNew = true;
            DynamicObjectCollection entryColl = record.getDynamicObjectCollection("entry");
            block1: for (DynamicObject entry : entryColl) {
                Map mainInfoMap;
                Object backWriteDetailListTemp;
                String mainWfInfo_tag;
                Map mainInfoMap2;
                Object backWriteDetailListTemp2;
                String assWfInfo_tag = entry.getString("asswfinfo_tag");
                if (StringUtils.isNotEmpty((CharSequence)assWfInfo_tag) && (backWriteDetailListTemp2 = (mainInfoMap2 = (Map)SerializationUtils.fromJsonString((String)assWfInfo_tag, Map.class)).get("backWriteDetailList")) != null) {
                    List backWriteDetailList = (List)backWriteDetailListTemp2;
                    for (Map infoMap : backWriteDetailList) {
                        String value;
                        Object valueTemp = infoMap.get("value");
                        if (valueTemp == null || "0".equals(value = valueTemp.toString())) continue;
                        isNew = false;
                        break block1;
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)(mainWfInfo_tag = entry.getString("mainwfinfo_tag"))) || (backWriteDetailListTemp = (mainInfoMap = (Map)SerializationUtils.fromJsonString((String)mainWfInfo_tag, Map.class)).get("backWriteDetailList")) == null) continue;
                List backWriteDetailList = (List)backWriteDetailListTemp;
                for (Map infoMap : backWriteDetailList) {
                    String value;
                    Object valueTemp = infoMap.get("value");
                    if (valueTemp == null || "0".equals(value = valueTemp.toString())) continue;
                    isNew = false;
                    break block1;
                }
            }
            if (!isNew) continue;
            requireCodeWriteBackRecordList.add(record);
        }
    }

    private Map<String, List<Object[]>> buildOriginalBackSql(List<VerifyRecordVO> disAstParamByQtyList, List<VerifyRecordVO> disAstParamByAmtList) {
        String updateOriginalEntrySql;
        Object updateOriginalHeadSql;
        Long asstEntryId;
        Long asstId;
        ArrayList<Object[]> sqlOriginalEntryParams;
        ArrayList<Object[]> sqlOriginalHeadParams;
        HashMap<String, List<Object[]>> sqlLists = new HashMap<String, List<Object[]>>();
        if (disAstParamByQtyList.size() > 0) {
            sqlOriginalHeadParams = new ArrayList<Object[]>(disAstParamByQtyList.size());
            sqlOriginalEntryParams = new ArrayList<Object[]>(disAstParamByQtyList.size());
            for (VerifyRecordVO verifyRecordVO : disAstParamByQtyList) {
                BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                BigDecimal verifyAsstQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                asstId = verifyRecordVO.getAsstId();
                asstEntryId = verifyRecordVO.getAsstEntryId();
                Object[] originalHeadParam = new Object[]{verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, verifyPriceTaxDiff, verifyPriceTaxDiff, asstId};
                sqlOriginalHeadParams.add(originalHeadParam);
                Object[] originalEntryParam = new Object[]{verifyAsstQtyDiff, verifyAsstQtyDiff, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, verifyPriceTaxDiff, verifyPriceTaxDiff, asstId, asstEntryId};
                sqlOriginalEntryParams.add(originalEntryParam);
            }
            updateOriginalHeadSql = "update t_sim_original_bill set fpushlocalamount = fpushlocalamount - ?,funpushlocalamount = funpushlocalamount + ?, fpushamount = fpushamount - ?, funpushamount = funpushamount + ? where fid = ? ";
            updateOriginalEntrySql = "update t_sim_original_bill_item set fpushnum = fpushnum -?,funpushnum = funpushnum +?, fpushlocalamt = fpushlocalamt - ?, funpushlocalamt = funpushlocalamt + ?,fpushamt = fpushamt -? , funpushamt = funpushamt + ? where fid = ? and fentryid = ?";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildOriginalBackSql disAstParamByQtyList sqlOriginalHeadParams " + sqlOriginalHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildOriginalBackSql disAstParamByQtyList sqlOriginalEntryParams " + sqlOriginalEntryParams.size());
            sqlLists.put((String)updateOriginalHeadSql, sqlOriginalHeadParams);
            sqlLists.put(updateOriginalEntrySql, sqlOriginalEntryParams);
        }
        if (disAstParamByAmtList.size() > 0) {
            sqlOriginalHeadParams = new ArrayList(disAstParamByAmtList.size());
            sqlOriginalEntryParams = new ArrayList(disAstParamByAmtList.size());
            for (VerifyRecordVO verifyRecordVO : disAstParamByAmtList) {
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                BigDecimal verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                BigDecimal verifyQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                asstId = verifyRecordVO.getAsstId();
                asstEntryId = verifyRecordVO.getAsstEntryId();
                Object[] updateHeadParam = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, asstId};
                sqlOriginalHeadParams.add(updateHeadParam);
                Object[] updateEntryParam = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff, verifyLocPriceTaxDiff, verifyQtyDiff, verifyQtyDiff, asstId, asstEntryId};
                sqlOriginalEntryParams.add(updateEntryParam);
            }
            updateOriginalHeadSql = "update t_sim_original_bill set fpushamount = fpushamount -?,funpushamount = funpushamount + ?, fpushlocalamount = fpushlocalamount - ?, funpushlocalamount = funpushlocalamount + ? where fid = ? ";
            updateOriginalEntrySql = "update t_sim_original_bill_item set fpushamt = fpushamt -?,funpushamt = funpushamt + ?, fpushlocalamt = fpushlocalamt - ?, funpushlocalamt = funpushlocalamt + ?, fpushnum = fpushnum - ?, funpushnum = funpushnum +? where fid = ? and fentryid = ?";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildOriginalBackSql disAstParamByQtyList disAstParamByAmtList " + sqlOriginalHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildOriginalBackSql disAstParamByQtyList disAstParamByAmtList " + sqlOriginalEntryParams.size());
            sqlLists.put((String)updateOriginalHeadSql, sqlOriginalHeadParams);
            sqlLists.put(updateOriginalEntrySql, sqlOriginalEntryParams);
        }
        return sqlLists;
    }

    private Map<String, List<Object[]>> buildFinBackSql(List<VerifyRecordVO> disMainParamByQtyList, List<VerifyRecordVO> disMainParamByAmtList, List<VerifyRecordVO> disAstParamByQtyList, List<VerifyRecordVO> disAstParamByAmtList) {
        String updateFinArEntrySql;
        Object updateFinArHeadSql;
        Long mainEntryId;
        Long mainId;
        BigDecimal verifyLocPriceTaxDiff;
        BigDecimal verifyLocTaxDiff;
        BigDecimal verifyTaxDiff;
        BigDecimal verifyLocAmtDiff;
        BigDecimal verifyAmtDiff;
        ArrayList<Object[]> sqlFinEntryParams;
        ArrayList<Object[]> sqlFinHeadParams;
        String updateEntrySql;
        Object updateHeadSql;
        Object[] headParam;
        ArrayList<Object[]> sqlEntryParams;
        ArrayList<Object[]> sqlHeadParams;
        HashMap<String, List<Object[]>> sqlLists = new HashMap<String, List<Object[]>>();
        if (disMainParamByQtyList.size() > 0) {
            sqlHeadParams = new ArrayList<Object[]>(disMainParamByQtyList.size());
            sqlEntryParams = new ArrayList<Object[]>(disMainParamByQtyList.size());
            for (VerifyRecordVO verifyRecordVO : disMainParamByQtyList) {
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                BigDecimal verifyLocPriceTaxDiff2 = verifyRecordVO.getVerifyLocPriceTaxDiff();
                Long mainId2 = verifyRecordVO.getMainId();
                Long mainEntryId2 = verifyRecordVO.getMainEntryId();
                BigDecimal verifyMainQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                headParam = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff2, verifyLocPriceTaxDiff2, mainId2};
                sqlHeadParams.add(headParam);
                Object[] param = new Object[]{verifyMainQtyDiff, verifyMainQtyDiff, verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff2, verifyLocPriceTaxDiff2, mainId2, mainEntryId2};
                sqlEntryParams.add(param);
            }
            updateHeadSql = "update t_ar_finarbill_e set finvoicedamt = finvoicedamt - ?,funinvoicedamt = funinvoicedamt + ?,finvoicedlocalamt = finvoicedlocalamt - ?, funinvoicedlocalamt = funinvoicedlocalamt + ? where fid = ?";
            updateEntrySql = "update t_ar_finarbillentry_e set finvoicedqty = finvoicedqty -?,funinvoicedqty =funinvoicedqty + ?, funinvoicedamt = funinvoicedamt + ?,finvoicedamt = finvoicedamt - ?,funinvoicedlocalamt = funinvoicedlocalamt+?, finvoicedlocalamt = finvoicedlocalamt - ? where fid = ? and fentryid = ?";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disMainParamByQtyList sqlHeadParams " + sqlHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disMainParamByQtyList sqlEntryParams " + sqlEntryParams.size());
            sqlLists.put((String)updateHeadSql, sqlHeadParams);
            sqlLists.put(updateEntrySql, sqlEntryParams);
        }
        if (disMainParamByAmtList.size() > 0) {
            sqlHeadParams = new ArrayList(disMainParamByAmtList.size());
            sqlEntryParams = new ArrayList(disMainParamByAmtList.size());
            for (VerifyRecordVO verifyRecordVO : disMainParamByAmtList) {
                BigDecimal verifyLocPriceTaxDiff3 = verifyRecordVO.getVerifyLocPriceTaxDiff();
                BigDecimal verifyQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                Long mainId3 = verifyRecordVO.getMainId();
                Long mainEntryId3 = verifyRecordVO.getMainEntryId();
                headParam = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff3, verifyLocPriceTaxDiff3, mainId3};
                sqlHeadParams.add(headParam);
                Object[] entryParam = new Object[]{verifyPriceTaxDiff, verifyPriceTaxDiff, verifyLocPriceTaxDiff3, verifyLocPriceTaxDiff3, verifyQtyDiff, verifyQtyDiff, mainId3, mainEntryId3};
                sqlEntryParams.add(entryParam);
            }
            updateHeadSql = "update t_ar_finarbill_e set finvoicedamt = finvoicedamt -?,funinvoicedamt = funinvoicedamt+?, finvoicedlocalamt = finvoicedlocalamt - ? , funinvoicedlocalamt = funinvoicedlocalamt + ? where fid = ?";
            updateEntrySql = "update t_ar_finarbillentry_e set finvoicedamt = finvoicedamt -?, funinvoicedamt = funinvoicedamt +?, funinvoicedlocalamt = funinvoicedlocalamt + ?, finvoicedlocalamt = finvoicedlocalamt - ?, finvoicedqty = finvoicedqty - ?, funinvoicedqty = funinvoicedqty + ? where fid = ? and fentryid = ?";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disMainParamByAmtList sqlHeadParams " + sqlHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disMainParamByAmtList sqlEntryParams " + sqlEntryParams.size());
            sqlLists.put((String)updateHeadSql, sqlHeadParams);
            sqlLists.put(updateEntrySql, sqlEntryParams);
        }
        if (disAstParamByQtyList.size() > 0) {
            sqlFinHeadParams = new ArrayList<Object[]>(disAstParamByQtyList.size());
            sqlFinEntryParams = new ArrayList<Object[]>(disAstParamByQtyList.size());
            for (VerifyRecordVO verifyRecordVO : disAstParamByQtyList) {
                verifyAmtDiff = verifyRecordVO.getVerifyAmtDiff();
                verifyLocAmtDiff = verifyRecordVO.getVerifyLocAmtDiff();
                verifyTaxDiff = verifyRecordVO.getVerifyTaxDiff();
                verifyLocTaxDiff = verifyRecordVO.getVerifyLocTaxDiff();
                verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                BigDecimal verifyAsstQtyDiff = verifyRecordVO.getVerifyAsstQtyDiff();
                mainId = verifyRecordVO.getMainId();
                mainEntryId = verifyRecordVO.getMainEntryId();
                Object[] finHeadParam = new Object[]{verifyLocPriceTaxDiff, verifyPriceTaxDiff, mainId};
                sqlFinHeadParams.add(finHeadParam);
                Object[] finEntryParam = new Object[]{verifyAsstQtyDiff, verifyAmtDiff, verifyLocAmtDiff, verifyTaxDiff, verifyLocTaxDiff, verifyLocPriceTaxDiff, verifyPriceTaxDiff, mainId, mainEntryId};
                sqlFinEntryParams.add(finEntryParam);
            }
            updateFinArHeadSql = "update t_ar_finarbill_e set fissueinvreclocalamt = fissueinvreclocalamt - ?,fissueinvrecamt = fissueinvrecamt - ? where fid =?";
            updateFinArEntrySql = "update t_ar_finarbillentry_e set fissueinvqty = fissueinvqty -?, fissueinvamt = fissueinvamt - ?,fissueinvlocalamt = fissueinvlocalamt -?, fissueinvtax = fissueinvtax - ?, fissueinvlocaltax = fissueinvlocaltax -?,fissueinvreclocalamt = fissueinvreclocalamt - ?,fissueinvrecamt = fissueinvrecamt -? where fid = ? and fentryid =? ";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disAstParamByQtyList sqlFinHeadParams " + sqlFinHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disAstParamByQtyList sqlFinEntryParams " + sqlFinEntryParams.size());
            sqlLists.put((String)updateFinArHeadSql, sqlFinHeadParams);
            sqlLists.put(updateFinArEntrySql, sqlFinEntryParams);
        }
        if (disAstParamByAmtList.size() > 0) {
            sqlFinHeadParams = new ArrayList(disAstParamByAmtList.size());
            sqlFinEntryParams = new ArrayList(disAstParamByAmtList.size());
            for (VerifyRecordVO verifyRecordVO : disAstParamByAmtList) {
                verifyAmtDiff = verifyRecordVO.getVerifyAmtDiff();
                verifyLocAmtDiff = verifyRecordVO.getVerifyLocAmtDiff();
                verifyTaxDiff = verifyRecordVO.getVerifyTaxDiff();
                verifyLocTaxDiff = verifyRecordVO.getVerifyLocTaxDiff();
                verifyLocPriceTaxDiff = verifyRecordVO.getVerifyLocPriceTaxDiff();
                BigDecimal verifyQtyDiff = verifyRecordVO.getVerifyMainQtyDiff();
                BigDecimal verifyPriceTaxDiff = verifyRecordVO.getVerifyPriceTaxDiff();
                mainId = verifyRecordVO.getMainId();
                mainEntryId = verifyRecordVO.getMainEntryId();
                Object[] updateHeadParam = new Object[]{verifyPriceTaxDiff, verifyLocPriceTaxDiff, mainId};
                sqlFinHeadParams.add(updateHeadParam);
                Object[] updateEntryParam = new Object[]{verifyPriceTaxDiff, verifyAmtDiff, verifyLocAmtDiff, verifyTaxDiff, verifyLocTaxDiff, verifyLocPriceTaxDiff, verifyQtyDiff, mainId, mainEntryId};
                sqlFinEntryParams.add(updateEntryParam);
            }
            updateFinArHeadSql = "update t_ar_finarbill_e set fissueinvrecamt = fissueinvrecamt -?, fissueinvreclocalamt = fissueinvreclocalamt - ? where fid = ?";
            updateFinArEntrySql = "update t_ar_finarbillentry_e set fissueinvrecamt = fissueinvrecamt - ?, fissueinvamt = fissueinvamt - ?,fissueinvlocalamt = fissueinvlocalamt -?, fissueinvtax = fissueinvtax - ?, fissueinvlocaltax = fissueinvlocaltax -?,fissueinvreclocalamt = fissueinvreclocalamt - ?,fissueinvqty = fissueinvqty-? where fid = ? and fentryid =? ";
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disAstParamByAmtList sqlFinHeadParams " + sqlFinHeadParams.size());
            logger.info("ArOriginalUnWFRecordWriteOffPlugin buildFinBackSql disAstParamByAmtList sqlFinEntryParams " + sqlFinEntryParams.size());
            sqlLists.put((String)updateFinArHeadSql, sqlFinHeadParams);
            sqlLists.put(updateFinArEntrySql, sqlFinEntryParams);
        }
        return sqlLists;
    }

    private void buildDisBillInfo(List<VerifyRecordVO> disMainParamByQtyList, List<VerifyRecordVO> disMainParamByAmtList, List<VerifyRecordVO> disAsstParamByQtyList, List<VerifyRecordVO> disAsstParamByAmtList, long verifyTypeId, DynamicObjectCollection recordEntrys) {
        for (DynamicObject recordEntry : recordEntrys) {
            VerifyRecordVO mainVerifyRecordVO = new VerifyRecordVO();
            long billId = recordEntry.getLong("billid");
            long billEntryId = recordEntry.getLong("billentryid");
            BigDecimal verifyQty = recordEntry.getBigDecimal("verifyqty");
            BigDecimal verifyPriceTax = recordEntry.getBigDecimal("verifypricetax");
            BigDecimal verifyLocPriceTax = recordEntry.getBigDecimal("verifylocpricetax");
            mainVerifyRecordVO.setMainId(billId);
            mainVerifyRecordVO.setMainEntryId(billEntryId);
            mainVerifyRecordVO.setVerifyPriceTaxDiff(verifyPriceTax);
            mainVerifyRecordVO.setVerifyLocPriceTaxDiff(verifyLocPriceTax);
            mainVerifyRecordVO.setVerifyMainQtyDiff(verifyQty);
            BigDecimal assVerifyAmt = recordEntry.getBigDecimal("assverifyamt");
            BigDecimal assverifyLocAmt = recordEntry.getBigDecimal("assverifylocamt");
            BigDecimal assVerifyTax = recordEntry.getBigDecimal("assverifytax");
            BigDecimal assVerifyLocTax = recordEntry.getBigDecimal("assverifyloctax");
            BigDecimal assVerifyPriceTax = recordEntry.getBigDecimal("assverifypricetax");
            BigDecimal assVerifyLocPriceTax = recordEntry.getBigDecimal("assverifylocpricetax");
            BigDecimal assVerifyQty = recordEntry.getBigDecimal("assverifyqty");
            long assBillId = recordEntry.getLong("assbillid");
            long assBillEntryId = recordEntry.getLong("assbillentryid");
            VerifyRecordVO asstVerifyRecordVO = new VerifyRecordVO();
            asstVerifyRecordVO.setMainId(billId);
            asstVerifyRecordVO.setMainEntryId(billEntryId);
            asstVerifyRecordVO.setAsstId(assBillId);
            asstVerifyRecordVO.setAsstEntryId(assBillEntryId);
            asstVerifyRecordVO.setVerifyTaxDiff(assVerifyTax);
            asstVerifyRecordVO.setVerifyLocTaxDiff(assVerifyLocTax);
            asstVerifyRecordVO.setVerifyAmtDiff(assVerifyAmt);
            asstVerifyRecordVO.setVerifyLocAmtDiff(assverifyLocAmt);
            asstVerifyRecordVO.setVerifyPriceTaxDiff(assVerifyPriceTax);
            asstVerifyRecordVO.setVerifyLocPriceTaxDiff(assVerifyLocPriceTax);
            asstVerifyRecordVO.setVerifyMainQtyDiff(verifyQty);
            asstVerifyRecordVO.setVerifyAsstQtyDiff(assVerifyQty);
            if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE == verifyTypeId) {
                disMainParamByQtyList.add(mainVerifyRecordVO);
                disAsstParamByQtyList.add(asstVerifyRecordVO);
                continue;
            }
            if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE != verifyTypeId) continue;
            disMainParamByAmtList.add(mainVerifyRecordVO);
            disAsstParamByAmtList.add(asstVerifyRecordVO);
        }
    }

    private void disposeFinBill(DynamicObject[] finArBills, List<DynamicObject> arOriginalRecords) {
        logger.info("------ArOriginalUnWFRecordWriteOffPlugin.disposeFinBill.begin------");
        HashMap<Long, List<DynamicObject>> entryIdRecordMap = new HashMap<Long, List<DynamicObject>>(arOriginalRecords.size());
        boolean writeOffUnAduit = false;
        for (DynamicObject redRecord : arOriginalRecords) {
            DynamicObjectCollection entrys = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long billEntryId = entry.getLong("billentryid");
                boolean isWrittenOff = entry.getBoolean("e_iswrittenoff");
                if (isWrittenOff) {
                    writeOffUnAduit = true;
                }
                List redRecordList = entryIdRecordMap.getOrDefault(billEntryId, new ArrayList(entrys.size()));
                redRecordList.add(entry);
                entryIdRecordMap.put(billEntryId, redRecordList);
            }
        }
        Set finArIdSet = Arrays.stream(finArBills).map(a -> a.getLong("id")).collect(Collectors.toSet());
        Set curRecordIdSet = arOriginalRecords.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection historyRecordColl = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.billentryid,entry.assinvoiceno,entry.assinvoicecode", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", finArIdSet)});
        Set<DynamicObject> historyRecordSet = historyRecordColl.stream().filter(a -> !curRecordIdSet.contains(a.getLong("id"))).collect(Collectors.toSet());
        if (writeOffUnAduit) {
            logger.info("------ArOriginalUnWFRecordWriteOffPlugin.dealWriteOffUnAudit.begin------");
            this.dealWriteOffUnAudit(finArBills, entryIdRecordMap);
            logger.info("------ArOriginalUnWFRecordWriteOffPlugin.dealWriteOffUnAudit.end------");
        } else {
            logger.info("------ArOriginalUnWFRecordWriteOffPlugin.dealUnAudit.begin------");
            this.dealUnAudit(finArBills, entryIdRecordMap, historyRecordSet);
            logger.info("------ArOriginalUnWFRecordWriteOffPlugin.dealUnAudit.end------");
        }
        this.doArHeadInvNoCode(finArBills);
        logger.info("------ArOriginalUnWFRecordWriteOffPlugin.disposeFinBill.end------");
    }

    private void dealWriteOffUnAudit(DynamicObject[] finArBills, Map<Long, List<DynamicObject>> entryIdRecordMap) {
        for (DynamicObject finArBill : finArBills) {
            DynamicObjectCollection finArEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject finArEntry : finArEntries) {
                Long entryId = finArEntry.getLong("id");
                String invoiceCode = finArEntry.getString("e_invoicecode");
                String invoiceNo = finArEntry.getString("e_invoiceno");
                ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invoiceNo.split(", ")));
                ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invoiceCode.split(", ")));
                List<DynamicObject> redRecordEntryList = entryIdRecordMap.get(entryId);
                if (ObjectUtils.isEmpty(redRecordEntryList)) continue;
                for (DynamicObject entry : redRecordEntryList) {
                    inCodesList.remove("");
                    inNosList.remove("");
                    String assinvoiceno = entry.getString("assinvoiceno");
                    String assinvoicecode = entry.getString("assinvoicecode");
                    if (StringUtils.isNotEmpty((CharSequence)assinvoiceno) && !inNosList.contains(assinvoiceno)) {
                        inNosList.add(assinvoiceno);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)assinvoicecode) || inCodesList.contains(assinvoicecode)) continue;
                    inCodesList.add(assinvoicecode);
                }
                finArEntry.set("e_invoicecode", (Object)String.join((CharSequence)", ", inCodesList));
                finArEntry.set("e_invoiceno", (Object)String.join((CharSequence)", ", inNosList));
            }
        }
    }

    private void dealUnAudit(DynamicObject[] finArBills, Map<Long, List<DynamicObject>> entryIdRecordMap, Set<DynamicObject> historyRecordSet) {
        HashMap<Long, Set> entryIdInvNoMap = new HashMap<Long, Set>(8);
        for (DynamicObject historyRecord : historyRecordSet) {
            long billEntryId = historyRecord.getLong("entry.billentryid");
            String invNo = historyRecord.getString("entry.assinvoiceno");
            Set invNoSet = entryIdInvNoMap.getOrDefault(billEntryId, new HashSet(8));
            invNoSet.add(invNo);
            entryIdInvNoMap.put(billEntryId, invNoSet);
        }
        for (DynamicObject finArBill : finArBills) {
            DynamicObjectCollection finArEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject finArEntry : finArEntries) {
                Long entryId = finArEntry.getLong("id");
                Set invNoSet = (Set)entryIdInvNoMap.get(entryId);
                String invoiceCode = finArEntry.getString("e_invoicecode");
                String invoiceNo = finArEntry.getString("e_invoiceno");
                ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invoiceNo.split(", ")));
                ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invoiceCode.split(", ")));
                List<DynamicObject> redRecordEntryList = entryIdRecordMap.get(entryId);
                if (ObjectUtils.isEmpty(redRecordEntryList)) continue;
                for (DynamicObject entry : redRecordEntryList) {
                    inCodesList.remove("");
                    inNosList.remove("");
                    String assinvoiceno = entry.getString("assinvoiceno");
                    String assinvoicecode = entry.getString("assinvoicecode");
                    for (int i = inNosList.size() - 1; i >= 0; --i) {
                        if (ObjectUtils.isEmpty((Object)assinvoiceno) || !assinvoiceno.equals(inNosList.get(i)) || invNoSet != null && invNoSet.contains(assinvoiceno)) continue;
                        if (!ObjectUtils.isEmpty((Object)assinvoicecode)) {
                            inCodesList.remove(i);
                        }
                        inNosList.remove(i);
                    }
                }
                finArEntry.set("e_invoicecode", (Object)String.join((CharSequence)", ", inCodesList));
                finArEntry.set("e_invoiceno", (Object)String.join((CharSequence)", ", inNosList));
            }
        }
    }

    private void doArHeadInvNoCode(DynamicObject[] arBills) {
        for (DynamicObject arBill : arBills) {
            DynamicObjectCollection entrys = arBill.getDynamicObjectCollection("entry");
            HashSet<String> headNosSet = new HashSet<String>(entrys.size());
            HashSet<String> headCodesSet = new HashSet<String>(entrys.size());
            for (DynamicObject entry : entrys) {
                String invCode = entry.getString("e_invoicecode");
                String invNo = entry.getString("e_invoiceno");
                ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invNo.split(", ")));
                ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invCode.split(", ")));
                inCodesList.remove("");
                inNosList.remove("");
                if (!ObjectUtils.isEmpty(inCodesList)) {
                    headCodesSet.addAll(inCodesList);
                }
                if (ObjectUtils.isEmpty(inNosList)) continue;
                headNosSet.addAll(inNosList);
            }
            arBill.set("invoicecode", (Object)String.join((CharSequence)", ", headCodesSet));
            arBill.set("invoiceno", (Object)String.join((CharSequence)", ", headNosSet));
        }
        SaveServiceHelper.save((DynamicObject[])arBills);
    }
}

