/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class FiBOTPLinkMatcherNewPlugin
implements IMatchPlugin {
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693748335779055616L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693749472343164928L;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_AR_ORIGINAL_AMT_BOTP, WriteOffTypeIdConst.HXLB_AR_ORIGINAL_QTY_BOTP, WriteOffTypeIdConst.HXLB_AR_SAL_BOTP);
    }

    @Override
    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.PPGZ_AR_ORIGINAL_AMT_BOTP, WriteOffTypeIdConst.PPGZ_AR_ORIGINAL_QTY_BOTP, WriteOffTypeIdConst.PPGZ_AR_SAL_BOTP);
    }

    @Override
    public String botpTrackRelation(DynamicObject srcConfigObj, DynamicObject tgtConfigObj) {
        DynamicObject srcWfBillObj = srcConfigObj.getDynamicObject("wfbillalias");
        DynamicObject tgtWfBillObj = tgtConfigObj.getDynamicObject("wfbillalias");
        String srcBillEntity = srcWfBillObj.getString("wfbill.number");
        String tgtBillEntity = tgtWfBillObj.getString("wfbill.number");
        if ("ar_finarbill".equals(srcBillEntity) && "sim_original_bill".equals(tgtBillEntity)) {
            return "trackup";
        }
        if ("sim_original_bill".equals(srcBillEntity) && "ar_finarbill".equals(tgtBillEntity)) {
            return "trackup";
        }
        if ("im_saloutbill".equals(srcBillEntity) && "ar_finarbill".equals(tgtBillEntity)) {
            return "trackdown";
        }
        if ("ar_finarbill".equals(srcBillEntity) && "im_saloutbill".equals(tgtBillEntity)) {
            return "trackup";
        }
        return "trackNone";
    }

    @Override
    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObject) {
        Object taxrate;
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(2);
        MatchPluginResult matchPluginResult = new MatchPluginResult();
        matchPluginResult.setMatchValue(String.valueOf(writeOffObject.getWriteOffObjectBase().getPkValue()));
        results.add(matchPluginResult);
        WriteOffObjectBase writeOffObjectBase = writeOffObject.getWriteOffObjectBase();
        String entityKey = writeOffObjectBase.getWFBillEntityName();
        DynamicObject typeConfig = writeOffObject.getTypeConfig();
        Object pkValue = typeConfig.getPkValue();
        BigDecimal taxrateValue = BigDecimal.ONE.negate();
        String unitName = "null";
        if ("ar_finarbill".equals(entityKey)) {
            taxrate = writeOffObjectBase.getValue("e_taxrate");
            String unit = (String)writeOffObjectBase.getValue("e_measureunit.name");
            if (!StringUtils.isEmpty((CharSequence)unit)) {
                unitName = unit;
            }
            if (taxrate != null) {
                taxrateValue = (BigDecimal)taxrate;
            }
        }
        if ("sim_original_bill".equals(entityKey)) {
            taxrate = (String)writeOffObjectBase.getValue("taxrate");
            String oriunit = (String)writeOffObjectBase.getValue("oriunit");
            if (!StringUtils.isEmpty((CharSequence)oriunit)) {
                unitName = oriunit;
            } else {
                String unit = (String)writeOffObjectBase.getValue("unit");
                if (!StringUtils.isEmpty((CharSequence)unit)) {
                    unitName = unit;
                }
            }
            if (taxrate != null && !"".equals(taxrate)) {
                taxrateValue = new BigDecimal((String)taxrate);
            }
        }
        if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP.equals(pkValue) || HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP.equals(pkValue)) {
            String HXLB = "botp";
            MatchPluginResult response = new MatchPluginResult();
            response.setMatchValue(HXLB + "#" + taxrateValue + "#" + unitName);
            response.setMatchName("BOTP");
            response.setComparison("in");
            results.add(response);
        }
        return results;
    }

    @Override
    public Boolean matchCompare(MatchPluginResult response, Object srcValue) {
        return Boolean.TRUE;
    }

    @Override
    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntryId) {
        if (value == null) {
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        String[] values = value.toString().split("#");
        String hxlb = values[0];
        if ("botp".equals(hxlb)) {
            BigDecimal taxrate = new BigDecimal(values[1]);
            String unitName = values[2];
            if (taxrate.compareTo(BigDecimal.ONE.negate()) == 0 || "null".equals(unitName)) {
                return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            }
            if ("ar_finarbill".equals(targetEntity)) {
                return new QFilter("entry.e_taxrate", "=", (Object)taxrate.multiply(new BigDecimal(100)).stripTrailingZeros()).and(new QFilter("entry.e_measureunit.name", "=", (Object)unitName));
            }
            if ("sim_original_bill".equals(targetEntity)) {
                return new QFilter("sim_original_bill_item.taxrate", "=", (Object)taxrate.divide(new BigDecimal("100")).stripTrailingZeros().toString()).and(new QFilter("sim_original_bill_item.oriunit", "=", (Object)unitName));
            }
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }
}

