/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class FinArSaloutUnWriteOffPlugin
implements IUnWriteOffCheckPlugin,
IUnWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(FinArSaloutUnWriteOffPlugin.class);
    private static final Long HXLB_AR_SAL_BOTP = 1682538187484133376L;
    private static final Long HXLB_AR_SAL_CORE = 1679120508043735040L;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(HXLB_AR_SAL_BOTP, HXLB_AR_SAL_CORE);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("ar_saloutwfrecord", new HashSet<String>(Arrays.asList("isvoucher", "writeofftypeid", "entry.e_hadwrittenoff", "entry.billid", "entry.billentryid", "entry.verifybaseqty", "entry.verifypricetotal", "entry.verifyamt")));
        return fieldMap;
    }

    @Override
    public boolean check(DynamicObject record) {
        if (record.getBoolean("isvoucher")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArSaloutUnWriteOffPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        boolean isHadWriteOff = false;
        DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            if (!entry.getBoolean("e_hadwrittenoff")) continue;
            isHadWriteOff = true;
            break;
        }
        if (isHadWriteOff) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinArSaloutUnWriteOffPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return true;
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        if (records == null || records.size() < 1) {
            return new HashMap<String, Map<String, List<Object[]>>>(8);
        }
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>(8);
        HashMap<Long, BigDecimal> finArIdAndVerifyAmt = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> finArBillIds = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long billId = entry.getLong("billid");
                finArBillIds.add(billId);
                BigDecimal verifyAmt = entry.getBigDecimal("verifyamt");
                finArIdAndVerifyAmt.merge(billId, verifyAmt, BigDecimal::add);
            }
        }
        HashMap<String, List> statusAndIdMap = new HashMap<String, List>(8);
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,amount,unverifyamount", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        for (DynamicObject bill : finArBills) {
            List verified;
            BigDecimal releaseVerifyAmount;
            BigDecimal unVerifyAmount;
            BigDecimal billunVerifyAmountBase;
            Long id = bill.getLong("id");
            BigDecimal amount = bill.getBigDecimal("amount");
            if (amount.compareTo(billunVerifyAmountBase = (unVerifyAmount = bill.getBigDecimal("unverifyamount")).add(releaseVerifyAmount = (BigDecimal)finArIdAndVerifyAmt.get(id))) == 0) {
                verified = statusAndIdMap.getOrDefault("unverify", new ArrayList(8));
                verified.add(id);
                statusAndIdMap.put("unverify", verified);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(billunVerifyAmountBase) == 0) {
                verified = statusAndIdMap.getOrDefault("verified", new ArrayList(8));
                verified.add(id);
                statusAndIdMap.put("verified", verified);
                continue;
            }
            List partVerify = statusAndIdMap.getOrDefault("partverify", new ArrayList(8));
            partVerify.add(id);
            statusAndIdMap.put("partverify", partVerify);
        }
        HashMap sqlLists = new HashMap(8);
        if (statusAndIdMap.size() > 0) {
            for (Map.Entry statusIdEntry : statusAndIdMap.entrySet()) {
                String key = (String)statusIdEntry.getKey();
                List value = (List)statusIdEntry.getValue();
                String sql = "update t_ar_finarbill set fverifystatus = ? where fid = ?";
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(8);
                for (Long id : value) {
                    Object[] param = new Object[]{key, id};
                    sqlParams.add(param);
                }
                sqlLists.put(sql, sqlParams);
            }
        }
        if (sqlLists.size() > 0) {
            sqlListMaps.put("fi", sqlLists);
        }
        return sqlListMaps;
    }

    @Override
    public void beforeWfRecordDelete(List<DynamicObject> records) {
        if (records == null || records.size() < 1) {
            return;
        }
        HashSet<Long> hxlbSet = new HashSet<Long>(8);
        hxlbSet.add(HXLB_AR_SAL_CORE);
        List<DynamicObject> arSalRecords = records.stream().filter(e -> hxlbSet.contains(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        if (arSalRecords.size() < 1) {
            return;
        }
        try {
            List<Map<String, Object>> paramList = this.buildArToSalParam(arSalRecords);
            List<Map<String, Object>> salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
            List<Map<String, Object>> salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList());
            if (salOrderParamList.size() > 0) {
                ArrayList<Map<String, Object>> salOrderParamHasSourceList = new ArrayList<Map<String, Object>>(8);
                for (Map map2 : salOrderParamList) {
                    if (map2.get("sourcebilltype") != null) {
                        map2.remove("sourcebilltype");
                        continue;
                    }
                    salOrderParamHasSourceList.add(map2);
                }
                this.disposeSalOrderService(salOrderParamHasSourceList);
                this.disposeSalContractService(salOrderParamList);
            }
            if (salContractParamList.size() > 0) {
                this.disposeSalContractService(salContractParamList);
            }
        }
        catch (RuntimeException e2) {
            throw new KDBizException(e2.getMessage());
        }
    }

    private List<Map<String, Object>> buildArToSalParam(List<DynamicObject> records) {
        Long[] coreIdAndEntryId;
        Long finArEntryId;
        Set seqTemp;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        Map<Long, Boolean> assactInterMap = this.isExistInternalBusinessUnit(records);
        ArrayList<Long> finArBillIds = new ArrayList<Long>(8);
        ArrayList<Long> finArBillEntryIds = new ArrayList<Long>(8);
        HashMap<Long, BigDecimal> entryIdQAndQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> entryIdQAndAmt = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billEntryId = entry.getLong("billentryid");
                finArBillIds.add(entry.getLong("billid"));
                finArBillEntryIds.add(billEntryId);
                entryIdQAndQty.merge(billEntryId, entry.getBigDecimal("verifybaseqty").negate(), BigDecimal::add);
                entryIdQAndAmt.merge(billEntryId, entry.getBigDecimal("verifypricetotal").negate(), BigDecimal::add);
            }
        }
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebilltype,entry.id,org.id,asstact.id,currency.amtprecision,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.e_conbillentity.number,entry.e_conbillnumber,entry.e_conbillrownum", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds), new QFilter("entry.id", "in", finArBillEntryIds)});
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<String> conBillNos = new HashSet<String>(8);
        HashMap coreNoAndSeqs = new HashMap(8);
        HashMap conNoAndSeqs = new HashMap(8);
        HashMap<String, Long> coreNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        HashMap<String, Long> conNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        for (DynamicObject finArBill : finArBills) {
            Long entryId = finArBill.getLong("entry.id");
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            String coreBillNo = finArBill.getString("entry.e_corebillno");
            int coreBillEntrySeq = finArBill.getInt("entry.e_corebillentryseq");
            if (!StringUtils.isEmpty((CharSequence)coreBillType) && !StringUtils.isEmpty((CharSequence)coreBillNo) && coreBillEntrySeq != 0) {
                coreNoSeqMapAndFinArEntryId.put(coreBillNo + coreBillEntrySeq, entryId);
                coreBillNos.add(coreBillNo);
                Set seqTemp2 = (Set)coreNoAndSeqs.get(coreBillNo);
                if (seqTemp2 == null) {
                    HashSet<Integer> seqList = new HashSet<Integer>(8);
                    seqList.add(coreBillEntrySeq);
                    coreNoAndSeqs.put(coreBillNo, seqList);
                } else {
                    seqTemp2.add(coreBillEntrySeq);
                }
            }
            String conBillType = finArBill.getString("entry.e_conbillentity.number");
            String conBillNo = finArBill.getString("entry.e_conbillnumber");
            String conBillEntrySeq = finArBill.getString("entry.e_conbillrownum");
            if (StringUtils.isEmpty((CharSequence)conBillType) || StringUtils.isEmpty((CharSequence)conBillNo) || StringUtils.isEmpty((CharSequence)conBillEntrySeq) || !conBillEntrySeq.matches("^[0-9]*$")) continue;
            conNoSeqMapAndFinArEntryId.put(conBillNo + conBillEntrySeq, entryId);
            conBillNos.add(conBillNo);
            Set seqTemp3 = (Set)conNoAndSeqs.get(conBillNo);
            if (seqTemp3 == null) {
                HashSet<String> seqList = new HashSet<String>(8);
                seqList.add(conBillEntrySeq);
                conNoAndSeqs.put(coreBillNo, seqList);
                continue;
            }
            seqTemp3.add(conBillEntrySeq);
        }
        HashMap<Long, Long[]> finArEntryIdAndCoreIdEntryId = new HashMap<Long, Long[]>(8);
        HashMap<Long, Long[]> finArEntryIdAndConIdEntryId = new HashMap<Long, Long[]>(8);
        if (coreBillNos.size() > 0) {
            DynamicObjectCollection salOrderBills = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billno,billentry.id,billentry.seq", (QFilter[])new QFilter[]{new QFilter("billno", "in", coreBillNos)});
            for (DynamicObject salOrderBill : salOrderBills) {
                long salOrderId = salOrderBill.getLong("id");
                long salOrderEntryId = salOrderBill.getLong("billentry.id");
                int salOrderEntrySeq = salOrderBill.getInt("billentry.seq");
                String salOrderNo = salOrderBill.getString("billno");
                seqTemp = (Set)coreNoAndSeqs.get(salOrderNo);
                if (seqTemp == null || !seqTemp.contains(salOrderEntrySeq) || (finArEntryId = (Long)coreNoSeqMapAndFinArEntryId.get(salOrderNo + salOrderEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndCoreIdEntryId.get(finArEntryId) != null) continue;
                coreIdAndEntryId = new Long[]{salOrderId, salOrderEntryId};
                finArEntryIdAndCoreIdEntryId.put(finArEntryId, coreIdAndEntryId);
            }
        }
        if (conBillNos.size() > 0) {
            DynamicObjectCollection salContractBills = QueryServiceHelper.query((String)"conm_salcontract", (String)"id,billno,billentry.id,billentry.lineno", (QFilter[])new QFilter[]{new QFilter("billno", "in", conBillNos)});
            for (DynamicObject salContractBill : salContractBills) {
                long salConId = salContractBill.getLong("id");
                long salConEntryId = salContractBill.getLong("billentry.id");
                String salConEntrySeq = salContractBill.getString("billentry.lineno");
                String salConNo = salContractBill.getString("billno");
                seqTemp = (Set)conNoAndSeqs.get(salConNo);
                if (seqTemp == null || !seqTemp.contains(salConEntrySeq) || (finArEntryId = (Long)conNoSeqMapAndFinArEntryId.get(salConNo + salConEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndConIdEntryId.get(finArEntryId) != null) continue;
                coreIdAndEntryId = new Long[]{salConId, salConEntryId};
                finArEntryIdAndConIdEntryId.put(finArEntryId, coreIdAndEntryId);
            }
        }
        for (DynamicObject finArBill : finArBills) {
            Long billId = finArBill.getLong("id");
            String sourceBillType = finArBill.getString("sourcebilltype");
            Long entryId = finArBill.getLong("entry.id");
            Long settleOrgId = finArBill.getLong("org.id");
            Long asstactId = finArBill.getLong("asstact.id");
            int amtPrecision = finArBill.getInt("currency.amtprecision");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            Long[] coreIdAndEntryId2 = (Long[])finArEntryIdAndCoreIdEntryId.get(entryId);
            if (coreIdAndEntryId2 == null) continue;
            Long coreBillId = coreIdAndEntryId2[0];
            Long coreBillEntryId = coreIdAndEntryId2[1];
            BigDecimal baseQty = (BigDecimal)entryIdQAndQty.get(entryId);
            BigDecimal amount = (BigDecimal)entryIdQAndAmt.get(entryId);
            Long[] conIdAndEntryId = (Long[])finArEntryIdAndConIdEntryId.get(entryId);
            Long conbillid = 0L;
            Long conbillentryid = 0L;
            if (conIdAndEntryId != null) {
                conbillid = conIdAndEntryId[0];
                conbillentryid = conIdAndEntryId[1];
            }
            String conbillentity = finArBill.getString("entry.e_conbillentity.number");
            if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
            String wbType = "sm_salorder".equals(coreBillType) ? "salorder" : "salcontract";
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("arinternalasst", isExistInternal);
            map.put("arasstactid", asstactId);
            map.put("arsettleorgid", settleOrgId);
            map.put("arMainBillEntity", coreBillType);
            map.put("soid", coreBillId);
            map.put("soentryid", coreBillEntryId);
            map.put("baseqty", baseQty);
            map.put("amount", amount.setScale(amtPrecision, RoundingMode.HALF_UP));
            map.put("conbillentity", conbillentity);
            map.put("conbillid", conbillid);
            map.put("conbillentryid", conbillentryid);
            map.put("wbtype", wbType);
            map.put("ArApBillId", billId);
            if ("sm_salorder".equals(sourceBillType)) {
                map.put("sourcebilltype", "sm_salorder");
            }
            params.add(map);
        }
        return params;
    }

    private Map<Long, Boolean> isExistInternalBusinessUnit(List<DynamicObject> records) {
        Map<Long, Boolean> tempAssactMap;
        HashSet<Long> supplierIds = new HashSet<Long>(8);
        HashSet<Long> customerIds = new HashSet<Long>(8);
        for (DynamicObject adjust : records) {
            String asstactType = adjust.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(adjust.getLong("asstact.id"));
            }
            if (!"bd_customer".equals(asstactType)) continue;
            customerIds.add(adjust.getLong("asstact.id"));
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(records.size());
        if (!supplierIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_supplier", supplierIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        if (!customerIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_customer", customerIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        return result;
    }

    private Map<Long, Boolean> checkInternalBusinessUnit(String entityName, Set<Long> assIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(assIds.size());
        Map assactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", assIds)});
        for (Map.Entry entrySet : assactMap.entrySet()) {
            DynamicObject asstact = (DynamicObject)entrySet.getValue();
            DynamicObject internalCompany = asstact.getDynamicObject("internal_company");
            if (internalCompany == null) {
                result.put(asstact.getLong("id"), Boolean.FALSE);
                continue;
            }
            if (internalCompany.getPkValue() != null && (Long)internalCompany.getPkValue() != 0L) {
                result.put(asstact.getLong("id"), Boolean.TRUE);
                continue;
            }
            result.put(asstact.getLong("id"), Boolean.FALSE);
        }
        return result;
    }

    private void disposeSalOrderService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSOAr");
        logger.info("FinArSaloutUnWriteOffPlugin.disposeSalOrderService.params:" + params);
        List<String> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId").toString()).distinct().collect(Collectors.toList());
        logger.info("FinArSaloutUnWriteOffPlugin.disposeSalOrderService.billid: " + arApBillIds);
        ECServiceHelper.execute("ar_salout_verify", "ar_salout_verify_wborder", "scmc", "sm", "fi", "SalWbService", arApBillIds, (Param)param, null, true);
    }

    private void disposeSalContractService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSalContAr");
        logger.info("FinArSaloutUnWriteOffPlugin.disposeSalContractService.params:" + params);
        List<String> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId").toString()).distinct().collect(Collectors.toList());
        logger.info("FinArSaloutUnWriteOffPlugin.disposeSalContractService.billid:" + arApBillIds);
        ECServiceHelper.execute("ar_salout_verify", "ar_salout_verify_wbcontract", "scmc", "conm", "fi", "SalConmService", arApBillIds, (Param)param, null, true);
    }
}

