/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.fi.arap.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.price.AbstractPriceCalculator;

public class PriceTotalCalculator
extends AbstractPriceCalculator {
    public PriceTotalCalculator(BigDecimal quantity, BigDecimal amount, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = false;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.amount = amount.setScale(currencyPrecision, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    public PriceTotalCalculator(BigDecimal quantity, BigDecimal amount, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt) {
        this.isTax = false;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.amount = amount.setScale(currencyPrecision, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        this.adjustamt = adjustamt;
    }

    public PriceTotalCalculator(BigDecimal quantity, BigDecimal amount, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt, BigDecimal discountamt) {
        this.isTax = false;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.amount = amount.setScale(currencyPrecision, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        this.adjustamt = adjustamt;
        if ("TOTAL".equals(discountmode)) {
            this.discountamount = discountamt;
        }
    }

    @Override
    public void calculate() {
        if (BigDecimal.ZERO.compareTo(this.quantity) == 0) {
            return;
        }
        if ("PERCENT".equals(this.discountmode)) {
            BigDecimal discountRate = this.discountrate.divide(ONE_HUNDRED);
            if (ONE.compareTo(discountRate) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            this.unitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP).divide(ONE.subtract(discountRate), 10, RoundingMode.HALF_UP);
            this.taxunitprice = this.unitprice.multiply(ONE.add(this.taxrate)).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = this.taxunitprice.multiply(this.quantity).multiply(discountRate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.unitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP).add(this.discountrate);
            this.taxunitprice = this.unitprice.multiply(ONE.add(this.taxrate)).setScale(10, RoundingMode.HALF_UP);
            this.discountamount = this.discountrate.multiply(this.quantity).multiply(ONE.add(this.taxrate)).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else {
            this.unitprice = this.amount.add(this.discountamount.divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP)).divide(this.quantity, 10, RoundingMode.HALF_UP);
            this.taxunitprice = this.unitprice.multiply(ONE.add(this.taxrate)).setScale(10, RoundingMode.HALF_UP);
        }
        this.tax = this.amount.multiply(this.taxrate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.pricetaxtotal = this.amount.add(this.tax).add(this.adjustamt);
        if (BigDecimal.ZERO.compareTo(this.discountamount) == 0) {
            this.actunitprice = this.unitprice;
            this.acttaxunitprice = this.taxunitprice;
        } else {
            this.actunitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP);
            this.acttaxunitprice = this.pricetaxtotal.subtract(this.adjustamt).divide(this.quantity, 10, RoundingMode.HALF_UP);
        }
    }
}

