/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AutoBillWriteOffGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.entity.AutoGenBillObj;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.AbstractMergeSplitHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll.MultiQueuePoller;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll.QueueElement;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.poll.QueueElementGroup;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.InvEntrustHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.im.BillUnitAndQtytHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.im.ImBillBotpHelp;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.model.AgencyWriteOffElement;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class AgencyRowSplitHandler
extends AbstractMergeSplitHandler {
    private static final Log log = LogFactory.getLog(AgencyRowSplitHandler.class);
    private boolean negate = false;

    public AgencyRowSplitHandler(boolean negate) {
        this.negate = negate;
    }

    private Set<Long> getSalAgencyEntryIds(List<AutoBillWriteOffGroup> queues) {
        HashSet<Long> salagencyEntryIds = new HashSet<Long>(16);
        for (AutoBillWriteOffGroup writeOffQueueGroup : queues) {
            List<IWriteOffQueue> candidateQueues = writeOffQueueGroup.getQueueGroup().getCandidateQueues();
            for (IWriteOffQueue iWriteOffQueue : candidateQueues) {
                List<WriteOffObjectBase> peekAll = iWriteOffQueue.peekAll();
                String wfBillEntityName = peekAll.get(0).getWFBillEntityName();
                if (!"sm_salesagency".equals(wfBillEntityName)) continue;
                for (WriteOffObjectBase baseObj : iWriteOffQueue.peekAll()) {
                    salagencyEntryIds.add((Long)baseObj.getPkValue());
                }
            }
        }
        return salagencyEntryIds;
    }

    @Override
    protected List<AutoBillWriteOffGroup> doExeucte(List<AutoBillWriteOffGroup> genAutoBillGroup) {
        HashMap allSaloutEntrySplitInfo = new HashMap(16);
        for (AutoBillWriteOffGroup autoBillWriteOffGroup : genAutoBillGroup) {
            Map<Object, List<AgencyWriteOffElement>> saloutEntrySplitInfo = this.getSrcIdToSaloutBillEntry(autoBillWriteOffGroup);
            MapUtils.mapMerge(allSaloutEntrySplitInfo, saloutEntrySplitInfo);
        }
        HashMap<String, Map<Object, DynamicObject>> basecache = new HashMap<String, Map<Object, DynamicObject>>(4);
        Set<Long> salAgencyEntryIds = this.getSalAgencyEntryIds(genAutoBillGroup);
        Map<Long, Map<String, Object>> salesAgencyMaps = InvEntrustHelper.getSalesAgencyMapsInfo(salAgencyEntryIds, basecache);
        HashMap<String, String> unitConvertCache = new HashMap<String, String>(16);
        List<DynamicObject> autoBillObjs = AutoBillWriteOffGroup.getAutoBillObjs(genAutoBillGroup);
        for (DynamicObject saloutBill : autoBillObjs) {
            InvEntrustHelper.validateSalOutBill(saloutBill);
            Long seq = 1L;
            DynamicObjectCollection genSaloutEntires = saloutBill.getDynamicObjectCollection("billentry");
            ArrayList<DynamicObject> newLines = new ArrayList<DynamicObject>();
            for (DynamicObject genSaloutEntry : genSaloutEntires) {
                List infos = (List)allSaloutEntrySplitInfo.get(genSaloutEntry.getPkValue());
                if (infos == null) {
                    throw new KDBizException("splitInfo not exist:" + genSaloutEntry.getPkValue());
                }
                BigDecimal oribaseQty = genSaloutEntry.getBigDecimal("baseqty");
                BigDecimal ori2ndQty = genSaloutEntry.getBigDecimal("qtyunit2nd");
                BigDecimal unitRate = this.getUnitConvert(genSaloutEntry, unitConvertCache);
                AgencyWriteOffElement srcElemnt = null;
                for (int i = 0; i < infos.size(); ++i) {
                    AgencyWriteOffElement elemnt = (AgencyWriteOffElement)infos.get(i);
                    Object salAgencyEntryId = elemnt.getAgencyWfObj().getPkValue();
                    BigDecimal curqty = elemnt.getNumber();
                    if (this.negate) {
                        curqty = curqty.negate();
                    }
                    Map<String, Object> salesAgencyEntryInfo = salesAgencyMaps.get(salAgencyEntryId);
                    if (seq == 1L) {
                        InvEntrustHelper.setSalOutProp(saloutBill, salesAgencyEntryInfo, basecache);
                    }
                    DynamicObject curSalOutBillEntry = genSaloutEntry;
                    if (i == 0) {
                        srcElemnt = elemnt;
                    } else {
                        DynamicObject salOutBillSplitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)genSaloutEntry, (boolean)false, (boolean)true);
                        salOutBillSplitEntry.setParent((Object)saloutBill);
                        DynamicObjectUtil.setBilEntrylId(salOutBillSplitEntry);
                        newLines.add(salOutBillSplitEntry);
                        curSalOutBillEntry = salOutBillSplitEntry;
                        if (srcElemnt != null && srcElemnt.getGroup() == elemnt.getGroup()) {
                            elemnt.addNewAutoGenEntry(salOutBillSplitEntry);
                        } else {
                            elemnt.replaceAutoGenEntry(salOutBillSplitEntry, genSaloutEntry);
                        }
                    }
                    InvEntrustHelper.setSalOutEntryProp(curSalOutBillEntry, salesAgencyEntryInfo, seq, oribaseQty, ori2ndQty, unitRate, basecache, curqty);
                    Long l = seq;
                    Long l2 = seq = Long.valueOf(seq + 1L);
                }
            }
            if (!newLines.isEmpty()) {
                genSaloutEntires.addAll(newLines);
            }
            ImBillBotpHelp.reCalFields(saloutBill, "im_saloutbill");
        }
        return genAutoBillGroup;
    }

    private BigDecimal getUnitConvert(DynamicObject genSaloutEntry, Map<String, String> unitConvertCache) {
        Object material = genSaloutEntry.get("materialmasterid");
        Long materialmasterid = material instanceof DynamicObject ? (Long)((DynamicObject)material).getPkValue() : (Long)material;
        DynamicObject baseUnit = genSaloutEntry.getDynamicObject("baseunit");
        DynamicObject unit = genSaloutEntry.getDynamicObject("unit");
        return BillUnitAndQtytHelper.getUnitRateConv(materialmasterid, (Long)baseUnit.getPkValue(), (Long)unit.getPkValue(), unitConvertCache);
    }

    private Map<Object, List<AgencyWriteOffElement>> getSrcIdToSaloutBillEntry(AutoBillWriteOffGroup autoBillWriteOffGroup) {
        HashMap<Object, Object> srcToTargetEntry = new HashMap<Object, Object>(16);
        for (AutoGenBillObj autoGenBillObj : autoBillWriteOffGroup.getGenObjs()) {
            DynamicObject genSaloutEntry = autoGenBillObj.getObj();
            DynamicObjectCollection linkEntries = genSaloutEntry.getDynamicObjectCollection("billentry_lk");
            if (linkEntries == null || linkEntries.isEmpty()) {
                log.info("\u59d4\u6258\u4ee3\u9500\u62c6\u884c\u2014\u2014\u751f\u6210\u5355\u5206\u5f55\u5173\u8054\u5173\u7cfb\u4e3a\u7a7a\u3002");
                continue;
            }
            Object linkId = ((DynamicObject)linkEntries.get(0)).get("billentry_lk_sid");
            srcToTargetEntry.put(linkId, genSaloutEntry);
        }
        MultiQueuePoller<WriteOffObjectBase> poller = new MultiQueuePoller<WriteOffObjectBase>();
        List<IWriteOffQueue> candidateQueues = autoBillWriteOffGroup.getQueueGroup().getCandidateQueues();
        for (IWriteOffQueue iWriteOffQueue : candidateQueues) {
            List<WriteOffObjectBase> peekAll = iWriteOffQueue.peekAll();
            String wfBillEntityName = peekAll.get(0).getWFBillEntityName();
            if ("sm_salesagency".equals(wfBillEntityName)) {
                for (WriteOffObjectBase writeOffObjectBase : iWriteOffQueue.peekAll()) {
                    poller.addMainElement(writeOffObjectBase, writeOffObjectBase.getWriteOffNumber());
                }
                continue;
            }
            for (WriteOffObjectBase writeOffObjectBase : iWriteOffQueue.peekAll()) {
                poller.addAssistElement(writeOffObjectBase, writeOffObjectBase.getWriteOffNumber());
            }
        }
        List pollQueue = poller.pollQueue();
        HashMap<Object, List<AgencyWriteOffElement>> splitInfos = new HashMap<Object, List<AgencyWriteOffElement>>(16);
        for (QueueElementGroup queue : pollQueue) {
            for (QueueElement queueElement : queue.getAssistQueueElement()) {
                WriteOffObjectBase salAgencyObj = (WriteOffObjectBase)queue.getMainQueueElement().getElement();
                Object matchedSaloutEntryId = ((WriteOffObjectBase)queueElement.getElement()).getPkValue();
                DynamicObject genSaloutBillEntry = (DynamicObject)srcToTargetEntry.get(matchedSaloutEntryId);
                AgencyWriteOffElement agencyWriteOffElement = new AgencyWriteOffElement(genSaloutBillEntry, queueElement.getNumber());
                agencyWriteOffElement.setInfo(salAgencyObj, (WriteOffObjectBase)queueElement.getElement(), autoBillWriteOffGroup);
                MapUtils.mapGetListValue(splitInfos, genSaloutBillEntry.getPkValue()).add(agencyWriteOffElement);
            }
        }
        return splitInfos;
    }
}

