/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.AutoBillArrangeHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.IAutoBillHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.generate.handler.SplitByWriteOffQueueHandler;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractNewWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.AgencyRowSplitHandler;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;

public class AgencyWriteOffStrategy
extends AbstractNewWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(AgencyWriteOffStrategy.class);

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            if (!writeOffQueue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        logger.info("\u59d4\u6258\u4ee3\u9500\u6838\u9500AgencyWriteOffStrategy");
        ArrayList<IWriteOffQueue> selectedQueues = new ArrayList<IWriteOffQueue>(10);
        BigDecimal needWriteOffNumber = this.countWriteOffNumber(candidateQueues);
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            IWriteOffQueue writeOffQueue = candidateQueue.pollQueue(false, needWriteOffNumber);
            selectedQueues.add(writeOffQueue);
        }
        return selectedQueues;
    }

    private BigDecimal countWriteOffNumber(List<IWriteOffQueue> candidateQueues) {
        BigDecimal sumWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            BigDecimal thisSumWriteOffNumber = writeOffQueue.getSumWriteOffNumber();
            if (thisSumWriteOffNumber.abs().compareTo(sumWriteOffNumber.abs()) >= 0) continue;
            sumWriteOffNumber = thisSumWriteOffNumber;
        }
        return sumWriteOffNumber;
    }

    @Override
    protected List<IAutoBillHandler> getAutoBillHandlers() {
        ArrayList<IAutoBillHandler> handlers = new ArrayList<IAutoBillHandler>(2);
        if (WriteOffTypeIdConst.HXLB_WTDX_SALES.equals(this.getTypeConfig().getId())) {
            handlers.add(new AgencyRowSplitHandler(false));
        } else if (WriteOffTypeIdConst.HXLB_WTDX_SALES_RETURN.equals(this.getTypeConfig().getId())) {
            handlers.add(new AgencyRowSplitHandler(true));
        }
        if (!this.getTypeConfig().isMergeAutoBill()) {
            logger.info("\u59d4\u6258\u4ee3\u9500\u6838\u9500 \u751f\u6210\u6267\u884c\u5355\u636e\u62c6\u5206");
            handlers.add(new SplitByWriteOffQueueHandler());
        } else {
            logger.info("\u59d4\u6258\u4ee3\u9500\u6838\u9500 \u751f\u6210\u5355\u636e\u5408\u5e76\u4e0d\u62c6\u5206");
        }
        handlers.add(new AutoBillArrangeHandler());
        return handlers;
    }
}

