/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CommonHelper {
    private CommonHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static BigDecimal getDesQtyConv(DynamicObject matMasterID, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (matMasterID != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)matMasterID.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt("precision");
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, CommonHelper.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    public static int getRoundMode(DynamicObject unit) {
        String precisionaccount = unit.getString("precisionaccount");
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionaccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionaccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    public static <T> T invokeIMBizService(String serviceName, String methodName, Object ... paras) {
        try {
            return (T)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)serviceName, (String)methodName, (Object[])paras);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

