/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWriteOffDetail;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.im.SettleBillHelper;

public class BillTplIsPushValidator {
    private static final String PUR_IN_STOCK = "pur_instock";
    private static final String PUR_RETURN = "pur_return";
    private static final String PUR_RECEIPT = "pur_receipt";
    private static final String PUR_RECEIPT_RETURN = "pur_receipt_return";
    private static final String PM_TRANSFERBILL = "pm_transferbill";
    private static final String BBC_DELIVERY_RECORD = "bbc_delivery_record";
    private static final String OCBSOC_DELIVERY_RECORD = "ocbsoc_delivery_record";
    private static final String IM_SALOUTBILL = "im_saloutbill";
    private static Map<String, List<String>> skipMap = new HashMap<String, List<String>>(4);
    private static List<String> skipList = new ArrayList<String>(4);

    public void validate(DynamicObject record) {
        BackWriteOffDetail backWriteOffDetail = WriteOffRecordHelper.getWfInfo(record);
        if (backWriteOffDetail == null || backWriteOffDetail.getAutoList() == null) {
            return;
        }
        HashMap map = new HashMap(16);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (BackWriteOffDetail.AutoGeneration bill : backWriteOffDetail.getAutoList()) {
            String billType = bill.getBillType();
            Long billId = bill.getBillId();
            ids.add(billId);
            map.putIfAbsent(billType, new HashSet(4));
            ((Set)map.get(billType)).add(billId);
        }
        Map<Long, Map<String, HashSet<Long>>> settleBills = SettleBillHelper.getGenerateSettleBills(ids);
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject[] dataEntities;
            String billType = (String)entry.getKey();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
            for (DynamicObject dataEntity : dataEntities = BusinessDataServiceHelper.load((Object[])((Set)entry.getValue()).toArray(), (DynamicObjectType)dataEntityType)) {
                Set<String> settleIds;
                Long id = dataEntity.getLong("id");
                boolean isPushed = this.isPushed(id, billType, settleIds = this.parseBillMap(settleBills.get(id)));
                if (!isPushed) continue;
                String pushMsg = ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u7ed3\u7b97\u3002", (String)"BillTplIsPushValidator_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                throw new KDBizException(pushMsg);
            }
        }
    }

    private boolean isPushed(Long id, String srcBillType, Set<String> settleIds) {
        Map pushedBills = BFTrackerServiceHelper.findTargetBills((String)srcBillType, (Long[])new Long[]{id});
        if (pushedBills == null || pushedBills.isEmpty()) {
            return false;
        }
        boolean skipPushCheck = this.canSkipValidate(srcBillType, pushedBills.keySet());
        if (skipPushCheck) {
            return false;
        }
        Set<String> ids = this.parseBillMap(pushedBills);
        ids.removeAll(settleIds);
        return !ids.isEmpty();
    }

    private boolean canSkipValidate(String srcBillType, Set<String> targetEntities) {
        List<String> subBillTypes = skipMap.get(srcBillType);
        if (subBillTypes == null || subBillTypes.isEmpty()) {
            subBillTypes = new ArrayList<String>();
        }
        Iterator<String> iterator = targetEntities.iterator();
        while (iterator.hasNext()) {
            String targetEntity = iterator.next();
            if (!subBillTypes.contains(targetEntity) && !skipList.contains(targetEntity)) continue;
            iterator.remove();
        }
        return targetEntities.isEmpty();
    }

    private Set<String> parseBillMap(Map<String, HashSet<Long>> maps) {
        HashSet<String> ids = new HashSet<String>();
        if (maps != null) {
            for (Map.Entry<String, HashSet<Long>> entry : maps.entrySet()) {
                HashSet<Long> targetIds = entry.getValue();
                for (Long targetId : targetIds) {
                    ids.add(entry.getKey() + "-" + targetId);
                }
            }
        }
        return ids;
    }

    static {
        ArrayList<String> targetBills = new ArrayList<String>();
        targetBills.add(PUR_RECEIPT);
        targetBills.add(PUR_RECEIPT_RETURN);
        skipMap.put("im_purreceivebill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(IM_SALOUTBILL);
        skipMap.put("im_purinbill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put("im_materialreqoutbill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(BBC_DELIVERY_RECORD);
        targetBills.add(OCBSOC_DELIVERY_RECORD);
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put(IM_SALOUTBILL, targetBills);
        targetBills = new ArrayList();
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put("im_otheroutbill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put("im_transdirbill", targetBills);
        skipList.add(PUR_IN_STOCK);
        skipList.add(PUR_RETURN);
    }
}

