/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency.plugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.AgencyWriteOffHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FieldWriteBackEntity;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FormulaTypeEnum;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.GeneratorBillWf;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;

public class AgencyWFPlugin
implements IWriteOffPlugin {
    private static final Log LOG = LogFactory.getLog(AgencyWFPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WTDX_SALES);
    }

    @Override
    public void generateBillDeal(List<IWriteOffQueue> list, List<GeneratorBillWf> generateBills) {
        if (list == null || list.isEmpty() || generateBills == null || generateBills.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> autoBills = new HashMap<Long, DynamicObject>(16);
        for (GeneratorBillWf bill : generateBills) {
            List<DynamicObject> autoDynamic = bill.getAutoDynamic();
            for (DynamicObject ob : autoDynamic) {
                Long pkValue = (Long)ob.getPkValue();
                autoBills.put(pkValue, ob);
            }
        }
        Map<Long, BigDecimal> autoBillWfRes = AgencyWriteOffHelper.autoBillWfQty(generateBills);
        Map<Long, BigDecimal> agencyWfRes = AgencyWriteOffHelper.getQueueWfQty(list, "sm_salesagency");
        if (agencyWfRes.isEmpty() || autoBillWfRes.isEmpty()) {
            return;
        }
        LOG.info(MessageFormat.format(ResManager.loadKDString((String)"\u63d0\u53d6\u5230\u7684\u6e05\u5355\uff1a{0}, \u63d0\u53d6\u5230\u7684\u81ea\u52a8\u751f\u6210\u5355 \uff1a{1}", (String)"AgencyWFHandle_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), agencyWfRes, autoBillWfRes));
        Map<Long, Map<Long, BigDecimal>> groupWriteOffRes = AgencyWriteOffHelper.groupWriteOff(agencyWfRes, autoBillWfRes, false);
        LOG.info(ResManager.loadKDString((String)("\u6838\u9500\u8bb0\u5f55\u62c6\u5206\u7ed3\u679c\uff1a" + groupWriteOffRes), (String)"AgencyWFHandle_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        Map<Long, Map<String, String>> res = AgencyWriteOffHelper.spiltRow(groupWriteOffRes, autoBills);
        LOG.info("res = " + res);
    }

    @Override
    public void afterWfAutoGenerate(List<DynamicObject> generateBills) {
        List<Object> ids = generateBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        AgencyWriteOffHelper.executeOperateByWriteOff(ids);
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        LOG.info("AgencyWFHandle-buildBackSql-start");
        Map<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>(16);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection recordEntry;
            if (recordBill == null || (recordEntry = recordBill.getDynamicObjectCollection("entry")) == null || recordEntry.isEmpty()) continue;
            HashSet<String> entityType = new HashSet<String>();
            for (DynamicObject t : recordEntry) {
                DynamicObject billType = t.getDynamicObject("billtype");
                if (billType == null) continue;
                entityType.add(billType.getString("number"));
            }
            if (!entityType.contains("sm_salesagency")) continue;
            List<DynamicObject> sendBills = AgencyWriteOffHelper.getOutBill(recordBill, 688857787480045568L);
            List outBillIDs = sendBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            HashMap<Long, BigDecimal> returnQty = new HashMap<Long, BigDecimal>(16);
            for (DynamicObject record : recordEntry) {
                if (!outBillIDs.contains(record.getLong("billid"))) continue;
                returnQty.put(record.getLong("billentryid"), record.getBigDecimal("qty"));
            }
            ArrayList<FieldWriteBackEntity> backFields = new ArrayList<FieldWriteBackEntity>(5);
            backFields.add(new FieldWriteBackEntity("remainbackqty", "fremainbackqty", "unit", "remainbasebackqty", "fremainbasebackqty", "baseunit", FormulaTypeEnum.SUBTRACT));
            backFields.add(new FieldWriteBackEntity("entrustverifyqty", "fentrustverifyqty", "unit", "entrustverifybaseqty", "fentrustverifybaseqty", "baseunit", FormulaTypeEnum.ADD));
            sqlListMaps = AgencyWriteOffHelper.buildBackOrderSql(sendBills, returnQty, backFields, sqlListMaps);
        }
        LOG.info("AgencyWFHandle-buildBackSql-end");
        return sqlListMaps;
    }
}

