/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.agency.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.AgencyWriteOffHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FieldWriteBackEntity;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.FormulaTypeEnum;
import kd.mpscmm.mscommon.writeoff.ext.scmc.agency.helper.im.BillTplIsPushBatchValidator;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffPlugin;

public class ReturnAgencyUnWFPlugin
implements IUnWriteOffPlugin,
IUnWriteOffCheckPlugin {
    private static final Log LOG = LogFactory.getLog(ReturnAgencyUnWFPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WTDX_SALES_RETURN);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("sm_wfrecord", new HashSet<String>(Arrays.asList("headwfinfo_tag", "entry.billtype", "entry.billid", "entry.billentryid", "entry.qty")));
        return fieldMap;
    }

    @Override
    public void check(List<DynamicObject> wfRecordList) {
        BillTplIsPushBatchValidator validator = new BillTplIsPushBatchValidator();
        validator.validate(wfRecordList);
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        LOG.info("ReturnAgencyUnWFHandle-buildBackSql-start");
        Map<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>(16);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection recordEntry;
            if (recordBill == null || (recordEntry = recordBill.getDynamicObjectCollection("entry")) == null || recordEntry.isEmpty()) continue;
            HashSet<String> entityType = new HashSet<String>();
            for (DynamicObject t : recordEntry) {
                DynamicObject billType = t.getDynamicObject("billtype");
                if (billType == null) continue;
                entityType.add(billType.getString("number"));
            }
            if (!entityType.contains("sm_salesagency")) continue;
            List<DynamicObject> salesBills = AgencyWriteOffHelper.getOutBill(recordBill, 1103399833190053888L);
            List salesBillIDs = salesBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            HashMap<Long, BigDecimal> returnQty = new HashMap<Long, BigDecimal>(4);
            for (DynamicObject record : recordEntry) {
                if (!salesBillIDs.contains(record.getLong("billid"))) continue;
                returnQty.put(record.getLong("billentryid"), record.getBigDecimal("qty"));
            }
            if (returnQty.isEmpty()) continue;
            ArrayList<FieldWriteBackEntity> backFields = new ArrayList<FieldWriteBackEntity>(5);
            backFields.add(new FieldWriteBackEntity("remainreturnqty", "fremainreturnqty", "unit", "remainreturnbaseqty", "fremainreturnbaseqty", "baseunit", FormulaTypeEnum.SUBTRACT));
            backFields.add(new FieldWriteBackEntity("entrustunverifyqty", "fentrustunverifyqty", "unit", "entrustunverifybaseqty", "fentrustunverifybaseqty", "baseunit", FormulaTypeEnum.SUBTRACT));
            backFields.add(new FieldWriteBackEntity("entrustverifyqty", "fentrustverifyqty", "unit", "entrustverifybaseqty", "fentrustverifybaseqty", "baseunit", FormulaTypeEnum.ADD));
            sqlListMaps = AgencyWriteOffHelper.buildBackSendBillSql(salesBills, returnQty, backFields, sqlListMaps);
            backFields.clear();
            backFields.add(new FieldWriteBackEntity("remainbackqty", "fremainbackqty", "unit", "remainbasebackqty", "fremainbasebackqty", "baseunit", FormulaTypeEnum.SUBTRACT));
            backFields.add(new FieldWriteBackEntity("entrustverifyqty", "fentrustverifyqty", "unit", "entrustverifybaseqty", "fentrustverifybaseqty", "baseunit", FormulaTypeEnum.ADD));
            sqlListMaps = AgencyWriteOffHelper.buildBackOrderSql(salesBills, returnQty, backFields, sqlListMaps);
        }
        LOG.info("ReturnAgencyUnWFHandle-buildBackSql-end");
        return sqlListMaps;
    }

    @Override
    public void autoBillDelete(String billType, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        AgencyWriteOffHelper.executeOperateByUnWriteOff(idList);
    }
}

