/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.MatchPluginResult;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class PurOmReturnMatchPlugin
implements IMatchPlugin {
    private static final Log logger = LogFactory.getLog(PurOmReturnMatchPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR_OMRETURN);
    }

    @Override
    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.PPGZ_PUR_OMRETURN);
    }

    @Override
    public List<MatchPluginResult> matchCondition(WriteOffObjectArgs writeOffObjectArgs) {
        ArrayList<MatchPluginResult> results = new ArrayList<MatchPluginResult>(1);
        WriteOffObjectBase writeOffObject = writeOffObjectArgs.getWriteOffObjectBase();
        String entityKey = writeOffObject.getWFBillEntityName();
        if (!"im_ospurinbill".equals(entityKey)) {
            logger.info("PurOmReturnMatchPlugin:\u6838\u9500\u5bf9\u8c61\u4e0d\u662f\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355");
            return results;
        }
        Object billId = writeOffObject.getWfBillPk();
        Object entryId = writeOffObject.getPkValue();
        String entryKey = writeOffObject.getMainFieldEntityType().getName();
        MatchPluginResult response = new MatchPluginResult();
        StringBuilder matchInfoBuild = new StringBuilder();
        matchInfoBuild.append(entityKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(billId);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryKey);
        matchInfoBuild.append('#');
        matchInfoBuild.append(entryId);
        response.setMatchValue(matchInfoBuild.toString());
        response.setMatchName("puromreturn");
        response.setComparison("in");
        results.add(response);
        return results;
    }

    @Override
    public QFilter getMatchFilter(Object value, String targetEntity, String targetEntry) {
        logger.info("PurOmReturnMatchPlugin:\u5f00\u59cb\u6784\u9020\u8fc7\u6ee4\u6761\u4ef6");
        if (!"im_osmaterialreqoutbill".equals(targetEntity)) {
            logger.info("PurOmReturnMatchPlugin:\u76ee\u6807\u5355\u4e0d\u662f\u9886\u6599\u5355:" + targetEntity);
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        if (value == null) {
            logger.info("PurOmReturnMatchPlugin:\u65e0\u5339\u914d\u7ed3\u679c");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        String[] values = value.toString().split("#");
        String entityKey = values[0];
        Long billId = Long.valueOf(values[1]);
        String entryKey = values[2];
        Long entryId = Long.valueOf(values[3]);
        HashSet<Long> srcBillIds = new HashSet<Long>(8);
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(8);
        this.handleLinkUpNodes(entityKey, entryKey, billId, entryId, "im_ospurinbill", srcBillIds, srcBillEntryIds);
        if (srcBillIds.isEmpty()) {
            logger.info("PurOmReturnMatchPlugin:\u672a\u627e\u5230\u4e0a\u6e38\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        QFilter recordQ = new QFilter("entry.billid", "in", srcBillIds);
        recordQ.and("entry.billentryid", "in", srcBillEntryIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"im_oswfrecord", (String)"entry.billid,entry.billentryid,entry.billtype", (QFilter[])recordQ.toArray());
        HashSet<Long> reqOutIds = new HashSet<Long>(16);
        HashSet<Long> reqOutEntryIds = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                String billType = entry.getDynamicObject("billtype").getString("number");
                if (!"im_osmaterialreqoutbill".equals(billType)) continue;
                reqOutIds.add(entry.getLong("billid"));
                reqOutEntryIds.add(entry.getLong("billentryid"));
            }
        }
        if (reqOutIds.isEmpty()) {
            logger.info("PurOmReturnMatchPlugin:\u4ece\u6750\u6599\u6838\u9500\u8bb0\u5f55\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u9886\u6599\u5355");
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        QFilter targetFilter = new QFilter("id", "in", reqOutIds);
        targetFilter.and(targetEntry, "in", reqOutEntryIds);
        return targetFilter;
    }

    private void handleLinkUpNodes(String curEntity, String curEntryKey, Long curId, Long curEntryId, String targetEntity, Set<Long> ids, Set<Long> entryIds) {
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)curEntity, (String)curEntryKey, (Long[])new Long[]{curId}, (Long[])new Long[]{curEntryId}, null);
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)targetEntity);
        Long upTableId = tableDefine.getTableId();
        for (BFRowLinkUpNode linkUpNode : linkUpNodes) {
            List<BFRowLinkUpNode> sourceNodes = PurOmReturnMatchPlugin.findSourceNodes(linkUpNode, upTableId, curId);
            for (BFRowLinkUpNode sourceNode : sourceNodes) {
                ids.add(sourceNode.getRowId().getBillId());
                entryIds.add(sourceNode.getRowId().getEntryId());
            }
        }
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(PurOmReturnMatchPlugin.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }
}

