/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IMatchPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffGroupArgs;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class PurOmSupplierMatchPlugin
implements IMatchPlugin {
    private static final Log logger = LogFactory.getLog(PurOmSupplierMatchPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_OS_PURIN);
    }

    @Override
    public Set<Long> getMachRuleIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.PPGZ_PUR_OMSUPPLILER);
    }

    @Override
    public void batchSetMatchFilter(String srcAlias, List<WriteOffGroupArgs> mainWfObjs) {
        for (WriteOffGroupArgs mainWfGroup : mainWfObjs) {
            String paramValue;
            List<WriteOffObjectBase> wfObjBases = mainWfGroup.getObjects();
            if (wfObjBases.isEmpty()) continue;
            Date minBookDate = this.getMinBookDate(wfObjBases);
            DynamicObject topWfObj = wfObjBases.get(0).getWriteOffObject();
            Long orgId = topWfObj.getLong("entrysettleorg");
            Long supplierId = topWfObj.getLong("supplier");
            HashSet<Long> orderIds = new HashSet<Long>(16);
            HashSet<Long> orderEntryIds = new HashSet<Long>(16);
            for (WriteOffObjectBase wfObjBase : wfObjBases) {
                DynamicObject wfObj = wfObjBase.getWriteOffObject();
                orderIds.add((Long)wfObj.get("mainbillid"));
                orderEntryIds.add((Long)wfObj.get("mainbillentryid"));
            }
            QFilter orderBillQ = new QFilter("id", "in", orderIds);
            orderBillQ.and("billentry.id", "in", orderEntryIds);
            DataSet orderDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"billentry.billentry_sub.submaterial as matid,org", (QFilter[])orderBillQ.toArray(), null);
            HashSet<Long> matIDs = new HashSet<Long>(16);
            for (Row row : orderDs) {
                matIDs.add(row.getLong("matid"));
            }
            if (matIDs.isEmpty()) {
                mainWfGroup.setNotMatch("im_osmaterialreqoutbill");
                logger.info("PurOmSupplierMatchPlugin:\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u4fe1\u606f,supplierid" + supplierId);
                continue;
            }
            QFilter reqBillQ = new QFilter("settleorg", "=", (Object)orgId);
            reqBillQ.and("supplier", "=", (Object)supplierId);
            reqBillQ.and("billstatus", "=", (Object)Character.valueOf('C'));
            reqBillQ.and("billentry.material", "in", matIDs);
            reqBillQ.and("billentry.osunverifyqty", ">", (Object)BigDecimal.ZERO);
            Calendar bookDateRangeCalendar = Calendar.getInstance();
            bookDateRangeCalendar.setTime(minBookDate);
            int dateRange = 365;
            QFilter qFilter = new QFilter("key", "=", (Object)"supwfdayrange");
            qFilter.and("org", "=", (Object)0L);
            DynamicObject paramObj = QueryServiceHelper.queryOne((String)"im_invdbparam", (String)"value", (QFilter[])qFilter.toArray());
            if (paramObj != null && !StringUtils.isEmpty((String)(paramValue = paramObj.getString("value")))) {
                dateRange = Integer.parseInt(paramValue);
            }
            bookDateRangeCalendar.add(6, -dateRange);
            reqBillQ.and("bookdate", ">", (Object)bookDateRangeCalendar.getTime());
            reqBillQ.and("bookdate", "<=", (Object)minBookDate);
            DataSet reqBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_osmaterialreqoutbill", (String)"id,billentry.id as entryid,billentry.material as matid", (QFilter[])reqBillQ.toArray(), null);
            HashSet<Long> reqBillIds = new HashSet<Long>(16);
            HashSet<Long> reqBillEntryIds = new HashSet<Long>(16);
            for (Row row : reqBillDs) {
                reqBillIds.add(row.getLong("id"));
                reqBillEntryIds.add(row.getLong("entryid"));
            }
            if (reqBillIds.isEmpty()) {
                mainWfGroup.setNotMatch("im_osmaterialreqoutbill");
                logger.info("PurOmSupplierMatchPlugin:\u672a\u83b7\u53d6\u5230\u9886\u6599\u5355,supplierid" + supplierId);
                continue;
            }
            QFilter targetFilter = new QFilter("id", "in", reqBillIds);
            targetFilter.and("billentry.id", "in", reqBillEntryIds);
            mainWfGroup.setFilter("im_osmaterialreqoutbill", targetFilter);
        }
    }

    private Date getMinBookDate(List<WriteOffObjectBase> wfObjBases) {
        Date minBookDate = null;
        for (WriteOffObjectBase wfObjBase : wfObjBases) {
            DynamicObject writeOffObject = wfObjBase.getWriteOffObject();
            Date bookDate = writeOffObject.getDate("bookdate");
            if (minBookDate != null && !bookDate.before(minBookDate)) continue;
            minBookDate = bookDate;
        }
        minBookDate = minBookDate == null ? TimeServiceHelper.now() : minBookDate;
        minBookDate = PurOmSupplierMatchPlugin.getThisMonthEndDay(minBookDate);
        return minBookDate;
    }

    public static Date getThisMonthEndDay(Date minBookDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(minBookDate);
        ca.set(5, ca.getActualMaximum(5));
        ca.set(ca.get(1), ca.get(2), ca.get(5), 23, 59, 59);
        return ca.getTime();
    }
}

