/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin.WriteOffDealRecordCommomCalPlugin;

public class PurWriteOffDealSwapplCalPlugin
extends WriteOffDealRecordCommomCalPlugin {
    private static final Log logger = LogFactory.getLog(PurWriteOffDealSwapplCalPlugin.class);
    private static String[] noCalServiceBillArr = new String[]{"ap_finapbill"};
    private String crtWfQtyNum = "";
    private String crtWfBaseQtyNum = "";
    private String crtWfAmtNum = "";
    private String crtWfLocalAmtNum = "";
    private String crtWfTaxAmtNum = "";
    private String crtWfLocalTaxAmtNum = "";
    private String crtWfIntercostNum = "";
    private String rateNum = "";
    private static final String noWfBaseQtyNum = "unverifybaseqty";
    private static final String baseQtyNum = "baseqty";
    private static final String amountNum = "amount";
    private static final String localAmountNum = "baseamount";
    private static final String taxAmtNum = "taxamt";
    private static final String localTaxAmtNum = "localtaxamt";
    private static final String priceNum = "price";
    private static final String taxPriceNum = "pricetax";
    private static final String interCostAmtNum = "intercostamt";
    private static final String quotationNum = "quotation";
    private static final String currencyAmtPresionNum = "cryamtpresion";
    private static final String localCurrencyAmtPresionNum = "basecryamtpresion";
    private boolean isCalInterCost = false;
    private Map<Long, BigDecimal> accureEntryWfQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> accureAmtMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> accureTaxAmtMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> accureLocalAmtMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> accureLocalTaxAmtMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, BigDecimal> accureInterCostAmtMap = new HashMap<Long, BigDecimal>(16);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR, WriteOffTypeIdConst.HXLB_PUR_RED_FLUSH, WriteOffTypeIdConst.HXLB_PRODUCT_OM, WriteOffTypeIdConst.HXLB_INVOICE_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE, WriteOffTypeIdConst.HXLB_PURRECEIVE_RED_FLUSH, WriteOffTypeIdConst.HXLB_PRODUCT_OM_RED, WriteOffTypeIdConst.HXLB_SIMPLE_OM_RED, WriteOffTypeIdConst.HXLB_SIMPLE_OM, WriteOffTypeIdConst.HXLB_PUR_OMIN, WriteOffTypeIdConst.HXLB_PUR_OMREDBLUE);
    }

    @Override
    public void beforeAllWfRecordGenerate(List<DynamicObject> recordBills) {
        super.beforeAllWfRecordGenerate(recordBills);
        logger.info("\u8fdb\u5165\u91c7\u8d2d\u6838\u9500\u8bb0\u5f55\u91d1\u989d\u5904\u7406\u63d2\u4ef6-PurWriteOffDealSwapplCalPlugin");
        this.accureAmtMap.clear();
        this.accureTaxAmtMap.clear();
        this.accureLocalAmtMap.clear();
        this.accureLocalTaxAmtMap.clear();
        this.accureInterCostAmtMap.clear();
        if (this.mainBillType == null) {
            logger.info("\u4e3b\u65b9\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u505a\u91d1\u989d\u5904\u7406");
            return;
        }
        this.isCalInterCost = this.getIsCalInterCost(recordBills.get(0));
        logger.info("isCalInterCost = " + this.isCalInterCost);
        this.InitAmtNum(true);
        for (DynamicObject recordBill : recordBills) {
            this.calculateAmt(true, recordBill);
        }
        this.accureEntryWfQtyMap.clear();
        this.InitAmtNum(false);
        for (DynamicObject recordBill : recordBills) {
            this.calculateAmt(false, recordBill);
            this.dealSwappl(recordBill);
        }
    }

    private void dealSwappl(DynamicObject recordBill) {
        int currencyAmtPresion;
        BigDecimal assistExchangerate;
        Long mainBillEntryId = recordBill.getLong("billentryid");
        Long assistBillEntryId = ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).getLong("e_billentryid");
        DynamicObject mainBillDym = (DynamicObject)this.mainBillDymMap.get(mainBillEntryId);
        DynamicObject assistBillDym = (DynamicObject)this.assistBillDymMap.get(assistBillEntryId);
        BigDecimal verifyAmount = recordBill.getBigDecimal("verifyamount");
        BigDecimal mainExchangerate = recordBill.getBigDecimal("exchangerate");
        if (mainExchangerate.compareTo(assistExchangerate = ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).getBigDecimal("e_exchangerate")) == 0) {
            return;
        }
        BigDecimal diffExchangerate = mainExchangerate.subtract(assistExchangerate);
        String mainBillQuotation = mainBillDym.getString(quotationNum);
        String assistBillQuotation = assistBillDym.getString(quotationNum);
        int n = currencyAmtPresion = mainBillDym.getInt(currencyAmtPresionNum) == 0 ? 10 : mainBillDym.getInt(currencyAmtPresionNum);
        BigDecimal swappl = "0".equals(mainBillQuotation) ? ("0".equals(assistBillQuotation) ? verifyAmount.multiply(diffExchangerate).setScale(currencyAmtPresion, 4) : verifyAmount.multiply(mainExchangerate).setScale(currencyAmtPresion, 4).subtract(verifyAmount.divide(assistExchangerate, currencyAmtPresion, 4))) : ("0".equals(assistBillQuotation) ? verifyAmount.divide(mainExchangerate, currencyAmtPresion, 4).subtract(verifyAmount.multiply(assistExchangerate).setScale(currencyAmtPresion, 4)) : verifyAmount.divide(mainExchangerate, currencyAmtPresion, 4).subtract(verifyAmount.divide(assistExchangerate, currencyAmtPresion, 4)));
        recordBill.set("swappl", (Object)swappl);
        ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).set("e_swappl", (Object)swappl.negate());
    }

    private void calculateAmt(boolean isMain, DynamicObject recordBill) {
        Long mainBillEntryId = recordBill.getLong("billentryid");
        Long assistBillEntryId = ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).getLong("e_billentryid");
        DynamicObject mainBillDym = (DynamicObject)this.mainBillDymMap.get(mainBillEntryId);
        DynamicObject assistBillDym = (DynamicObject)this.assistBillDymMap.get(assistBillEntryId);
        DynamicObject billInfo = mainBillDym;
        DynamicObject recordInfo = recordBill;
        String billTypeNum = this.mainBillType;
        Long billentryId = recordBill.getLong("billentryid");
        if (!isMain) {
            billInfo = assistBillDym;
            recordInfo = (DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0);
            billTypeNum = this.assistBillType;
            billentryId = recordInfo.getLong("e_billentryid");
        }
        BigDecimal crtWfBasetQty = recordInfo.getBigDecimal(this.crtWfBaseQtyNum);
        BigDecimal crtWfQty = recordInfo.getBigDecimal(this.crtWfQtyNum);
        BigDecimal noWfBaseQty = billInfo.getBigDecimal(noWfBaseQtyNum);
        BigDecimal baseQty = billInfo.getBigDecimal(baseQtyNum);
        BigDecimal exchangerate = recordInfo.getBigDecimal(this.rateNum);
        BigDecimal amount = billInfo.getBigDecimal(amountNum);
        BigDecimal localAmount = billInfo.getBigDecimal(localAmountNum);
        BigDecimal taxAmt = billInfo.getBigDecimal(taxAmtNum);
        BigDecimal localTaxAmt = billInfo.getBigDecimal(localTaxAmtNum);
        BigDecimal price = billInfo.getBigDecimal(priceNum);
        BigDecimal taxPrice = billInfo.getBigDecimal(taxPriceNum);
        BigDecimal interCostAmt = BigDecimal.ZERO;
        if (this.isCalInterCost) {
            interCostAmt = billInfo.getBigDecimal(interCostAmtNum);
        }
        String wfMethod = this.getWriteOffMethod(billentryId, crtWfBasetQty, noWfBaseQty, baseQty);
        String quotation = billInfo.getString(quotationNum);
        int currencyAmtPresion = billInfo.getInt(currencyAmtPresionNum);
        int localCurrencyAmtPresion = billInfo.getInt(localCurrencyAmtPresionNum);
        switch (wfMethod) {
            case "wholewf": {
                recordInfo.set(this.crtWfAmtNum, (Object)amount);
                recordInfo.set(this.crtWfLocalAmtNum, (Object)localAmount);
                recordInfo.set(this.crtWfTaxAmtNum, (Object)taxAmt);
                recordInfo.set(this.crtWfLocalTaxAmtNum, (Object)localTaxAmt);
                if (!this.isCalInterCost) break;
                recordInfo.set(this.crtWfIntercostNum, (Object)interCostAmt);
                break;
            }
            case "partwf": {
                BigDecimal accureEntryWfQty;
                BigDecimal crtWfAmt = BigDecimal.ZERO;
                BigDecimal crtWfTaxAmt = BigDecimal.ZERO;
                BigDecimal crtWfLocalAmt = BigDecimal.ZERO;
                BigDecimal crtWfLocalTaxAmt = BigDecimal.ZERO;
                BigDecimal crtWfIntercost = BigDecimal.ZERO;
                if (Arrays.asList(noCalServiceBillArr).contains(billTypeNum)) {
                    crtWfAmt = crtWfQty.multiply(price).setScale(currencyAmtPresion, 4);
                    crtWfTaxAmt = crtWfQty.multiply(taxPrice).setScale(currencyAmtPresion, 4);
                    recordInfo.set(this.crtWfAmtNum, (Object)crtWfAmt);
                    recordInfo.set(this.crtWfTaxAmtNum, (Object)crtWfTaxAmt);
                    if ("0".equals(quotation)) {
                        crtWfLocalAmt = crtWfQty.multiply(price).multiply(exchangerate).setScale(localCurrencyAmtPresion, 4);
                        crtWfLocalTaxAmt = crtWfQty.multiply(taxPrice).multiply(exchangerate).setScale(localCurrencyAmtPresion, 4);
                    } else {
                        crtWfLocalAmt = crtWfQty.multiply(price).divide(exchangerate, localCurrencyAmtPresion, 4);
                        crtWfLocalTaxAmt = crtWfQty.multiply(taxPrice).divide(exchangerate, localCurrencyAmtPresion, 4);
                    }
                    recordInfo.set(this.crtWfLocalAmtNum, (Object)crtWfLocalAmt);
                    recordInfo.set(this.crtWfLocalTaxAmtNum, (Object)crtWfLocalTaxAmt);
                    if (this.isCalInterCost) {
                        crtWfIntercost = interCostAmt.multiply(crtWfBasetQty.divide(baseQty, 10, 4)).setScale(localCurrencyAmtPresion, 4);
                        recordInfo.set(this.crtWfIntercostNum, (Object)crtWfIntercost);
                    }
                } else {
                    logger.info("\u90e8\u5206\u6838\u9500\u8c03\u7528\u7b97\u6cd5\u670d\u52a1\u8ba1\u7b97\u6838\u9500\u91d1\u989d");
                    DynamicObject billDym = BusinessDataServiceHelper.loadSingle((String)billTypeNum, (QFilter[])new QFilter("billentry.id", "=", (Object)billentryId).toArray());
                    if (billDym == null) {
                        logger.info("\u6839\u636e\u5355\u636e\u5206\u5f55id\u672a\u52a0\u8f7d\u51fa\u5355\u636e\u5bf9\u8c61");
                        break;
                    }
                    DynamicObjectCollection billDymEntrys = billDym.getDynamicObjectCollection("billentry");
                    DynamicObject billDymEntry = null;
                    for (DynamicObject entry : billDymEntrys) {
                        if (Long.compare(entry.getLong("id"), billentryId) != 0) continue;
                        billDymEntry = entry;
                    }
                    if (billDymEntry == null) {
                        logger.info("\u83b7\u53d6\u5355\u636e\u5206\u5f55\u4fe1\u606f\u4e3a\u7a7a");
                        break;
                    }
                    billDymEntry.set("qty", (Object)crtWfQty);
                    Map resultMap = AlgorithmHelper.entryCalculate((String)billTypeNum, billDymEntry, (String)"qty");
                    if (resultMap == null) {
                        logger.info("\u8c03\u7528\u7b97\u6cd5\u670d\u52a1\u8ba1\u7b97\u7ed3\u679c\u4e3a\u7a7a");
                        break;
                    }
                    crtWfAmt = (BigDecimal)resultMap.get(amountNum);
                    recordInfo.set(this.crtWfAmtNum, (Object)crtWfAmt);
                    crtWfTaxAmt = (BigDecimal)resultMap.get("amountandtax");
                    recordInfo.set(this.crtWfTaxAmtNum, (Object)crtWfTaxAmt);
                    crtWfLocalAmt = (BigDecimal)resultMap.get("curamount");
                    recordInfo.set(this.crtWfLocalAmtNum, (Object)crtWfLocalAmt);
                    crtWfLocalTaxAmt = (BigDecimal)resultMap.get("curamountandtax");
                    recordInfo.set(this.crtWfLocalTaxAmtNum, (Object)crtWfLocalTaxAmt);
                    if (this.isCalInterCost) {
                        crtWfIntercost = (BigDecimal)resultMap.get(interCostAmtNum);
                        recordInfo.set(this.crtWfIntercostNum, (Object)crtWfIntercost);
                    }
                }
                if ((accureEntryWfQty = this.accureEntryWfQtyMap.get(billentryId)) == null) {
                    this.accureEntryWfQtyMap.put(billentryId, crtWfBasetQty);
                    this.accureAmtMap.put(billentryId, crtWfAmt == null ? BigDecimal.ZERO : crtWfAmt);
                    this.accureTaxAmtMap.put(billentryId, crtWfTaxAmt == null ? BigDecimal.ZERO : crtWfTaxAmt);
                    this.accureLocalAmtMap.put(billentryId, crtWfLocalAmt == null ? BigDecimal.ZERO : crtWfLocalAmt);
                    this.accureLocalTaxAmtMap.put(billentryId, crtWfLocalTaxAmt == null ? BigDecimal.ZERO : crtWfLocalTaxAmt);
                    this.accureInterCostAmtMap.put(billentryId, crtWfIntercost == null ? BigDecimal.ZERO : crtWfIntercost);
                    break;
                }
                this.accureEntryWfQtyMap.put(billentryId, crtWfBasetQty.add(accureEntryWfQty));
                this.accureAmtMap.put(billentryId, crtWfAmt.add(this.accureAmtMap.get(billentryId)));
                this.accureTaxAmtMap.put(billentryId, crtWfTaxAmt.add(this.accureTaxAmtMap.get(billentryId)));
                this.accureLocalAmtMap.put(billentryId, crtWfLocalAmt.add(this.accureLocalAmtMap.get(billentryId)));
                this.accureLocalTaxAmtMap.put(billentryId, crtWfLocalTaxAmt.add(this.accureLocalTaxAmtMap.get(billentryId)));
                this.accureInterCostAmtMap.put(billentryId, crtWfIntercost.add(this.accureInterCostAmtMap.get(billentryId)));
                break;
            }
            case "lastwf": {
                BigDecimal sumWfAmt = BigDecimal.ZERO;
                BigDecimal sumWfLocalAmt = BigDecimal.ZERO;
                BigDecimal sumWfTaxAmt = BigDecimal.ZERO;
                BigDecimal sumWfLocalTaxAmt = BigDecimal.ZERO;
                BigDecimal sumWfInterCostAmt = BigDecimal.ZERO;
                DataSet recordSet = null;
                if (isMain) {
                    QFilter mainQ = new QFilter("billid", "=", (Object)recordInfo.getLong("billid"));
                    mainQ.and("billentryid", "=", (Object)recordInfo.getLong("billentryid"));
                    recordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"billid,billentryid,verifyamount,localverifyamt,verifytaxamount,localverifytaxamt,verifyintercostamt", (QFilter[])mainQ.toArray(), null);
                    if ("ap_finapbill".equals(this.mainBillType)) {
                        QFilter assistQ = new QFilter("entry.e_billid", "=", (Object)recordInfo.getLong("billid"));
                        assistQ.and("entry.e_billentryid", "=", (Object)recordInfo.getLong("billentryid"));
                        DataSet apAssistDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"entry.e_billid as billid,entry.e_billentryid as billentryid,entry.e_verifyamount as verifyamount,entry.e_localverifyamt as localverifyamt,entry.e_verifytaxamount as verifytaxamount,entry.e_localverifytaxamt as localverifytaxamt,entry.e_verifyintercostamt as verifyintercostamt", (QFilter[])assistQ.toArray(), null);
                        recordSet = recordSet.union(apAssistDs);
                    }
                } else {
                    QFilter assistQ = new QFilter("entry.e_billid", "=", (Object)recordInfo.getLong("e_billid"));
                    assistQ.and("entry.e_billentryid", "=", (Object)recordInfo.getLong("e_billentryid"));
                    recordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"entry.e_billid as billid,entry.e_billentryid as billentryid,entry.e_verifyamount as verifyamount,entry.e_localverifyamt as localverifyamt,entry.e_verifytaxamount as verifytaxamount,entry.e_localverifytaxamt as localverifytaxamt,entry.e_verifyintercostamt as verifyintercostamt", (QFilter[])assistQ.toArray(), null);
                    if ("ap_finapbill".equals(this.assistBillType)) {
                        QFilter mainQ = new QFilter("billid", "=", (Object)recordInfo.getLong("e_billid"));
                        mainQ.and("billentryid", "=", (Object)recordInfo.getLong("e_billentryid"));
                        DataSet apMainDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purwfrecord", (String)"billid,billentryid,verifyamount,localverifyamt,verifytaxamount,localverifytaxamt,verifyintercostamt", (QFilter[])mainQ.toArray(), null);
                        recordSet = recordSet.union(apMainDs);
                    }
                }
                recordSet = recordSet.groupBy(new String[]{"billentryid"}).sum("verifyamount").sum("localverifyamt").sum("verifytaxamount").sum("localverifytaxamt").sum("verifyintercostamt").finish();
                for (Row row : recordSet) {
                    sumWfAmt = row.getBigDecimal("verifyamount");
                    sumWfLocalAmt = row.getBigDecimal("localverifyamt");
                    sumWfTaxAmt = row.getBigDecimal("verifytaxamount");
                    sumWfLocalTaxAmt = row.getBigDecimal("localverifytaxamt");
                    sumWfInterCostAmt = row.getBigDecimal("verifyintercostamt");
                }
                BigDecimal accureAmt = this.accureAmtMap.get(billentryId) == null ? BigDecimal.ZERO : this.accureAmtMap.get(billentryId);
                BigDecimal accureWfTaxAmt = this.accureTaxAmtMap.get(billentryId) == null ? BigDecimal.ZERO : this.accureTaxAmtMap.get(billentryId);
                BigDecimal accureWfLocalAmt = this.accureLocalAmtMap.get(billentryId) == null ? BigDecimal.ZERO : this.accureLocalAmtMap.get(billentryId);
                BigDecimal accureWfLocalTaxAmt = this.accureLocalTaxAmtMap.get(billentryId) == null ? BigDecimal.ZERO : this.accureLocalTaxAmtMap.get(billentryId);
                recordInfo.set(this.crtWfAmtNum, (Object)amount.subtract(sumWfAmt.add(accureAmt)));
                recordInfo.set(this.crtWfLocalAmtNum, (Object)localAmount.subtract(sumWfLocalAmt.add(accureWfLocalAmt)));
                recordInfo.set(this.crtWfTaxAmtNum, (Object)taxAmt.subtract(sumWfTaxAmt.add(accureWfTaxAmt)));
                recordInfo.set(this.crtWfLocalTaxAmtNum, (Object)localTaxAmt.subtract(sumWfLocalTaxAmt.add(accureWfLocalTaxAmt)));
                if (!this.isCalInterCost) break;
                BigDecimal accureInterCostAmt = this.accureInterCostAmtMap.get(billentryId) == null ? BigDecimal.ZERO : this.accureInterCostAmtMap.get(billentryId);
                recordInfo.set(this.crtWfIntercostNum, (Object)interCostAmt.subtract(sumWfInterCostAmt.add(accureInterCostAmt)));
                break;
            }
        }
    }

    private void InitAmtNum(boolean isMain) {
        if (isMain) {
            this.crtWfQtyNum = "verifyqty";
            this.crtWfBaseQtyNum = "verifybaseqty";
            this.crtWfAmtNum = "verifyamount";
            this.crtWfLocalAmtNum = "localverifyamt";
            this.crtWfTaxAmtNum = "verifytaxamount";
            this.crtWfLocalTaxAmtNum = "localverifytaxamt";
            this.crtWfIntercostNum = "verifyintercostamt";
            this.rateNum = "exchangerate";
        } else {
            this.crtWfQtyNum = "e_verifyqty";
            this.crtWfBaseQtyNum = "e_verifybaseqty";
            this.crtWfAmtNum = "e_verifyamount";
            this.crtWfLocalAmtNum = "e_localverifyamt";
            this.crtWfTaxAmtNum = "e_verifytaxamount";
            this.crtWfLocalTaxAmtNum = "e_localverifytaxamt";
            this.crtWfIntercostNum = "e_verifyintercostamt";
            this.rateNum = "e_exchangerate";
        }
    }

    private String getWriteOffMethod(Long billentryId, BigDecimal crtWfBaseQty, BigDecimal noWfBaseQty, BigDecimal baseQty) {
        BigDecimal accureEntryWfQty = this.accureEntryWfQtyMap.get(billentryId);
        if (accureEntryWfQty == null) {
            accureEntryWfQty = BigDecimal.ZERO;
        }
        if (crtWfBaseQty.compareTo(noWfBaseQty) != 0 && crtWfBaseQty.add(accureEntryWfQty).compareTo(noWfBaseQty) != 0) {
            return "partwf";
        }
        if (crtWfBaseQty.compareTo(noWfBaseQty) == 0 && crtWfBaseQty.compareTo(baseQty) == 0) {
            return "wholewf";
        }
        return "lastwf";
    }

    private boolean getIsCalInterCost(DynamicObject recordBill) {
        String mainBillNum = recordBill.getDynamicObject("billtype").getString("number");
        String assistBillNum = ((DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0)).getDynamicObject("e_billtype").getString("number");
        logger.info("\u4e3b\u8f85\u65b9\u5355\u636e\u7c7b\u578b\uff1a" + mainBillNum + "  " + assistBillNum);
        return !(!"im_purinbill".equals(mainBillNum) && !"ap_finapbill".equals(mainBillNum) && !"im_ospurinbill".equals(mainBillNum) || !"im_purinbill".equals(assistBillNum) && !"ap_finapbill".equals(assistBillNum));
    }
}

