/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWriteOffCheckPlugin;

public class RedBlueUnWriteoffCheckPlugin
implements IUnWriteOffCheckPlugin {
    private Map<String, List<DynamicObject>> wfTypeRecordMap = new HashMap<String, List<DynamicObject>>(16);
    private static final Log logger = LogFactory.getLog(RedBlueUnWriteoffCheckPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE_RED_FLUSH);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("cal_purwfrecord", new HashSet<String>(Arrays.asList("verifyrelation", "billid", "billentryid", "billno", "billtype", "asstact", "entry.e_billid", "entry.e_billentryid", "entry.e_billno", "entry.e_billtype")));
        return fieldMap;
    }

    @Override
    public void check(List<DynamicObject> wfRecordList) {
        logger.info("RedBlueUnWriteoffCheckPlugin-\u5f00\u59cbcheck");
        this.collectRedBlueRecords(wfRecordList);
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (isCQConfig.booleanValue()) {
            for (Map.Entry<String, List<DynamicObject>> entry : this.wfTypeRecordMap.entrySet()) {
                this.purSelfUnverifyCheck(entry.getValue());
            }
        }
    }

    private void collectRedBlueRecords(List<DynamicObject> wfRecordList) {
        for (DynamicObject billInfo : wfRecordList) {
            String verifyRelation = billInfo.getString("verifyrelation");
            if ("purself".equals(verifyRelation)) {
                List<DynamicObject> purSelfRecord = this.wfTypeRecordMap.get("purself");
                if (purSelfRecord == null) {
                    purSelfRecord = new ArrayList<DynamicObject>(16);
                }
                purSelfRecord.add(billInfo);
                this.wfTypeRecordMap.put("purself", purSelfRecord);
                continue;
            }
            if ("ominself".equals(verifyRelation)) {
                List<DynamicObject> ominSelfRecord = this.wfTypeRecordMap.get("purself");
                if (ominSelfRecord == null) {
                    ominSelfRecord = new ArrayList<DynamicObject>(16);
                }
                ominSelfRecord.add(billInfo);
                this.wfTypeRecordMap.put("purself", ominSelfRecord);
                continue;
            }
            if (!"appurreced".equals(verifyRelation) || !"im_purreceivebill".equals(((DynamicObject)billInfo.getDynamicObjectCollection("entry").get(0)).getDynamicObject("e_billtype").getString("number"))) continue;
            List<DynamicObject> appurSelfRecord = this.wfTypeRecordMap.get("appurreced");
            if (appurSelfRecord == null) {
                appurSelfRecord = new ArrayList<DynamicObject>(16);
            }
            appurSelfRecord.add(billInfo);
            this.wfTypeRecordMap.put("purself", appurSelfRecord);
        }
    }

    private void purSelfUnverifyCheck(List<DynamicObject> purSelfList) {
        HashSet asstactIds = new HashSet(16);
        purSelfList.forEach(entry -> asstactIds.add(entry.getLong("asstact.id")));
        ArrayList ispremiumIds = new ArrayList(16);
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Arrays.stream(suppliers).filter(supplier -> supplier.getBoolean("issuppcolla")).forEach(supplier -> ispremiumIds.add(supplier.getLong("id")));
        if (ispremiumIds.size() > 0) {
            HashMap<Long, List<Long>> dataMap = new HashMap<Long, List<Long>>(16);
            HashMap<Long, String> billIdToBillNoMapping = new HashMap<Long, String>(16);
            for (DynamicObject purSelf : purSelfList) {
                long asstactId = purSelf.getLong("asstact.id");
                if (!ispremiumIds.contains(asstactId)) continue;
                this.buildParamAndMapping(dataMap, purSelf, billIdToBillNoMapping);
            }
            if (dataMap.size() == 0) {
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("billIds", dataMap);
            paramMap.put("entityName", purSelfList.get(0).getDynamicObject("billtype").getString("number"));
            paramMap.put("entryKey", "billentry");
            try (TXHandle tx = TX.requiresNew((String)"unVerifyinvokeScm");){
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{paramMap});
                if (resultMap.size() > 0 && !((Boolean)resultMap.get("succed")).booleanValue()) {
                    Map resultDataMap = (Map)resultMap.get("data");
                    HashSet noWriteoffEntryIds = new HashSet(16);
                    for (List entryIds : resultDataMap.values()) {
                        noWriteoffEntryIds.addAll(entryIds);
                    }
                    HashSet billNos = new HashSet(2);
                    for (DynamicObject record : purSelfList) {
                        Long mainEntryId = record.getLong("billentryid");
                        Long assistEntryId = ((DynamicObject)record.getDynamicObjectCollection("entry").get(0)).getLong("e_billentryid");
                        if (noWriteoffEntryIds.contains(mainEntryId)) {
                            billNos.add(billIdToBillNoMapping.get(record.getLong("billid")));
                        }
                        if (!noWriteoffEntryIds.contains(assistEntryId)) continue;
                        billNos.add(billIdToBillNoMapping.get(((DynamicObject)record.getDynamicObjectCollection("entry").get(0)).getLong("e_billid")));
                    }
                    if (!billNos.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5931\u8d25\uff0c\u6240\u9009\u5355\u636e%s\u5df2\u7531\u4f9b\u5e94\u5546\u534f\u540c\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u53cd\u6838\u9500\u3002", (String)"RedBlueUnWriteOffCheckPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[]{String.join((CharSequence)",", billNos)}));
                    }
                }
            }
        }
    }

    private void buildParamAndMapping(Map<Long, List<Long>> dataMap, DynamicObject purSelf, Map<Long, String> billIdToBillNoMapping) {
        List<Long> entryIds;
        Long billId = purSelf.getLong("billid");
        Long entryId = purSelf.getLong("billentryid");
        String billNo = purSelf.getString("billno");
        if (dataMap.get(billId) != null) {
            entryIds = dataMap.get(billId);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        } else {
            entryIds = new ArrayList<Long>(8);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        }
        DynamicObjectCollection entry = purSelf.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            List<Long> entryIds2;
            billId = row.getLong("e_billid");
            entryId = row.getLong("e_billentryid");
            billNo = row.getString("e_billno");
            if (dataMap.get(billId) != null) {
                entryIds2 = dataMap.get(billId);
                entryIds2.add(entryId);
                dataMap.put(billId, entryIds2);
                billIdToBillNoMapping.put(billId, billNo);
                continue;
            }
            entryIds2 = new ArrayList<Long>(8);
            entryIds2.add(entryId);
            dataMap.put(billId, entryIds2);
            billIdToBillNoMapping.put(billId, billNo);
        }
    }
}

