/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWfEndWriteBackPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWfEndWriteBackPlugin;

public class WriteBackVerifyStatusPlugin
implements IWfEndWriteBackPlugin,
IUnWfEndWriteBackPlugin {
    private static final Log logger = LogFactory.getLog(WriteBackVerifyStatusPlugin.class);

    @Override
    public Set<String> handleDbRouteKey() {
        return Collections.singleton("fi");
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_PUR, WriteOffTypeIdConst.HXLB_SALE, WriteOffTypeIdConst.HXLB_REVCF_RED_FLUSH, WriteOffTypeIdConst.HXLB_INVOICE_RED_FLUSH, WriteOffTypeIdConst.HXLB_PURRECEIVE, WriteOffTypeIdConst.HXLB_PRODUCT_OM, WriteOffTypeIdConst.HXLB_OM_PUR);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("cal_purwfrecord", new HashSet<String>(Arrays.asList("billtype", "billid", "entry.e_billtype", "entry.e_billid")));
        fieldMap.put("cal_salwfrecord", new HashSet<String>(Arrays.asList("billtype", "billid", "entry.e_billtype", "entry.e_billid")));
        return fieldMap;
    }

    @Override
    public void endWriteBack(String DBRouteKey, List<DynamicObject> records) {
        logger.info("endWriteBack\u5f00\u59cb");
        if (!this.needHandle(DBRouteKey, records)) {
            return;
        }
        logger.info("endWriteBack-\u5f00\u59cb\u67e5\u8be2\u6838\u9500\u72b6\u6001");
        Map<String, List<Object[]>> updateParams = this.buildParams(records);
        logger.info("endWriteBack-\u6838\u9500\u72b6\u6001" + updateParams);
        this.flash2DB(updateParams);
        logger.info("endWriteBack-\u6838\u9500\u72b6\u6001\u53cd\u5199\u7ed3\u675f");
    }

    private void flash2DB(Map<String, List<Object[]>> updateParams) {
        DBRoute dbRoute = new DBRoute("fi");
        for (Map.Entry<String, List<Object[]>> entry : updateParams.entrySet()) {
            String entity = entry.getKey();
            List<Object[]> params = entry.getValue();
            this.updateFiSql(dbRoute, entity, params);
        }
    }

    private void updateFiSql(DBRoute dbRoute, String entity, List<Object[]> params) {
        DB.executeBatch((DBRoute)dbRoute, (String)this.getUpdateSql(entity), params);
    }

    private String getUpdateSql(String entity) {
        if ("ap_finapbill".equals(entity)) {
            return "update t_ap_finapbill set fverifystatus = ?,funverifyamount = ? where fid = ?";
        }
        if ("ar_finarbill".equals(entity)) {
            return "update t_ar_finarbill set fverifystatus = ?,funverifyamount = ? where fid = ?";
        }
        return "update t_ar_revcfmbill set fverifystatus = ?,funverifyamt = ? where fid = ?";
    }

    private Map<String, List<Object[]>> buildParams(List<DynamicObject> records) {
        Set ids;
        HashMap<String, Set> entity2IdMap = new HashMap<String, Set>(4);
        for (DynamicObject record : records) {
            String entity = record.getString("billtype_id");
            Long id = record.getLong("billid");
            if ("ap_finapbill".equals(entity) || "ar_finarbill".equals(entity) || "ar_revcfmbill".equals(entity)) {
                ids = entity2IdMap.computeIfAbsent(entity, k -> new HashSet(16));
                ids.add(id);
            }
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entry) {
                String e_entity = dynamicObject.getString("e_billtype_id");
                Long e_id = dynamicObject.getLong("e_billid");
                if (!"ap_finapbill".equals(e_entity) && !"ar_finarbill".equals(e_entity) && !"ar_revcfmbill".equals(e_entity)) continue;
                Set ids2 = entity2IdMap.computeIfAbsent(e_entity, k -> new HashSet(16));
                ids2.add(e_id);
            }
        }
        HashMap<String, List<Object[]>> resultMap = new HashMap<String, List<Object[]>>(4);
        for (Map.Entry entry : entity2IdMap.entrySet()) {
            String entity = (String)entry.getKey();
            ids = (Set)entry.getValue();
            QFilter filter = new QFilter("id", "in", (Object)ids);
            logger.info("endWriteBack-\u5f00\u59cb\u67e5\u8be2" + entity + "\u5f00\u59cb");
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)this.getSelects(entity), (QFilter[])filter.toArray(), null).groupBy(new String[]{"id"}).sum("unvqty").sum("vqty").sum("unverifyamt").finish();){
                for (Row row : ds) {
                    List list;
                    Object[] params;
                    Long id = row.getLong("id");
                    BigDecimal unvqty = row.getBigDecimal("unvqty");
                    BigDecimal vqty = row.getBigDecimal("vqty");
                    BigDecimal unverifyamt = row.getBigDecimal("unverifyamt");
                    if (unvqty.compareTo(BigDecimal.ZERO) == 0) {
                        params = new Object[]{this.getVerifyValue(entity), unverifyamt, id};
                        list = resultMap.computeIfAbsent(entity, k -> new ArrayList(16));
                        list.add(params);
                        continue;
                    }
                    if (vqty.compareTo(BigDecimal.ZERO) != 0) {
                        params = new Object[]{this.getPartVerifyValue(entity), unverifyamt, id};
                        list = resultMap.computeIfAbsent(entity, k -> new ArrayList(16));
                        list.add(params);
                        continue;
                    }
                    if (vqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    params = new Object[]{this.getUnVerifyValue(entity), unverifyamt, id};
                    list = resultMap.computeIfAbsent(entity, k -> new ArrayList(16));
                    list.add(params);
                }
            }
            logger.info("endWriteBack-\u5f00\u59cb\u67e5\u8be2" + entity + "\u7ed3\u675f");
        }
        return resultMap;
    }

    private Object getUnVerifyValue(String entity) {
        if ("ap_finapbill".equals(entity)) {
            return "10";
        }
        if ("ar_finarbill".equals(entity)) {
            return "unverify";
        }
        return "unverify";
    }

    private Object getPartVerifyValue(String entity) {
        if ("ap_finapbill".equals(entity)) {
            return "20";
        }
        if ("ar_finarbill".equals(entity)) {
            return "partverify";
        }
        return "partverify";
    }

    private String getVerifyValue(String entity) {
        if ("ap_finapbill".equals(entity)) {
            return "30";
        }
        if ("ar_finarbill".equals(entity)) {
            return "verified";
        }
        return "verified";
    }

    private String getSelects(String entity) {
        if ("ap_finapbill".equals(entity)) {
            return "id,detailentry.unverifyquantity as unvqty,detailentry.verifyquantity as vqty,detailentry.e_unverifyamount as unverifyamt";
        }
        if ("ar_finarbill".equals(entity)) {
            return "id,entry.e_unverifyqty as unvqty,entry.e_verifiedqty as vqty,entry.e_unverifyamt as unverifyamt";
        }
        return "id,entry.e_unverifyqty as unvqty,entry.e_verifiedqty as vqty,entry.e_unverifyamt as unverifyamt";
    }

    private boolean needHandle(String DBRouteKey, List<DynamicObject> records) {
        if (!"fi".equals(DBRouteKey) || records == null || records.isEmpty()) {
            return false;
        }
        String entity = records.get(0).getDataEntityType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)EntityMetadataCache.getDataEntityType((String)entity).getInheritPath());
        return "msmod_mainassisttpl".equals(entityType.getName());
    }
}

