/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.cal.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class WriteOffDealRecordCommomCalPlugin
implements IWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(WriteOffDealRecordCommomCalPlugin.class);
    protected Map<String, String> billSelectMap = this.getBillOtherSelect();
    protected Map<Long, DynamicObject> mainBillDymMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, DynamicObject> assistBillDymMap = new HashMap<Long, DynamicObject>(16);
    protected String mainBillType;
    protected String assistBillType;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return null;
    }

    @Override
    public void beforeAllWfRecordGenerate(List<DynamicObject> recordBills) {
        logger.info("\u8fdb\u5165\u91c7\u8d2d\u9500\u552e\u6838\u9500\u8bb0\u5f55\u6570\u636e\u5904\u7406\u63d2\u4ef6--WriteOffDealRecordCommomCalPlugin");
        this.init(recordBills);
    }

    private void init(List<DynamicObject> recordBills) {
        HashSet<Long> mainBillIds = new HashSet<Long>(16);
        HashSet<Long> mainBillEntryIds = new HashSet<Long>(16);
        HashSet<Long> assistBillIds = new HashSet<Long>(16);
        HashSet<Long> assistBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject recordBill : recordBills) {
            Long mainBillId = recordBill.getLong("billid");
            Long mainBillEntryId = recordBill.getLong("billentryid");
            mainBillIds.add(mainBillId);
            mainBillEntryIds.add(mainBillEntryId);
            DynamicObject mainBillDym = recordBill.getDynamicObject("billtype");
            this.mainBillType = mainBillDym.getString("number");
            DynamicObject assistEntry = (DynamicObject)recordBill.getDynamicObjectCollection("entry").get(0);
            Long assistBillId = assistEntry.getLong("e_billid");
            Long assistBillEntryId = assistEntry.getLong("e_billentryid");
            assistBillIds.add(assistBillId);
            assistBillEntryIds.add(assistBillEntryId);
            DynamicObject assistBillDym = assistEntry.getDynamicObject("e_billtype");
            this.assistBillType = assistBillDym.getString("number");
        }
        QFilter mainBillQ = new QFilter("id", "in", mainBillIds);
        mainBillQ.and(this.getEntryNameByEntityNum(this.mainBillType) + ".id", "in", mainBillEntryIds);
        String mainBillSelect = this.getBillSelect(this.mainBillType);
        QFilter assistBillQ = new QFilter("id", "in", assistBillIds);
        assistBillQ.and(this.getEntryNameByEntityNum(this.assistBillType) + ".id", "in", assistBillEntryIds);
        String assistBillSelect = this.getBillSelect(this.assistBillType);
        DynamicObjectCollection mainBillDyms = QueryServiceHelper.query((String)this.mainBillType, (String)mainBillSelect, (QFilter[])mainBillQ.toArray());
        DynamicObjectCollection assistBillDyms = QueryServiceHelper.query((String)this.assistBillType, (String)assistBillSelect, (QFilter[])assistBillQ.toArray());
        for (DynamicObject mainBillDym : mainBillDyms) {
            this.mainBillDymMap.put(mainBillDym.getLong(this.getEntryNameByEntityNum(this.mainBillType) + ".id"), mainBillDym);
        }
        for (DynamicObject assistBillDym : assistBillDyms) {
            this.assistBillDymMap.put(assistBillDym.getLong(this.getEntryNameByEntityNum(this.assistBillType) + ".id"), assistBillDym);
        }
    }

    private String getBillSelect(String billType) {
        StringBuilder selectBuild = new StringBuilder();
        selectBuild.append("bookdate");
        Set billFields = MetadataServiceHelper.getDataEntityType((String)billType).getAllFields().keySet();
        if (billFields.contains("quotation")) {
            selectBuild.append(",quotation");
        }
        if (this.billSelectMap.get(billType) != null) {
            selectBuild.append(',');
            selectBuild.append(this.billSelectMap.get(billType));
        }
        return selectBuild.toString();
    }

    protected String getEntryNameByEntityNum(String entityNum) {
        String entryName = "billentry";
        if ("ap_finapbill".equals(entityNum)) {
            entryName = "detailentry";
        }
        if ("ar_revcfmbill".equals(entityNum)) {
            entryName = "entry";
        }
        return entryName;
    }

    private Map<String, String> getBillOtherSelect() {
        HashMap<String, String> billOtherSelect = new HashMap<String, String>(16);
        String purBillSelect = "settlecurrency.amtprecision as cryamtpresion,currency.amtprecision as basecryamtpresion,billentry.id,billentry.amount as amount,billentry.curamount as baseamount,billentry.amountandtax as taxamt,billentry.curamountandtax as localtaxamt,billentry.actualprice as price,billentry.actualtaxprice as pricetax,billentry.intercostamt as intercostamt,billentry.baseqty as baseqty,billentry.unverifybaseqty as unverifybaseqty";
        String otherImBillSelect = "settlecurrency.amtprecision as cryamtpresion,currency.amtprecision as basecryamtpresion,billentry.id,billentry.amount as amount,billentry.curamount as baseamount,billentry.amountandtax as taxamt,billentry.curamountandtax as localtaxamt,billentry.actualprice as price,billentry.actualtaxprice as pricetax,billentry.baseqty as baseqty,billentry.unverifybaseqty as unverifybaseqty";
        String apBillSelect = "currency.amtprecision as cryamtpresion,basecurrency.amtprecision as basecryamtpresion,detailentry.id,detailentry.e_amount as amount,detailentry.e_amountbase as baseamount,detailentry.e_pricetaxtotal as taxamt,detailentry.e_pricetaxtotalbase as localtaxamt,detailentry.actprice as price,detailentry.actpricetax as pricetax,detailentry.intercostamt as intercostamt,detailentry.e_baseunitqty as baseqty,detailentry.unverifyquantity as unverifybaseqty";
        String revcfmBillSelect = "entry.id";
        billOtherSelect.put("im_purinbill", purBillSelect);
        billOtherSelect.put("im_purreceivebill", otherImBillSelect);
        billOtherSelect.put("im_ospurinbill", purBillSelect);
        billOtherSelect.put("im_mdc_omcmplinbill", otherImBillSelect);
        billOtherSelect.put("ap_finapbill", apBillSelect);
        billOtherSelect.put("im_saloutbill", otherImBillSelect);
        billOtherSelect.put("ar_revcfmbill", revcfmBillSelect);
        return billOtherSelect;
    }
}

