/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.pojo.WriteOffResponse;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class SalContractWriteOffPlugin
implements IWriteOffPlugin,
IWriteOffCheckPlugin {
    private static final Log log = LogFactory.getLog(SalContractWriteOffPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_REC_PLAN);
    }

    @Override
    public boolean check(DynamicObject recordBill) {
        DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
        String batchNumber = recordBill.getString("wfseq");
        List<Map<String, Object>> list = this.getDetails(entrys);
        WriteOffResponse validate = this.matchValidate(batchNumber, list);
        log.info("\u6536\u6b3e\u5355\u53d8\u66f4\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)validate));
        if (validate != null && "success".equalsIgnoreCase(validate.getStatus())) {
            return true;
        }
        String errorMsg = CommonHelper.showMatchFailMsg(validate);
        throw new KDBizException(errorMsg);
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        try (TXHandle h = TX.requiresNew((String)"SalContractWriteOffHandler_match");){
            try {
                for (DynamicObject recordBill : records) {
                    DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
                    String batchNumber = recordBill.getString("wfseq");
                    List<Map<String, Object>> list = this.getDetails(entrys);
                    WriteOffResponse match = this.match(batchNumber, list);
                    log.info("\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)match));
                    if (match != null && "success".equalsIgnoreCase(match.getStatus())) {
                        this.updateCasBillEntryId(recordBill, match);
                        continue;
                    }
                    String errorMsg = CommonHelper.showMatchFailMsg(match);
                    throw new KDBizException(errorMsg);
                }
            }
            catch (Exception e) {
                log.info("SalContractWriteOffHandler-\u8c03\u7528\u51fa\u7eb3\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                h.markRollback();
                String errorMsg = ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff1a", (String)"CommonHelper_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                throw new KDBizException(errorMsg + e.getMessage());
            }
        }
        log.info("SalContractWriteOffHandler-\u5f00\u542f\u4e8b\u52a1\uff0c\u51c6\u5907\u66f4\u65b0\u5339\u914d\u8bb0\u5f55");
        try {
            SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[records.size()]));
        }
        catch (Exception e) {
            log.info("SalContractWriteOffHandler-\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u5931\u8d25\uff1a", (String)"SalContractWriteOffHandler_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            throw new KDBizException(errorMsg + e.getMessage());
        }
        log.info("SalContractWriteOffHandler\uff0c\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u5b8c\u6bd5");
    }

    private void updateCasBillEntryId(DynamicObject recordBill, WriteOffResponse match) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject entry : recordBill.getDynamicObjectCollection("entry")) {
            entryMap.put("" + entry.getLong("billid") + entry.getLong("billentryid") + entry.getLong("assbillid") + entry.getLong("assbillentryid"), entry);
        }
        List<WriteOffResponse.Detail> details = match.getDetails();
        for (WriteOffResponse.Detail detail : details) {
            Long sourceContractBillId = detail.getSourceBillId();
            Long sourceContractBillEntryId = detail.getSourceBillEntryId();
            Long oldCasBillId = detail.getBillId();
            Long oldCasBillEntryId = detail.getBillEntryId();
            Long newCaseBillEntryId = detail.getNewBillEntryId();
            if (CommonHelper.notNull(sourceContractBillId, sourceContractBillEntryId, oldCasBillId, oldCasBillEntryId, newCaseBillEntryId)) {
                DynamicObject entry = (DynamicObject)entryMap.get("" + sourceContractBillId + sourceContractBillEntryId + oldCasBillId + oldCasBillEntryId);
                if (entry == null) continue;
                entry.set("assbillentryid", (Object)newCaseBillEntryId);
                continue;
            }
            log.error("\u6536\u6b3e\u5355\u5339\u914d\uff0c\u8fd4\u56de\u53c2\u6570\u4e2d\u5305\u542bnull\u503c");
        }
    }

    private List<Map<String, Object>> getDetails(DynamicObjectCollection entrys) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceBillType", "conm_salcontract");
            Long billid = entry.getLong("billid");
            map.put("sourceBillId", billid);
            Long entryid = entry.getLong("billentryid");
            map.put("sourceBillEntryId", entryid);
            Long entrySeq = entry.getLong("entryseq");
            map.put("sourceBillEntrySeq", entrySeq);
            String billNo = entry.getString("billno");
            map.put("sourceBillNo", billNo);
            Long casbillid = entry.getLong("assbillid");
            map.put("billId", casbillid);
            Long casEntryid = entry.getLong("assbillentryid");
            map.put("billEntryId", casEntryid);
            BigDecimal cas_amount = entry.getBigDecimal("asscurwfamount");
            map.put("matchAmt", cas_amount);
            Long sallDetailId = entry.getLong("sallDetailId");
            if (sallDetailId == null || sallDetailId <= 0L) {
                sallDetailId = entry.getPkValue() != null && (Long)entry.getPkValue() > 0L ? (Long)entry.getPkValue() : CommonHelper.getRandomLong();
                entry.set("sallDetailId", (Object)sallDetailId);
            }
            map.put("sallDetailId", sallDetailId);
            list.add(map);
        }
        return list;
    }

    private WriteOffResponse matchValidate(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "matchValidate");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse match(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "match");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse dispachService(HashMap<String, Object> map) {
        String param = JSON.toJSONString(map);
        log.info("\u9884\u6536\u6b3e\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u53c2\u6570\uff1a" + param);
        String re = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"recBusinessAccountService", (String)"operate", (Object[])new Object[]{param});
        log.info("\u9884\u6536\u6b3e\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + re);
        WriteOffResponse writeOffResponse = (WriteOffResponse)JSON.parseObject((String)re, WriteOffResponse.class);
        return writeOffResponse;
    }
}

