/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.helper.SalOrderWriteOffHelper;
import kd.mpscmm.mscommon.writeoff.ext.scmc.receivematch.pojo.WriteOffResponse;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;

public class SalOrderWriteOffPlugin
implements IWriteOffCheckPlugin,
IWriteOffPlugin {
    private static final Log log = LogFactory.getLog(SalOrderWriteOffPlugin.class);

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_ORDER_PLAN);
    }

    @Override
    public boolean check(DynamicObject recordBill) {
        DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
        String batchNumber = recordBill.getString("wfseq");
        List<Map<String, Object>> list = this.getDetails(entrys);
        WriteOffResponse validate = this.matchValidate(batchNumber, list);
        log.info("\u6536\u6b3e\u5355\u53d8\u66f4\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)validate));
        if (validate != null && "success".equalsIgnoreCase(validate.getStatus())) {
            return true;
        }
        String errorMsg = CommonHelper.showMatchFailMsg(validate);
        throw new KDBizException(errorMsg);
    }

    @Override
    public void afterWfRecordStrategy(List<DynamicObject> records) {
        try (TXHandle h = TX.requiresNew((String)"SalOrderWriteOffHandler_match");){
            try {
                for (DynamicObject recordBill : records) {
                    DynamicObjectCollection entrys = recordBill.getDynamicObjectCollection("entry");
                    String batchNumber = recordBill.getString("wfseq");
                    List<Map<String, Object>> list = this.getDetails(entrys);
                    WriteOffResponse match = this.match(batchNumber, list);
                    log.info("\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)match));
                    if (match != null && "success".equalsIgnoreCase(match.getStatus())) {
                        this.updateCasBillEntryId(recordBill, match);
                        continue;
                    }
                    String errorMsg = CommonHelper.showMatchFailMsg(match);
                    throw new KDBizException(errorMsg);
                }
            }
            catch (Exception e) {
                log.info("SalOrderWriteOffHandler-\u8c03\u7528\u51fa\u7eb3\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                h.markRollback();
                String errorMsg = ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff1a", (String)"CommonHelper_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                throw new KDBizException(errorMsg + e.getMessage());
            }
        }
        log.info("SalOrderWriteOffHandler-\u5f00\u542f\u4e8b\u52a1\uff0c\u51c6\u5907\u66f4\u65b0\u5339\u914d\u8bb0\u5f55");
        try {
            SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[records.size()]));
        }
        catch (Exception e) {
            log.info("SalOrderWriteOffHandler-\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u5931\u8d25\uff1a", (String)"SalContractWriteOffHandler_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            throw new KDBizException(errorMsg + e.getMessage());
        }
        log.info("SalOrderWriteOffHandler\uff0c\u66f4\u65b0\u5339\u914d\u8bb0\u5f55\u6210\u529f");
    }

    @Override
    public Map<String, Map<String, List<Object[]>>> buildBackSql(List<DynamicObject> records) {
        HashMap<String, Map<String, List<Object[]>>> sqlListMaps = new HashMap<String, Map<String, List<Object[]>>>();
        Map<String, List<Object[]>> sqlLists = (HashMap<String, List<Object[]>>)sqlListMaps.get("scm");
        if (sqlLists == null) {
            sqlLists = new HashMap<String, List<Object[]>>();
        }
        log.info("SalOrderWriteOffHandler-\u51c6\u5907\u6784\u5efa\u53cd\u5199sql-records_size\uff1a" + records.size());
        for (DynamicObject recordBill : records) {
            Long conbillid;
            DynamicObjectCollection orderEntrys;
            Long orderID;
            DynamicObject order;
            DynamicObjectCollection recordEntrys;
            if (recordBill == null || (recordEntrys = recordBill.getDynamicObjectCollection("entry")) == null || recordEntrys.isEmpty() || (order = BusinessDataServiceHelper.loadSingle((Object)(orderID = Long.valueOf(((DynamicObject)recordEntrys.get(0)).getLong("billid"))), (String)"sm_salorder")) == null || (orderEntrys = order.getDynamicObjectCollection("billentry")) == null || orderEntrys.isEmpty() || ((conbillid = Long.valueOf(((DynamicObject)orderEntrys.get(0)).getLong("conbillid"))) == null || conbillid <= 0L) && (!"conm_salcontract".equals(((DynamicObject)orderEntrys.get(0)).getString("srcbillentity")) || (conbillid = Long.valueOf(((DynamicObject)orderEntrys.get(0)).getLong("srcbillid"))) == null || conbillid <= 0L)) continue;
            for (DynamicObject recordEntry : recordEntrys) {
                BigDecimal curwfamount = recordEntry.getBigDecimal("curwfamount");
                sqlLists = SalOrderWriteOffHelper.bulidOrderBackSql(conbillid, curwfamount, "add", sqlLists);
            }
        }
        log.info("SalOrderWriteOffHandler-\u6784\u5efa\u53cd\u5199sql\u5b8c\u6bd5\uff0csqlLists_size\uff1a" + sqlLists.size());
        sqlListMaps.put("scm", sqlLists);
        return sqlListMaps;
    }

    private void updateCasBillEntryId(DynamicObject recordBill, WriteOffResponse match) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject entry : recordBill.getDynamicObjectCollection("entry")) {
            entryMap.put("" + entry.getLong("billid") + entry.getLong("billentryid") + entry.getLong("assbillid") + entry.getLong("assbillentryid"), entry);
        }
        List<WriteOffResponse.Detail> details = match.getDetails();
        for (WriteOffResponse.Detail detail : details) {
            Long sourceOrderBillId = detail.getSourceBillId();
            Long sourceOrderBillEntryId = detail.getSourceBillEntryId();
            Long oldCasBillId = detail.getBillId();
            Long oldCasBillEntryId = detail.getBillEntryId();
            Long newCaseBillEntryId = detail.getNewBillEntryId();
            if (CommonHelper.notNull(sourceOrderBillId, sourceOrderBillEntryId, oldCasBillId, oldCasBillEntryId, newCaseBillEntryId)) {
                DynamicObject entry = (DynamicObject)entryMap.get("" + sourceOrderBillId + sourceOrderBillEntryId + oldCasBillId + oldCasBillEntryId);
                if (entry == null) continue;
                entry.set("assbillentryid", (Object)newCaseBillEntryId);
                continue;
            }
            log.error("\u6536\u6b3e\u5355\u5339\u914d\uff0c\u8fd4\u56de\u53c2\u6570\u4e2d\u5305\u542bnull\u503c");
        }
    }

    private List<Map<String, Object>> getDetails(DynamicObjectCollection entrys) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : entrys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceBillType", "sm_salorder");
            Long billid = entry.getLong("billid");
            map.put("sourceBillId", billid);
            Long entryid = entry.getLong("billentryid");
            map.put("sourceBillEntryId", entryid);
            Long entrySeq = entry.getLong("entryseq");
            map.put("sourceBillEntrySeq", entrySeq);
            String billNo = entry.getString("billno");
            map.put("sourceBillNo", billNo);
            Long casbillid = entry.getLong("assbillid");
            map.put("billId", casbillid);
            Long casEntryid = entry.getLong("assbillentryid");
            map.put("billEntryId", casEntryid);
            BigDecimal cas_amount = entry.getBigDecimal("asscurwfamount");
            map.put("matchAmt", cas_amount);
            Long sallDetailId = entry.getLong("sallDetailId");
            if (sallDetailId == null || sallDetailId <= 0L) {
                sallDetailId = entry.getPkValue() != null && (Long)entry.getPkValue() > 0L ? (Long)entry.getPkValue() : CommonHelper.getRandomLong();
                entry.set("sallDetailId", (Object)sallDetailId);
            }
            map.put("sallDetailId", sallDetailId);
            list.add(map);
        }
        return list;
    }

    private WriteOffResponse matchValidate(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "matchValidate");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse match(String batchNumber, List<Map<String, Object>> details) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("details", details);
        map.put("operate", "match");
        map.put("batchNumber", batchNumber);
        return this.dispachService(map);
    }

    private WriteOffResponse dispachService(HashMap<String, Object> map) {
        String param = JSON.toJSONString(map);
        log.info("\u9884\u6536\u6b3e\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u53c2\u6570\uff1a" + param);
        String re = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"recBusinessAccountService", (String)"operate", (Object[])new Object[]{param});
        log.info("\u9884\u6536\u6b3e\u5339\u914d\u8c03\u7528\u6536\u6b3e\u5355\u53d8\u66f4\u63a5\u53e3\u8fd4\u56de\u503c\uff1a" + re);
        WriteOffResponse writeOffResponse = (WriteOffResponse)JSON.parseObject((String)re, WriteOffResponse.class);
        return writeOffResponse;
    }
}

