/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.scmc.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeObjConst;
import kd.mpscmm.mscommon.writeoff.common.helper.VerifyRelationHelper;
import kd.mpscmm.mscommon.writeoff.common.util.BotpLinkHelper;
import kd.mpscmm.mscommon.writeoff.ext.fi.arap.helper.PreInvoiceVerifyHelper;

public class AbstractWriteBackBillByMService {
    protected static final Log logger = LogFactory.getLog(AbstractWriteBackBillByMService.class);
    private Map<Long, Object> confirmParams = new HashMap<Long, Object>(8);
    private static boolean enableArSaloutVerify = false;

    protected Map<Long, Object[]> resolveWFRecords(List<DynamicObject> records) {
        HashMap<Long, Object[]> paramMap = new HashMap<Long, Object[]>(16);
        this.preHandleSaloutRecordForValidate(records);
        Map<Long, String> revcfmbillSrcType = this.saloutRecordFindUpBills(records);
        HashSet<Long> arAPAssBillIds = new HashSet<Long>(16);
        HashSet<Long> arAPAssBillEntryIds = new HashSet<Long>(16);
        String mainBillentityKey = null;
        String assBillEntityKey = null;
        boolean aparNotRedWriteOff = false;
        for (DynamicObject record : records) {
            Long writeTypeId = record.getLong("writeofftypeid_id");
            aparNotRedWriteOff = this.isAPARNotRedWriteOff(writeTypeId);
            if (!aparNotRedWriteOff) continue;
            mainBillentityKey = record.getDynamicObject("billtype").getPkValue().toString();
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entryVO : entry) {
                Long assBillId = entryVO.getLong("e_billid");
                Long assBillEntryId = entryVO.getLong("e_billentryid");
                assBillEntityKey = entryVO.getDynamicObject("e_billtype").getPkValue().toString();
                arAPAssBillIds.add(assBillId);
                arAPAssBillEntryIds.add(assBillEntryId);
            }
        }
        HashSet<String> srcBillid2TargetBillidSet = new HashSet(2);
        if (aparNotRedWriteOff) {
            srcBillid2TargetBillidSet = BotpLinkHelper.findSrcBillid2TargetBillidSet(arAPAssBillIds.toArray(new Long[0]), arAPAssBillEntryIds.toArray(new Long[0]), assBillEntityKey, mainBillentityKey);
        }
        for (DynamicObject record : records) {
            Long writeTypeId = record.getLong("writeofftypeid_id");
            if (this.isRedWriteOff(writeTypeId)) {
                this.resolveSelWFRecords(paramMap, record, writeTypeId);
                continue;
            }
            if (!this.isAPARNotRedWriteOff(writeTypeId)) continue;
            this.resolveWFRecords(paramMap, record, writeTypeId, srcBillid2TargetBillidSet, new HashMap<Long, List<Long>>(8), revcfmbillSrcType);
        }
        return paramMap;
    }

    protected boolean isRedWriteOff(Long writeTypeId) {
        return WriteOffTypeObjConst.WFTYPE_PURIN_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_OMCMPLIN_REDVACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_SALOUT_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_SIMPLE_OM_RED.compareTo(writeTypeId) == 0;
    }

    protected boolean isAPARNotRedWriteOff(Long writeTypeId) {
        return WriteOffTypeObjConst.WFTYPE_PURIN.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_PURRECIVE.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.HXLB_SIMPLE_OM_RED.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_OMCMPLIN.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_REVCFM_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_OM_PUR.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.OM_AP_FINAPBILL.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_SIMPLE_OM.compareTo(writeTypeId) == 0;
    }

    protected boolean isAPWriteOff(Long writeTypeId) {
        return WriteOffTypeObjConst.WFTYPE_PURIN.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_PURIN_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_PURRECIVE_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_AP_REDBACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_PURRECIVE.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_OMCMPLIN_REDVACK.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_OMCMPLIN.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_OM_PUR.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_SIMPLE_OM.compareTo(writeTypeId) == 0 || WriteOffTypeIdConst.HXLB_SIMPLE_OM_RED.compareTo(writeTypeId) == 0;
    }

    protected boolean isARWriteOff(Long writeTypeId) {
        return WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) == 0 || WriteOffTypeObjConst.WFTYPE_SALOUT_REDBACK.compareTo(writeTypeId) == 0;
    }

    protected void resolveSelWFRecords(Map<Long, Object[]> paramMap, DynamicObject record, Long writeTypeId) {
        Object[] params = paramMap.get(writeTypeId);
        if (params == null) {
            CommonParam ecParam = new CommonParam();
            ArrayList disposeList = new ArrayList(16);
            ecParam.put((Object)"disposeList", disposeList);
            ArrayList businessInfo = new ArrayList(16);
            params = new Object[]{ecParam, businessInfo};
            paramMap.put(writeTypeId, params);
        }
        List disposeList = (List)((CommonParam)params[0]).get((Object)"disposeList");
        List businessInfo = (List)params[1];
        HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
        businessInfo.add(record.getString("id"));
        businessInfo.add(record.getString("billid"));
        rowMap.put("entity", record.getDynamicObject("billtype").getPkValue());
        rowMap.put("orgid", record.getDynamicObject("org").getPkValue());
        rowMap.put("pk", record.getLong("billid"));
        rowMap.put("billno", record.getString("billno"));
        rowMap.put("entrypk", record.getLong("billentryid"));
        rowMap.put("measureunit", record.getDynamicObject("measureunit").getPkValue());
        rowMap.put("verifyqty", record.getBigDecimal("verifyqty"));
        rowMap.put("verifybaseqty", record.getBigDecimal("verifybaseqty"));
        boolean needDisposeRemain = !"auto".equals(record.getString("verifytype"));
        rowMap.put("needDisposeRemain", needDisposeRemain);
        rowMap.put("verifyrelation", VerifyRelationHelper.getVerifyRelationByWriteOffTypeId(writeTypeId, record.getBigDecimal("verifyqty").signum()));
        rowMap.put("verifytype", record.getString("verifytype"));
        rowMap.put("verifyamt", record.getBigDecimal("verifytaxamount"));
        rowMap.put("verifyamtnotax", record.getBigDecimal("verifyamount"));
        rowMap.put("iswrittenoffverify", false);
        if (this.isRedWriteOff(writeTypeId)) {
            rowMap.put("confirmamt", BigDecimal.ZERO);
        } else {
            rowMap.put("confirmamt", record.getBigDecimal("verifyamount"));
        }
        rowMap.put("ismscommon", true);
        disposeList.add(rowMap);
        DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
        for (DynamicObject entryVO : entry) {
            businessInfo.add(entryVO.getString("e_billid"));
            HashMap<String, Object> entryRowMap = new HashMap<String, Object>(16);
            entryRowMap.put("entity", entryVO.getDynamicObject("e_billtype").getPkValue());
            entryRowMap.put("orgid", record.getDynamicObject("org").getPkValue());
            entryRowMap.put("pk", entryVO.getString("e_billid"));
            entryRowMap.put("billno", entryVO.getString("e_billno"));
            entryRowMap.put("entrypk", entryVO.getLong("e_billentryid"));
            entryRowMap.put("measureunit", entryVO.getDynamicObject("e_measureunit").getPkValue());
            entryRowMap.put("verifyqty", entryVO.getBigDecimal("e_verifyqty"));
            entryRowMap.put("verifybaseqty", entryVO.getBigDecimal("e_verifybaseqty"));
            entryRowMap.put("needDisposeRemain", needDisposeRemain);
            entryRowMap.put("verifyrelation", VerifyRelationHelper.getVerifyRelationByWriteOffTypeId(writeTypeId, record.getBigDecimal("verifyqty").signum()));
            entryRowMap.put("verifytype", record.getString("verifytype"));
            entryRowMap.put("verifyamt", entryVO.getBigDecimal("e_verifytaxamount"));
            entryRowMap.put("verifyamtnotax", entryVO.getBigDecimal("e_verifyamount"));
            if (this.isRedWriteOff(writeTypeId)) {
                entryRowMap.put("confirmamt", BigDecimal.ZERO);
            } else {
                rowMap.put("confirmamt", entryVO.getBigDecimal("e_verifyamount"));
            }
            entryRowMap.put("ismscommon", true);
            disposeList.add(entryRowMap);
        }
    }

    @Deprecated
    protected void resolveWFRecords(Map<Long, Object[]> paramMap, DynamicObject record, Long writeTypeId, Set<String> srcBillid2TargetBillidSet) {
        this.resolveWFRecords(paramMap, record, writeTypeId, srcBillid2TargetBillidSet, new HashMap<Long, List<Long>>(8));
    }

    @Deprecated
    protected void resolveWFRecords(Map<Long, Object[]> paramMap, DynamicObject record, Long writeTypeId, Set<String> srcBillid2TargetBillidSet, Map<Long, List<Long>> revcfmUpBillMaps) {
        this.resolveWFRecords(paramMap, record, writeTypeId, srcBillid2TargetBillidSet, revcfmUpBillMaps, new HashMap<Long, String>(8));
    }

    protected void resolveWFRecords(Map<Long, Object[]> paramMap, DynamicObject record, Long writeTypeId, Set<String> srcBillid2TargetBillidSet, Map<Long, List<Long>> revcfmUpBillMaps, Map<Long, String> revcfmbillSrcType) {
        DynamicObject org;
        Object[] params = paramMap.get(writeTypeId);
        if (params == null) {
            CommonParam ecParam = new CommonParam();
            ArrayList disposeList = new ArrayList(16);
            ecParam.put((Object)"disposeList", disposeList);
            ArrayList businessInfo = new ArrayList(16);
            params = new Object[]{ecParam, businessInfo};
            paramMap.put(writeTypeId, params);
        }
        List disposeList = (List)((CommonParam)params[0]).get((Object)"disposeList");
        List businessInfo = (List)params[1];
        HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
        businessInfo.add(record.getString("id"));
        Long mainBillId = record.getLong("billid");
        businessInfo.add(mainBillId.toString());
        String mainBillentityKey = record.getDynamicObject("billtype").getPkValue().toString();
        rowMap.put("recordid", record.getLong("id"));
        rowMap.put("entity", mainBillentityKey);
        rowMap.put("orgid", record.getDynamicObject("org").getPkValue());
        rowMap.put("pk", mainBillId);
        rowMap.put("billno", record.getString("billno"));
        rowMap.put("entrypk", record.getLong("billentryid"));
        rowMap.put("measureunit", record.getDynamicObject("measureunit").getPkValue());
        rowMap.put("verifyqty", record.getBigDecimal("verifyqty"));
        rowMap.put("verifybaseqty", record.getBigDecimal("verifybaseqty"));
        boolean needDisposeRemain = !"auto".equals(record.getString("verifytype"));
        rowMap.put("needDisposeRemain", needDisposeRemain);
        rowMap.put("verifyrelation", VerifyRelationHelper.getVerifyRelationByWriteOffTypeId(writeTypeId, record.getBigDecimal("verifybaseqty").signum()));
        rowMap.put("verifytype", record.getString("verifytype"));
        rowMap.put("verifyamt", record.getBigDecimal("verifytaxamount"));
        rowMap.put("verifyamtnotax", record.getBigDecimal("verifyamount"));
        ArrayList asstDataList = new ArrayList(16);
        DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
        rowMap.put("iswrittenoffverify", false);
        if (this.isRedWriteOff(writeTypeId)) {
            rowMap.put("confirmamt", BigDecimal.ZERO);
        } else if (entry.size() >= 1) {
            rowMap.put("confirmamt", ((DynamicObject)entry.get(0)).getBigDecimal("e_verifyamount"));
        }
        rowMap.put("ismscommon", true);
        boolean hasChargeOffFiled = false;
        if (!entry.isEmpty() && ((DynamicObject)entry.get(0)).getDataEntityType().getProperties().containsKey((Object)"e_iswrittenoff")) {
            hasChargeOffFiled = true;
        }
        for (DynamicObject entryVO : entry) {
            Long assBillId = entryVO.getLong("e_billid");
            String assBillEntityKey = entryVO.getDynamicObject("e_billtype").getPkValue().toString();
            businessInfo.add(assBillId.toString());
            HashMap<String, Object> asstData = new HashMap<String, Object>(16);
            Long e_billId = entryVO.getLong("e_billid");
            asstData.put("asstentity", assBillEntityKey);
            asstData.put("asstpk", e_billId);
            asstData.put("asstbillno", entryVO.getString("e_billno"));
            asstData.put("asstentrypk", entryVO.getLong("e_billentryid"));
            asstData.put("asstmeasureunit", entryVO.getDynamicObject("e_measureunit").getPkValue());
            asstData.put("asstverifyqty", entryVO.getBigDecimal("e_verifyqty"));
            asstData.put("asstverifybaseqty", entryVO.getBigDecimal("e_verifybaseqty"));
            asstData.put("asstverifyamount", entryVO.getBigDecimal("e_verifytaxamount"));
            asstData.put("asstverifyamtnotax", entryVO.getBigDecimal("e_verifyamount"));
            if ("ar_finarbill".equals(revcfmbillSrcType.get(e_billId))) {
                asstData.put("hasfinar", Boolean.TRUE);
            } else {
                asstData.put("hasfinar", Boolean.FALSE);
            }
            if (hasChargeOffFiled) {
                asstData.put("ischargeoff", entryVO.getBoolean("e_iswrittenoff"));
                asstData.put("hadchargeoff", entryVO.getBoolean("e_hadwrittenoff"));
            }
            asstDataList.add(asstData);
            rowMap.put("isbotp", srcBillid2TargetBillidSet.contains(mainBillId + "#" + assBillId));
        }
        if (WriteOffTypeObjConst.WFTYPE_REVCFM_REDBACK.compareTo(writeTypeId) == 0) {
            HashMap<String, Object> asstData = new HashMap<String, Object>(16);
            asstData.put("asstentity", mainBillentityKey);
            asstData.put("asstpk", mainBillId);
            asstData.put("asstbillno", record.getString("billno"));
            asstData.put("asstentrypk", record.getLong("billentryid"));
            asstData.put("asstmeasureunit", record.getDynamicObject("measureunit").getPkValue());
            asstData.put("asstverifyqty", record.getBigDecimal("verifyqty"));
            asstData.put("asstverifybaseqty", record.getBigDecimal("verifybaseqty"));
            asstData.put("asstverifyamount", record.getBigDecimal("verifytaxamount"));
            asstData.put("asstverifyamtnotax", record.getBigDecimal("verifyamount"));
            asstDataList.add(asstData);
        }
        rowMap.put("asstdata", asstDataList);
        if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) == 0 && (org = record.getDynamicObject("org")) != null) {
            Object ar_005 = this.confirmParams.get(org.getLong("id"));
            if (ar_005 != null && !((Boolean)ar_005).booleanValue() && enableArSaloutVerify) {
                rowMap.put("noupdjoinqty", Boolean.TRUE);
            } else {
                rowMap.put("noupdjoinqty", Boolean.FALSE);
            }
        }
        disposeList.add(rowMap);
    }

    private void prepareValidateData(List<DynamicObject> records) {
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (DynamicObject record : records) {
            DynamicObject org;
            Long writeTypeId = record.getLong("writeofftypeid_id");
            if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) != 0 || (org = record.getDynamicObject("org")) == null) continue;
            orgIds.add(org.getLong("id"));
        }
        this.confirmParams = PreInvoiceVerifyHelper.batchGetAppParameter(Boolean.TRUE, orgIds, "ar_005");
        enableArSaloutVerify = PreInvoiceVerifyHelper.enablePreOriginalWfConfig(false);
    }

    private void preHandleSaloutRecordForValidate(List<DynamicObject> records) {
        for (DynamicObject record : records) {
            Long writeTypeId = record.getLong("writeofftypeid_id");
            if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) != 0) continue;
            this.prepareValidateData(records);
            break;
        }
    }

    private Map<Long, String> saloutRecordFindUpBills(List<DynamicObject> records) {
        ArrayList<Long> revcfmBillIds = new ArrayList<Long>(8);
        for (DynamicObject record : records) {
            Long writeTypeId = record.getLong("writeofftypeid_id");
            if (WriteOffTypeObjConst.WFTYPE_SALOUT.compareTo(writeTypeId) != 0) continue;
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entryVO : entry) {
                String assBillEntityKey = entryVO.getDynamicObject("e_billtype").getPkValue().toString();
                if (!"ar_revcfmbill".equals(assBillEntityKey)) continue;
                revcfmBillIds.add(entryVO.getLong("e_billid"));
            }
        }
        DynamicObjectCollection revcfmBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", revcfmBillIds)});
        Map<Long, String> revcfmBillSrcType = revcfmBills.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("sourcebilltype")));
        return revcfmBillSrcType;
    }

    public CommonParam copyAndAss2VerifyAmt(CommonParam ecParam) {
        CommonParam ecParamCopy = new CommonParam();
        List disposeList = (List)ecParam.get((Object)"disposeList");
        ArrayList disposeListNew = new ArrayList(4);
        for (Map map : disposeList) {
            List asstdata;
            HashMap<String, BigDecimal> mapNew = new HashMap<String, BigDecimal>(4);
            mapNew.putAll(map);
            BigDecimal signum = BigDecimal.ONE;
            BigDecimal verifyqty = (BigDecimal)mapNew.get("verifyqty");
            if (verifyqty != null && verifyqty.signum() < 0) {
                signum = signum.negate();
            }
            if ((asstdata = (List)mapNew.get("asstdata")) != null && !asstdata.isEmpty()) {
                BigDecimal verifyamt = BigDecimal.ZERO;
                for (Map asstdatum : asstdata) {
                    BigDecimal asstverifyamount = (BigDecimal)asstdatum.get("asstverifyamount");
                    if (asstverifyamount == null) continue;
                    verifyamt = asstverifyamount.add(verifyamt);
                }
                if (verifyamt.compareTo(BigDecimal.ZERO) != 0) {
                    mapNew.put("verifyamt", verifyamt.abs().multiply(signum));
                }
            }
            disposeListNew.add(mapNew);
        }
        ecParamCopy.put((Object)"disposeList", disposeListNew);
        return ecParamCopy;
    }
}

