/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.TaxcWriteOffUtil;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.unwirteoff.IUnWfEndWriteBackPlugin;
import org.apache.commons.lang.StringUtils;

public class CktsThreeBillUnWfWriteBackPlugin
implements IUnWfEndWriteBackPlugin {
    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WMQY_SDPP, WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP, WriteOffTypeIdConst.HXLB_SCQY);
    }

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(4);
        fieldMap.put("tcetr_updownwfrecord", new HashSet<String>(Arrays.asList("writeofftypeid", "entry.billtype", "entry.billid", "entry.billentryid")));
        fieldMap.put("tcetr_wfrecord_scqy", new HashSet<String>(Arrays.asList("writeofftypeid", "entry.billtype", "entry.billid", "entry.billentryid")));
        return fieldMap;
    }

    @Override
    public void endWriteBack(String DBRouteKey, List<DynamicObject> records) {
        if ("taxc".equals(DBRouteKey) && records != null && records.size() > 0) {
            long writeofftypeid = records.get(0).getLong("writeofftypeid_id");
            String sourceUnitCol = TaxcWriteOffUtil.getSourceUnitColByTypeId(writeofftypeid);
            String sourceNumCol = TaxcWriteOffUtil.getSourceNumCol(sourceUnitCol);
            if (StringUtils.isEmpty((String)sourceNumCol)) {
                throw new KDBizException("Can't find the number of customs declaration form fields\uff01");
            }
            List collect = records.stream().filter(a -> a.getDynamicObjectCollection("entry") != null).flatMap(a -> a.getDynamicObjectCollection("entry").stream()).filter(a -> "tdm_export_declaration".equalsIgnoreCase(a.getString("billtype_id"))).collect(Collectors.toList());
            Set<Object> billid = collect.stream().collect(Collectors.groupingBy(k -> k.get("billid"))).keySet();
            DynamicObject[] exports = BusinessDataServiceHelper.load((Object[])billid.toArray(new Object[billid.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_export_declaration"));
            Map<Object, DynamicObject> entryMap = Arrays.stream(exports).flatMap(a -> a.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (m, n) -> m));
            Map<String, List<DynamicObject>> exportRecordGroup = collect.stream().collect(Collectors.groupingBy(k -> k.getString("billentryid")));
            for (Map.Entry<String, List<DynamicObject>> entry : exportRecordGroup.entrySet()) {
                DynamicObject dynamicObject = entryMap.get(entry.getKey());
                if (dynamicObject == null) continue;
                BigDecimal totalNum = dynamicObject.getBigDecimal(sourceNumCol);
                BigDecimal dbWriteoffqty = dynamicObject.getBigDecimal("writeoffqty");
                BigDecimal unWriteoffqty = totalNum.subtract(dbWriteoffqty);
                dynamicObject.set("unwriteoffqty", (Object)unWriteoffqty);
            }
            SaveServiceHelper.save((DynamicObject[])exports);
        }
    }
}

