/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffCheckPlugin;

public class CktsThreeBillWriteOffCheckPlugin
implements IWriteOffCheckPlugin {
    public static final String NOCONTROL = "nocontrol";
    public static final String BYRELATION = "byrelation";
    public static final String BYPERIOD = "byperiod";
    private static final String TPO_TCVAT_ASSIST = "tpo_tcvat_assist";
    private boolean isInit = false;
    private Long org = null;
    private String hhcbkz = null;
    private BigDecimal hhcbsx = BigDecimal.ZERO;
    private BigDecimal hhcbxx = BigDecimal.ZERO;

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WMQY_SDPP, WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP);
    }

    @Override
    public boolean checkWithoutException(DynamicObject recordBill) {
        DynamicObjectCollection entry = recordBill.getDynamicObjectCollection("entry");
        Map<String, List<DynamicObject>> collect = entry.stream().collect(Collectors.groupingBy(a -> a.getString("billtype.id")));
        List exportListDetails = collect.getOrDefault("tdm_export_declaration", new ArrayList(0));
        this.init(exportListDetails, recordBill);
        if (exportListDetails.size() > 0 && BYRELATION.equals(this.hhcbkz)) {
            BigDecimal hhcb = recordBill.getBigDecimal("hhcb");
            return hhcb.compareTo(this.hhcbsx) <= 0 && hhcb.compareTo(this.hhcbxx) >= 0;
        }
        return true;
    }

    private void init(List<DynamicObject> exportListDetails, DynamicObject recordBill) {
        if (!this.isInit) {
            this.org = recordBill.getLong("taxorg_id");
            this.hhcbkz = CktsThreeBillWriteOffCheckPlugin.getZeroDeclareParameter("tcetr", "hhcbkz", this.org);
            Date billdate = exportListDetails.get(0).getDate("billdate");
            List<String> hhcbsx = CktsThreeBillWriteOffCheckPlugin.queryAssistParams("hhcbsx", ResManager.loadKDString((String)"\u6362\u6c47\u6210\u672c\u4e0a\u9650", (String)"CktsThreeBillWriteOffCheckPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billdate);
            List<String> hhcbxx = CktsThreeBillWriteOffCheckPlugin.queryAssistParams("hhcbxx", ResManager.loadKDString((String)"\u6362\u6c47\u6210\u672c\u4e0b\u9650", (String)"CktsThreeBillWriteOffCheckPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billdate);
            if (hhcbsx.size() > 0 && hhcbxx.size() > 0) {
                this.hhcbsx = new BigDecimal(hhcbsx.get(0));
                this.hhcbxx = new BigDecimal(hhcbxx.get(0));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u5230\u6362\u6c47\u6210\u672c\u4e0a\u4e0b\u9650\u53c2\u6570\u3002", (String)"CktsThreeBillWriteOffCheckPlugin_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
        }
        this.isInit = true;
    }

    public static List<String> queryAssistParams(String assistCode, String classtype, Date billdate) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter code = new QFilter("number", "=", (Object)assistCode).and("classtype", "=", (Object)classtype);
        QFilter fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)billdate);
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)billdate).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)TPO_TCVAT_ASSIST, (String)"entryentity.fvalue1,entryentity.wherejson", (QFilter[])new QFilter[]{code, fstatus1, startdate, enddate}, (String)"entryentity.fvalue1 asc,entryentity.endDate DESC");
        for (DynamicObject d : doc) {
            String fvalue1 = d.getString("entryentity.fvalue1");
            list.add(fvalue1);
        }
        return list;
    }

    public static String getZeroDeclareParameter(String appNumber, String paramKey, long orgId) {
        if (appNumber == null || appNumber.length() == 0) {
            return NOCONTROL;
        }
        Object sysParams = CktsThreeBillWriteOffCheckPlugin.getAppParameter(appNumber, paramKey, orgId);
        return (String)sysParams;
    }

    public static Object getAppParameter(String appNumber, String paramKey, long orgId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)paramKey);
    }
}

