/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.TaxcWriteOffUtil;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffPlugin;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class CktsThreeBillWriteOffPlugin
implements IWriteOffPlugin {
    private static final Log logger = LogFactory.getLog(CktsThreeBillWriteOffPlugin.class);

    @Override
    public Map<String, Set<String>> preparePropKey() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        hashMap.put("tdm_export_declaration", Sets.newHashSet((Object[])new String[]{"entryentity.firstunit.name", "entryentity.firstunitqty", "entryentity.secondunit.name", "entryentity.secondunitqty", "entryentity.tradeunit.name", "entryentity.tradeqty", "entryentity.mylaj", "consignee.name", "org.id", "entryentity.mylaj", "entryentity.itemno", "entryentity.hscode.edrate", "entryentity.hscode.name"}));
        hashMap.put("rim_inv_special", Sets.newHashSet((Object[])new String[]{"items.unit", "items.num", "items.detail_amount", "items.tax_rate"}));
        hashMap.put("rim_inv_electric", Sets.newHashSet((Object[])new String[]{"items.unit", "items.num", "items.detail_amount", "items.tax_rate"}));
        hashMap.put("sim_vatinvoice", Sets.newHashSet((Object[])new String[]{"items.unit", "items.num", "items.amount", "items.taxrate"}));
        return hashMap;
    }

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WMQY_SDPP, WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP, WriteOffTypeIdConst.HXLB_SCQY);
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill) {
    }

    @Override
    public void beforeWfRecordGenerate(DynamicObject recordBill, List<WriteOffObjectBase> objs) {
        this.process(recordBill, objs);
    }

    private void process(DynamicObject recordBill, List<WriteOffObjectBase> wfObjectBase) {
        Long org = 0L;
        DynamicObjectCollection entry = recordBill.getDynamicObjectCollection("entry");
        if (entry.size() == 0) {
            return;
        }
        long typeId = recordBill.getLong("writeofftypeid.id");
        long l = System.currentTimeMillis();
        String sourceUnitCol = TaxcWriteOffUtil.getSourceUnitColByTypeId(typeId);
        String[] split = sourceUnitCol.split("\\.");
        long l21 = System.currentTimeMillis();
        HashMap<String, WriteOffObjectBase> exportMap = new HashMap<String, WriteOffObjectBase>(8);
        HashMap<String, WriteOffObjectBase> rimMap = new HashMap<String, WriteOffObjectBase>(8);
        HashMap<String, WriteOffObjectBase> simMap = new HashMap<String, WriteOffObjectBase>(8);
        for (WriteOffObjectBase writeOffObjectBase : wfObjectBase) {
            String writeoffbillnumber = writeOffObjectBase.getWfBillEntity().getString("writeoffbillnumber");
            if ("tdm_export_declaration".equals(writeoffbillnumber)) {
                exportMap.put(writeOffObjectBase.getPkValue().toString(), writeOffObjectBase);
                continue;
            }
            if ("rim_inv_special".equals(writeoffbillnumber) || "rim_inv_electric".equals(writeoffbillnumber)) {
                rimMap.put(writeOffObjectBase.getPkValue().toString(), writeOffObjectBase);
                continue;
            }
            if ("sim_vatinvoice".equals(writeoffbillnumber)) {
                simMap.put(writeOffObjectBase.getPkValue().toString(), writeOffObjectBase);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u65e0\u6cd5\u5904\u7406:%s", (String)"CktsThreeBillWriteOffPlugin_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), writeoffbillnumber == null ? "null" : writeoffbillnumber));
        }
        long l2 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u6279\u91cf\u67e5\u8be2\u539f\u5355,cost:{}ms", (Object)(l2 - l21));
        }
        String ckfpName = ResManager.loadKDString((String)"\u51fa\u53e3\u53d1\u7968", (String)"CktsThreeBillWriteOffPlugin_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String jxfpName = ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968", (String)"CktsThreeBillWriteOffPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        String ckbgdName = ResManager.loadKDString((String)"\u51fa\u53e3\u62a5\u5173\u5355", (String)"CktsThreeBillWriteOffPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        for (DynamicObject detail : entry) {
            Object unitid;
            BigDecimal ftje;
            BigDecimal amount;
            BigDecimal billqty;
            BigDecimal curQty;
            BigDecimal qty;
            BigDecimal unitRate;
            String invoiceUnit;
            WriteOffObjectBase assistBill;
            String assistBillType = detail.getDynamicObject("billtype").getString("id");
            Long assistBillEntryId = detail.getLong("billentryid");
            if ("tdm_export_declaration".equals(assistBillType)) {
                assistBill = (WriteOffObjectBase)exportMap.get(assistBillEntryId.toString());
                detail.set("trade", assistBill.getValue("consignee.name"));
                Long unit = (Long)assistBill.getValue(split[split.length - 1]);
                org = (Long)assistBill.getValue("org.id");
                BigDecimal mylaj = (BigDecimal)assistBill.getValue("mylaj");
                BigDecimal billqty2 = detail.getBigDecimal("billqty");
                BigDecimal qty2 = detail.getBigDecimal("qty");
                BigDecimal ftje2 = qty2.multiply(mylaj).divide(billqty2, 2, 4);
                detail.set("ftje", (Object)ftje2);
                detail.set("invoicecode", assistBill.getValue("itemno"));
                detail.set("taxrate", (Object)(assistBill.getValue("hscode.edrate") == null ? BigDecimal.ZERO : ((BigDecimal)assistBill.getValue("hscode.edrate")).divide(BigDecimal.TEN.multiply(BigDecimal.TEN))));
                detail.set("unit", (Object)unit);
                detail.set("unit_id", (Object)unit);
                detail.set("goodsname", assistBill.getValue("hscode.name"));
                detail.set("billname", (Object)ckbgdName);
                continue;
            }
            if ("rim_inv_special".equals(assistBillType) || "rim_inv_electric".equals(assistBillType)) {
                assistBill = (WriteOffObjectBase)rimMap.get(assistBillEntryId.toString());
                invoiceUnit = (String)assistBill.getValue("unit");
                unitRate = BigDecimal.ONE;
                qty = detail.getBigDecimal("qty");
                curQty = qty.divide(unitRate, 10, 4);
                detail.set("qty", (Object)curQty);
                billqty = (BigDecimal)assistBill.getValue("num");
                amount = (BigDecimal)assistBill.getValue("detail_amount");
                ftje = curQty.multiply(amount).divide(billqty, 2, 4);
                detail.set("ftje", (Object)ftje);
                detail.set("taxrate", assistBill.getValue("tax_rate"));
                unitid = TaxcWriteOffUtil.getUnitId(invoiceUnit);
                detail.set("unit", unitid);
                detail.set("billqty", (Object)billqty);
                if ("rim_inv_electric".equals(assistBillType)) {
                    jxfpName = ResManager.loadKDString((String)"\u8fdb\u9879\u6570\u7535\u4e13\u7968", (String)"CktsThreeBillWriteOffPlugin_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
                }
                detail.set("billname", (Object)jxfpName);
                continue;
            }
            if (!"sim_vatinvoice".equals(assistBillType)) continue;
            assistBill = (WriteOffObjectBase)simMap.get(assistBillEntryId.toString());
            invoiceUnit = (String)assistBill.getValue("unit");
            unitRate = BigDecimal.ONE;
            qty = detail.getBigDecimal("qty");
            curQty = qty.divide(unitRate, 10, 4);
            detail.set("qty", (Object)curQty);
            billqty = (BigDecimal)assistBill.getValue("num");
            amount = (BigDecimal)assistBill.getValue("amount");
            ftje = curQty.multiply(amount).divide(billqty, 2, 4);
            detail.set("ftje", (Object)ftje);
            unitid = TaxcWriteOffUtil.getUnitId(invoiceUnit);
            detail.set("unit", unitid);
            BigDecimal taxrateBig = this.getBigDecimalTaxrate((String)assistBill.getValue("taxrate"));
            detail.set("taxrate", (Object)taxrateBig);
            detail.set("billqty", (Object)billqty);
            detail.set("billname", (Object)ckfpName);
        }
        long l3 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u5faa\u73af\u5904\u7406\u5206\u644a,cost:{}ms", (Object)(l3 - l2));
        }
        Map<String, List<DynamicObject>> collect = entry.stream().collect(Collectors.groupingBy(a -> a.getString("billtype.id")));
        List exportListDetails = collect.getOrDefault("tdm_export_declaration", new ArrayList(0));
        BigDecimal refundRates = ((DynamicObject)exportListDetails.get(0)).getBigDecimal("taxrate");
        BigDecimal exportSum = exportListDetails.stream().map(a -> a.getBigDecimal("ftje")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List inputInvoiceDetails = collect.getOrDefault("rim_inv_special", new ArrayList(0));
        if (CollectionUtils.isEmpty((Collection)inputInvoiceDetails)) {
            inputInvoiceDetails = collect.getOrDefault("rim_inv_electric", new ArrayList(0));
        }
        BigDecimal invoiceSum = inputInvoiceDetails.stream().map(a -> {
            BigDecimal ftje = a.getBigDecimal("ftje");
            BigDecimal taxrate = a.getBigDecimal("taxrate");
            return refundRates.compareTo(BigDecimal.ZERO) == 0 || taxrate.compareTo(refundRates) < 0 ? ftje : ftje.multiply(BigDecimal.ONE.add(taxrate).subtract(refundRates));
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal hhcb = BigDecimal.ZERO.compareTo(exportSum) == 0 ? BigDecimal.ZERO : invoiceSum.divide(exportSum, 2, 4);
        recordBill.set("iscreatedraft", (Object)0);
        if (typeId == WriteOffTypeIdConst.HXLB_WMQY_SDPP || typeId == WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP) {
            recordBill.set("hhcb", (Object)hhcb);
            recordBill.set("qylx", (Object)"wmqy");
        } else if (typeId == WriteOffTypeIdConst.HXLB_SCQY) {
            recordBill.set("qylx", (Object)"scqy");
        }
        recordBill.set("taxorg", (Object)org);
        long l4 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u8ba1\u7b97\u6362\u6c47\u6210\u672c,cost:{}ms", (Object)(l4 - l3));
            logger.debug("logflag:\u6574\u4f53process\u6267\u884c,cost:{}ms", (Object)(l4 - l));
        }
    }

    private BigDecimal getBigDecimalTaxrate(String taxrate) {
        if (taxrate.endsWith("%")) {
            return new BigDecimal(taxrate.replace("%", "")).divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        }
        return new BigDecimal(taxrate);
    }
}

