/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.ext.taxc;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffTypeContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.WriteOffQueueGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.business.engine.core.record.WriteOffRecordMapper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.manager.WriteOffObjectManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.queue.WriteOffObjectQueue;
import kd.mpscmm.mscommon.writeoff.business.engine.core.writeoff.impl.AbstractWriteOffStrategy;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.ext.taxc.CktsThreeBillWriteOffCheckPlugin;
import kd.mpscmm.mscommon.writeoff.ext.taxc.TaxcWriteOffUtil;
import kd.sdk.mpscmm.mscommon.writeoff.params.IWriteOffQueue;
import kd.sdk.mpscmm.mscommon.writeoff.params.SchemeContextConfig;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class CktsThreeBillWriteOffStrategy
extends AbstractWriteOffStrategy {
    private static final Log logger = LogFactory.getLog(CktsThreeBillWriteOffStrategy.class);
    private static final int LIMIT_COUNT = 10000000;
    private static final String COUNT = "count";
    private static final int exportIndex = 0;
    private static final int rimIndex = 1;
    private static final int simIndex = 2;
    private String sourceUnitCol = "";
    private String entrySourceUnitCol = "";
    private Boolean isOverLimit = Boolean.FALSE;
    private Boolean isMatch = Boolean.FALSE;
    private Boolean isMylajZero = Boolean.FALSE;
    private boolean isInit = false;
    private Long org = null;
    private String hhcbkz = null;
    private BigDecimal hhcbsx = BigDecimal.ZERO;
    private BigDecimal hhcbxx = BigDecimal.ZERO;
    private HashMap<String, BigDecimal> unitRateCache = new HashMap();

    @Override
    public Set<Long> getWriteOffTypeIds() {
        return CommonUtils.getIdSet(WriteOffTypeIdConst.HXLB_WMQY_SDPP, WriteOffTypeIdConst.HXLB_WMQY_SDPP_SDP);
    }

    @Override
    public void batchExecute(SchemeContextConfig schemeContextConfig, List<WriteOffQueueGroup> queueGroups) {
        if (queueGroups != null) {
            logger.info("logflag:batchExecute\uff0csize:{}", (Object)queueGroups.size());
            for (WriteOffQueueGroup queue : queueGroups) {
                List<IWriteOffQueue> candidateQueues = queue.getCandidateQueues();
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    this.buildLogDatas(candidateQueues, stringBuilder);
                    this.execute(schemeContextConfig, candidateQueues);
                }
                catch (Exception e) {
                    logger.error("logflag: batchExecute", (Throwable)e);
                    stringBuilder.insert(0, ",error detail data id\uff1a");
                    stringBuilder.insert(0, e.getMessage());
                    if (queueGroups.size() != 1) continue;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void buildLogDatas(List<IWriteOffQueue> candidateQueues, StringBuilder stringBuilder) {
        for (int i = 0; i < candidateQueues.size(); ++i) {
            if (candidateQueues.get(i) == null) continue;
            List collect = candidateQueues.get(i).peekAll().stream().map(n -> n.getPkValue().toString()).collect(Collectors.toList());
            String billType = this.getBillType(candidateQueues.get(i));
            stringBuilder.append("{");
            stringBuilder.append(billType);
            stringBuilder.append("#");
            stringBuilder.append(JSONObject.toJSONString(collect));
            stringBuilder.append("},");
            if (logger.isDebugEnabled()) {
                logger.debug("logflag:\u6838\u9500\u961f\u5217\u6570\u636e:" + JSONObject.toJSONString(collect));
            }
            logger.info("logflag:\u51fa\u53e3\u4e09\u5355\u6838\u9500,{}\u961f\u5217\u7684\u6570\u636e\u957f\u5ea6\u4e3a{}", (Object)billType, (Object)candidateQueues.get(i).size());
        }
    }

    @Override
    public void execute(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        if (candidateQueues == null || candidateQueues.size() == 0) {
            return;
        }
        logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6574\u4f53\u6267\u884c");
        this.init(candidateQueues.get(0));
        long l = System.currentTimeMillis();
        if (this.isCompleted(candidateQueues)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u6838\u9500\u7684\u6570\u636e\u3002", (String)"CktsThreeBillWriteOffStrategy_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        boolean isWhole = this.isWhole(schemeContextConfig, candidateQueues);
        if (isWhole) {
            this.validExport(candidateQueues.get(0));
            List<List<IWriteOffQueue>> writeOffQueueGroups = this.wfRecordGroup(schemeContextConfig, candidateQueues);
            WriteOffTypeContext snapShootHolder = this.getSnapShootHolder();
            for (List<IWriteOffQueue> writeOffQueueList : writeOffQueueGroups) {
                WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueueList, null, schemeContextConfig);
                recordBill.getRecordBill().set("type", (Object)TaxcWriteOffUtil.WF_MODEL_MAP.get(schemeContextConfig.getWfMode()));
                snapShootHolder.addRecordBill(recordBill);
            }
            return;
        }
        this.sourceUnitCol = this.getSourceUnitCol();
        String[] split = this.sourceUnitCol.split("\\.");
        this.entrySourceUnitCol = split[split.length - 1];
        Map<String, Object> result = this.executeFirstSameUnit(schemeContextConfig, candidateQueues, isWhole);
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6574\u4f53\u6267\u884c,cost:{}ms", (Object)(l1 - l));
        int count = (Integer)result.getOrDefault(COUNT, 0);
        this.finish();
        if (count == 0) {
            logger.error("logflag:\u6838\u9500\u5931\u8d25\uff0c\u6ca1\u6709\u5408\u9002\u7684\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u6216\u6362\u6c47\u6210\u672c\u8ba1\u7b97\u8d85\u51fa\u9650\u5236\u3001\u7f8e\u5143\u79bb\u5cb8\u4ef7\u4e3a0\u3002");
            if (this.isMylajZero.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u7f8e\u5143\u79bb\u5cb8\u4ef7\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u5148\u8ba1\u7b97\u51fa\u53e3\u62a5\u5173\u5355\u7684\u7f8e\u5143\u79bb\u5cb8\u4ef7\u3002", (String)"CktsThreeBillWriteOffStrategy_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            if (this.isOverLimit.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u6362\u6c47\u6210\u672c\u8ba1\u7b97\u8d85\u51fa\u9650\u5236\u3002", (String)"CktsThreeBillWriteOffStrategy_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u6ca1\u6709\u5408\u9002\u7684\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u3002", (String)"CktsThreeBillWriteOffStrategy_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private void finish() {
        this.unitRateCache.clear();
    }

    private void init(IWriteOffQueue iWriteOffQueue) {
        if (!this.isInit) {
            WriteOffObjectBase export = iWriteOffQueue.peek();
            this.org = (Long)export.getValue("org.id");
            this.hhcbkz = CktsThreeBillWriteOffCheckPlugin.getZeroDeclareParameter("tcetr", "hhcbkz", this.org);
            Date billdate = new Date();
            List<String> hhcbsx = CktsThreeBillWriteOffCheckPlugin.queryAssistParams("hhcbsx", ResManager.loadKDString((String)"\u6362\u6c47\u6210\u672c\u4e0a\u9650", (String)"CktsThreeBillWriteOffCheckPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billdate);
            List<String> hhcbxx = CktsThreeBillWriteOffCheckPlugin.queryAssistParams("hhcbxx", ResManager.loadKDString((String)"\u6362\u6c47\u6210\u672c\u4e0b\u9650", (String)"CktsThreeBillWriteOffCheckPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), billdate);
            if (hhcbsx.size() <= 0 || hhcbxx.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u5230\u6362\u6c47\u6210\u672c\u4e0a\u4e0b\u9650\u53c2\u6570\u3002", (String)"CktsThreeBillWriteOffCheckPlugin_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            this.hhcbsx = new BigDecimal(hhcbsx.get(0));
            this.hhcbxx = new BigDecimal(hhcbxx.get(0));
            this.unitRateCache = new HashMap(iWriteOffQueue.size());
        }
        this.isInit = true;
    }

    private boolean isHhcbkz() {
        return "byrelation".equals(this.hhcbkz);
    }

    private boolean isInHhcbRange(WriteOffObjectBase export, WriteOffObjectBase inputInvoice) {
        BigDecimal hhcb;
        String invoiceUnit;
        Long expUnitId;
        String expUnitName = (String)export.getValue(this.entrySourceUnitCol + ".name");
        BigDecimal TR = this.getUnitRate(expUnitName, expUnitId = (Long)export.getValue(this.entrySourceUnitCol), invoiceUnit = (String)inputInvoice.getValue("unit"));
        if (TR == null) {
            return false;
        }
        BigDecimal refundRates = export.getValue("hscode.edrate") == null ? BigDecimal.ZERO : ((BigDecimal)export.getValue("hscode.edrate")).divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        BigDecimal EM = (BigDecimal)export.getValue("mylaj");
        String sourceNumCol = TaxcWriteOffUtil.getSourceNumCol(this.sourceUnitCol);
        BigDecimal SE = (BigDecimal)export.getValue(sourceNumCol);
        BigDecimal M1 = (BigDecimal)inputInvoice.getValue("detail_amount");
        BigDecimal tax_rate = (BigDecimal)inputInvoice.getValue("tax_rate");
        BigDecimal S1 = (BigDecimal)inputInvoice.getValue("num");
        BigDecimal two = BigDecimal.ONE;
        if (tax_rate.compareTo(refundRates) > 0) {
            two = BigDecimal.ONE.add(tax_rate).subtract(refundRates);
        }
        if (this.hhcbsx.compareTo(hhcb = M1.multiply(SE).multiply(two).divide(EM.multiply(S1).multiply(TR), 2, 4)) >= 0 && this.hhcbxx.compareTo(hhcb) <= 0) {
            return true;
        }
        this.isOverLimit = Boolean.TRUE;
        return false;
    }

    private BigDecimal getUnitRate(String expUnitName, Long expUnitId, String invoiceUnit) {
        String key = invoiceUnit + "_" + expUnitId;
        if (this.unitRateCache.containsKey(key)) {
            return this.unitRateCache.get(key);
        }
        BigDecimal unitRateFromCache = TaxcWriteOffUtil.getUnitRateFromCache(invoiceUnit, expUnitName, expUnitId);
        this.unitRateCache.put(key, unitRateFromCache);
        return unitRateFromCache;
    }

    private void validExport(IWriteOffQueue writeOffQueue) {
        List<WriteOffObjectBase> writeOffObjectBases = writeOffQueue.peekAll();
        for (WriteOffObjectBase poll : writeOffObjectBases) {
            BigDecimal mylaj = (BigDecimal)poll.getValue("mylaj");
            if (mylaj.compareTo(BigDecimal.ZERO) > 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7f8e\u5143\u79bb\u5cb8\u4ef7\u5927\u4e8e0\u624d\u80fd\u6838\u9500\uff0c\u5b58\u5728\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CktsThreeBillWriteOffStrategy_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> executeFirstSameUnit(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole) {
        long l = System.currentTimeMillis();
        logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u76f8\u540c\u4f18\u5148\u6838\u9500");
        int count = 0;
        Map<Object, Object> result = new HashMap();
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            if (!schemeContextConfig.isWhole()) continue;
            writeOffQueue.sortByWhole();
        }
        HashMap<Long, String> exportUnitIdMap = new HashMap<Long, String>();
        List<Map<String, IWriteOffQueue>> splitData = this.splitDataByUnit(candidateQueues, exportUnitIdMap);
        Map<String, IWriteOffQueue> queueMapEx = splitData.get(0);
        ArrayList<IWriteOffQueue> multiUnitQueues = new ArrayList<IWriteOffQueue>(4);
        multiUnitQueues.add(new WriteOffObjectQueue());
        multiUnitQueues.add(new WriteOffObjectQueue());
        multiUnitQueues.add(new WriteOffObjectQueue());
        HashSet<String> invoiceUnitNameSet = new HashSet<String>();
        invoiceUnitNameSet.addAll(splitData.get(1).keySet());
        invoiceUnitNameSet.addAll(splitData.get(2).keySet());
        for (Map.Entry<Long, String> entry : exportUnitIdMap.entrySet()) {
            Long unitid = entry.getKey();
            String unitname = entry.getValue();
            boolean canConvert = false;
            for (String string : invoiceUnitNameSet) {
                BigDecimal bigDecimal = this.getUnitRate(unitname, unitid, string);
                if (bigDecimal == null) continue;
                canConvert = true;
            }
            if (canConvert) continue;
            queueMapEx.remove(unitname);
        }
        Iterator<Map.Entry<String, IWriteOffQueue>> iterator = queueMapEx.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IWriteOffQueue> next = iterator.next();
            String key = next.getKey();
            if (splitData.get(1).containsKey(key) && splitData.get(2).containsKey(key)) continue;
            ((IWriteOffQueue)multiUnitQueues.get(0)).addAll(next.getValue().peekAll());
            iterator.remove();
        }
        logger.info("logflag:\u6bcf\u7ec4\u5355\u4f4d\u5148\u6838\u9500 start");
        long l3 = System.currentTimeMillis();
        Map<String, IWriteOffQueue> exportMap = splitData.get(0);
        Map<String, IWriteOffQueue> rimMap = splitData.get(1);
        Map<String, IWriteOffQueue> simMap = splitData.get(2);
        for (Map.Entry<String, IWriteOffQueue> entry : exportMap.entrySet()) {
            if (count >= 10000000) break;
            String sameUnit = entry.getKey();
            IWriteOffQueue exportQueue = entry.getValue();
            IWriteOffQueue rimQueue = rimMap.get(sameUnit);
            IWriteOffQueue simQueue = simMap.get(sameUnit);
            if (exportQueue == null || exportQueue.isEmpty() || rimQueue == null || rimQueue.isEmpty() || simQueue == null || simQueue.isEmpty()) continue;
            ArrayList<IWriteOffQueue> queueList = new ArrayList<IWriteOffQueue>();
            queueList.add(exportQueue);
            queueList.add(rimQueue);
            queueList.add(simQueue);
            result = this.executeMulUnit(schemeContextConfig, queueList, isWhole, true, true);
            count += result.getOrDefault(COUNT, 0).intValue();
        }
        long l2 = System.currentTimeMillis();
        logger.info("logflag:\u6bcf\u7ec4\u5355\u4f4d\u5148\u6838\u9500 end,cost:{}ms", (Object)(l2 - l3));
        logger.info("logflag:\u4e0d\u540c\u5355\u4f4d\u6838\u9500 start");
        long l22 = System.currentTimeMillis();
        if (count < 10000000) {
            for (int i = 0; i < splitData.size(); ++i) {
                Map<String, IWriteOffQueue> queueMap = splitData.get(i);
                for (IWriteOffQueue queue : queueMap.values()) {
                    if (queue.isEmpty()) continue;
                    ((IWriteOffQueue)multiUnitQueues.get(i)).addAll(queue.peekAll());
                }
            }
            result = this.executeMulUnit(schemeContextConfig, multiUnitQueues, isWhole, false, false);
            result.put(COUNT, count += ((Integer)result.getOrDefault(COUNT, 0)).intValue());
        }
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u4e0d\u540c\u5355\u4f4d\u6838\u9500 end,cost:{}ms", (Object)(l1 - l22));
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u76f8\u540c\u4f18\u5148\u6838\u9500,cost:{}ms", (Object)(l1 - l));
        return result;
    }

    private Map<String, Object> executeMulUnit(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole, boolean sameUnit, boolean mergeData) {
        long l = System.currentTimeMillis();
        logger.debug("logflag:\u5f00\u59cb\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5");
        HashMap<String, Object> reulst = new HashMap<String, Object>(4);
        int count = 0;
        if (this.isCompleted(candidateQueues)) {
            reulst.put(COUNT, count);
            return reulst;
        }
        IDataEntityProperty simUnitProp = null;
        IDataEntityProperty simIdProp = null;
        IDataEntityProperty rimUnitProp = null;
        IDataEntityProperty rimIdProp = null;
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            String billType = this.getBillType(writeOffQueue);
            if (StringUtils.isNotEmpty((String)billType)) {
                if ("sim_vatinvoice".equals(billType)) {
                    simUnitProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"unit");
                    simIdProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"id");
                } else if ("rim_inv_special".equals(billType) || "rim_inv_electric".equals(billType)) {
                    rimUnitProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"unit");
                    rimIdProp = (IDataEntityProperty)writeOffQueue.peek().getWriteOffObject().getDataEntityType().getProperties().get((Object)"id");
                }
            }
            if (writeOffQueue == null) continue;
            if (logger.isDebugEnabled()) {
                List collect = writeOffQueue.peekAll().stream().map(n -> n.getPkValue()).collect(Collectors.toList());
                logger.debug("logflag:\u5f00\u59cb\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,\u6838\u9500\u961f\u5217\u6570\u636e:" + JSONObject.toJSONString(collect));
            }
            logger.info("logflag:\u5f00\u59cb\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,{}\u961f\u5217\u7684\u6570\u636e\u957f\u5ea6\u4e3a{}", (Object)(billType + " "), (Object)writeOffQueue.size());
        }
        if (simIdProp == null && simUnitProp == null && rimIdProp == null && rimUnitProp == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u53d1\u7968\u7684id\u548c\u5355\u4f4d\u5217\u3002", (String)"CktsThreeBillWriteOffStrategy_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        WriteOffTypeConfig typeConfig = this.getTypeConfig();
        WriteOffTypeContext snapShootHolder = this.getSnapShootHolder();
        IWriteOffQueue exportQueue = candidateQueues.get(0);
        IWriteOffQueue rimQueue = candidateQueues.get(1);
        IWriteOffQueue simQueue = candidateQueues.get(2);
        ArrayList<IWriteOffQueue> queueList = new ArrayList<IWriteOffQueue>();
        queueList.add(new WriteOffObjectQueue());
        queueList.add(new WriteOffObjectQueue());
        queueList.add(simQueue);
        WriteOffObjectQueue exportNoMatchQueue = new WriteOffObjectQueue();
        WriteOffObjectQueue rimNoMatchQueue = new WriteOffObjectQueue();
        WriteOffObjectQueue simPool = new WriteOffObjectQueue();
        int i = 0;
        while (!exportQueue.isEmpty() && count < 10000000) {
            WriteOffObjectBase export = this.pollExportEntry(exportQueue);
            if (export == null) continue;
            ((IWriteOffQueue)queueList.get(0)).add(export);
            while (!((IWriteOffQueue)queueList.get(0)).isEmpty() && !rimQueue.isEmpty() && count < 10000000) {
                WriteOffObjectBase pollRimEntry = this.pollRimEntry(rimQueue, queueList, rimNoMatchQueue);
                if (pollRimEntry == null) continue;
                ((IWriteOffQueue)queueList.get(1)).add(pollRimEntry);
                ((IWriteOffQueue)queueList.get(2)).addAll(simPool.peekAll());
                simPool.peekAll().clear();
                while (!this.isCompleted(queueList) && count < 10000000) {
                    ++i;
                    List<IWriteOffQueue> writeOffQueues = this.pickDiffUnitWriteOffObjects(schemeContextConfig, queueList, isWhole, exportNoMatchQueue, rimNoMatchQueue, rimUnitProp, rimIdProp, simUnitProp, simIdProp);
                    Optional<IWriteOffQueue> first = writeOffQueues.stream().filter(IWriteOffQueue::isEmpty).findFirst();
                    if (first.isPresent()) break;
                    this.isMatch = Boolean.TRUE;
                    List<IWriteOffQueue> copyQueues = this.copyQueues(writeOffQueues);
                    String wbDetail = null;
                    WriteOffRecordMapper recordBill = this.writeOffRecord(writeOffQueues, wbDetail, schemeContextConfig);
                    boolean checkWithoutException = WfPluginExtFactory.checkWithoutException(this.getExecuteContext().getPluginFactory(), recordBill.getRecordBill(), typeConfig);
                    if (checkWithoutException) {
                        recordBill.getRecordBill().set("type", (Object)TaxcWriteOffUtil.WF_MODEL_MAP.get(schemeContextConfig.getWfMode()));
                        snapShootHolder.addRecordBill(recordBill);
                        ++count;
                        continue;
                    }
                    logger.debug("logflag:WfPluginExtFactory.check,false");
                    Object rimPkValue = copyQueues.get(1).peek().getPkValue();
                    ((IWriteOffQueue)queueList.get(0)).addAll(copyQueues.get(0).peekAll());
                    ((IWriteOffQueue)queueList.get(1)).addAll(copyQueues.get(1).peekAll());
                    simPool.addAll(copyQueues.get(2).peekAll());
                    this.mergeData((IWriteOffQueue)queueList.get(1));
                    Predicate<WriteOffObjectBase> condition = a -> rimPkValue.equals(a.getPkValue());
                    IWriteOffQueue polls = this.pollCondition((IWriteOffQueue)queueList.get(1), condition);
                    rimNoMatchQueue.addAll(polls.peekAll());
                }
                rimNoMatchQueue.addAll(((IWriteOffQueue)queueList.get(1)).peekAll());
                ((IWriteOffQueue)queueList.get(1)).peekAll().clear();
            }
            rimQueue.addAll(rimNoMatchQueue.peekAll());
            rimNoMatchQueue.peekAll().clear();
            exportNoMatchQueue.addAll(((IWriteOffQueue)queueList.get(0)).peekAll());
            ((IWriteOffQueue)queueList.get(0)).peekAll().clear();
        }
        if (mergeData) {
            exportQueue.addAll(((IWriteOffQueue)queueList.get(0)).peekAll());
            rimQueue.addAll(((IWriteOffQueue)queueList.get(1)).peekAll());
            exportQueue.addAll(exportNoMatchQueue.peekAll());
            rimQueue.addAll(rimNoMatchQueue.peekAll());
            simQueue.addAll(simPool.peekAll());
            candidateQueues.forEach(a -> this.mergeData((IWriteOffQueue)a));
        }
        reulst.put(COUNT, count);
        long l1 = System.currentTimeMillis();
        logger.info("logflag:\u7ed3\u675f\u51fa\u53e3\u4e09\u5355\u6838\u9500,\u6267\u884c\u5355\u4f4d\u4e0d\u7edf\u4e00\u7684\u60c5\u51b5,cost:{}ms,\u5faa\u73af\uff1a{}\u6b21", (Object)(l1 - l), (Object)i);
        return reulst;
    }

    private WriteOffObjectBase pollRimEntry(IWriteOffQueue rimQueue, List<IWriteOffQueue> queueList, WriteOffObjectQueue rimNoMatchQueue) {
        if (this.isHhcbkz()) {
            while (!rimQueue.isEmpty()) {
                WriteOffObjectBase input = rimQueue.poll();
                if (this.isInHhcbRange(queueList.get(0).peek(), input)) {
                    return input;
                }
                rimNoMatchQueue.add(input);
            }
        } else {
            return rimQueue.poll();
        }
        return null;
    }

    private IWriteOffQueue pollCondition(IWriteOffQueue iWriteOffQueue, Predicate<WriteOffObjectBase> condition) {
        WriteOffObjectQueue queue = new WriteOffObjectQueue();
        ArrayList<WriteOffObjectBase> queueList1 = new ArrayList<WriteOffObjectBase>(32);
        while (!iWriteOffQueue.isEmpty()) {
            WriteOffObjectBase poll = iWriteOffQueue.poll();
            if (condition.test(poll)) {
                queue.add(poll);
                continue;
            }
            queueList1.add(poll);
        }
        iWriteOffQueue.addAll(queueList1);
        return queue;
    }

    private void mergeData(IWriteOffQueue candidateQueue) {
        ArrayList<WriteOffObjectBase> queueList = new ArrayList<WriteOffObjectBase>(32);
        Map<String, List<WriteOffObjectBase>> map = candidateQueue.peekAll().stream().filter(a -> a != null).collect(Collectors.groupingBy(a -> String.format("%s_%s", a.getWfBillPk(), a.getPkValue())));
        for (Map.Entry<String, List<WriteOffObjectBase>> entry : map.entrySet()) {
            List<WriteOffObjectBase> values = entry.getValue();
            WriteOffObjectBase writeOffObjectBase = values.get(0);
            BigDecimal reduce = values.stream().map(a -> a.getWriteOffNumber()).reduce(BigDecimal.ZERO, BigDecimal::add);
            writeOffObjectBase.setWriteOffNumber(reduce);
            queueList.add(writeOffObjectBase);
        }
        candidateQueue.peekAll().clear();
        candidateQueue.addAll(queueList);
    }

    private List<IWriteOffQueue> copyQueues(List<IWriteOffQueue> writeOffQueues) {
        ArrayList<IWriteOffQueue> copyQueues = new ArrayList<IWriteOffQueue>(4);
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            WriteOffObjectQueue copyQueue = new WriteOffObjectQueue();
            copyQueue.addAll(writeOffQueue.peekAll());
            copyQueues.add(copyQueue);
        }
        return copyQueues;
    }

    private boolean isCompletedData(List<Map<String, IWriteOffQueue>> splitData) {
        for (Map<String, IWriteOffQueue> splitDatum : splitData) {
            boolean isCompleted = true;
            for (Map.Entry<String, IWriteOffQueue> entry : splitDatum.entrySet()) {
                IWriteOffQueue candidateQueue = entry.getValue();
                if (candidateQueue.isEmpty()) continue;
                isCompleted = false;
            }
            if (!isCompleted) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("logflag:\u4e0d\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
        }
        return false;
    }

    private List<Map<String, IWriteOffQueue>> splitDataByUnit(List<IWriteOffQueue> candidateQueues, HashMap<Long, String> exportUnitIdMap) {
        long l = System.currentTimeMillis();
        logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d splitDataByUnit start");
        ArrayList<Map<String, IWriteOffQueue>> splitData = new ArrayList<Map<String, IWriteOffQueue>>(4);
        HashMap seqMap = new HashMap(4);
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            LinkedHashMap<String, IWriteOffQueue> map = new LinkedHashMap<String, IWriteOffQueue>();
            int index = 0;
            while (!candidateQueue.isEmpty()) {
                WriteOffObjectBase poll = candidateQueue.poll();
                String billType = this.getBillType(poll);
                String unitName = null;
                if ("tdm_export_declaration".equals(billType)) {
                    index = 0;
                    unitName = (String)poll.getValue(this.entrySourceUnitCol + ".name");
                    Long id = (Long)poll.getValue(this.entrySourceUnitCol);
                    exportUnitIdMap.putIfAbsent(id, unitName);
                } else if ("rim_inv_special".equals(billType) || "rim_inv_electric".equals(billType)) {
                    index = 1;
                    unitName = (String)poll.getValue("unit");
                } else if ("sim_vatinvoice".equals(billType)) {
                    index = 2;
                    unitName = (String)poll.getValue("unit");
                }
                if (unitName == null) continue;
                IWriteOffQueue orDefault = map.getOrDefault(unitName, new WriteOffObjectQueue());
                orDefault.add(poll);
                map.put(unitName, orDefault);
            }
            seqMap.put(index, map);
        }
        for (int i = 0; i < 3; ++i) {
            Map element = seqMap.getOrDefault(i, new HashMap());
            splitData.add(element);
        }
        logger.info("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d splitDataByUnit end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
        return splitData;
    }

    @Override
    public boolean isCompleted(List<IWriteOffQueue> candidateQueues) {
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            if (!candidateQueue.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("logflag:\u4e0d\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u5b58\u5728\u53ef\u914d\u5bf9\u7684\u6838\u9500\u5bf9\u8c61");
        }
        return false;
    }

    @Override
    public List<IWriteOffQueue> pickWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues) {
        return null;
    }

    private IWriteOffQueue pollQueue(IWriteOffQueue candidateQueue, boolean isWhole, BigDecimal needWriteOffNumber, Map<String, BigDecimal> rateMap, IDataEntityProperty rimIdProp, IDataEntityProperty simIdProp) {
        String billType = this.getBillType(candidateQueue);
        IWriteOffQueue writeOffQueue = new WriteOffObjectQueue();
        if (StringUtils.isNotEmpty((String)billType)) {
            if ("tdm_export_declaration".equals(billType)) {
                writeOffQueue = candidateQueue.pollQueue(isWhole, needWriteOffNumber);
            } else if ("rim_inv_special".equals(billType) || "rim_inv_electric".equals(billType) || "sim_vatinvoice".equals(billType)) {
                IDataEntityProperty idProp;
                BigDecimal queueWfNumber = BigDecimal.ZERO;
                IDataEntityProperty iDataEntityProperty = idProp = "rim_inv_special".equals(billType) || "rim_inv_electric".equals(billType) ? rimIdProp : simIdProp;
                while (queueWfNumber.compareTo(needWriteOffNumber) < 0 && !candidateQueue.isEmpty()) {
                    WriteOffObjectBase poll = candidateQueue.poll();
                    Long id = (Long)idProp.getValueFast((Object)poll.getWriteOffObject());
                    BigDecimal unitRate = rateMap.get(billType + id);
                    BigDecimal originalNumber = WriteOffObjectManager.getLogicWriteOffNumber(poll);
                    BigDecimal canWONumber = originalNumber.multiply(unitRate);
                    BigDecimal temp = queueWfNumber.add(canWONumber);
                    if (temp.compareTo(needWriteOffNumber) > 0) {
                        BigDecimal lastNeed = needWriteOffNumber.subtract(queueWfNumber);
                        BigDecimal planWriteOffNumber = lastNeed.divide(unitRate, 10, 4);
                        BigDecimal returnWriteOffNumber = originalNumber.subtract(planWriteOffNumber);
                        WriteOffObjectBase planWriteOffObject = poll.clone();
                        WriteOffObjectManager.setLogicWriteOffNumber(planWriteOffObject, planWriteOffNumber);
                        writeOffQueue.add(planWriteOffObject);
                        WriteOffObjectManager.setLogicWriteOffNumberNotAss(poll, returnWriteOffNumber, planWriteOffObject.getWriteOffValues());
                        candidateQueue.add(poll);
                        break;
                    }
                    poll.setWfComplete(true);
                    writeOffQueue.add(poll);
                    queueWfNumber = temp;
                }
            }
        }
        return writeOffQueue;
    }

    public List<IWriteOffQueue> pickDiffUnitWriteOffObjects(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> candidateQueues, boolean isWhole, WriteOffObjectQueue exportNoMatchQueue, WriteOffObjectQueue rimNoMatchQueue, IDataEntityProperty rimUnitProp, IDataEntityProperty rimIdProp, IDataEntityProperty simUnitProp, IDataEntityProperty simIdProp) {
        long l = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects start");
        }
        ArrayList<WriteOffObjectQueue> selectedQueues = new ArrayList<WriteOffObjectQueue>(10);
        BigDecimal needWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal exportWriteOffNumber = BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal rimWriteOffNumber = BigDecimal.ZERO;
        BigDecimal simWrirteOffNumber = BigDecimal.ZERO;
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        Long targetUnitId = null;
        String targetUnitName = null;
        HashMap<String, IWriteOffQueue> queuesMap = new HashMap<String, IWriteOffQueue>();
        for (IWriteOffQueue writeOffQueue : candidateQueues) {
            String string = this.getBillType(writeOffQueue);
            if (!StringUtils.isNotEmpty((String)string)) continue;
            queuesMap.put(string, writeOffQueue);
        }
        for (IWriteOffQueue candidateQueue : candidateQueues) {
            String string = this.getBillType(candidateQueue);
            WriteOffObjectQueue curCanWfQueue = new WriteOffObjectQueue();
            if (StringUtils.isNotEmpty((String)string) && "tdm_export_declaration".equals(string)) {
                WriteOffObjectBase poll = this.pollExportEntry(candidateQueue);
                if (poll != null) {
                    curCanWfQueue.add(poll);
                    targetUnitId = (Long)poll.getValue(this.entrySourceUnitCol);
                    targetUnitName = (String)poll.getValue(this.entrySourceUnitCol + ".name");
                    exportWriteOffNumber = poll.getWriteOffNumber();
                }
            } else if (StringUtils.isNotEmpty((String)string) && ("rim_inv_special".equals(string) || "rim_inv_electric".equals(string) || "sim_vatinvoice".equals(string))) {
                long l1 = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects traverse {} queue start", (Object)string);
                }
                IDataEntityProperty unitProp = "rim_inv_special".equals(string) || "rim_inv_electric".equals(string) ? rimUnitProp : simUnitProp;
                IDataEntityProperty idProp = "rim_inv_special".equals(string) || "rim_inv_electric".equals(string) ? rimIdProp : simIdProp;
                BigDecimal queueWfSum = BigDecimal.ZERO;
                if (targetUnitId != null) {
                    WriteOffObjectQueue curNoCanWfQueue = new WriteOffObjectQueue();
                    while (candidateQueue.size() > 0 && queueWfSum.compareTo(exportWriteOffNumber) < 0) {
                        WriteOffObjectBase writeOffObjectBase = candidateQueue.peek();
                        String invoiceUnit = (String)unitProp.getValueFast((Object)writeOffObjectBase.getWriteOffObject());
                        BigDecimal unitRate = this.getUnitRate(targetUnitName, targetUnitId, invoiceUnit);
                        if (unitRate != null) {
                            writeOffObjectBase = candidateQueue.poll();
                            BigDecimal originalNumber = WriteOffObjectManager.getLogicWriteOffNumber(writeOffObjectBase);
                            BigDecimal canWONumber = originalNumber.multiply(unitRate);
                            Long id = (Long)idProp.getValueFast((Object)writeOffObjectBase.getWriteOffObject());
                            rateMap.put(string + id, unitRate);
                            curCanWfQueue.add(writeOffObjectBase);
                            queueWfSum = queueWfSum.add(canWONumber);
                            continue;
                        }
                        if (StringUtils.isEmpty((String)invoiceUnit)) {
                            candidateQueue.poll();
                            continue;
                        }
                        curNoCanWfQueue.add(candidateQueue.poll());
                    }
                    candidateQueue.addAll(curNoCanWfQueue.peekAll());
                    if (logger.isDebugEnabled()) {
                        logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects traverse {} queue end,cost:{}ms", (Object)string, (Object)(System.currentTimeMillis() - l1));
                    }
                }
                if ("rim_inv_special".equals(string) || "rim_inv_electric".equals(string)) {
                    rimWriteOffNumber = queueWfSum;
                } else {
                    simWrirteOffNumber = queueWfSum;
                }
            }
            selectedQueues.add(curCanWfQueue);
        }
        for (BigDecimal decimal : Arrays.asList(exportWriteOffNumber, rimWriteOffNumber, simWrirteOffNumber)) {
            if (decimal.abs().compareTo(needWriteOffNumber.abs()) >= 0) continue;
            needWriteOffNumber = decimal;
        }
        ArrayList<IWriteOffQueue> finalQueues = new ArrayList<IWriteOffQueue>(10);
        for (IWriteOffQueue iWriteOffQueue : selectedQueues) {
            if (needWriteOffNumber.compareTo(BigDecimal.ZERO) > 0) {
                IWriteOffQueue writeOffQueue = this.pollQueue(iWriteOffQueue, isWhole, needWriteOffNumber, rateMap, rimIdProp, simIdProp);
                finalQueues.add(writeOffQueue);
                this.reInQueue(queuesMap, rateMap, iWriteOffQueue, true, simIdProp, rimIdProp, exportNoMatchQueue, rimNoMatchQueue);
                continue;
            }
            this.reInQueue(queuesMap, rateMap, iWriteOffQueue, true, simIdProp, rimIdProp, exportNoMatchQueue, rimNoMatchQueue);
            finalQueues.add(new WriteOffObjectQueue());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
        }
        return finalQueues;
    }

    private WriteOffObjectBase pollExportEntry(IWriteOffQueue candidateQueue) {
        BigDecimal mylaj;
        WriteOffObjectBase poll = candidateQueue.poll();
        while (poll != null && ((mylaj = (BigDecimal)poll.getValue("mylaj")).compareTo(BigDecimal.ZERO) <= 0 || poll.getWriteOffNumber().compareTo(BigDecimal.ZERO) <= 0)) {
            poll = candidateQueue.poll();
        }
        if (poll == null) {
            this.isMylajZero = Boolean.TRUE;
        }
        return poll;
    }

    private void reInQueue(Map<String, IWriteOffQueue> queuesMap, Map<String, BigDecimal> rateMap, IWriteOffQueue restQueue, boolean recordExport, IDataEntityProperty simIdProp, IDataEntityProperty rimIdProp, WriteOffObjectQueue exportNoMatchQueue, WriteOffObjectQueue rimNoMatchQueue) {
        String billType;
        long l = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects reInQueue start");
        }
        if (StringUtils.isNotEmpty((String)(billType = this.getBillType(restQueue))) && simIdProp != null && rimIdProp != null) {
            IWriteOffQueue originalQueue = queuesMap.get(billType);
            if ("sim_vatinvoice".equals(billType)) {
                originalQueue.addAll(restQueue.peekAll());
            } else if ("rim_inv_special".equals(billType) || "rim_inv_electric".equals(billType)) {
                if (recordExport) {
                    originalQueue.addAll(restQueue.peekAll());
                } else {
                    rimNoMatchQueue.addAll(restQueue.peekAll());
                }
            } else if ("tdm_export_declaration".equals(billType)) {
                if (recordExport) {
                    originalQueue.addAll(restQueue.peekAll());
                } else {
                    exportNoMatchQueue.addAll(restQueue.peekAll());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("logflag:\u51fa\u53e3\u9000\u7a0e\u6838\u9500\uff08\u5916\u8d38\u4f01\u4e1a\uff09-\u4e09\u5355\u5339\u914d pickWriteOffObjects reInQueue end,cost:{}ms", (Object)(System.currentTimeMillis() - l));
        }
    }

    private String getBillType(IWriteOffQueue candidateQueue) {
        WriteOffObjectBase peekOne = candidateQueue.peek();
        if (peekOne != null) {
            WriteOffBillConfig writeOffBillConfig = this.getBillConfig(peekOne);
            return writeOffBillConfig.getBillType();
        }
        return null;
    }

    private String getBillType(WriteOffObjectBase peekOne) {
        WriteOffBillConfig writeOffBillConfig = this.getBillConfig(peekOne);
        return writeOffBillConfig.getBillType();
    }

    private boolean isWhole(SchemeContextConfig schemeContextConfig, List<IWriteOffQueue> writeOffQueues) {
        if ("2".equals(schemeContextConfig.getWfMode()) && (schemeContextConfig.isManualWhole() || this.queueIsWhole(writeOffQueues))) {
            return true;
        }
        if ("3".equals(schemeContextConfig.getWfMode())) {
            return false;
        }
        return schemeContextConfig.isWhole() && this.queueIsWhole(writeOffQueues);
    }

    private boolean queueIsWhole(List<IWriteOffQueue> writeOffQueues) {
        for (IWriteOffQueue writeOffQueue : writeOffQueues) {
            boolean flag = writeOffQueue.peek().getWhole();
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private WriteOffBillConfig getBillConfig(WriteOffObjectBase writeOffObject) {
        return this.getTypeConfig().getBillConfigsById((Long)writeOffObject.getWfBillEntity().getPkValue());
    }

    private String getSourceUnitCol() {
        DynamicObjectCollection writeoffbillentry = this.getTypeConfig().getObj().getDynamicObjectCollection("writeoffbillentry");
        Object mappingid = ((DynamicObject)writeoffbillentry.get(0)).getDynamicObject("wfmapping").get("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)mappingid, (String)"sbs_billfieldmapping");
        DynamicObjectCollection colsmap = dynamicObject.getDynamicObjectCollection("colsmap");
        Optional<DynamicObject> targetbillcol = colsmap.stream().filter(a -> "entry.unit".equals(a.getString("targetobjcol"))).findFirst();
        return targetbillcol.get().getString("sourcebillcol");
    }
}

