/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PageShowHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.PresetHelper;
import kd.mpscmm.mscommon.writeoff.common.trans.FieldFormTranslator;
import kd.mpscmm.mscommon.writeoff.common.util.ColsTreeUtil;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfTypeBaseDataPlugin;
import kd.mpscmm.mscommon.writeoff.lang.NounLang;

public class MatchRuleEditPlugin
extends AbstractWfTypeBaseDataPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillfieldname", "targetbillfieldname"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "srcbilltype", "targetbilltype");
        this.addItemClickListeners(new String[]{"advcontoolbarap11", "advcontoolbarap1"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translateInfo();
    }

    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            FieldFormTranslator translator = FieldFormTranslator.create(this.getModel());
            translator.entryToSubEntryTranslate("matchrelateentry", "srcbilltype", "matchcditsubentry", "srcbillfieldkey", "srcbillfieldname");
            translator.entryToSubEntryTranslate("matchrelateentry", "targetbilltype", "matchcditsubentry", "targetbillfieldkey", "targetbillfieldname");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryOpBtnEnable();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("deleteentry_a".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "matchcditsubentry", "mseispreset");
        } else if ("deleteentry_p".equals(key)) {
            PresetHelper.presetEntryRowDeleteCheck(view, model, evt, "matchpluginentry", "mpeispreset");
        }
    }

    @Override
    protected String presetKey() {
        return "ispreset";
    }

    private void initEntryOpBtnEnable() {
        boolean isPreSet = (Boolean)this.getModel().getValue("ispreset");
        if (isPreSet) {
            this.setEntryOpBtnEnable(false);
        }
    }

    private void setEntryOpBtnEnable(boolean isEnable) {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(isEnable), new String[]{"newentry", "deleteentry", "newentry_a", "deleteentry_a"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (proName = e.getProperty().getName()) {
            case "srcbilltype": 
            case "targetbilltype": {
                this.beforeBillType(e, model, view);
                break;
            }
        }
    }

    private void beforeBillType(BeforeF7SelectEvent e, IDataModel model, IFormView view) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject writeOffType = (DynamicObject)model.getValue("writeofftype");
        if (writeOffType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u9500\u7c7b\u522b\u3002", (String)"MatchRuleEditPluginWFTypeInputErr", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List<Object> ids = this.getWriteOffTypeBillAlias();
        QFilter wfBillQFilter = new QFilter("id", "in", ids);
        showParameter.getListFilterParameter().setFilter(wfBillQFilter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object oldValue = changeSet.getOldValue();
        int rowIndex = changeSet.getRowIndex();
        IDataModel model = this.getModel();
        switch (proName) {
            case "srcbilltype": {
                this.srcBillTypeChanged(model, (DynamicObject)oldValue, rowIndex);
                break;
            }
            case "targetbilltype": {
                this.targetBillTypeChanged(model, (DynamicObject)oldValue, (DynamicObject)changeSet.getNewValue(), rowIndex);
                break;
            }
            case "srcbillfieldname": {
                this.billFieldNameChanged("srcbillfieldname", changeSet);
                break;
            }
            case "targetbillfieldname": {
                this.billFieldNameChanged("targetbillfieldname", changeSet);
                break;
            }
        }
    }

    private void billFieldNameChanged(String billNameKey, ChangeData changeSet) {
        int rowIndex = changeSet.getRowIndex();
        String value = (String)this.getModel().getValue(billNameKey, rowIndex, changeSet.getParentRowIndex());
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return;
        }
        if ("srcbillfieldname".equals(billNameKey)) {
            this.getModel().setValue("srcbillfieldkey", null, rowIndex, changeSet.getParentRowIndex());
        } else {
            this.getModel().setValue("targetbillfieldkey", null, rowIndex, changeSet.getParentRowIndex());
        }
    }

    private void targetBillTypeChanged(IDataModel model, DynamicObject oldValue, DynamicObject newValue, int index) {
        int subRowCount = model.getEntryRowCount("matchcditsubentry");
        if (subRowCount == 0) {
            return;
        }
        for (int i = 0; i < subRowCount; ++i) {
            if ("id,entryid".equals(this.getModel().getValue("targetbillfieldkey", i, index))) {
                if (newValue != null && "cal_costrecord_subentity".equals(newValue.getString("wfbill.number"))) {
                    this.getModel().setValue("targetbillfieldname", (Object)NounLang.bizIdAndBizEntryId(), i, index);
                    continue;
                }
                this.getModel().setValue("targetbillfieldname", (Object)NounLang.idAndEntryId(), i, index);
                continue;
            }
            this.getModel().setValue("targetbillfieldname", (Object)"", i, index);
        }
        DynamicObjectCollection subEntry = model.getEntryRowEntity("matchrelateentry", index).getDynamicObjectCollection("matchcditsubentry");
        Iterator iterator = subEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject matchSubEntry = (DynamicObject)iterator.next();
            String srcFieldName = matchSubEntry.getString("srcbillfieldname");
            String srcFieldKey = matchSubEntry.getString("srcbillfieldkey");
            if (!StringUtils.isEmpty((CharSequence)srcFieldName) || !StringUtils.isEmpty((CharSequence)srcFieldKey)) continue;
            iterator.remove();
        }
        this.getView().updateView("matchcditsubentry");
    }

    private void srcBillTypeChanged(IDataModel model, DynamicObject oldValue, int index) {
        DynamicObject entryRowEntity = model.getEntryRowEntity("matchrelateentry", index);
        DynamicObjectCollection subEntry = entryRowEntity.getDynamicObjectCollection("matchcditsubentry");
        int subRowCount = subEntry.size();
        if (subRowCount == 0) {
            return;
        }
        Object value = this.getModel().getValue("matchcditsubentry", index);
        if (value == null) {
            return;
        }
        for (int i = 0; i < subRowCount; ++i) {
            model.setValue("srcbillfieldname", (Object)"", i, index);
            model.setValue("comparison", (Object)"", i, index);
        }
        Iterator iterator = subEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject matchSubEntry = (DynamicObject)iterator.next();
            String targetFieldName = matchSubEntry.getString("targetbillfieldname");
            String targetFieldKey = matchSubEntry.getString("targetbillfieldkey");
            if (!StringUtils.isEmpty((CharSequence)targetFieldName) || !StringUtils.isEmpty((CharSequence)targetFieldKey)) continue;
            iterator.remove();
        }
        this.getView().updateView("matchcditsubentry");
    }

    @Override
    protected void clearWriteOffType() {
        this.getModel().setValue("description", null);
        this.getView().updateView("description");
        this.getModel().deleteEntryData("matchrelateentry");
        this.getModel().deleteEntryData("matchcditsubentry");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = FormUtils.getOpKey(args);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (operateKey) {
            case "newentry_a": {
                this.checkBeforeNewSubE(args, model, view);
                break;
            }
        }
    }

    private void checkBeforeNewSubE(BeforeDoOperationEventArgs args, IDataModel model, IFormView view) {
        EntryGrid matchRelateGrid = (EntryGrid)this.getControl("matchrelateentry");
        int pFocusIndex = matchRelateGrid.getEntryState().getFocusRow();
        Object srcBillType = model.getValue("srcbilltype", pFocusIndex);
        Object targetBillType = model.getValue("targetbilltype", pFocusIndex);
        if (srcBillType == null && targetBillType != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u6e90\u5355\u636e\u3002", (String)"MatchRuleEditPluginSrcBillNotInput", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (srcBillType == null && targetBillType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u6e90\u5355\u636e\u548c\u76ee\u6807\u5355\u636e\u3002", (String)"MatchRuleEditPluginSTBillNotInput", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (srcBillType != null && targetBillType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u76ee\u6807\u5355\u636e\u3002", (String)"MatchRuleEditPluginTargetBillNotInput", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        Object source = e.getSource();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String fieldNameKey = textEdit.getFieldKey();
            int parentIndex = model.getEntryCurrentRowIndex("matchrelateentry");
            int currSubIndex = textEdit.getModel().getEntryCurrentRowIndex("matchcditsubentry");
            switch (fieldNameKey) {
                case "srcbillfieldname": {
                    this.clickSBillFieldName(model, view, fieldNameKey, parentIndex, currSubIndex);
                    break;
                }
                case "targetbillfieldname": {
                    this.clickTBillFieldName(model, view, fieldNameKey, parentIndex, currSubIndex);
                    break;
                }
            }
        }
    }

    private void clickTBillFieldName(IDataModel model, IFormView view, String fieldNameKey, int parentIndex, int currSubIndex) {
        DynamicObject targetBillType = (DynamicObject)model.getValue("targetbilltype", parentIndex);
        if (targetBillType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u76ee\u6807\u5355\u636e\u3002", (String)"MatchRuleEditPluginTargetBillNotInput", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        String srcFieldKey = (String)this.getModel().getValue("srcbillfieldkey", currSubIndex);
        IDataEntityProperty property = null;
        DynamicObject srcBillType = (DynamicObject)model.getValue("srcbilltype", parentIndex);
        if (srcBillType != null) {
            DynamicObject srcBillNumber = srcBillType.getDynamicObject("wfbill");
            String srcFieldKeyTmp = DynamicObjectUtil.getLastKey(srcFieldKey);
            property = MetadataServiceHelper.getDataEntityType((String)srcBillNumber.getString("number")).findProperty(srcFieldKeyTmp);
        }
        DynamicObjectCollection matchCditSubEntry = this.getModel().getEntryEntity("matchcditsubentry");
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject entry : matchCditSubEntry) {
            String fieldKey = entry.getString("targetbillfieldkey");
            list.add(fieldKey);
        }
        List<String> fields = Arrays.asList(srcFieldKey.split("\\."));
        if (property == null) {
            this.clickFieldName(targetBillType, fieldNameKey, currSubIndex, list, new IDataEntityProperty[0]);
        } else if (fields.contains("id") || fields.contains("seq")) {
            this.clickFieldName(targetBillType, fieldNameKey, currSubIndex, list, new IDataEntityProperty[0]);
        } else if (property instanceof MuliLangTextProp) {
            property = new TextProp();
            this.clickFieldName(targetBillType, fieldNameKey, currSubIndex, list, property);
        } else if (property instanceof IntegerProp) {
            property = new IntegerProp();
            this.clickFieldName(targetBillType, fieldNameKey, currSubIndex, list, property);
        } else {
            this.clickFieldName(targetBillType, fieldNameKey, currSubIndex, list, property);
        }
    }

    private void clickSBillFieldName(IDataModel model, IFormView view, String fieldNameKey, int parentIndex, int currSubIndex) {
        DynamicObject srcBillType = (DynamicObject)model.getValue("srcbilltype", parentIndex);
        if (srcBillType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5339\u914d\u5173\u7cfb\u5206\u5f55\u7684\u6e90\u5355\u636e\u3002", (String)"MatchRuleEditPluginSrcBillNotInput", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection matchCditSubEntry = this.getModel().getEntryEntity("matchcditsubentry");
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject entry : matchCditSubEntry) {
            String fieldKey = entry.getString("srcbillfieldkey");
            list.add(fieldKey);
        }
        IDataEntityProperty property = null;
        DynamicObject tagBillType = (DynamicObject)model.getValue("targetbilltype", parentIndex);
        String tagFieldKey = (String)this.getModel().getValue("targetbillfieldkey", currSubIndex);
        if (tagBillType != null) {
            DynamicObject tgtBillNumber = tagBillType.getDynamicObject("wfbill");
            String tagFieldKeyTmp = DynamicObjectUtil.getLastKey(tagFieldKey);
            property = MetadataServiceHelper.getDataEntityType((String)tgtBillNumber.getString("number")).findProperty(tagFieldKeyTmp);
        }
        List<String> fields = Arrays.asList(tagFieldKey.split("\\."));
        if (property == null) {
            this.clickFieldName(srcBillType, fieldNameKey, currSubIndex, list, new IDataEntityProperty[0]);
        } else if (fields.contains("id") || fields.contains("seq")) {
            this.clickFieldName(srcBillType, fieldNameKey, currSubIndex, list, new IDataEntityProperty[0]);
        } else {
            this.clickFieldName(srcBillType, fieldNameKey, currSubIndex, list, property);
        }
    }

    private void clickFieldName(DynamicObject billType, String fieldName, int currSubIndex, List<String> filterFields, IDataEntityProperty ... properties) {
        if (billType == null) {
            return;
        }
        String billIEntity = billType.getDynamicObject("wfbill").getString("number");
        boolean isWf = this.isWf();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billIEntity);
        for (IDataEntityProperty prop : dataEntityType.getAllFields().values()) {
            if (!(prop instanceof MuliLangTextProp) && (!isWf || !(prop instanceof LargeTextProp))) continue;
            IDataEntityType parent = prop.getParent();
            if (billIEntity.equals(parent.getName())) {
                filterFields.add(prop.getName());
                continue;
            }
            filterFields.add(parent.getName() + "." + prop.getName());
        }
        PageShowHelper.showSubEColsTree3Page(this, billIEntity, null, fieldName, currSubIndex, filterFields, properties);
    }

    private boolean isWf() {
        return "A".equals(((DynamicObject)this.getValue("writeofftype")).get("writeofftype"));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "srcbillfieldname": {
                this.callBackFieldName(e, key, "srcbillfieldkey");
                break;
            }
            case "targetbillfieldname": {
                this.callBackFieldName(e, key, "targetbillfieldkey");
                break;
            }
        }
    }

    private void callBackFieldName(ClosedCallBackEvent e, String fieldName, String fieldKey) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        int currSubIndex = Integer.parseInt(this.getPageCache().get("subindex"));
        this.handleValues(dataJson, fieldName, fieldKey, currSubIndex);
    }

    private void handleValues(JSONObject dataJson, String fieldName, String fieldKey, int currSubIndex) {
        IDataModel model = this.getModel();
        int parentIndex = model.getEntryCurrentRowIndex("matchrelateentry");
        DynamicObject parentDy = (DynamicObject)model.getEntryEntity("matchrelateentry").get(parentIndex);
        DynamicObject subDy = (DynamicObject)parentDy.getDynamicObjectCollection("matchcditsubentry").get(currSubIndex);
        subDy.set(fieldName, dataJson.get((Object)"text"));
        subDy.set(fieldKey, dataJson.get((Object)"id"));
        subDy.set("comparison", (Object)"=");
        if ("srcbillfieldkey".equals(fieldKey)) {
            if (this.fieldIsLargeText(parentDy.getDynamicObject("srcbilltype").getString("wfbill.number"), dataJson.get((Object)"id"))) {
                DynamicObject target = parentDy.getDynamicObject("targetbilltype");
                if (target != null && "cal_costrecord_subentity".equals(target.getString("wfbill.number"))) {
                    subDy.set("targetbillfieldname", (Object)NounLang.bizIdAndBizEntryId());
                } else {
                    subDy.set("targetbillfieldname", (Object)NounLang.idAndEntryId());
                }
                subDy.set("emptyequal", (Object)Boolean.FALSE);
                subDy.set("targetbillfieldkey", (Object)"id,entryid");
            } else if ("id,entryid".equals(this.getModel().getValue("targetbillfieldkey", currSubIndex))) {
                subDy.set("targetbillfieldkey", (Object)"");
                subDy.set("targetbillfieldname", (Object)"");
            }
        }
        this.getView().updateView("matchcditsubentry");
    }

    private boolean fieldIsLargeText(String entity, Object object) {
        String propKey = DynamicObjectUtil.getLastKey(object.toString());
        return MetadataServiceHelper.getDataEntityType((String)entity).findProperty(propKey) instanceof LargeTextProp;
    }

    @Override
    protected boolean notPopWriteOffChange(DynamicObject oldValue, DynamicObject newValue) {
        return CommonUtils.judgeWfBillIsSame(oldValue, newValue);
    }
}

