/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.mpscmm.mscommon.writeoff.common.util.WfConnectUtil;
import kd.mpscmm.mscommon.writeoff.form.EntityIdCalculator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SQLExportPlugin
extends AbstractFormPlugin {
    private static final String TARGET_OBJ = "targetobj";
    private static final String TARGET_OBJ_IDS = "targetobjid";
    private static final String TARGET_OBJ_NAME = "targetobjname";
    private static final String BUTTON_EXECUTE = "execute";
    private static final String CODE_EDIT_SQL = "sqlcodeeditap";
    private static final String SELECT_F7_CB = "selectF7CB";
    private static final String E_DATA_INFO = "datainfo";
    private static final String TABLE_NAME = "tablename";
    private static final String TABLE_COLUMN = "tablecolumn";
    private static final String FIELD_KEY = "fieldkey";
    private static final String FIELD_NAME = "fieldname";
    private static final String FORM_PACK_NAME = "mpscmm-mscommon-writeoff";
    private static final String[] bills = new String[]{"msmod_writeofftype", "msmod_scheme", "msmod_matchrule", "msmod_schemeset", "msmod_writeofftype_sort", "msmod_recordfieldgroup", "msmod_rewriterule", "msmod_recordtypegroup", "msmod_billtype"};

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_EXECUTE, TARGET_OBJ_IDS});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "targetobj": {
                this.targetObjChange(e);
                break;
            }
        }
    }

    private void targetObjChange(PropertyChangedArgs e) {
        this.getModel().setValue(TARGET_OBJ_IDS, (Object)"");
        this.getModel().setValue(TARGET_OBJ_NAME, (Object)"");
        this.getModel().deleteEntryData(E_DATA_INFO);
        DynamicObject newBillEntity = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newBillEntity == null) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)newBillEntity.getString("number"));
        this.loadTargetObjInfo(entityType);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjid": {
                this.clickTargetObjIds();
                break;
            }
            case "execute": {
                this.export();
                break;
            }
        }
    }

    private void clickTargetObjIds() {
        String selectList = (String)this.getModel().getValue(TARGET_OBJ_IDS);
        Object[] pkIds = null;
        if (StringUtils.isNotEmpty((String)selectList)) {
            List list = SerializationUtils.fromJsonStringToList((String)selectList, Object.class);
            pkIds = list.toArray();
        }
        ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)this.getTargetObjName(), (boolean)false);
        basedataF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_F7_CB));
        basedataF7Param.setMultiSelect(true);
        if (pkIds != null) {
            basedataF7Param.setSelectedRows(pkIds);
        }
        this.getView().showForm((FormShowParameter)basedataF7Param);
    }

    private void export() {
        this.showCodeText("");
        EntryGrid grid = (EntryGrid)this.getView().getControl(E_DATA_INFO);
        int[] rowIndexs = grid.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7684\u5b57\u6bb5\u3002", (String)"plsSelectNeedField", (String)FORM_PACK_NAME, (Object[])new Object[0]));
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetObjName());
        String dbRouteKey = entityType.getDBRouteKey();
        List<Object> targetObjIds = this.getTargetObjIds();
        Map<String, String> whereInfo = this.getWhereInfo(entityType, targetObjIds);
        Map<String, Set<String>> selectTableAndColumns = this.getSelectTableAndColumns(rowIndexs);
        StringBuilder sqls = new StringBuilder();
        for (Map.Entry<String, Set<String>> tableAndColumn : selectTableAndColumns.entrySet()) {
            String tableName = tableAndColumn.getKey();
            Set<String> columns = tableAndColumn.getValue();
            String whereFiled = whereInfo.get(tableName);
            String sql = this.generateSql(dbRouteKey, tableName, this.collectionToStr(columns, null), whereFiled);
            sqls.append(sql);
        }
        this.showCodeText(sqls.toString());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"codeGenerateSuccess", (String)FORM_PACK_NAME, (Object[])new Object[0]));
    }

    private Map<String, String> getWhereInfo(MainEntityType entityType, List<Object> targetObjIds) {
        HashMap<String, String> tablePkField = new HashMap<String, String>(16);
        Map<String, List<Object>> prepareEntryIds = new EntityIdCalculator(entityType, targetObjIds).handleIdInfo();
        Map entities = entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            if (entryEntityType instanceof LinkEntryType || entryEntityType.getAlias() == null) continue;
            String whereInfo = null;
            if (entryEntityType instanceof EntryType) {
                ISimpleProperty entryPkProp = entryEntityType.getPrimaryKey();
                List<Object> entryIds = prepareEntryIds.get(entryEntityType.getName());
                whereInfo = entryPkProp.getAlias() + " in (" + this.collectionToStr(entryIds, entryPkProp.getPropertyType()) + ")";
            } else {
                ISimpleProperty primaryKey = entityType.getPrimaryKey();
                whereInfo = primaryKey.getAlias() + " in (" + this.collectionToStr(targetObjIds, primaryKey.getPropertyType()) + ")";
            }
            String tableName = entryEntityType.getAlias().toUpperCase();
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableGroup = prop.getTableGroup();
                String grouptableName = tableName;
                if (StringUtils.isNotEmpty((String)tableGroup)) {
                    grouptableName = grouptableName + "_" + tableGroup;
                }
                tablePkField.put(grouptableName, whereInfo);
            }
            tablePkField.put(tableName + "_L", whereInfo);
        }
        return tablePkField;
    }

    private String generateSql(String dbRouteKey, String tableName, String selectField, String whereField) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)dbRouteKey), tableName, selectField, whereField, "", "");
        }
        catch (Exception var48) {
            throw new KDBizException((Throwable)var48, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", var48.getMessage())});
        }
        String sql = (String)map.get("sql");
        Object xml = map.get("xml");
        if (xml != null) {
            HashMap longTextDataFile = (HashMap)xml;
            for (Map.Entry entry : longTextDataFile.entrySet()) {
                StringWriter sw = (StringWriter)entry.getValue();
                byte[] barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                try {
                    ByteArrayInputStream ins1 = new ByteArrayInputStream(barray);
                    Throwable throwable = null;
                    try {
                        this.exportFile(ins1, (String)entry.getKey());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ins1 == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)ins1).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)ins1).close();
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        }
        return sql.replaceAll("0E-10", "0");
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }

    private void showCodeText(String sql) {
        this.showCodeEdit(this.getView(), sql, CODE_EDIT_SQL);
    }

    private void showCodeEdit(IFormView view, String sql, String codeEditKey) {
        CodeEdit codeSQLshow = (CodeEdit)view.getControl(codeEditKey);
        if (codeSQLshow == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63a7\u4ef6\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ControlNotExist", (String)FORM_PACK_NAME, (Object[])new Object[0]), codeEditKey));
        }
        String sqlContent = sql;
        if (sql.length() > 100000) {
            String mes = ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad\u3002", (String)"KSQLExpPlugin_3", (String)FORM_PACK_NAME, (Object[])new Object[0]);
            sqlContent = WfConnectUtil.strConnect(mes, System.lineSeparator(), sql.substring(0, 100000));
        }
        codeSQLshow.setText(sqlContent);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "selectF7CB": {
                this.selectF7CloseCallBack((ListSelectedRowCollection)returnData);
                break;
            }
        }
    }

    private void selectF7CloseCallBack(ListSelectedRowCollection rows) {
        IDataModel model = this.getModel();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>(rows.size());
        ArrayList<String> nameValues = new ArrayList<String>(rows.size());
        for (ListSelectedRow row : rows) {
            pkValues.add(row.getPrimaryKeyValue());
            String name = row.getName();
            if (StringUtils.isEmpty((String)name)) {
                name = row.getBillNo();
            }
            nameValues.add(name);
        }
        model.setValue(TARGET_OBJ_IDS, (Object)SerializationUtils.toJsonString(pkValues));
        model.setValue(TARGET_OBJ_NAME, (Object)SerializationUtils.toJsonString(nameValues));
    }

    private Map<String, Set<String>> getSelectTableAndColumns(int[] rowIndexs) {
        LinkedHashMap<String, Set<String>> tablesName = new LinkedHashMap<String, Set<String>>(16);
        for (int rowIndex : rowIndexs) {
            String tableColumn = (String)this.getModel().getValue(TABLE_COLUMN, rowIndex);
            String tableName = (String)this.getModel().getValue(TABLE_NAME, rowIndex);
            LinkedHashSet<String> columns = (LinkedHashSet<String>)tablesName.get(tableName);
            if (columns == null) {
                columns = new LinkedHashSet<String>(16);
                tablesName.put(tableName, columns);
            }
            columns.add(tableColumn);
        }
        return tablesName;
    }

    private void loadTargetObjInfo(MainEntityType entityType) {
        Map entities = entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            if (entryEntityType instanceof LinkEntryType || entryEntityType.getAlias() == null) continue;
            String tableName = entryEntityType.getAlias().toUpperCase();
            HashSet<String> groups = new HashSet<String>(16);
            HashSet<String> multiLangField = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableColumn = prop.getAlias();
                if (StringUtils.isEmpty((String)tableColumn)) continue;
                if (prop instanceof MuliLangTextProp) {
                    multiLangField.add(prop.getAlias());
                    if (!((MuliLangTextProp)prop).isGL()) continue;
                }
                String tableGroup = prop.getTableGroup();
                String grouptableName = tableName;
                if (StringUtils.isNotEmpty((String)tableGroup)) {
                    grouptableName = grouptableName + "_" + tableGroup;
                    groups.add(grouptableName);
                }
                this.fillDataInfo((IDataEntityProperty)prop, grouptableName);
            }
            for (String group : groups) {
                this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), group);
            }
            if (entryEntityType instanceof EntryType) {
                ISimpleProperty mainPkId = entryEntityType.getParent().getPrimaryKey();
                this.fillDataInfo((IDataEntityProperty)mainPkId, tableName);
                for (String group : groups) {
                    this.fillDataInfo((IDataEntityProperty)mainPkId, group);
                }
            }
            if (multiLangField.isEmpty()) continue;
            String multiLangTable = tableName + "_L";
            this.fillDataInfo("FPKID", "FPKID", "FPKID", multiLangTable);
            this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), multiLangTable);
            this.fillDataInfo("FLOCALEID", "FLOCALEID", "FLOCALEID", multiLangTable);
            for (String multiLangF : multiLangField) {
                this.fillDataInfo(multiLangF, multiLangF, multiLangF, multiLangTable);
            }
        }
    }

    private void fillDataInfo(IDataEntityProperty prop, String tableName) {
        String tableColumn = prop.getAlias();
        LocaleString displayName = prop.getDisplayName();
        String fieldName = displayName != null ? displayName.getLocaleValue() : prop.getName();
        this.fillDataInfo(fieldName, prop.getName(), tableColumn, tableName);
    }

    private void fillDataInfo(String fieldName, String fieldKey, String tableColumn, String tableName) {
        int rowIndex = this.getModel().createNewEntryRow(E_DATA_INFO);
        this.getModel().setValue(FIELD_NAME, (Object)fieldName, rowIndex);
        this.getModel().setValue(FIELD_KEY, (Object)fieldKey, rowIndex);
        this.getModel().setValue(TABLE_COLUMN, (Object)tableColumn.toUpperCase(), rowIndex);
        this.getModel().setValue(TABLE_NAME, (Object)tableName, rowIndex);
    }

    private String getTargetObjName() {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue(TARGET_OBJ);
        if (targetObj == null) {
            throw new KDBizException("...");
        }
        String entityName = targetObj.getString("number");
        return entityName;
    }

    private List<Object> getTargetObjIds() {
        String selectList = (String)this.getModel().getValue(TARGET_OBJ_IDS);
        if (StringUtils.isNotEmpty((String)selectList)) {
            return SerializationUtils.fromJsonStringToList((String)selectList, Object.class);
        }
        return new ArrayList<Object>();
    }

    private String collectionToStr(Collection<?> list, Class<?> clazz) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (Object object : list) {
            if (clazz != null && clazz.equals(String.class)) {
                str.append('\'');
                str.append(object);
                str.append('\'');
            } else {
                str.append(object);
            }
            str.append(',');
        }
        String string = str.toString();
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }
}

