/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import org.apache.commons.lang.StringUtils;

public class WfFieldConfEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "wfbill");
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("ispreset", (Object)Boolean.FALSE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"fieldname"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"fieldkey"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object oldValue = changeSet.getOldValue();
        Object newValue = changeSet.getNewValue();
        switch (proName) {
            case "writeofftype": {
                this.writeoffTypeChanged(oldValue);
                break;
            }
            case "wfbill": {
                this.buildBillFields((DynamicObject)newValue);
                this.getView().setEnable(Boolean.FALSE, new String[]{"fieldname"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"fieldkey"});
                break;
            }
        }
    }

    private void buildBillFields(DynamicObject newValue) {
        DynamicObject wfBill = newValue;
        if (wfBill == null) {
            return;
        }
        String entity = wfBill.getDynamicObject("wfbill").getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        this.loadTargetObjInfo1(dataEntityType);
    }

    private void writeoffTypeChanged(Object oldValue) {
        if (oldValue != null) {
            Long pkValue = (Long)((DynamicObject)oldValue).getPkValue();
            IPageCache pagecache = this.getPageCache();
            pagecache.put("WfFieldConfConst_writeofftypeconfirmCB", String.valueOf(pkValue));
            String isUnCditMtConfmMsg = ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u5207\u6362\u5c06\u6e05\u9664\u9875\u9762\u5df2\u7ef4\u62a4\u5206\u5f55\u7684\u6240\u6709\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"MatchRuleEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("WfFieldConfConst_writeofftypeconfirmCB", (IFormPlugin)this);
            this.getView().showConfirm(isUnCditMtConfmMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, "");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "wfbill": {
                this.wfBillTypeF7Select(showParameter, e);
                break;
            }
        }
    }

    private void wfBillTypeF7Select(ListShowParameter showParameter, BeforeF7SelectEvent e) {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wfType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u9500\u7c7b\u522b\u3002", (String)"WfRecordGroupEditPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("writeofftypenumber", "=", (Object)wfType.getString("number"));
        filter.and("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public void confirmCallBack(MessageBoxClosedEvent msgBoxClosedEvent) {
        super.confirmCallBack(msgBoxClosedEvent);
        String callBackId = msgBoxClosedEvent.getCallBackId();
        MessageBoxResult result = msgBoxClosedEvent.getResult();
        switch (callBackId) {
            case "WfFieldConfConst_writeofftypeconfirmCB": {
                this.confirmWriteoffTypeCB(result);
                break;
            }
        }
    }

    private void confirmWriteoffTypeCB(MessageBoxResult result) {
        if (result.equals((Object)MessageBoxResult.Yes)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("subentryentity");
        } else {
            String oldValue = this.getPageCache().get("WfFieldConfConst_writeofftypeconfirmCB");
            this.getModel().beginInit();
            this.getModel().setValue("writeofftype", (Object)oldValue);
            this.getView().updateView("writeofftype");
            this.getModel().endInit();
        }
    }

    private void loadTargetObjInfo1(MainEntityType entityType) {
        for (EntityType entity : entityType.getAllEntities().values()) {
            if (entity instanceof LinkEntryType) continue;
            DataEntityPropertyCollection properties = entity.getProperties();
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableColumn = prop.getAlias();
                boolean empty = StringUtils.isEmpty((String)tableColumn);
                boolean isPk = prop instanceof LongProp && (((LongProp)prop).isRefId() || ((LongProp)prop).isPrimaryKey());
                boolean isSeq = "seq".equals(property.getName());
                if (empty || isPk || isSeq) continue;
                this.fillDataInfo(property);
            }
        }
    }

    private void loadTargetObjInfo(MainEntityType entityType) {
        Map entities = entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            if (entryEntityType instanceof LinkEntryType || entryEntityType.getAlias() == null) continue;
            String tableName = entryEntityType.getAlias().toUpperCase();
            HashSet<String> groups = new HashSet<String>(16);
            HashSet<String> multiLangField = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableColumn = prop.getAlias();
                if (StringUtils.isEmpty((String)tableColumn)) continue;
                if (prop instanceof MuliLangTextProp) {
                    multiLangField.add(prop.getAlias());
                    continue;
                }
                String tableGroup = prop.getTableGroup();
                String grouptableName = tableName;
                if (StringUtils.isNotEmpty((String)tableGroup)) {
                    grouptableName = grouptableName + "_" + tableGroup;
                    groups.add(grouptableName);
                }
                this.fillDataInfo((IDataEntityProperty)prop, grouptableName);
            }
            for (String group : groups) {
                this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), group);
            }
            if (entryEntityType instanceof EntryType) {
                ISimpleProperty mainPkId = entryEntityType.getParent().getPrimaryKey();
                this.fillDataInfo((IDataEntityProperty)mainPkId, tableName);
                for (String group : groups) {
                    this.fillDataInfo((IDataEntityProperty)mainPkId, group);
                }
            }
            if (multiLangField.isEmpty()) continue;
            String multiLangTable = tableName + "_L";
            this.fillDataInfo("FPKID", "FPKID", "FPKID", multiLangTable);
            this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), multiLangTable);
            this.fillDataInfo("FLOCALEID", "FLOCALEID", "FLOCALEID", multiLangTable);
            for (String multiLangF : multiLangField) {
                this.fillDataInfo(multiLangF, multiLangF, multiLangF, multiLangTable);
            }
        }
    }

    private void fillDataInfo(IDataEntityProperty prop, String tableName) {
        String tableColumn = prop.getAlias();
        LocaleString displayName = prop.getDisplayName();
        String fieldName = displayName != null ? displayName.getLocaleValue() : prop.getName();
        this.fillDataInfo(fieldName, prop.getName(), tableColumn, tableName);
    }

    private void fillDataInfo(IDataEntityProperty prop) {
        String tableColumn = prop.getAlias();
        LocaleString displayName = prop.getDisplayName();
        String fieldName = displayName != null ? displayName.getLocaleValue() : prop.getName();
        this.fillDataInfo(fieldName, prop.getName(), tableColumn, null);
    }

    private void fillDataInfo(String fieldName, String fieldKey, String tableColumn, String tableName) {
        int rowIndex = this.getModel().createNewEntryRow("subentryentity");
        this.getModel().setValue("fieldname", (Object)fieldName, rowIndex);
        this.getModel().setValue("fieldkey", (Object)fieldKey, rowIndex);
    }
}

