/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class WfRecordGroupListPlugin
extends AbstractListPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject date : pageData) {
            String groupField = date.getString("groupfield");
            DynamicObject wfType = date.getDynamicObject("wftype");
            Map<String, LocaleString> fieldMapping = this.getFieldMapping(wfType);
            String[] fields = groupField.split(",");
            StringBuilder displayName = new StringBuilder();
            for (String field : fields) {
                if (StringUtils.isEmpty((CharSequence)field)) continue;
                LocaleString localeString = fieldMapping.get(field);
                displayName.append(localeString).append(',');
            }
            String substring = displayName.substring(0, displayName.length() - 1);
            date.set("groupfield", (Object)substring);
        }
    }

    private Map<String, LocaleString> getFieldMapping(DynamicObject wfType) {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
        if (wfType == null) {
            return map;
        }
        DynamicObject wfRecord = wfType.getDynamicObject("writeoffrecordbill");
        if (wfRecord == null) {
            return map;
        }
        String number = wfRecord.getString("number");
        if (number == null) {
            return map;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        Collection entityTypes = dataEntityType.getAllFields().values();
        for (IDataEntityProperty entityType : entityTypes) {
            map.put(entityType.getName(), entityType.getDisplayName());
        }
        return map;
    }

    private void setCombItems() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("wftype");
        DynamicObject wfRecord = wfType.getDynamicObject("writeoffrecordbill");
        String number = wfRecord.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        Collection entityTypes = dataEntityType.getAllFields().values();
        ArrayList<ComboItem> opItems = new ArrayList<ComboItem>(32);
        for (IDataEntityProperty entityType : entityTypes) {
            String name = entityType.getName();
            opItems.add(new ComboItem(entityType.getDisplayName(), name));
        }
        ComboEdit srcBillType = (ComboEdit)this.getView().getControl("groupfield");
        srcBillType.setComboItems(opItems);
    }
}

