/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;

public class WriteOffGuideEdit
extends AbstractWfFormPlugin
implements RowClickEventListener,
SearchClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl("subentryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.initContainer();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initContainer();
        this.loadData(new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
    }

    private void initContainer() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setTitle(MetadataServiceHelper.getDataEntityType((String)"msmod_writeofftype").getDisplayName());
        filterContainer.setBillFormId("msmod_writeofftype");
        filterContainer.addSearchClickListener((SearchClickListener)this);
    }

    public void click(SearchClickEvent e) {
        ArrayList filters = new ArrayList(16);
        filters.addAll(e.getFilterParameter().getQFilters());
        filters.addAll(e.getFastQFilters());
        if (filters.isEmpty()) {
            this.loadData(new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        } else {
            this.loadData(filters.toArray(new QFilter[filters.size()]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "newwftype": {
                this.newWriteOffType();
                break;
            }
            case "addbasedata": {
                this.newBaseData();
                break;
            }
            case "deletebasedata": {
                this.doBaseDataOP("delete");
                break;
            }
            case "enablebasedata": {
                this.doBaseDataOP("enable");
                break;
            }
            case "disablebasedata": {
                this.doBaseDataOP("disable");
                break;
            }
            case "refresh": {
                this.refresh();
            }
        }
    }

    private void newWriteOffType() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("msmod_writeofftype");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void newBaseData() {
        ComboProp prop = (ComboProp)this.getModel().getDataEntityType().findProperty("carddatatype");
        List comboItems = prop.getComboItems();
        ArrayList combitems = new ArrayList(comboItems.size());
        for (ValueMapItem item : comboItems) {
            HashMap<String, String> values = new HashMap<String, String>(3);
            values.put("ImageKey", item.getImageKey());
            values.put("Name", item.getName().getLocaleValue());
            values.put("Value", item.getValue());
            combitems.add(values);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", combitems);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newbasedata"));
        this.getView().showForm(showParameter);
    }

    private void doBaseDataOP(String opDisable) {
    }

    private void refresh() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
    }

    public void loadData(QFilter[] wftypeFilter) {
        this.getModel().deleteEntryData("wftypeentry");
        Map writeOffTypes = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])wftypeFilter);
        if (writeOffTypes.isEmpty()) {
            return;
        }
        Set<Object> wfTypeIds = writeOffTypes.keySet();
        Map<Long, List<DynamicObject>> typeToSchemes = this.getTypeToDatas(wfTypeIds, "msmod_scheme", "writeofftype");
        Map<Long, List<DynamicObject>> typeToMatchRule = this.getTypeToDatas(wfTypeIds, "msmod_matchrule", "writeofftype");
        Map<Long, List<DynamicObject>> typeToRewrites = this.getTypeToDatas(wfTypeIds, "msmod_rewriterule", "writeofftype");
        Map<Long, List<DynamicObject>> typeToShareRules = this.getTypeToDatas(wfTypeIds, "msmod_sharerule", "writeofftype");
        Map<Long, List<DynamicObject>> typeToSchemeSet = this.getTypeToDatas(wfTypeIds, "msmod_schemeset", "writeofftype");
        Map<Long, List<DynamicObject>> typeToRecordGroup = this.getTypeToDatas(wfTypeIds, "msmod_recordfieldgroup", "wftype");
        this.getModel().batchCreateNewEntryRow("wftypeentry", writeOffTypes.size());
        int i = 0;
        for (DynamicObject writeOffType : writeOffTypes.values()) {
            long wfTypeId = writeOffType.getLong("id");
            this.getModel().setValue("writeofftype", (Object)writeOffType, i);
            DynamicObjectCollection subEntries = (DynamicObjectCollection)this.getModel().getValue("subentryentity", i);
            subEntries.clear();
            this.fillsubEntryDatas(typeToSchemes, wfTypeId, subEntries);
            this.fillsubEntryDatas(typeToMatchRule, wfTypeId, subEntries);
            this.fillsubEntryDatas(typeToRewrites, wfTypeId, subEntries);
            this.fillsubEntryDatas(typeToShareRules, wfTypeId, subEntries);
            this.fillsubEntryDatas(typeToSchemeSet, wfTypeId, subEntries);
            this.fillsubEntryDatas(typeToRecordGroup, wfTypeId, subEntries);
            ++i;
        }
        this.getView().updateView("wftypeentry");
    }

    private Map<Long, List<DynamicObject>> getTypeToDatas(Collection<Object> writeTypeIds, String dataEntity, String writeOffKey) {
        Map reWriteRules = BusinessDataServiceHelper.loadFromCache((String)dataEntity, (QFilter[])new QFilter(writeOffKey, "in", writeTypeIds).toArray());
        Map<Long, List<DynamicObject>> typeToRewrites = this.sortBaseDataByWriteOffType(reWriteRules, writeOffKey);
        return typeToRewrites;
    }

    private Map<Long, List<DynamicObject>> sortBaseDataByWriteOffType(Map<Object, DynamicObject> matchRules, String writeOffKey) {
        HashMap<Long, List<DynamicObject>> typeToMatchRule = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject matchRule : matchRules.values()) {
            DynamicObject wfTypeObj = matchRule.getDynamicObject(writeOffKey);
            if (wfTypeObj == null) continue;
            MapUtils.mapGetListValue(typeToMatchRule, wfTypeObj.getLong("id")).add(matchRule);
        }
        return typeToMatchRule;
    }

    private void fillsubEntryDatas(Map<Long, List<DynamicObject>> typeToDatas, long wfTypeId, DynamicObjectCollection subEntries) {
        List<DynamicObject> datas = typeToDatas.get(wfTypeId);
        if (datas != null) {
            for (DynamicObject data : datas) {
                String dataEntity = data.getDataEntityType().getName();
                DynamicObject addNew = subEntries.addNew();
                addNew.set("carddatatype", (Object)dataEntity);
                addNew.set("dataid", (Object)data.getLong("id"));
                addNew.set(dataEntity, (Object)data);
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        String entity = (String)this.getValue("carddatatype", row);
        Long dataId = (Long)this.getValue("dataid", row);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)dataId);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String returnData = (String)e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return;
        }
        Map valByConditions = (Map)SerializationUtils.fromJsonString((String)((String)e.getReturnData()), Map.class);
        String entity = (String)valByConditions.get("expression");
        int i = this.getModel().getEntryCurrentRowIndex("wftypeentry");
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype", i);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("wftypeid", wfType.getPkValue());
        this.getView().showForm((FormShowParameter)showParameter);
        super.closedCallBack(e);
    }
}

