/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.manual;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.WfManualUtil;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;
import org.apache.commons.collections.CollectionUtils;

public class WfManualDataReader {
    private String entityNumber;
    private String wfMainField;
    private String mainEntryId;
    private String wfCfgFilter;
    private String wfCfgCFilter;
    private List<String> wfCfgFilters = new ArrayList<String>(16);
    private String curEntryKey;
    private String mainType;
    private Set<String> formulafields = new HashSet<String>(8);
    private List<QFilter> billFilters = new ArrayList<QFilter>(16);
    private Set<Object> entryIds = null;
    private Set<Object> billIds = null;
    private String mainFieldExpression;
    private String mainEntryKey;
    private IWriteOffMainFieldCalPlugin mainFieldCal;

    public WfManualDataReader(String entityNumber, String wfMainField, String wfCfgFilter, String wfCfgCFilter, String curEntryKey, String writeOffTypeEntyId) {
        this.entityNumber = entityNumber;
        this.wfCfgFilter = wfCfgFilter;
        this.wfCfgCFilter = wfCfgCFilter;
        this.curEntryKey = curEntryKey;
        if (StringUtils.isNotEmpty((CharSequence)wfMainField)) {
            String[] split = wfMainField.split("@@");
            this.wfMainField = split[0];
            this.mainType = split[1];
            if ("C".equals(this.mainType)) {
                this.mainFieldCal = WfPluginExtFactory.getWfMainFiledPlugin(split[0], Long.valueOf(writeOffTypeEntyId));
            }
        }
        this.mainEntryId = this.getEntryKey();
        this.mainEntryKey = this.getEntryName();
        this.addFilter(wfCfgFilter, wfCfgCFilter);
    }

    private void addFilter(String ... filters) {
        for (String filter : filters) {
            if (!StringUtils.isNotEmpty((CharSequence)filter)) continue;
            this.wfCfgFilters.add(filter);
        }
    }

    private String getEntryKey() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        String mainEntry = "";
        if ("B".equals(this.mainType)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)this.wfMainField, CRCondition.class);
            String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
            IDataEntityProperty property = dataEntityType.findProperty(columns[0]);
            String entryName = property.getParent().getName();
            mainEntry = !dataEntityType.getName().equals(entryName) ? entryName + ".id" : "id";
            List<String> fields = Arrays.asList(columns);
            this.formulafields.addAll(fields);
            this.mainFieldExpression = condition.getExpression();
        } else if ("C".equals(this.mainType)) {
            String entry = this.mainFieldCal.mainFieldEntry();
            mainEntry = this.entityNumber.equals(entry) ? "id" : entry + ".id";
            Set<String> calFields = WfManualUtil.changeField(this.mainFieldCal.calNeedFields());
            this.formulafields.addAll(calFields);
        } else if ("A".equals(this.mainType)) {
            mainEntry = this.getEntryKey(dataEntityType, this.wfMainField);
        }
        return mainEntry;
    }

    public TableValueSetter createTableValueSetter(List<String> selectFields, Map<String, String> billFormFieldMap, Map<String, String> wfFieldAssitFieldMap) {
        return this.createTableValueSetter(selectFields, billFormFieldMap, wfFieldAssitFieldMap, 10000);
    }

    public TableValueSetter createTableValueSetter(List<String> selectFields, Map<String, String> billFormFieldMap, Map<String, String> wfFieldAssitFieldMap, int maxShowSize) {
        TableValueSetter tableValueSetter;
        selectFields.remove("billid");
        selectFields.remove("billentryid");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        this.removeOtherField(selectFields, dataEntityType);
        String selectFieldStr = this.getSelectFieldStr(this.entityNumber, selectFields);
        if (StringUtils.isEmpty((CharSequence)selectFieldStr)) {
            return new TableValueSetter(new String[0]);
        }
        String orderFields = null;
        MainEntityType dataEntity = MetadataServiceHelper.getDataEntityType((String)this.entityNumber);
        if (dataEntity.getProperties().containsKey((Object)"bookdate")) {
            orderFields = "bookdate";
        }
        try (DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityNumber, (String)selectFieldStr, (QFilter[])this.getFilters(), (String)orderFields);){
            this.filterHighCondition(orderFields, maxShowSize);
            tableValueSetter = this.getTableValueSetter(selectFields, billDs, billFormFieldMap, wfFieldAssitFieldMap, maxShowSize);
        }
        return tableValueSetter;
    }

    private void removeOtherField(List<String> selectFields, MainEntityType dataEntityType) {
        Iterator<String> iterator = selectFields.iterator();
        while (iterator.hasNext()) {
            String field = iterator.next();
            IDataEntityProperty property = dataEntityType.findProperty(field);
            IDataEntityType parent = property.getParent();
            String entryName = this.mainEntryKey;
            boolean isRemoveField = !this.entityNumber.equals(parent.getName()) && (this.entityNumber.equals(entryName) || !entryName.equals(parent.getName()));
            String alias = property.getAlias();
            if (!(isRemoveField = isRemoveField || StringUtils.isEmpty((CharSequence)alias))) continue;
            iterator.remove();
        }
    }

    private TableValueSetter getTableValueSetter(List<String> formFields, DataSet billDs, Map<String, String> billFormFieldMap, Map<String, String> wfFieldAssitField, int maxSize) {
        boolean isEntryIdsNull = this.entryIds == null;
        boolean isBillIdsNull = this.billIds == null;
        ArrayList<String> fields = new ArrayList<String>(16);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : formFields) {
            vs.addField(billFormFieldMap.get(string), new Object[0]);
        }
        fields.addAll(formFields);
        ArrayList<String> formWfFields = new ArrayList<String>(wfFieldAssitField.keySet());
        fields.addAll(formWfFields);
        for (String item : formWfFields) {
            vs.addField(wfFieldAssitField.get(item), new Object[0]);
        }
        String string = billFormFieldMap.get("curwfdata");
        if (string != null) {
            vs.addField(string, new Object[0]);
            fields.add("curwfdata");
        }
        DataSet select = billDs.copy();
        ArrayList<Object> billIdList = new ArrayList<Object>(16);
        for (Row row : select) {
            Object billId = row.get("billid");
            billIdList.add(billId);
        }
        WFSnapshotContext snapShootHolder = new WFSnapshotContext(null);
        snapShootHolder.loadSnapShootMap(billIdList, this.entityNumber);
        int valuesSizes = fields.size();
        String suffix = this.curEntryKey.replace("entry", "");
        String entryBillId = "billid" + suffix;
        String entryBillEntryId = "billentryid" + suffix;
        vs.addField(entryBillId, new Object[0]);
        vs.addField(entryBillEntryId, new Object[0]);
        valuesSizes += 2;
        String mainField = DynamicObjectUtil.getLastKey(this.wfMainField);
        for (Row row : billDs) {
            if (vs.getCount() >= maxSize) {
                return vs;
            }
            Long billId = row.getLong("billid");
            Long billEntryId = row.getLong("billentryid");
            if (!isBillIdsNull && !this.billIds.contains(billId) || !isEntryIdsNull && !this.entryIds.contains(billEntryId)) continue;
            Object[] values = new Object[valuesSizes];
            boolean isSkip = false;
            for (int i = 0; i < fields.size(); ++i) {
                String field = (String)fields.get(i);
                if ("C".equals(this.mainType) && StringUtils.equals((CharSequence)"curwfdata", (CharSequence)field) || StringUtils.equals((CharSequence)mainField, (CharSequence)field)) {
                    BigDecimal snapShotValue = snapShootHolder.getSnapShotValue(this.getSnapFieldKey(), billId, this.entityNumber, billEntryId, this.getEntrySignName());
                    BigDecimal bigDecimal = this.mainAsstFieldSetVal(fields, row, values, i, snapShotValue);
                    if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) continue;
                    isSkip = true;
                    break;
                }
                this.commonFieldSetVal(fields, row, values, i);
            }
            if (isSkip) continue;
            values[fields.size()] = billId;
            values[fields.size() + 1] = billEntryId;
            vs.addRow(values);
        }
        return vs;
    }

    private String getSnapFieldKey() {
        String snapFieldKey = this.mainFieldCal == null ? this.wfMainField : this.mainFieldCal.getClass().getName();
        return snapFieldKey;
    }

    private void commonFieldSetVal(List<String> fields, Row row, Object[] values, int i) {
        if (fields.get(i).endsWith("curwfdata")) {
            BigDecimal result = this.getFormulaValue(row);
            values[i] = result;
        } else {
            values[i] = row.get(fields.get(i));
        }
    }

    private BigDecimal mainAsstFieldSetVal(List<String> fields, Row row, Object[] values, int i, BigDecimal snapShotValue) {
        String mainFiled = fields.get(i);
        BigDecimal result = BigDecimal.ZERO;
        if ("curwfdata".equals(mainFiled)) {
            BigDecimal formulaValue = this.getFormulaValue(row);
            result = formulaValue == null ? BigDecimal.ZERO : formulaValue.subtract(snapShotValue);
        } else {
            BigDecimal bigDecimal = row.getBigDecimal(fields.get(i));
            if (bigDecimal != null) {
                result = bigDecimal.subtract(snapShotValue);
            }
        }
        values[i] = result;
        return result;
    }

    private BigDecimal getFormulaValue(Row row) {
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        for (String field : this.formulafields) {
            args.put(field, row.get(field));
        }
        if ("C".equals(this.mainType)) {
            return this.mainFieldCal.wfManualmainFieldCal(row);
        }
        if ("B".equals(this.mainType)) {
            return (BigDecimal)FormulaEngine.execExcelFormula((String)this.mainFieldExpression, args);
        }
        return null;
    }

    private void filterHighCondition(String orderFields, int maxShowSize) {
        DynamicObject[] billDycs;
        if (this.wfCfgFilters.isEmpty()) {
            return;
        }
        ArrayList<String> expressionList = new ArrayList<String>(16);
        ArrayList<String> fields = new ArrayList<String>(16);
        for (String filter : this.wfCfgFilters) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filter, CRCondition.class);
            String expression = condition.getExpression();
            if (!StringUtils.isNotEmpty((CharSequence)expression)) continue;
            expressionList.add(expression);
            fields.addAll(this.getFields(expression));
        }
        if (CollectionUtils.isEmpty(expressionList)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        QFilter[] billfs = this.getFilters();
        String entryKey = this.mainEntryId;
        boolean isBillHead = dataEntityType.getPrimaryKey().getName().equals(entryKey);
        if (!isBillHead) {
            fields.add(entryKey);
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)this.entityNumber, (QFilter[])billfs, (String)orderFields, (int)(maxShowSize * 2));
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)this.entityNumber, fields);
        for (DynamicObject billDyc : billDycs = BusinessDataReader.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)subDataEntityType, (Boolean)Boolean.TRUE)) {
            if (isBillHead) {
                boolean checkPass;
                if (this.billIds == null) {
                    this.billIds = new HashSet<Object>(16);
                }
                if (!(checkPass = this.checkHighConditions(dataEntityType.getName(), (MainEntityType)subDataEntityType, expressionList, billDyc))) continue;
                this.billIds.add(billDyc.getPkValue());
                continue;
            }
            if (this.entryIds == null) {
                this.entryIds = new HashSet<Object>(16);
            }
            entryKey = entryKey.replace(".id", "");
            for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection(entryKey)) {
                boolean checkPass = this.checkHighConditions(entryKey, (MainEntityType)subDataEntityType, expressionList, entryDyc);
                if (!checkPass) continue;
                this.entryIds.add(entryDyc.getPkValue());
            }
        }
    }

    private List<String> getFields(String expression) {
        String[] varFields = FormulaEngine.extractVariables((String)expression);
        List<String> fields = Arrays.asList(varFields);
        return new ArrayList<String>(fields);
    }

    private String getEntryKey(MainEntityType dataEntityType, String wfMainField) {
        int lastPointIndex;
        String entryId = null;
        entryId = wfMainField != null ? ((lastPointIndex = wfMainField.lastIndexOf(".")) == -1 ? dataEntityType.getPrimaryKey().getName() : wfMainField.substring(0, lastPointIndex) + ".id") : dataEntityType.getPrimaryKey().getName();
        return entryId;
    }

    private String getSelectFieldStr(String entityNumber, List<String> formFields) {
        if (formFields.size() < 1) {
            return "";
        }
        HashSet<String> set = new HashSet<String>(16);
        set.addAll(formFields);
        set.addAll(this.formulafields);
        StringBuilder selectFieldSb = WfManualUtil.addFormFields(set, entityNumber);
        selectFieldSb.append("id as ");
        selectFieldSb.append("billid");
        if (StringUtils.isNotEmpty((CharSequence)this.mainEntryId)) {
            selectFieldSb.append(",");
            String entryIdKey = this.mainEntryId;
            selectFieldSb.append(entryIdKey);
            selectFieldSb.append(" as ");
            selectFieldSb.append("billentryid");
        }
        return selectFieldSb.toString();
    }

    private String getEntryName() {
        String[] spit = this.mainEntryId.split("\\.");
        String entryName = spit[0];
        return "id".equals(entryName) ? this.entityNumber : entryName;
    }

    private String getEntrySignName() {
        String[] spit = this.mainEntryId.split("\\.");
        String entryName = spit[0];
        return "id".equals(entryName) ? " " : entryName;
    }

    private QFilter[] getFilters() {
        QFilter[] billfs = null;
        if (this.billFilters.size() > 0) {
            billfs = this.billFilters.toArray(new QFilter[0]);
        }
        return billfs;
    }

    public void setBillFilters(List<QFilter> billFilters) {
        this.billFilters = billFilters;
    }

    private boolean checkHighCondition(String entry, MainEntityType type, String preCondition, DynamicObject dynamicObject) {
        RowDataModel rowDataModel = new RowDataModel(entry, type);
        ExpressionParameter preConditionParam = new ExpressionParameter(preCondition, rowDataModel);
        preConditionParam.setFcunLib(FunctionManage.get());
        preConditionParam.setActiveRow((Object)dynamicObject);
        return (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)preConditionParam);
    }

    private boolean checkHighConditions(String entry, MainEntityType type, List<String> preConditions, DynamicObject dynamicObject) {
        for (String preConditon : preConditions) {
            if (this.checkHighCondition(entry, type, preConditon, dynamicObject)) continue;
            return false;
        }
        return true;
    }

    public String getMainEntryKey() {
        return this.mainEntryKey;
    }

    public void setMainEntryKey(String mainEntryKey) {
        this.mainEntryKey = mainEntryKey;
    }

    public IWriteOffMainFieldCalPlugin getMainFieldCal() {
        return this.mainFieldCal;
    }

    public void setMainFieldCal(IWriteOffMainFieldCalPlugin mainFieldCal) {
        this.mainFieldCal = mainFieldCal;
    }

    public String getWfCfgFilter() {
        return this.wfCfgFilter;
    }

    public void setWfCfgFilter(String wfCfgFilter) {
        this.wfCfgFilter = wfCfgFilter;
    }

    public String getWfCfgCFilter() {
        return this.wfCfgCFilter;
    }

    public void setWfCfgCFilter(String wfCfgCFilter) {
        this.wfCfgCFilter = wfCfgCFilter;
    }
}

