/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.manual;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.isv.ISVService;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.WfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.consts.WfManualConst;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.FilterGridControlUtils;
import kd.mpscmm.mscommon.writeoff.common.util.WfManualUtil;
import kd.mpscmm.mscommon.writeoff.common.util.WfPluginFactory;
import kd.mpscmm.mscommon.writeoff.common.util.WfWarnException;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;
import kd.mpscmm.mscommon.writeoff.form.manual.WfManualDataReader;
import kd.mpscmm.mscommon.writeoff.form.manual.WfManualPluginExtHandler;
import kd.mpscmm.mscommon.writeoff.form.queryscheme.ISchemeSavePlugin;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import kd.sdk.mpscmm.mscommon.writeoff.extpoint.writeoff.IWriteOffMainFieldCalPlugin;

public class WfManualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ICloseCallBack,
IWfManualExtService,
ISchemeSavePlugin {
    private static final String WFTYPE_ERRO = "WFTYPEERRO";
    private static final Log log = LogFactory.getLog(WfManualPlugin.class);
    private static final String[] WF_SCHEME_CONFIGKEY = new String[]{"lastwhole", "whole", "onlyequals", "single", "equalsfirst"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("writeofftype", (Object)this.getWfTypeFromParam());
        this.setDefaultScheme();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "wfscheme", "writeofftype");
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap_a", "advcontoolbarap_b", "advcontoolbarap_c", "advcontoolbarap_d"});
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    private void openConditonPage(String suffix) {
        String curEntryKey = "entry" + suffix;
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        String billType = entryBillMap.get(curEntryKey);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("mscommon_query_condition");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("billType", (Object)billType);
        parameter.setCustomParam("entryKey", (Object)curEntryKey);
        parameter.setCustomParam("defaultFilter", (Object)this.addDefaultPageFilterConditon(this.getView(), curEntryKey));
        String pkValue = String.valueOf(((DynamicObject)this.getModel().getValue("writeofftype")).getPkValue());
        parameter.setCustomParam("writeofftype", (Object)pkValue);
        List<Map<String, Object>> maps = this.addFilterGrid(billType);
        parameter.setCustomParam("filterConditonField", maps);
        parameter.setCloseCallBack(new CloseCallBack(this.getClass().getName(), "queryConditionCallBack"));
        this.getView().showForm(parameter);
    }

    @Override
    public String addDefaultPageFilterConditon(IFormView iFormView, String curEntryKey) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            return pagePlugin.addDefaultPageFilterConditon(iFormView, curEntryKey);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "queryConditionCallBack".equals(actionId)) {
            JSONObject returnData = (JSONObject)object;
            String filterValue = returnData.getString("filtervalue");
            String entryValue = returnData.getString("entryKey");
            String billEntity = returnData.getString("billEntity");
            Map<String, String> filterMap = this.getCacheValue("writeOffPageFilter");
            filterMap.put(entryValue, filterValue);
            filterMap.put(entryValue + "billEntity", billEntity);
            this.getPageCache().put("writeOffPageFilter", SerializationUtils.toJsonString(filterMap));
            this.queryPageData();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btnhistorywf".equals(itemKey)) {
            this.viewHistory();
        } else if ("btncurwf".equals(itemKey)) {
            this.viewCurrent();
        } else if ("querycondition_a".equals(itemKey)) {
            String suffix = this.transIndexToSuffix(0);
            this.openConditonPage(suffix);
        } else if ("querycondition_b".equals(itemKey)) {
            String suffix = this.transIndexToSuffix(1);
            this.openConditonPage(suffix);
        } else if ("querycondition_c".equals(itemKey)) {
            String suffix = this.transIndexToSuffix(2);
            this.openConditonPage(suffix);
        } else if ("querycondition_d".equals(itemKey)) {
            String suffix = this.transIndexToSuffix(3);
            this.openConditonPage(suffix);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key = event.getOperateKey();
        OperationResult result = event.getOperationResult();
        if (!result.isSuccess()) {
            return;
        }
        if ("query".equals(key)) {
            try {
                this.queryPageData();
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        } else if ("wfmanual".equals(key) || "wfauto".equals(key)) {
            if (this.isFeeShare()) {
                IDataModel model = this.getModel();
                MainEntityType dataEntityType = model.getDataEntityType();
                for (String configKey : WF_SCHEME_CONFIGKEY) {
                    if (!((Boolean)model.getValue(configKey)).booleanValue()) continue;
                    IDataEntityProperty prop = dataEntityType.findProperty(configKey);
                    throw new KDBizException(FormLang.feeShareNotSupport(prop));
                }
            }
            this.generateWfRecord(key, result, event);
        } else if ("btnrefresh".equals(key)) {
            this.init();
        }
    }

    private void checkFilterData() {
        DynamicObject wfScheme = (DynamicObject)this.getModel().getValue("wfscheme");
        if (wfScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_13", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        String wfCount = this.getView().getPageCache().get("wfcount");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.transIndexToSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            String entityNumber = entryBillMap.get(curEntryKey);
            List<QFilter> qFilters = this.filterDeal(curEntryKey, entryBillMap);
            this.checkOrgAndDateFilter(entityNumber, qFilters);
        }
    }

    private void generateWfRecord(String key, OperationResult result, AfterDoOperationEventArgs event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncurwf"});
        try {
            this.checkFilterData();
            if ("wfmanual".equals(key)) {
                this.startWfManual(result);
            } else {
                this.startAutoManual();
            }
        }
        catch (Exception e) {
            log.error("\u6838\u9500\u5931\u8d25\uff1a", (Throwable)e);
            String errorMsgByExp = this.getErrorMsgByExp(e);
            this.getView().showErrorNotification(errorMsgByExp);
            result.setSuccess(false);
            result.setShowMessage(false);
            this.insertAppLogInfo(false, errorMsgByExp, event);
        }
        if (result.isSuccess()) {
            this.bindEntryData();
            this.getPageCache().put("currentwfseq", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncurwf"});
            this.insertAppLogInfo(true, "", event);
        }
    }

    private void insertAppLogInfo(boolean isSuccess, String errorMsgByExp, AfterDoOperationEventArgs event) {
        FormOperate source = (FormOperate)event.getSource();
        String org = source.getOption().getVariableValue("org", RequestContext.get().getOrgId() + "");
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(MetadataServiceHelper.getDataEntityType((String)source.getEntityId()).getAppId());
        appLogInfo.setBizObjID(source.getEntityId());
        appLogInfo.setOpName(source.getOperateKey(), source.getOperateName().getLocaleValue());
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOrgID(Long.valueOf(org));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientName(RequestContext.get().getClient());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setAccountId(RequestContext.get().getAccountId());
        if (isSuccess) {
            String msg = ResManager.loadKDString((String)"\u6210\u529f", (String)"WfManualPlugin_15", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            appLogInfo.setOpDescription(source.getOperateName().getLocaleValue() + msg);
        } else {
            String msg = ResManager.loadKDString((String)"\u5931\u8d25\uff1a", (String)"WfManualPlugin_16", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
            appLogInfo.setOpDescription(source.getOperateName().getLocaleValue() + msg + errorMsgByExp);
        }
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private void queryPageData() {
        long start = System.currentTimeMillis();
        try (TraceSpan trace = Tracer.create((String)"WfManualPlugin-queryPageData", (String)"queryPageData");){
            this.init();
            this.bindEntryData();
        }
        long end = System.currentTimeMillis();
        log.info("\u624b\u5de5\u6838\u9500\u9875\u9762\u67e5\u8be2\u65f6\u95f4:" + (end - start) + "ms");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("wfscheme".equals(fieldKey)) {
            QFilter wfTypef = new QFilter("writeofftype", "=", (Object)this.getWfTypeByForm());
            showParameter.getListFilterParameter().getQFilters().add(wfTypef);
        } else if ("writeofftype".equals(fieldKey)) {
            this.beforeF7WfType(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        this.calcWfFieldCur(e);
        this.writeOffMethodChanged(name);
        if ("single".equals(name)) {
            if (((Boolean)this.getModel().getValue("single")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnautowf"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btnautowf"});
            }
        } else if ("writeofftype".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null) {
                model.beginInit();
                model.setValue("writeofftype", oldValue);
                model.endInit();
                return;
            }
            this.getModel().setValue("wfscheme", null);
            this.getPageCache().remove("writeOffPageFilter");
            this.setDefaultScheme();
            this.getView().updateView("wfscheme");
            this.init();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        IDataEntityProperty property;
        String wfMainField;
        super.beforeFieldPostBack(e);
        OperationContext op = OperationContext.get();
        Object fieldValue = e.getValue();
        String key = ((Control)e.getSource()).getKey();
        MainEntityType dataEntityType = (MainEntityType)this.getView().getModel().getDataEntity().getDataEntityType();
        Map properties = dataEntityType.getAllFields();
        IDataEntityProperty fieldProp = (IDataEntityProperty)properties.get(key);
        if (fieldProp == null) {
            return;
        }
        String proName = fieldProp.getName();
        if (proName.equals(wfMainField = proName.replace("_cur", "")) && fieldProp.getParent() instanceof EntryType) {
            wfMainField = this.getWFMainFieldEntryKey(fieldProp);
        }
        if ((property = (IDataEntityProperty)fieldProp.getParent().getProperties().get((Object)wfMainField)) != null && fieldValue != null && property instanceof DecimalProp && fieldProp instanceof DecimalProp) {
            boolean judge;
            BigDecimal curMainWfFieldNewValue = new BigDecimal((String)fieldValue);
            BigDecimal wfMainValue = null;
            Object wfMainValueObj = this.getModel().getValue(wfMainField, e.getRowIndex());
            wfMainValue = wfMainValueObj == null ? BigDecimal.ZERO : (wfMainValueObj instanceof Integer ? BigDecimal.valueOf(((Integer)wfMainValueObj).intValue()) : (BigDecimal)wfMainValueObj);
            boolean bl = judge = wfMainValue.multiply(curMainWfFieldNewValue).compareTo(BigDecimal.ZERO) < 0;
            if (judge) {
                e.setCancel(true);
                this.getView().updateView(proName, e.getRowIndex());
                if (!"entryRowClick".equals(op.getOpMethod())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s,%2$s\u9700\u4fdd\u6301\u7b26\u53f7\u4e00\u81f4\u3002", (String)"WfManualPlugin_6", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), fieldProp.getDisplayName().getLocaleValue(), property.getDisplayName().getLocaleValue()));
                    return;
                }
            }
            if (curMainWfFieldNewValue.abs().compareTo(wfMainValue.abs()) > 0) {
                e.setCancel(true);
                this.getView().updateView(proName, e.getRowIndex());
                if (!"entryRowClick".equals(op.getOpMethod())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"WfManualPlugin_1", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), fieldProp.getDisplayName().getLocaleValue(), property.getDisplayName().getLocaleValue()));
                }
            }
        }
    }

    private String getWFMainFieldEntryKey(IDataEntityProperty fieldProp) {
        String entryKey = fieldProp.getParent().getName();
        String mainField = this.getCacheValue("entrywfmainfieldmap").get(entryKey);
        String lastKey = DynamicObjectUtil.getLastKey(mainField.replaceAll("@@A", ""));
        return lastKey + entryKey.replaceAll("entry", "");
    }

    @Override
    public List<Map<String, Object>> addFilterGrid(String entityNumber) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            List<Map<String, Object>> results;
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null || CollectionUtils.isEmpty(results = pagePlugin.addFilterGrid(entityNumber))) continue;
            list.addAll(results);
        }
        return list;
    }

    @Override
    public String wfManualConfirmMessage() {
        String message = ResManager.loadKDString((String)"\u5b58\u5728\u4e3b\u65b9\u8f85\u65b9%s\u4e0d\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfManualPlugin_4", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]);
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            message = pagePlugin.wfManualConfirmMessage();
        }
        return message;
    }

    @Override
    public String wfQueryCheckMessage(String name, String number) {
        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)\u9700\u8981\u589e\u52a0\u7ec4\u7ec7\u548c\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"WfManualPlugin_9", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), name);
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            message = pagePlugin.wfQueryCheckMessage(name, number);
        }
        return message;
    }

    @Override
    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            pagePlugin.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        }
    }

    @Override
    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            pagePlugin.dealFieldsValueByBiz(tableValueSetter, curEntryKey);
            pagePlugin.dealFieldsValueByBiz(tableValueSetter, curEntryKey, this.getView());
        }
    }

    private void beforeF7WfType(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter wfTypeQ = null;
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wftypenumber");
        if (wfType == null) {
            String wfGroupNum = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            HashSet<Long> wfTypeIdSet = new HashSet<Long>(16);
            for (DynamicObject type : wfTypes) {
                wfTypeIdSet.add(type.getLong("entryentity.wftype"));
            }
            wfTypeQ = new QFilter("id", "in", wfTypeIdSet);
        } else {
            wfTypeQ = new QFilter("number", "=", (Object)wfType);
        }
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.getQFilters().add(wfTypeQ);
        listFilterParameter.setOrderBy("number asc");
    }

    private Map<String, String> getCacheValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheValueStr)) {
            return new HashMap<String, String>(1);
        }
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private String getPageFilterCacheValue(String cacheKey, String curEntryKey) {
        if (!"writeOffPageFilter".equals(cacheKey)) {
            return null;
        }
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheValueStr)) {
            return this.addDefaultPageFilterConditon(this.getView(), curEntryKey);
        }
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        String filterText = (String)cacheValueMap.get(curEntryKey);
        if (StringUtils.isEmpty((String)filterText)) {
            return this.addDefaultPageFilterConditon(this.getView(), curEntryKey);
        }
        return filterText;
    }

    private Map<String, String> getCacheMainFieldValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        HashMap<String, String> mainFiled = new HashMap<String, String>(16);
        for (Map.Entry entry : cacheValueMap.entrySet()) {
            String value = (String)entry.getValue();
            String[] split = value.split("@@");
            if ("B".equals(split[1])) {
                mainFiled.put((String)entry.getKey(), "curwfdata");
                continue;
            }
            if ("C".equals(split[1])) {
                mainFiled.put((String)entry.getKey(), "curwfdata");
                continue;
            }
            if (!"A".equals(split[1])) continue;
            mainFiled.put((String)entry.getKey(), split[0]);
        }
        return mainFiled;
    }

    private Map<String, List<String>> getCacheValueList(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private void init() {
        HashMap<String, String> entryBillMap = new HashMap<String, String>(16);
        HashMap<String, String> entryWfMainFieldMap = new HashMap<String, String>(16);
        HashMap entryWfFieldMap = new HashMap(16);
        HashMap entryWfFieldPreMap = new HashMap(16);
        HashMap<String, String> entryFilterStrMap = new HashMap<String, String>(16);
        HashMap<String, String> entryCFilterStrMap = new HashMap<String, String>(16);
        HashMap<String, String> entryTypeEntryIdMap = new HashMap<String, String>(16);
        Long wfTypeId = this.getWfTypeByForm();
        DynamicObject wfTypeDyc = BusinessDataServiceHelper.loadSingle((Object)wfTypeId, (String)"msmod_writeofftype");
        DynamicObjectCollection writeOffBillEntities = wfTypeDyc.getDynamicObjectCollection("writeoffbillentry");
        Collections.sort(writeOffBillEntities, Comparator.comparingInt(o -> o.getInt("seq")));
        int i = 0;
        for (DynamicObject writeOffBillEntry : writeOffBillEntities) {
            String suffix = this.transIndexToSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            if (writeOffBillEntry.getBoolean("isautogenerate") || !writeOffBillEntry.getBoolean("isinvolved")) continue;
            String entityNum = writeOffBillEntry.getDynamicObject("writeoffbilltype").getString("number");
            entryBillMap.put(curEntryKey, entityNum);
            DynamicObjectCollection subEntries = writeOffBillEntry.getDynamicObjectCollection("wffieldsubentry");
            if (this.isFeeShare() && subEntries.isEmpty()) {
                String wfFieldKey = this.getShareRuleFieldKey();
                entryWfMainFieldMap.put(curEntryKey, (String)wfFieldKey + "@@" + "A");
            } else {
                for (DynamicObject writeOffColumnEntry : subEntries) {
                    Object wfFieldKey = writeOffColumnEntry.getString("writeofffieldkey");
                    String valueMethod = writeOffColumnEntry.getString("valuemethod");
                    if (writeOffColumnEntry.getBoolean("writeoffcalcfield")) {
                        if ("B".equals(valueMethod)) {
                            String formula = writeOffColumnEntry.getString("calformuladesc_tag");
                            entryWfMainFieldMap.put(curEntryKey, formula + "@@" + "B");
                            wfFieldKey = "curwfdata";
                        } else if ("C".equals(valueMethod)) {
                            String plugin = writeOffColumnEntry.getString("wffieldplugin");
                            entryWfMainFieldMap.put(curEntryKey, plugin + "@@" + "C");
                            wfFieldKey = "curwfdata";
                        } else {
                            entryWfMainFieldMap.put(curEntryKey, (String)wfFieldKey + "@@" + "A");
                        }
                    }
                    entryWfFieldMap.putIfAbsent(curEntryKey, new ArrayList(16));
                    ((List)entryWfFieldMap.get(curEntryKey)).add(wfFieldKey);
                }
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(curEntryKey);
            DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
            entryWfFieldPreMap.putIfAbsent(curEntryKey, new ArrayList(16));
            for (IDataEntityProperty item : properties) {
                String keyName = item.getName();
                int prefixIndex = keyName.indexOf(suffix);
                if (prefixIndex == -1) continue;
                boolean containsWfField = properties.containsKey((Object)item.getName().replace("_cur", ""));
                keyName = keyName.substring(prefixIndex);
                if (!containsWfField || !keyName.startsWith(suffix) || !keyName.endsWith("_cur")) continue;
                ((List)entryWfFieldPreMap.get(curEntryKey)).add(item.getName());
            }
            String billFilterStr = writeOffBillEntry.getString("filterconditiondesc_tag");
            entryFilterStrMap.put(curEntryKey, billFilterStr);
            String cbillFilterStr = writeOffBillEntry.getString("cfilterconditiondesc_tag");
            entryCFilterStrMap.put(curEntryKey, cbillFilterStr);
            entryTypeEntryIdMap.put(curEntryKey, String.valueOf(writeOffBillEntry.getPkValue()));
            ++i;
        }
        this.getPageCache().put("writeOffTypeId", String.valueOf(wfTypeId));
        this.getPageCache().put("entrybillmap", SerializationUtils.toJsonString(entryBillMap));
        this.getPageCache().put("wfcount", String.valueOf(i));
        this.getPageCache().put("entrywfmainfieldmap", SerializationUtils.toJsonString(entryWfMainFieldMap));
        this.getPageCache().put("entrywffieldmap", SerializationUtils.toJsonString(entryWfFieldMap));
        this.getPageCache().put("entrywffieldpremap", SerializationUtils.toJsonString(entryWfFieldPreMap));
        this.getPageCache().put("entryfilterstrmap", SerializationUtils.toJsonString(entryFilterStrMap));
        this.getPageCache().put("entrycfilterstrmap", SerializationUtils.toJsonString(entryCFilterStrMap));
        this.getPageCache().put("recordentity", wfTypeDyc.getDynamicObject("writeoffrecordbill").getString("number"));
        this.getPageCache().put("writeOffTypeEntryIdsMap", SerializationUtils.toJsonString(entryTypeEntryIdMap));
    }

    private String getShareRuleFieldKey() {
        DynamicObject wfScheme = (DynamicObject)this.getModel().getValue("wfscheme");
        if (wfScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_13", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DynamicObject wfSchemeSRObj = QueryServiceHelper.queryOne((String)"msmod_scheme", (String)"sharerule", (QFilter[])new QFilter("id", "=", wfScheme.getPkValue()).toArray());
        long shareRuleId = wfSchemeSRObj.getLong("sharerule");
        DynamicObject shareRule = BusinessDataServiceHelper.loadSingleFromCache((Object)shareRuleId, (String)"msmod_sharerule");
        if (shareRule == null) {
            throw new KDBizException(FormLang.schemeNotConfigShareRule());
        }
        String fieldKey = null;
        int level = 0;
        for (DynamicObject shareRuleEntry : shareRule.getDynamicObjectCollection("entryentity")) {
            DynamicObjectCollection standardEntries = shareRuleEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject standardEntry : standardEntries) {
                String shareFieldKey;
                int length;
                if (!"0".equals(standardEntry.getString("shareweight")) || (length = (shareFieldKey = standardEntry.getString("sharebillfieldkey")).split("\\.").length) <= level && fieldKey != null) continue;
                fieldKey = shareFieldKey;
                level = length;
            }
        }
        return fieldKey;
    }

    private Long getWfTypeFromParam() {
        HashSet<String> wfTypeNums = new HashSet<String>();
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wftypenumber");
        if (wfType == null) {
            String wfGroupNum = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            if (wfTypes.isEmpty()) {
                this.getPageCache().put(WFTYPE_ERRO, "true");
                throw new WfWarnException(ResManager.loadKDString((String)"\u8868\u5355\u914d\u7f6e\u7684\u6838\u9500\u7c7b\u522b\u5206\u7ec4\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u5165\u53e3\u53c2\u6570\u3002", (String)"WfManualPlugin_17", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            for (DynamicObject wfTypeObj : wfTypes) {
                wfTypeNums.add(wfTypeObj.getString("entryentity.wftype.number"));
            }
            wfType = ((DynamicObject)wfTypes.get(0)).getString("entryentity.wftype.number");
        } else {
            wfTypeNums.add(wfType);
        }
        List wfTypeId = QueryServiceHelper.queryPrimaryKeys((String)"msmod_writeofftype", (QFilter[])new QFilter[]{new QFilter("number", "in", wfTypeNums), new QFilter("enable", "=", (Object)Boolean.TRUE)}, (String)"number asc", (int)1);
        if (wfTypeId.isEmpty()) {
            this.getPageCache().put(WFTYPE_ERRO, "true");
            throw new WfWarnException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6838\u9500\u7c7b\u522b\u3002", (String)"WfManualPlugin_19", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return (Long)wfTypeId.get(0);
    }

    private Long getWfTypeByForm() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wfType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_8", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        return wfType.getLong("id");
    }

    private String transIndexToSuffix(int index) {
        return "_" + (char)(WfManualConst.MIN_SUFFIX.charValue() + index);
    }

    private List<QFilter> buildQfilter(String billType, String suffix) {
        String curEntryKey = "entry" + suffix;
        curEntryKey = this.getEntryKey(curEntryKey);
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        String filterText = this.getPageFilterCacheValue("writeOffPageFilter", curEntryKey);
        String entityNumber = entryBillMap.get(curEntryKey);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
        String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
        QFilter wfCfgs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgFilter);
        billFilters.add(wfCfgs);
        Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
        String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
        QFilter wfCfgCs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgCFilter);
        billFilters.add(wfCfgCs);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter(entityNumber, filterText);
        billFilters.add(curBillFilter);
        HashMap<String, Object> pageDataMap = new HashMap<String, Object>(16);
        pageDataMap.put("model", this.getModel());
        pageDataMap.put("view", this.getView());
        this.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        return billFilters;
    }

    private void bindEntryData() {
        int maxShowSize = this.getMaxShowSize();
        DynamicObject wfScheme = (DynamicObject)this.getModel().getValue("wfscheme");
        if (wfScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_13", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        String wfCount = this.getView().getPageCache().get("wfcount");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.transIndexToSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            String entityNumber = entryBillMap.get(curEntryKey);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
            String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
            List<QFilter> billFilters = this.filterDeal(curEntryKey, entryBillMap);
            this.checkOrgAndDateFilter(entityNumber, billFilters);
            HashMap<String, String> billFormFieldMap = new HashMap<String, String>(16);
            List<String> formFields = this.getBillFields(suffix, curEntryKey, entityNumber, billFormFieldMap);
            Map<String, List<String>> entryWfMap = this.getCacheValueList("entrywffieldmap");
            List<String> wfFields = entryWfMap.get(curEntryKey);
            if (wfFields == null) {
                wfFields = new ArrayList<String>(16);
            }
            Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
            String wfMainField = entryWfMainFieldMap.get(curEntryKey);
            Map<String, String> wfFieldAssistField = this.getWfFieldAssistFieldMap(curEntryKey, billFormFieldMap, wfFields);
            String writeOffTypeEntyId = this.getCacheValue("writeOffTypeEntryIdsMap").get(curEntryKey);
            WfManualDataReader wfManualDataReader = new WfManualDataReader(entityNumber, wfMainField, wfCfgFilter, wfCfgCFilter, curEntryKey, writeOffTypeEntyId);
            wfManualDataReader.setBillFilters(billFilters);
            String customField = new WfManualPluginExtHandler(this.getView()).manualWriteOffField(this.getWfTypeFromParam(), suffix);
            if (StringUtils.isNotEmpty((String)customField)) {
                String mainFieldKey = DynamicObjectUtil.getLastKey(wfMainField.replaceAll("@@A", ""));
                wfFieldAssistField.put(mainFieldKey, customField);
            }
            this.getModel().deleteEntryData(curEntryKey);
            TableValueSetter tableValueSetter = wfManualDataReader.createTableValueSetter(formFields, billFormFieldMap, wfFieldAssistField, maxShowSize);
            this.getModel().beginInit();
            int rowCount = tableValueSetter.getCount();
            if (rowCount >= maxShowSize) {
                this.getView().showTipNotification(EngineLang.overQueryBillSize(entityNumber, maxShowSize));
            }
            if (rowCount != 0) {
                this.dealFieldsValueByBiz(tableValueSetter, curEntryKey);
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(curEntryKey, tableValueSetter);
            }
            this.getModel().endInit();
            this.getView().updateView(curEntryKey);
        }
    }

    private int getMaxShowSize() {
        return WriteOffParamManager.create().getMaxQuerySize();
    }

    private List<QFilter> filterDeal(String curEntryKey, Map<String, String> entryBillMap) {
        String filterText = this.getPageFilterCacheValue("writeOffPageFilter", curEntryKey);
        String entityNumber = entryBillMap.get(curEntryKey);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
        String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
        QFilter wfCfgs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgFilter);
        billFilters.add(wfCfgs);
        Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
        String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
        QFilter wfCfgCs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgCFilter);
        billFilters.add(wfCfgCs);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter(entityNumber, filterText);
        billFilters.add(curBillFilter);
        HashMap<String, Object> pageDataMap = new HashMap<String, Object>(16);
        pageDataMap.put("model", this.getModel());
        pageDataMap.put("view", this.getView());
        this.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        return billFilters;
    }

    private void checkOrgAndDateFilter(String entityNumber, List<QFilter> billFilters) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, IDataEntityProperty> fieldMap = this.getEntityPropertyMap(entityNumber, allEntities);
        Set entryNames = allEntities.keySet();
        boolean isOrg = false;
        boolean isDate = false;
        for (QFilter qFilter : billFilters) {
            if (qFilter == null) continue;
            HashSet<String> vars = new HashSet<String>(16);
            this.buildQfilterAllFields(qFilter, vars);
            for (String field : vars) {
                String[] spitFields = field.split("\\.");
                String spitField = spitFields[0];
                String fieldName = spitFields.length > 1 && entryNames.contains(spitField) ? spitField + "." + spitFields[1] : spitField;
                IDataEntityProperty property = fieldMap.get(fieldName);
                if (property instanceof OrgProp) {
                    isOrg = true;
                }
                if (!(property instanceof DateTimeProp)) continue;
                isDate = true;
            }
        }
        if (!isOrg || !isDate) {
            String name = dataEntityType.getDisplayName().getLocaleValue();
            String message = this.wfQueryCheckMessage(name, dataEntityType.getName());
            throw new KDBizException(message);
        }
    }

    private void buildQfilterAllFields(QFilter qFilter, Set<String> fields) {
        if (qFilter == null) {
            return;
        }
        String[] properties = qFilter.getProperties();
        fields.addAll(Arrays.asList(properties));
        List nests = qFilter.getNests(false);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            this.buildQfilterAllFields(filter, fields);
        }
    }

    private Map<String, IDataEntityProperty> getEntityPropertyMap(String entityNumber, Map<String, EntityType> allEntities) {
        HashMap<String, IDataEntityProperty> fieldMap = new HashMap<String, IDataEntityProperty>(16);
        for (Map.Entry<String, EntityType> entry : allEntities.entrySet()) {
            String entryKey = entry.getKey();
            EntityType value = entry.getValue();
            Map fields = value.getFields();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                if (entityNumber.equals(entryKey)) {
                    fieldMap.put(fieldKey, property);
                    continue;
                }
                String keyResult = entryKey + "." + fieldKey;
                fieldMap.put(keyResult, property);
            }
        }
        return fieldMap;
    }

    private List<String> getBillFields(String suffix, String curEntryKey, String entityNumber, Map<String, String> billFormFieldMap) {
        ArrayList<String> formFields = new ArrayList<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(curEntryKey);
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty item : properties) {
            String isvKey;
            String keyName = item.getName();
            if (!keyName.endsWith(suffix) && !keyName.endsWith("_x")) continue;
            if ((keyName = keyName.endsWith("_x") ? keyName.substring(0, keyName.lastIndexOf(suffix + "_x")) : keyName.substring(0, keyName.lastIndexOf(suffix))).startsWith(isvKey = ISVService.getISVInfo().getId() + "_")) {
                String newKeyName = keyName.substring(isvKey.length());
                if (dataEntityType.getProperties().containsKey((Object)newKeyName)) {
                    keyName = newKeyName;
                }
            }
            if (!formFields.contains(keyName)) {
                formFields.add(keyName);
            }
            billFormFieldMap.put(keyName, item.getName());
        }
        Map billAllFields = dataEntityType.getAllFields();
        formFields.retainAll(billAllFields.keySet());
        return formFields;
    }

    private Map<String, String> getWfFieldAssistFieldMap(String curEntryKey, Map<String, String> billFormFieldMap, List<String> wfFields) {
        HashMap<String, String> wfFieldAssistField = new HashMap<String, String>(16);
        for (String wfField : wfFields) {
            String[] splits = wfField.split("\\.");
            wfField = splits[splits.length - 1];
            String formField = billFormFieldMap.get(wfField);
            String mainField = billFormFieldMap.get(wfField + "_cur");
            if (formField == null && mainField == null) continue;
            String assistWfField = formField != null ? formField.substring(0, formField.length() - 2) + "_cur" + formField.substring(formField.length() - 2) : mainField.substring(0, mainField.length() - 2) + mainField.substring(mainField.length() - 2);
            DynamicObjectType curEntryType = this.getModel().getEntryEntity(curEntryKey).getDynamicObjectType();
            boolean containsAssistField = curEntryType.getProperties().containsKey((Object)assistWfField);
            boolean containsFormField = curEntryType.getProperties().containsKey((Object)formField);
            if (!containsAssistField || !containsFormField) continue;
            wfFieldAssistField.put(wfField, assistWfField);
        }
        return wfFieldAssistField;
    }

    private void calcWfFieldCur(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        String curEntryKey = e.getProperty().getParent().getName();
        Map<String, List<String>> entryWfPreMap = this.getCacheValueList("entrywffieldpremap");
        List<String> curWfFields = entryWfPreMap.get(curEntryKey);
        if (curWfFields == null) {
            return;
        }
        String wfMainField = proName.replace("_cur", "");
        IDataEntityProperty property = (IDataEntityProperty)e.getProperty().getParent().getProperties().get((Object)wfMainField);
        Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
        String[] splitWfMainFields = entryWfMainFieldMap.get(curEntryKey).split("\\.");
        String splitWfMainField = splitWfMainFields[splitWfMainFields.length - 1];
        if (property != null && wfMainField.contains(splitWfMainField)) {
            ChangeData[] valueSet = e.getChangeSet();
            for (int i = 0; i < valueSet.length; ++i) {
                int rowIndex = valueSet[i].getRowIndex();
                Object newValue = valueSet[i].getNewValue();
                if (!(newValue instanceof BigDecimal)) continue;
                BigDecimal curMainWfFieldNewValue = (BigDecimal)newValue;
                BigDecimal wfMainFieldValue = (BigDecimal)this.getModel().getValue(wfMainField, rowIndex);
                for (String item : curWfFields) {
                    if (proName.equals(item)) continue;
                    BigDecimal wfFieldValue = (BigDecimal)this.getModel().getValue(item.replace("_cur", ""), rowIndex);
                    BigDecimal curWfFieldValue = BigDecimal.ZERO;
                    if (wfMainFieldValue.compareTo(BigDecimal.ZERO) != 0) {
                        int scale = 10;
                        curWfFieldValue = curMainWfFieldNewValue.multiply(wfFieldValue).setScale(scale, RoundingMode.HALF_UP).divide(wfMainFieldValue, scale, RoundingMode.HALF_UP);
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(item, (Object)curWfFieldValue);
                    this.getModel().endInit();
                    this.getView().updateView(item, rowIndex);
                }
            }
        }
    }

    private void startAutoManual() {
        Map<String, Object> schemaMap = this.buildSchemaSortTypeConfigMap();
        Date wfDate = new Date();
        HashMap<String, Object> extParam = new HashMap<String, Object>(16);
        this.putWfParam(extParam, this.getView());
        if (this.isFeeShare()) {
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"FeeShareService", (String)"startAutoManualFeeShare", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, this.getConditionsMap(), extParam});
        } else {
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startAutoManualWriteOff", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, this.getConditionsMap(), extParam});
        }
    }

    private void startWfManual(OperationResult result) {
        String wfCount = this.getPageCache().get("wfcount");
        int count = 0;
        Boolean single = (Boolean)this.getModel().getValue("single");
        Boolean whole = (Boolean)this.getModel().getValue("whole");
        Boolean lastWhole = (Boolean)this.getModel().getValue("lastwhole");
        BigDecimal allCountTwo = null;
        Boolean isShowConfirm = Boolean.FALSE;
        StringBuilder builder = new StringBuilder();
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        DynamicObject record = wfType.getDynamicObject("writeoffrecordbill");
        WriteoffTemplateTypeEnum name = WfManualUtil.getWfTemplateType(record.getString("number"));
        boolean isMainAssist = WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == name;
        boolean isLeft = WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == name;
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.transIndexToSuffix(i);
            String entryKey = this.getEntryKey("entry" + suffix);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            int[] rows = entryGrid.getSelectRows();
            count += rows.length;
            if (i == 0 && rows.length < 1 && !single.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4e3b\u65b9\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e3b\u65b9\u5355\u636e\u3002", (String)"WfManualPlugin_2", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            if (i > 0 && rows.length < 1 && !single.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WfManualPlugin_3", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            }
            if (whole.booleanValue() && rows.length != 1) {
                if (isMainAssist) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u7ed3\u6784\u4e3a\u4e3b\u8f85\u7ed3\u6784\uff0c\u4e3b\u8f85\u65b9\u53ea\u80fd\u4e00\u5bf9\u4e00\u5b8c\u5168\u6838\u9500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfManualPlugin_10", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
                if (isLeft) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u7ed3\u6784\u4e3a\u5de6\u53f3\u7ed3\u6784\uff0c\u4e3b\u8f85\u65b9\u53ea\u80fd\u4e00\u5bf9\u4e00\u5b8c\u5168\u6838\u9500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfManualPlugin_11", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
                }
            }
            if (this.isFeeShare() || lastWhole.booleanValue()) continue;
            BigDecimal allCount = this.getWfCount(suffix, entryKey, rows, builder, i);
            if (allCountTwo != null && allCountTwo.abs().compareTo(allCount.abs()) != 0) {
                isShowConfirm = Boolean.TRUE;
                continue;
            }
            allCountTwo = allCount;
        }
        if (single.booleanValue() && count < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WfManualPlugin_7", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        if (!single.booleanValue() && !whole.booleanValue() && isShowConfirm.booleanValue() && !"B".equals(wfType.getString("writeofftype"))) {
            String message = this.wfManualConfirmMessage();
            String format = String.format(message, builder.toString());
            this.getView().showConfirm(format, MessageBoxOptions.None, new ConfirmCallBackListener("wfmanual", (IFormPlugin)this));
            result.setSuccess(false);
            result.setShowMessage(false);
        } else {
            this.wfManualDeal();
            result.setSuccess(true);
        }
    }

    private BigDecimal getWfCount(String suffix, String entryKey, int[] rows, StringBuilder builder, int line) {
        IDataEntityProperty property;
        Map<String, String> entryMainFieldMap = this.getCacheMainFieldValue("entrywfmainfieldmap");
        String[] splits = entryMainFieldMap.get(entryKey).split("\\.");
        String formField = splits[splits.length - 1] + "_cur" + suffix;
        String curMainFieldKey = this.getFormField(formField);
        String customField = new WfManualPluginExtHandler(this.getView()).manualWriteOffField(this.getWfTypeFromParam(), suffix);
        if (StringUtils.isNotEmpty((String)customField)) {
            curMainFieldKey = customField;
        }
        if ((property = this.getModel().getProperty(curMainFieldKey)) != null && line == 0) {
            String localeValue = property.getDisplayName().getLocaleValue();
            builder.append(localeValue);
        }
        BigDecimal allCount = BigDecimal.ZERO;
        for (int j = 0; j < rows.length; ++j) {
            IDataEntityProperty mainField = this.getModel().getDataEntityType().findProperty(curMainFieldKey);
            if (mainField == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u9500\u4e3b\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"WfManualPlugin_18", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), curMainFieldKey));
            }
            Object value = this.getModel().getValue(curMainFieldKey, rows[j]);
            BigDecimal curMainFieldValue = value == null ? BigDecimal.ZERO : (BigDecimal)value;
            if (curMainFieldValue == null || BigDecimal.ZERO.compareTo(curMainFieldValue) == 0) {
                String localeValue = mainField.getDisplayName().getLocaleValue();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5206\u5f55(%s)\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"WfManualPlugin_14", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]), localeValue));
            }
            allCount = allCount.add(curMainFieldValue);
        }
        return allCount;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callbackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callbackId) {
            case "wfmanual": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                long startTime = System.currentTimeMillis();
                this.wfManualDeal();
                long endTime1 = System.currentTimeMillis();
                log.info("\u624b\u5de5\u6838\u9500\u5904\u7406\u65f6\u95f4" + (endTime1 - startTime) + "ms");
                this.bindEntryData();
                this.getPageCache().put("currentwfseq", null);
                this.getView().setVisible(Boolean.TRUE, new String[]{"btncurwf"});
                long endTime = System.currentTimeMillis();
                log.info("\u624b\u5de5\u6838\u9500\u5904\u7406\u65f6\u95f42" + (endTime - startTime) + "ms");
                break;
            }
        }
    }

    private void wfManualDeal() {
        Map<String, Object> schemaMap = this.buildSchemaSortTypeConfigMap();
        Date wfDate = new Date();
        List<Map<Object, BigDecimal>> curMainFieldValueMaps = this.getEntryIdCurMainFieldValueMaps();
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("entrybillmap", entryBillMap);
        params.put("entrywfmainfieldmap", entryWfMainFieldMap);
        HashMap<Integer, String> indexEntryKeyMap = new HashMap<Integer, String>(16);
        for (int i = 0; i < curMainFieldValueMaps.size(); ++i) {
            String entryKey = "entry" + this.transIndexToSuffix(i);
            entryKey = this.getEntryKey(entryKey);
            indexEntryKeyMap.put(i, entryKey);
        }
        this.putWfParam(params, this.getView());
        params.put("entry", indexEntryKeyMap);
        if (this.isFeeShare()) {
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"FeeShareService", (String)"startManualFeeShare", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, curMainFieldValueMaps, params});
        } else {
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startManualWriteOff", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, curMainFieldValueMaps, params});
        }
    }

    @Override
    public void putWfParam(Map<String, Object> params, IFormView view) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getWfManualExtPlugin(className)) == null) continue;
            pagePlugin.putWfParam(params, view);
        }
    }

    private Map<String, Object> buildSchemaSortTypeConfigMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Object scheme = this.getModel().getValue("wfscheme");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u586b\u5199\u6838\u9500\u65b9\u6848\u3002", (String)"WfManualPlugin_0", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        map.put("sub_wf_scheme", ((DynamicObject)scheme).getPkValue());
        map.put("seq", 0);
        map.put("sub_unilateral", this.getModel().getValue("single"));
        map.put("sub_rbpriority", this.getModel().getValue("redbluefirst"));
        map.put("sub_equalsfirst", this.getModel().getValue("equalsfirst"));
        map.put("sub_onlyequals", this.getModel().getValue("onlyequals"));
        map.put("sub_whole", this.getModel().getValue("whole"));
        map.put("sub_lastwhole", this.getModel().getValue("lastwhole"));
        return map;
    }

    private List<Map<Object, BigDecimal>> getEntryIdCurMainFieldValueMaps() {
        ArrayList<Map<Object, BigDecimal>> entryIdCurMainFieldValueMaps = new ArrayList<Map<Object, BigDecimal>>(16);
        String wfCount = this.getPageCache().get("wfcount");
        Map<String, String> entryMainFieldOneMap = this.getCacheValue("entrywfmainfieldmap");
        Map<String, String> entryMainFieldMap = this.getCacheMainFieldValue("entrywfmainfieldmap");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        Map<String, String> wfTypeEntryIdMap = this.getCacheValue("writeOffTypeEntryIdsMap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.transIndexToSuffix(i);
            String entryKey = this.getEntryKey("entry" + suffix);
            String[] splits = entryMainFieldMap.get(entryKey).split("\\.");
            String formField = splits[splits.length - 1] + "_cur" + suffix;
            String mainField = splits[splits.length - 1] + suffix;
            String mainFieldAll = entryMainFieldOneMap.get(entryKey);
            String curMainFieldKey = this.getFormField(formField);
            String customMainFieldKey = new WfManualPluginExtHandler(this.getView()).manualWriteOffField(this.getWfTypeFromParam(), suffix);
            if (StringUtils.isNotEmpty((String)customMainFieldKey)) {
                curMainFieldKey = customMainFieldKey;
            }
            String mainFieldKey = this.getFormField(mainField);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            int[] rows = entryGrid.getSelectRows();
            String billType = entryBillMap.get(entryKey);
            Long wfTypeBillEntryId = Long.valueOf(wfTypeEntryIdMap.get(entryKey));
            HashMap<Object, BigDecimal> entryIdCurMainFieldValueMap = new HashMap<Object, BigDecimal>(rows.length);
            HashMap<Object, BigDecimal> entryIdMainFieldValueMap = new HashMap<Object, BigDecimal>(rows.length);
            for (int j = 0; j < rows.length; ++j) {
                String entryIdKey = "billentryid" + suffix;
                entryIdKey = this.getFormField(entryIdKey);
                Object entryId = this.getModel().getValue(entryIdKey, rows[j]);
                if (this.isFeeShare() && i > 0) {
                    entryIdCurMainFieldValueMap.put(entryId, BigDecimal.ZERO);
                    entryIdMainFieldValueMap.put(entryId, BigDecimal.ZERO);
                    continue;
                }
                Object value = this.getModel().getValue(curMainFieldKey, rows[j]);
                BigDecimal curMainFieldValue = value == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(curMainFieldKey, rows[j]);
                entryIdCurMainFieldValueMap.put(entryId, curMainFieldValue);
                IDataEntityProperty property = this.getModel().getDataEntityType().findProperty(mainFieldKey);
                if (property != null) {
                    Object mainFieldValue = this.getModel().getValue(mainFieldKey, rows[j]);
                    if (mainFieldValue instanceof Integer) {
                        mainFieldValue = BigDecimal.valueOf(((Integer)mainFieldValue).intValue());
                    }
                    entryIdMainFieldValueMap.put(entryId, mainFieldValue == null ? BigDecimal.ZERO : (BigDecimal)mainFieldValue);
                    continue;
                }
                entryIdMainFieldValueMap.put(entryId, value == null ? BigDecimal.ZERO : (BigDecimal)value);
            }
            if (!this.isFeeShare() || i <= 0) {
                this.checkBillIsUpdate(splits, mainFieldAll, billType, entryIdMainFieldValueMap, wfTypeBillEntryId);
                this.checkSelectDataQfilter(entryIdCurMainFieldValueMap.keySet(), billType, mainFieldAll, suffix, wfTypeBillEntryId);
            }
            entryIdCurMainFieldValueMaps.add(entryIdCurMainFieldValueMap);
        }
        return entryIdCurMainFieldValueMaps;
    }

    private void checkSelectDataQfilter(Set<Object> ids, String entityNumber, String wfMainField, String suffix, Long wfTypeBillEntryId) {
        String entryKey = WfManualUtil.getEntryKey(entityNumber, wfMainField, wfTypeBillEntryId);
        QFilter qFilter = new QFilter(entryKey, "in", ids);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(qFilter);
        qFilters.addAll(this.buildQfilter(entityNumber, suffix));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityNumber, (String)entryKey, (QFilter[])this.getFilters(qFilters));
        if (query.size() != ids.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private QFilter[] getFilters(List<QFilter> billFilters) {
        QFilter[] billfs = null;
        if (billFilters.size() > 0) {
            billfs = billFilters.toArray(new QFilter[0]);
        }
        return billfs;
    }

    private void checkBillIsUpdate(String[] splits, String mainFieldAll, String billType, Map<Object, BigDecimal> entryIdMainFieldValueMap, Long wfTypeBillEntryId) {
        String idKey = splits.length > 1 ? splits[0] + ".id" : "id";
        String expression = "";
        String[] mainFields = mainFieldAll.split("@@");
        String mainFieldType = "";
        String mainField = "";
        IWriteOffMainFieldCalPlugin mainFieldCal = null;
        ArrayList<String> billFields = new ArrayList<String>(16);
        if (mainFields.length > 1) {
            mainFieldType = mainFields[1];
            if ("B".equals(mainFieldType)) {
                String mainFieldExpress = mainFields[0];
                Set<String> expressionField = WfManualUtil.getExpressionField(billType, mainFieldAll);
                billFields.addAll(expressionField);
                expression = this.getExpression(mainFieldExpress);
                idKey = WfManualUtil.getEntryKey(billType, mainFieldAll, wfTypeBillEntryId);
            } else if ("C".equals(mainFieldType)) {
                mainFieldCal = WfPluginExtFactory.getWfMainFiledPlugin(mainFields[0], wfTypeBillEntryId);
                billFields.addAll(mainFieldCal.calNeedFields());
                idKey = WfManualUtil.getEntryKey(billType, mainFieldAll, wfTypeBillEntryId);
            } else if ("A".equals(mainFieldType)) {
                mainField = WfManualUtil.changeField(mainFields[0]);
                billFields.add(mainFields[0]);
            }
        } else {
            mainField = WfManualUtil.changeField(mainFieldAll);
            billFields.add(mainFieldAll);
        }
        Set<String> fields = WfManualUtil.changeField(new ArrayList<String>(billFields));
        StringBuilder builder = WfManualUtil.addFormFields(fields, billType);
        String selectFields = "id".equals(idKey) ? builder.append(idKey).toString() : builder.append(idKey).append(", id ").toString();
        QFilter qFilter = new QFilter(idKey, "in", entryIdMainFieldValueMap.keySet());
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)billType, (String)selectFields, (QFilter[])qFilter.toArray());
        if (entryIdMainFieldValueMap.size() != queryList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)billType, (String)selectFields, (QFilter[])qFilter.toArray(), null);
        DataSet select = billDs.copy();
        ArrayList<Object> billIdList = new ArrayList<Object>(16);
        for (Row row : select) {
            Object billId = row.get("id");
            billIdList.add(billId);
        }
        WFSnapshotContext snapShootHolder = new WFSnapshotContext(null);
        snapShootHolder.loadSnapShootMap(billIdList, billType);
        for (Row row : billDs) {
            BigDecimal o1;
            Long billEntryId;
            Long billId;
            String snapFieldKey;
            BigDecimal snapShotValue;
            BigDecimal resultQtyp;
            BigDecimal value = BigDecimal.ZERO;
            if ("B".equals(mainFieldType)) {
                HashMap<String, Object> args = new HashMap<String, Object>(16);
                Set<String> expressionField = WfManualUtil.getExpressionField(billType, mainFieldAll);
                for (String field : expressionField) {
                    Object fieldValue = row.get(field);
                    String[] spit = field.split("\\.");
                    args.put(spit[spit.length - 1], fieldValue);
                }
                Object result = FormulaEngine.execExcelFormula((String)expression, args);
                value = result == null ? BigDecimal.ZERO : (BigDecimal)result;
            } else {
                BigDecimal result;
                value = "C".equals(mainFieldType) && mainFieldCal != null ? ((result = mainFieldCal.wfManualmainFieldCal(row)) == null ? BigDecimal.ZERO : result) : ((result = row.getBigDecimal(mainField)) == null ? BigDecimal.ZERO : result);
            }
            if ((resultQtyp = value.subtract(snapShotValue = snapShootHolder.getSnapShotValue(snapFieldKey = mainFieldCal == null ? mainFields[0] : mainFieldCal.getClass().getName(), billId = row.getLong("id"), billType, billEntryId = row.getLong(idKey), this.getEntrySignName(idKey)))).compareTo(o1 = entryIdMainFieldValueMap.get(row.get(idKey))) == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
        }
    }

    private String getEntrySignName(String mainEntryId) {
        String[] spit = mainEntryId.split("\\.");
        String entryName = spit[0];
        return "id".equals(entryName) ? " " : entryName;
    }

    private Map<String, Map<String, String>> getConditionsMap() {
        LinkedHashMap<String, Map<String, String>> billConditionsMap = new LinkedHashMap<String, Map<String, String>>(16);
        String wfCount = this.getPageCache().get("wfcount");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.transIndexToSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
            String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
            String filterText = this.getPageFilter(curEntryKey);
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("pageFilter", filterText);
            map.put("wfTypeFilter", wfCfgFilter);
            map.put("wfTypeCFilter", wfCfgCFilter);
            String writeOffTypeEntyId = this.getCacheValue("writeOffTypeEntryIdsMap").get(curEntryKey);
            billConditionsMap.put(writeOffTypeEntyId, map);
        }
        return billConditionsMap;
    }

    private String getPageFilter(String curEntryKey) {
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        String filterText = this.getPageFilterCacheValue("writeOffPageFilter", curEntryKey);
        String entityNumber = entryBillMap.get(curEntryKey);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter(entityNumber, filterText);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        HashMap<String, Object> pageDataMap = new HashMap<String, Object>(16);
        pageDataMap.put("model", this.getModel());
        pageDataMap.put("view", this.getView());
        this.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        billFilters.add(curBillFilter);
        QFilter qFilterPage = new QFilter("1", "=", (Object)1);
        for (QFilter qFilter : billFilters) {
            qFilterPage.and(qFilter);
        }
        return qFilterPage.toSerializedString();
    }

    private String getExpression(String wfMainField) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        return condition.getExpression();
    }

    private String getFormField(String formField) {
        String isvKey;
        String newFormField;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Map allFields = dataEntityType.getAllEntities();
        if (!allFields.containsKey(formField) && allFields.containsKey(newFormField = (isvKey = ISVService.getISVInfo().getId()) + "_" + formField)) {
            formField = newFormField;
        }
        return formField;
    }

    private String getEntryKey(String entryKey) {
        String isvKey;
        String newEntryKey;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        if (!allEntities.containsKey(entryKey) && allEntities.containsKey(newEntryKey = (isvKey = ISVService.getISVInfo().getId()) + "_" + entryKey)) {
            entryKey = newEntryKey;
        }
        return entryKey;
    }

    private void writeOffMethodChanged(String method) {
        if ("whole".equals(method) && ((Boolean)this.getModel().getValue("whole")).booleanValue()) {
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("redbluefirst", (Object)false);
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("lastwhole", (Object)Boolean.FALSE);
        } else if ("equalsfirst".equals(method) && ((Boolean)this.getModel().getValue("equalsfirst")).booleanValue()) {
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("lastwhole", (Object)Boolean.FALSE);
        } else if ("onlyequals".equals(method) && ((Boolean)this.getModel().getValue("onlyequals")).booleanValue()) {
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("lastwhole", (Object)Boolean.FALSE);
        } else if ("single".equals(method) && ((Boolean)this.getModel().getValue("single")).booleanValue()) {
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("redbluefirst", (Object)false);
            this.getModel().setValue("lastwhole", (Object)Boolean.FALSE);
        } else if ("redbluefirst".equals(method) && ((Boolean)this.getModel().getValue("redbluefirst")).booleanValue()) {
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("whole", (Object)false);
        } else if ("lastwhole".equals(method) && ((Boolean)this.getModel().getValue("lastwhole")).booleanValue()) {
            this.getModel().setValue("equalsfirst", (Object)Boolean.FALSE);
            this.getModel().setValue("onlyequals", (Object)Boolean.FALSE);
            this.getModel().setValue("whole", (Object)Boolean.FALSE);
        }
    }

    private void setDefaultScheme() {
        QFilter wfTypef = new QFilter("writeofftype", "=", (Object)this.getWfTypeByForm());
        QFilter enablef = new QFilter("enable", "=", (Object)Boolean.TRUE);
        List shemeIds = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)"msmod_scheme", (QFilter[])new QFilter[]{wfTypef, enablef}, (String)"number", (int)1);
        if (shemeIds.size() > 0) {
            this.getModel().setValue("wfscheme", (Object)BusinessDataServiceHelper.loadSingleFromCache(shemeIds.get(0), (String)"msmod_scheme"));
        }
    }

    private void viewCurrent() {
        String entityName = this.getPageCache().get("recordentity");
        String currentwfseq = this.getPageCache().get("currentwfseq");
        QFilter creatorf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        if (currentwfseq == null) {
            DynamicObjectCollection wfRecordDycs = QueryServiceHelper.query((String)entityName, (String)"wfseq", (QFilter[])new QFilter[]{creatorf}, (String)"wfseq desc", (int)1);
            if (wfRecordDycs.isEmpty()) {
                return;
            }
            currentwfseq = ((DynamicObject)wfRecordDycs.get(0)).getString("wfseq");
            this.getPageCache().put("currentwfseq", currentwfseq);
        }
        QFilter wfSeqf = new QFilter("wfseq", "=", (Object)currentwfseq);
        QFilter[] filters = new QFilter[]{creatorf, wfSeqf};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        if (ids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u672c\u6b21\u6838\u9500\u8bb0\u5f55\uff0c\u53ef\u80fd\u5df2\u88ab\u53cd\u6838\u9500\u3002", (String)"WfManualPlugin_12", (String)"mpscmm-mscommon-writeoff", (Object[])new Object[0]));
            return;
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Object id : ids) {
            linkQueryPkIdCollection.addLinkQueryPkId(id);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId(entityName);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(creatorf));
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("wftypeid", (Object)this.getPageCache().get("writeOffTypeId"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewHistory() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(this.getPageCache().get("recordentity"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("wftypeid", (Object)this.getPageCache().get("writeOffTypeId"));
        parameter.setCustomParam("viewhistorycustparam", (Object)new WfManualPluginExtHandler(this.getView()).viewHistoryRecordParam());
        parameter.setCustomParam("wfmanual", (Object)"true");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getErrorMsgByExp(Exception e) {
        String errorMsg;
        if (e.getMessage() != null) {
            errorMsg = e.getMessage();
        } else {
            StackTraceElement[] errs;
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement err : errs = e.getStackTrace()) {
                sb.append(err).append('\n');
            }
            errorMsg = sb.toString();
        }
        return errorMsg;
    }

    @Override
    public boolean checkDataChangedExt() {
        return false;
    }

    public boolean isFeeShare() {
        boolean writeOffShare = WriteOffParamManager.create().isWriteOffShare();
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        Long wfid = wfType.getLong("id");
        if (!writeOffShare && (WriteOffTypeIdConst.HXLB_ACTUALFEE_SHARE.equals(wfid) || WriteOffTypeIdConst.HXLB_ESTFEE_SHARE.equals(wfid))) {
            return false;
        }
        return "B".equals(wfType.getString("writeofftype"));
    }
}

