/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.form.validate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.writeoff.business.config.manager.BillFieldInfoManager;
import kd.mpscmm.mscommon.writeoff.business.config.service.WriteOffPluginRegisterService;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffBillConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffColumnConfig;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.business.engine.ReverseWriteOffEngine;
import kd.mpscmm.mscommon.writeoff.business.engine.WriteOffExecuteContext;
import kd.mpscmm.mscommon.writeoff.business.engine.action.AbstractWriteOffAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.WriteOffActionProcessor;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.BillSelectFieldLoadAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.FlowBillGroupAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.FlowBillWfExecuteAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.FlowPreMatchExecuteAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.FlowWriteOffLoadAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.LoadMatchRuleAction;
import kd.mpscmm.mscommon.writeoff.business.engine.action.impl.LoadWriteBackRuleAction;
import kd.mpscmm.mscommon.writeoff.business.engine.core.context.WFSnapshotContext;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffMatchGroup;
import kd.mpscmm.mscommon.writeoff.business.engine.core.src.bo.WriteOffObject;
import kd.mpscmm.mscommon.writeoff.common.helper.PageShowHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffHelpr;
import kd.mpscmm.mscommon.writeoff.common.log.WriteOffExeucteInfo;
import kd.mpscmm.mscommon.writeoff.common.util.FormUtils;
import kd.mpscmm.mscommon.writeoff.common.util.MapUtils;
import kd.mpscmm.mscommon.writeoff.form.AbstractWfFormPlugin;
import kd.mpscmm.mscommon.writeoff.form.beforeselect.BillEnableWFRecord;
import kd.mpscmm.mscommon.writeoff.lang.FormLang;
import kd.sdk.mpscmm.mscommon.writeoff.params.WriteOffObjectBase;

public class MsModValidatePlugin
extends AbstractWfFormPlugin
implements ClickListener {
    private static final String ENTRY_BILL_LIST = "billlist";
    private static final String BILLNO = "billno";
    protected static final String BILL_TYPE = "billtype";
    private static final String SEARCH = "confsearch";
    private static final String PRE_MATCH = "prematch";
    private static final String WFEXECUTE = "wfexecute";
    private static final String UN_WFEXECUTE = "unwfexecute";
    public static final String SCHEMESET_NAME = "schemeset_name";

    @Override
    public void registerListener(EventObject e) {
        FormUtils.addF7Listener((BeforeF7SelectListener)new BillEnableWFRecord(), this, BILL_TYPE);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "wfscheme");
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{SEARCH, WFEXECUTE, UN_WFEXECUTE, "showselectfield", "billquery", PRE_MATCH, "schemematch"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        event.getSource();
        String billType = this.getBillType();
        QFilter filter = new QFilter("writeoffbillentry.writeoffbilltype", "=", (Object)billType);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection wfTypeObjIds = QueryServiceHelper.query((String)"msmod_writeofftype", (String)"id", (QFilter[])filter.toArray());
        if (wfTypeObjIds.isEmpty()) {
            throw new KDBizException("not matched writeOffType!");
        }
        HashSet<Long> wfTypeIds = new HashSet<Long>(16);
        for (DynamicObject typeObjId : wfTypeObjIds) {
            wfTypeIds.add(typeObjId.getLong("id"));
        }
        event.addCustomQFilter(new QFilter("writeofftype", "in", wfTypeIds));
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        String key = FormUtils.getControlEventKey(e);
        String billtype = this.getBillType();
        switch (key) {
            case "confsearch": {
                this.clickMatch(billtype, this.getGroupActions());
                break;
            }
            case "wfexecute": {
                this.clickMatch(billtype, this.getExecuteActions());
                break;
            }
            case "unwfexecute": {
                this.unwf(billtype);
                break;
            }
            case "prematch": {
                this.clickMatch(billtype, this.getPreExecuteActions());
                break;
            }
            case "showselectfield": {
                this.showSelectField(billtype);
                break;
            }
            case "schemematch": {
                this.schemeMatch(this.getBillType());
                break;
            }
        }
    }

    private void unwf(String billtype) {
        List<DynamicObject> selectedBills = this.getSelectedBill(billtype);
        if (selectedBills.isEmpty()) {
            return;
        }
        String op = (String)this.getValue("writeoffop");
        ReverseWriteOffEngine.execute(selectedBills.toArray(new DynamicObject[selectedBills.size()]), op, null);
    }

    private void schemeMatch(String billtype) {
        MulBasedataDynamicObjectCollection wfSchemes = (MulBasedataDynamicObjectCollection)this.getValue("wfschemes");
        if (wfSchemes.isEmpty()) {
            throw new KDBizException("plsInsertWfSchemes");
        }
        List<DynamicObject> selectedBills = this.getSelectedBill(billtype);
        if (selectedBills.isEmpty()) {
            throw new KDBizException("plsSelectBill");
        }
        ArrayList<Long> schemeIds = new ArrayList<Long>(16);
        for (DynamicObject scheme : wfSchemes) {
            schemeIds.add(scheme.getDynamicObject("fbasedataid").getLong("id"));
        }
        ArrayList<Object> billId = new ArrayList<Object>(16);
        for (DynamicObject bill : selectedBills) {
            billId.add(bill.getPkValue());
        }
        this.getView().showMessage(String.valueOf(WriteOffHelpr.getMatchedBillByScheme(schemeIds, billtype, billId)));
    }

    private void showSelectField(String billtype) {
        ArrayList<AbstractWriteOffAction> actions = new ArrayList<AbstractWriteOffAction>();
        actions.add(new FlowWriteOffLoadAction());
        actions.add(new LoadMatchRuleAction());
        actions.add(new LoadWriteBackRuleAction());
        actions.add(new BillSelectFieldLoadAction());
        WriteOffExecuteContext context = this.clickMatch(billtype, actions);
        if (context != null) {
            ArrayList<String> queryStrs = new ArrayList<String>(16);
            BillFieldInfoManager billFieldInfo = context.getBillFieldInfo();
            List<WriteOffTypeConfig> typeConfigs = context.getConfigManager().getAllWriteOffTypeConfigs();
            for (WriteOffTypeConfig writeOffTypeConfig : typeConfigs) {
                for (WriteOffBillConfig configs : writeOffTypeConfig.getBillConfigs()) {
                    WriteOffColumnConfig writeOffColumnConfig;
                    if (!configs.getBillType().equals(billtype) || (writeOffColumnConfig = configs.getWriteOffColumnConfig()) == null) continue;
                    String mainFieldEntry = writeOffColumnConfig.getWfFieldInfo().getMainFieldCalClass().mainFieldEntry();
                    String buildSelectField = billFieldInfo.buildSelectField(billtype, mainFieldEntry);
                    StringBuilder str = new StringBuilder();
                    str.append("WriteOffType:");
                    str.append(writeOffTypeConfig.getName());
                    str.append("\u2014\u2014");
                    str.append(buildSelectField);
                    str.append(";\n");
                    queryStrs.add(str.toString());
                }
            }
            FormShowParameter textShow = new FormShowParameter();
            textShow.setFormId("bos_multitext");
            textShow.getCustomParams().put("params", queryStrs);
            textShow.setCaption("QueryString");
            textShow.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(textShow);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "billtype": {
                this.billTypeChange(e);
                break;
            }
        }
    }

    private void billTypeChange(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newValue != null) {
            ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>(16);
            String formId = newValue.getString("number");
            List ops = EntityMetadataCache.getDataEntityOperate((String)formId);
            for (Map op : ops) {
                String opKey = (String)op.get("key");
                operationItems.add(new ComboItem(LocaleString.fromMap((Map)((Map)op.get("name"))), opKey));
            }
            ComboEdit woffEdit = (ComboEdit)this.getView().getControl("writeoffop");
            woffEdit.setComboItems(operationItems);
        }
    }

    private WriteOffExecuteContext clickMatch(String billtype, List<AbstractWriteOffAction> actions) {
        this.getModel().deleteEntryData("schemeset_entry");
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("submatchentry");
        this.getModel().setValue("executeinfo", (Object)"");
        List<DynamicObject> selectedBills = this.getSelectedBill(billtype);
        if (selectedBills.isEmpty()) {
            return null;
        }
        ArrayList<Object> billId = new ArrayList<Object>(16);
        for (DynamicObject bill : selectedBills) {
            billId.add(bill.getPkValue());
        }
        String op = (String)this.getValue("writeoffop");
        long startTime = System.currentTimeMillis();
        WriteOffActionProcessor processor = WriteOffActionProcessor.build(actions);
        WriteOffExecuteContext context = WriteOffExecuteContext.createFlow(billtype, billId, op);
        try (TXHandle tx = TX.requiresNew();){
            processor.doProcess(context);
        }
        this.getView().showSuccessNotification("cost:" + (System.currentTimeMillis() - startTime) + "ms");
        this.parseResult(context);
        return context;
    }

    private void parseResult(WriteOffExecuteContext context) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<WriteOffMatchGroup> matchGroupMap = context.getMatchGroupMap();
        this.showExecuteInfo(context);
        this.getModel().beginInit();
        for (WriteOffMatchGroup group : matchGroupMap) {
            vs.addField(SCHEMESET_NAME, new Object[]{group.getSchemeConfig().getId()});
            vs.addField("wftype", new Object[]{group.getTypeConfig().getId()});
            vs.addField("wfbilltype", new Object[]{group.getBillTypeConfig().getBillAlias()});
            vs.addField("matchkeyinfo", new Object[]{this.buildMatchKey(group.getMatchKeys())});
            vs.addField("subentryentity", new Object[]{this.getGroupPageData(group)});
            vs.addField("submatchentry", new Object[]{this.getMatchPageData(group, context)});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("schemeset_entry", vs);
        this.getModel().endInit();
        this.getView().updateView();
    }

    private DynamicObjectCollection getMatchPageData(WriteOffMatchGroup group, WriteOffExecuteContext context) {
        SubEntryType subEntryType = (SubEntryType)((SubEntryProp)this.getModel().getDataEntityType().findProperty("submatchentry")).getItemType();
        DynamicObjectCollection subEntry = new DynamicObjectCollection((DynamicObjectType)subEntryType, null);
        Long schemeId = group.getSchemeConfig().getId();
        Map<Long, Map<String, List<List<Map<String, Object>>>>> custParams = context.getTypeContext(group.getTypeConfig().getId()).getPreMatchMap();
        Map<String, List<List<Map<String, Object>>>> schemes = custParams.get(schemeId);
        if (MapUtils.isEmpty(schemes)) {
            return subEntry;
        }
        List<List<Map<String, Object>>> schemeQuery = schemes.get(group.getGroupKey());
        for (List<Map<String, Object>> list : schemeQuery) {
            for (Map<String, Object> matchData : list) {
                DynamicObject obj = subEntry.addNew();
                DynamicObject matchBillEntry = (DynamicObject)matchData.get("matchbill");
                if (matchBillEntry != null) {
                    obj.set("matchbill", matchBillEntry.get("wfbillalias"));
                }
                obj.set("matchobjbillno", matchData.get("matchobjbillno"));
                obj.set("matchobjtype", matchData.get("matchobjtype"));
                obj.set("matchobjbillid", matchData.get("matchobjbillid"));
                obj.set("curmatchnum", matchData.get("curmatchnum"));
                obj.set("matchnum", matchData.get("matchnum"));
            }
        }
        return subEntry;
    }

    private DynamicObjectCollection getGroupPageData(WriteOffMatchGroup group) {
        SubEntryType subEntryType = (SubEntryType)((SubEntryProp)this.getModel().getDataEntityType().findProperty("subentryentity")).getItemType();
        DynamicObjectCollection subEntry = new DynamicObjectCollection((DynamicObjectType)subEntryType, null);
        List<WriteOffObject> writeOffObjects = group.getWriteOffObjects();
        for (WriteOffObject wfObj : writeOffObjects) {
            DynamicObject obj = subEntry.addNew();
            obj.set("wfobjbillno", wfObj.getValue(BILLNO));
            if (wfObj.isBillObj()) {
                obj.set("wfobjtype", (Object)"0");
            } else {
                obj.set("wfobjtype", (Object)"1");
            }
            obj.set("wfobjbillid", wfObj.getWriteOffObjectPk());
            obj.set("curwfnum", (Object)wfObj.getWriteOffObjectBase().getCurWriteOffNumber());
            obj.set("wfnum", (Object)wfObj.getWriteOffObjectBase().getWriteOffNumber());
        }
        return subEntry;
    }

    private String buildMatchKey(List<Object> list) {
        StringBuilder buildKey = new StringBuilder();
        for (Object object : list) {
            if (object instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)object;
                buildKey.append(obj.getDataEntityType().getName());
                buildKey.append("[");
                buildKey.append(obj.getPkValue());
                buildKey.append("]");
            } else {
                buildKey.append(object);
            }
            buildKey.append(" ");
        }
        return buildKey.toString();
    }

    private void showExecuteInfo(WriteOffExecuteContext context) {
        WriteOffExeucteInfo executeInfo = context.getExecuteInfo();
        this.getModel().setValue("executeinfo", (Object)executeInfo.exportErroInfo());
    }

    public List<AbstractWriteOffAction> getGroupActions() {
        ArrayList<AbstractWriteOffAction> actions = new ArrayList<AbstractWriteOffAction>();
        actions.add(new FlowWriteOffLoadAction());
        actions.add(new LoadMatchRuleAction());
        actions.add(new LoadWriteBackRuleAction());
        actions.add(new BillSelectFieldLoadAction());
        actions.add(new FlowBillGroupAction());
        return actions;
    }

    public List<AbstractWriteOffAction> getExecuteActions() {
        List<AbstractWriteOffAction> actions = this.getGroupActions();
        actions.add(new FlowBillWfExecuteAction());
        return actions;
    }

    public List<AbstractWriteOffAction> getPreExecuteActions() {
        List<AbstractWriteOffAction> actions = this.getGroupActions();
        actions.add(new FlowPreMatchExecuteAction());
        return actions;
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "refreshregister": {
                this.register();
                break;
            }
            case "checklock": {
                this.checkLock();
            }
        }
    }

    private void register() {
        Map<String, Map<String, Set<String>>> refreshRegister = WriteOffPluginRegisterService.refreshRegister();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, Set<String>>> refreshRegisterEntry : refreshRegister.entrySet()) {
            String wfop = refreshRegisterEntry.getKey();
            sb.append(wfop);
            sb.append("\n");
            sb.append("==========");
            sb.append("\n");
            sb.append("billentity|op\n");
            sb.append("----|----\n");
            for (Map.Entry<String, Set<String>> entityOpEntry : refreshRegisterEntry.getValue().entrySet()) {
                String billentity = entityOpEntry.getKey();
                Set<String> ops = entityOpEntry.getValue();
                sb.append(billentity);
                sb.append("|");
                sb.append(String.valueOf(ops));
                sb.append("\n");
            }
            sb.append("\n");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_matchcondition");
        showParameter.getCustomParams().put("mdlog", sb.toString());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption("WriteOffService Register");
        this.getView().showForm(showParameter);
    }

    private void checkLock() {
        StringBuilder sb = new StringBuilder();
        sb.append("seq|fxid|fbusiness_id|fcreatetime\n");
        sb.append("----|----|----|----").append("\n");
        StringBuilder lockSql = new StringBuilder("select ctb.fxid, ctb.fbusiness_id, ctb.fcreate_time from t_cbs_dtx_business ctb JOIN t_cbs_dtx_transaction ctt ON ctb.fxid=ctt.fxid WHERE ctt.fstatus in (1,2,3,6,7) and ctb.fbusiness_type = 'WriteOffOpAction'");
        int i = 1;
        DynamicObject billType = (DynamicObject)this.getModel().getValue(BILL_TYPE);
        if (billType != null) {
            String number = billType.getString("number");
            lockSql.append(" and ctb.fbusiness_id like '");
            lockSql.append(number);
            lockSql.append("%'");
        }
        lockSql.append(" order by fcreate_time desc");
        try (DataSet queryDataSet = DB.queryDataSet((String)"checkLock", (DBRoute)new DBRoute("sys"), (String)lockSql.toString()).top(1000);){
            for (Row row : queryDataSet) {
                sb.append(i);
                sb.append("|");
                sb.append(row.getString("fxid"));
                sb.append("|");
                sb.append(row.getString("fbusiness_id"));
                sb.append("|");
                sb.append(row.getString("fcreate_time"));
                sb.append("\n");
                ++i;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_matchcondition");
        showParameter.getCustomParams().put("mdlog", sb.toString());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption("KDTX businessLock:WriteOffOpAction");
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "addsnapshot": {
                this.addsnapshot(e);
                break;
            }
            case "checksnapshot": {
                this.checkSnapshot();
                break;
            }
        }
    }

    private void checkSnapshot() {
        String billType = this.getBillType();
        ArrayList<Object> ids = new ArrayList<Object>(16);
        List<DynamicObject> selectedBill = this.getSelectedBill(billType);
        for (DynamicObject bill : selectedBill) {
            ids.add(bill.getPkValue());
        }
        QFilter dataFilter = new QFilter("verifybillid", "in", ids).and("verifyform.number", "=", (Object)billType);
        ListShowParameter baseDataListParam = PageShowHelper.getBaseDataListParam("msmod_wf_sp", dataFilter);
        this.getView().showForm((FormShowParameter)baseDataListParam);
    }

    private void addsnapshot(AfterDoOperationEventArgs e) {
        String billType = this.getBillType();
        List<DynamicObject> selectedBills = this.getSelectedBill(billType);
        if (selectedBills.isEmpty()) {
            return;
        }
        ArrayList<Object> billId = new ArrayList<Object>(16);
        for (DynamicObject bill : selectedBills) {
            billId.add(bill.getPkValue());
        }
        String op = (String)this.getValue("writeoffop");
        WriteOffActionProcessor processor = WriteOffActionProcessor.build(this.getGroupActions());
        WriteOffExecuteContext context = WriteOffExecuteContext.createFlow(billType, billId, op);
        try (TXHandle tx = TX.requiresNew();){
            processor.doProcess(context);
        }
        ArrayList<WriteOffObjectBase> addObjs = new ArrayList<WriteOffObjectBase>();
        List<WriteOffMatchGroup> matchGroupMap = context.getMatchGroupMap();
        for (WriteOffMatchGroup group : matchGroupMap) {
            List<WriteOffObject> writeOffObjects = group.getWriteOffObjects();
            WFSnapshotContext snapshot = new WFSnapshotContext(group.getTypeConfig());
            for (WriteOffObject woObject : writeOffObjects) {
                WriteOffObjectBase writeOffObjectBase = woObject.getWriteOffObjectBase();
                writeOffObjectBase.setWriteOffNumber(writeOffObjectBase.getCurWriteOffNumber().divide(BigDecimal.valueOf(2L), 8, RoundingMode.HALF_DOWN));
                addObjs.add(writeOffObjectBase);
                snapshot.addSnapShot(writeOffObjectBase);
            }
            snapshot.saveWfSnapShoot();
        }
        this.getView().showSuccessNotification(FormLang.addSnapshotSucess(addObjs));
    }

    private List<DynamicObject> getSelectedBill(String billtype) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_BILL_LIST);
        int[] selectRowIdex = entryGrid.getSelectRows();
        return this.getBill(billtype, selectRowIdex);
    }

    private List<DynamicObject> getBill(String billtype, int ... indexs) {
        IDataModel model = this.getModel();
        ArrayList<String> billNos = new ArrayList<String>(indexs.length);
        for (int i : indexs) {
            billNos.add((String)model.getValue(BILLNO, i));
        }
        if (billNos.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = new QFilter(BILLNO, "in", billNos);
        DynamicObject[] querybills = BusinessDataServiceHelper.load((String)billtype, (String)"id,billno", (QFilter[])filter.toArray());
        if (querybills == null || querybills.length == 0) {
            throw new KDBizException(FormLang.billNotExist());
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(querybills.length);
        for (DynamicObject bill : querybills) {
            bills.add(bill);
        }
        return bills;
    }

    private String getBillType() {
        DynamicObject billType = (DynamicObject)this.getValue(BILL_TYPE);
        return billType != null ? billType.getString("number") : null;
    }
}

