/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.writeoff.op.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.writeoff.op.validator.WriteOffTypeSaveValidator;

public class WriteOffTypeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("filterconditiondesc");
        e.getFieldKeys().add("cfilterconditiondesc");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection billEntryList = dynamicObject.getDynamicObjectCollection("writeoffbillentry");
            for (DynamicObject billEntry : billEntryList) {
                String cFilterStr;
                String filterStr = billEntry.getString("filterconditiondesc");
                if (filterStr.length() > 255) {
                    billEntry.set("filterconditiondesc", (Object)filterStr.substring(0, 100));
                }
                if ((cFilterStr = billEntry.getString("cfilterconditiondesc")).length() <= 255) continue;
                billEntry.set("cfilterconditiondesc", (Object)cFilterStr.substring(0, 100));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_msmod_wfbillsetentry");
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection billEntryList = dynamicObject.getDynamicObjectCollection("writeoffbillentry");
            for (DynamicObject billEntry : billEntryList) {
                if (billEntry.getPkValue() != null) {
                    cacheManager.removeByPrimaryKey(new Object[]{billEntry.getPkValue()});
                    continue;
                }
                cacheManager.removeByFilterDt();
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        TX.inTX();
        ArrayList wfBillAliasList = new ArrayList(16);
        for (DynamicObject dynamicObject : dataEntities) {
            String number = dynamicObject.getString("number");
            DynamicObjectCollection billentrys = dynamicObject.getDynamicObjectCollection("writeoffbillentry");
            for (DynamicObject billentry : billentrys) {
                billentry.set("writeofftypenumber", (Object)number);
            }
            this.botpIdTypeChange(dynamicObject);
        }
        DynamicObject[] wfBills = wfBillAliasList.toArray(new DynamicObject[wfBillAliasList.size()]);
        SaveServiceHelper.save((DynamicObject[])wfBills);
    }

    private void botpIdTypeChange(DynamicObject dynamicObject) {
        DynamicObjectCollection autoBills = dynamicObject.getDynamicObjectCollection("autogenebillentry");
        for (DynamicObject autoBill : autoBills) {
            DynamicObject ruleId = autoBill.getDynamicObject("botprule");
            Long pkValue = Long.valueOf((String)ruleId.getPkValue());
            autoBill.set("botprule", (Object)pkValue);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new WriteOffTypeSaveValidator());
    }
}

