/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.mpscmm.mscommon.writeoff.params;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;

public class WriteOffObjectBase
implements Cloneable {
    private DynamicObject writeOffObject;
    private String primaryColumn;
    private String primaryColumnEObjId;
    private Boolean isMainWriteOff;
    private Boolean isWhole = Boolean.FALSE;
    private BigDecimal writeOffNumber = BigDecimal.ZERO;
    private BigDecimal curWriteOffNumber = BigDecimal.ZERO;
    private Map<String, BigDecimal> writeOffValues = new HashMap<String, BigDecimal>(16);
    private boolean isInvert = false;
    private boolean wfComplete = false;
    private DynamicObject wfTypeEntity;
    private DynamicObject wfBillEntity;
    private String mainWFFieldIdKey;
    private EntityType mainFieldEntityType;
    private DynamicObject mergeAutoBill;

    public WriteOffObjectBase clone() {
        try {
            WriteOffObjectBase writeOffObject = (WriteOffObjectBase)super.clone();
            String valuesMapStr = JSON.toJSONString(writeOffObject.getWriteOffValues());
            Map valuesMap = (Map)JSON.parse((String)valuesMapStr);
            for (Map.Entry entry : valuesMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Integer)) continue;
                BigDecimal bigDecimal = BigDecimal.valueOf(((Integer)value).intValue());
                entry.setValue(bigDecimal);
            }
            writeOffObject.setWriteOffValues(valuesMap);
            return writeOffObject;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteOffObjectBase)) {
            return false;
        }
        WriteOffObjectBase that = (WriteOffObjectBase)o;
        return Objects.equals(this.getPkValue(), that.getPkValue());
    }

    public int hashCode() {
        return Objects.hash(this.getPkValue());
    }

    @Deprecated
    public DynamicObject getWriteOffBill() {
        if (this.isPlainObj() || "id".equals(this.mainWFFieldIdKey)) {
            return this.getWriteOffObject();
        }
        return (DynamicObject)this.getWriteOffObject().getParent();
    }

    public Object getWfBillPk() {
        if (this.mergeAutoBill != null) {
            return this.mergeAutoBill.getPkValue();
        }
        return this.getWriteOffBillPk();
    }

    public String getPkField() {
        EntityType mainFieldEntityType = this.getMainFieldEntityType();
        return mainFieldEntityType.getPrimaryKey().getAlias();
    }

    public String getBillPkField() {
        MainEntityType mainFieldEntityType = this.getWFBillEntityType();
        return mainFieldEntityType.getPrimaryKey().getAlias();
    }

    public String getWfBillBillNo() {
        if (this.mergeAutoBill != null) {
            String billNoKey = ((BillEntityType)this.mergeAutoBill.getDataEntityType()).getBillNo();
            return this.mergeAutoBill.getString(billNoKey);
        }
        if (this.isPlainObj()) {
            return (String)this.getValue("billno");
        }
        return this.getWriteOffBill().getString("billno");
    }

    @Deprecated
    public DynamicObject getWriteOffObject() {
        return this.writeOffObject;
    }

    public Object getPkValue() {
        if (this.writeOffObject == null) {
            return null;
        }
        if (this.isPlainObj()) {
            return this.writeOffObject.get(this.mainWFFieldIdKey);
        }
        return this.writeOffObject.getPkValue();
    }

    public Object getWriteOffBillPk() {
        if (this.writeOffObject == null) {
            return null;
        }
        if (this.isPlainObj()) {
            return this.writeOffObject.get("id");
        }
        return this.getWriteOffBill().getPkValue();
    }

    public Object getValue(String key) {
        if (this.isPlainObj()) {
            Object o;
            try {
                o = this.getWriteOffObject().get(key);
            }
            catch (Exception e) {
                throw new KDBizException(EngineLang.getHintBillFieldFail(this.getWFBillEntityType().getDisplayName().getLocaleValue(), key));
            }
            return o;
        }
        MainEntityType entryMainType = MetadataServiceHelper.getDataEntityType((String)this.getWFBillEntityName());
        String entryName = this.getWriteOffObject().getDynamicObjectType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, entryMainType);
        rowDataModel.setRowContext((Object)this.getWriteOffObject(), 0);
        return rowDataModel.getValue(key);
    }

    public void setLogicWriteOffNumber(BigDecimal newWriteOffNumber) {
        if (this.isInvert()) {
            newWriteOffNumber = BigDecimal.ZERO.subtract(newWriteOffNumber);
        }
        this.setActualLogicWriteOffNumber(newWriteOffNumber);
    }

    public void setActualLogicWriteOffNumber(BigDecimal newWriteOffNumber) {
        BigDecimal oldWriteOffNumber = this.getWriteOffNumber();
        this.setWriteOffNumber(newWriteOffNumber);
        this.setAssistWriteOffNumber(newWriteOffNumber, oldWriteOffNumber);
    }

    public void setAssistWriteOffNumber(BigDecimal newWriteOffNumber, BigDecimal oldWriteOffNumber) {
        for (String writeOffKey : this.getWriteOffValues().keySet()) {
            AmountProp amountProp;
            String controlPropName;
            Long amount;
            BigDecimal oldAssistNumber = this.getWriteOffValues().get(writeOffKey);
            String[] split = writeOffKey.split("\\.");
            String field = split[split.length - 1];
            Integer precision = oldAssistNumber.scale();
            Integer preciSionAccount = 1;
            IDataEntityProperty property = this.getWFBillEntityType().findProperty(field);
            if (property instanceof QtyProp) {
                QtyProp qtyProp = (QtyProp)property;
                String relatedUnit = qtyProp.getControlPropName();
                Long unit = (Long)this.getValue(relatedUnit);
                if (unit != null && Long.compare(unit, 0L) != 0) {
                    precision = (Integer)this.getValue(relatedUnit + ".precision");
                    String value = (String)this.getValue(relatedUnit + ".precisionaccount");
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        preciSionAccount = Integer.valueOf(value);
                    }
                }
            } else if (property instanceof AmountProp && (amount = (Long)this.getValue(controlPropName = (amountProp = (AmountProp)property).getControlPropName())) != null && Long.compare(amount, 0L) != 0) {
                precision = (Integer)this.getValue(controlPropName + ".amtprecision");
            }
            BigDecimal newAssistValue = BigDecimal.ZERO;
            newAssistValue = preciSionAccount == 1 ? newWriteOffNumber.multiply(oldAssistNumber).setScale(10, RoundingMode.HALF_UP).divide(oldWriteOffNumber, (int)precision, RoundingMode.HALF_UP) : (preciSionAccount == 2 ? newWriteOffNumber.multiply(oldAssistNumber).setScale(10, RoundingMode.HALF_UP).divide(oldWriteOffNumber, (int)precision, RoundingMode.DOWN) : (preciSionAccount == 3 ? newWriteOffNumber.multiply(oldAssistNumber).setScale(10, RoundingMode.HALF_UP).divide(oldWriteOffNumber, (int)precision, RoundingMode.UP) : newWriteOffNumber.multiply(oldAssistNumber).setScale(10, RoundingMode.HALF_UP).divide(oldWriteOffNumber, (int)precision, RoundingMode.HALF_UP)));
            this.getWriteOffValues().put(writeOffKey, newAssistValue);
        }
    }

    public void setWriteOffObject(DynamicObject writeOffObject) {
        this.writeOffObject = writeOffObject;
    }

    public Boolean getMainWriteOff() {
        return this.isMainWriteOff;
    }

    public void setMainWriteOff(Boolean mainWriteOff) {
        this.isMainWriteOff = mainWriteOff;
    }

    public String getPrimaryColumn() {
        return this.primaryColumn;
    }

    public void setPrimaryColumn(String primaryColumn) {
        this.primaryColumn = primaryColumn;
    }

    public BigDecimal getWriteOffNumber() {
        return this.writeOffNumber;
    }

    public void setWriteOffNumber(BigDecimal writeOffNumber) {
        this.writeOffNumber = writeOffNumber;
    }

    public Map<String, BigDecimal> getWriteOffValues() {
        return this.writeOffValues;
    }

    public void setWriteOffValues(Map<String, BigDecimal> writeOffValues) {
        this.writeOffValues = writeOffValues;
    }

    public boolean isInvert() {
        return this.isInvert;
    }

    public Boolean getWhole() {
        return this.isWhole;
    }

    public void setWhole(Boolean whole) {
        this.isWhole = whole;
    }

    public BigDecimal getCurWriteOffNumber() {
        return this.curWriteOffNumber;
    }

    public void setInvert(boolean invert) {
        this.isInvert = invert;
    }

    public void setWfComplete(boolean wfComplete) {
        this.wfComplete = wfComplete;
    }

    public boolean isWfComplete() {
        return this.wfComplete;
    }

    public String getPrimaryColumnEObjId() {
        return this.primaryColumnEObjId;
    }

    public void setPrimaryColumnEObjId(String primaryColumnEObjId) {
        this.primaryColumnEObjId = primaryColumnEObjId;
    }

    public boolean isBillObj() {
        return "id".equals(this.mainWFFieldIdKey);
    }

    public boolean isCurWriteOffNotZero() {
        return BigDecimal.ZERO.compareTo(this.curWriteOffNumber) != 0;
    }

    public void setCurWriteOffNumber(BigDecimal curWriteOffNumber) {
        this.curWriteOffNumber = curWriteOffNumber;
    }

    public DynamicObject getWfTypeEntity() {
        return this.wfTypeEntity;
    }

    public void setWfTypeEntity(DynamicObject wfTypeEntity) {
        this.wfTypeEntity = wfTypeEntity;
    }

    public DynamicObject getWfBillEntity() {
        return this.wfBillEntity;
    }

    public String getWFBillEntityName() {
        return this.wfBillEntity.getDynamicObject("writeoffbilltype").getString("number");
    }

    public MainEntityType getWFBillEntityType() {
        return MetadataServiceHelper.getDataEntityType((String)this.getWFBillEntityName());
    }

    public EntityType getMainFieldEntityType() {
        if (this.mainFieldEntityType == null) {
            this.mainFieldEntityType = "id".equals(this.mainWFFieldIdKey) ? this.getWFBillEntityType() : (EntityType)this.getWFBillEntityType().getAllEntities().get(this.mainWFFieldIdKey.split("\\.")[0]);
        }
        return this.mainFieldEntityType;
    }

    public DynamicObject getWFBillEntityObj() {
        String wfBillEntityName = this.getWFBillEntityName();
        DynamicObject bosEntity = BusinessDataServiceHelper.newDynamicObject((String)"bos_entityobject");
        bosEntity.set("id", (Object)wfBillEntityName);
        bosEntity.set("number", (Object)wfBillEntityName);
        return bosEntity;
    }

    public Boolean isMainShare() {
        return this.wfBillEntity.getBoolean("ismainshare");
    }

    public void setWfBillEntity(DynamicObject wfBillEntity) {
        this.wfBillEntity = wfBillEntity;
    }

    public DynamicObject getMergeAutoBill() {
        return this.mergeAutoBill;
    }

    public void setMergeAutoBill(DynamicObject mergeAutoBill) {
        this.mergeAutoBill = mergeAutoBill;
    }

    public boolean isPlainObj() {
        return "PlainObject".equalsIgnoreCase(this.writeOffObject.getDataEntityType().getName());
    }

    @Deprecated
    public Object getWriteOffObjectPk() {
        return this.getPkValue();
    }

    public String getMainWFFieldIdKey() {
        return this.mainWFFieldIdKey;
    }

    public void setMainWFFieldIdKey(String mainWFFieldIdKey) {
        this.mainWFFieldIdKey = mainWFFieldIdKey;
    }

    public String toString() {
        return "WriteOffObjectBase [" + this.getPkValue() + "]";
    }
}

