/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscommon.freeze.common.helper.EntityParseHelper;

public class FormShowHelper {
    private static Set<String> filterOps = new HashSet<String>();

    public static void showEntryFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, int currentRowIndex, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = (String)dataModel.getValue(filterJsonKey, currentRowIndex);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("freeze_filtercondition");
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetEntryCondition(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        String rowIndex = pageCache.get("rowIndex");
        dataModel.setValue(filterDesc, (Object)destValueShow, Integer.parseInt(rowIndex));
        dataModel.setValue(filterJson, (Object)returnData, Integer.parseInt(rowIndex));
        dataModel.setValue(filterFormula, (Object)scripts[0], Integer.parseInt(rowIndex));
    }

    public static void setOperationItems(IDataModel dataModel, IFormView view, String entityKey, String operationKey) {
        DynamicObject entity = dataModel.getDataEntity().getDynamicObject(entityKey);
        ComboEdit opEdit = (ComboEdit)view.getControl(operationKey);
        if (entity == null) {
            opEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map operation : operations) {
            String opType = (String)operation.get("type");
            if (filterOps.contains(opType)) continue;
            String opKey = (String)operation.get("key");
            Map opName = (Map)operation.get("name");
            comboItems.add(new ComboItem(LocaleString.fromMap((Map)opName), opKey));
        }
        opEdit.setComboItems(comboItems);
    }

    static {
        filterOps.add("save");
        filterOps.add("delete");
    }
}

