/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.filter;

import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BillFilter {
    public static DynamicObject[] filter(DynamicObject[] bills, String entryName, String filterExpression) {
        if (ObjectUtils.isEmpty((Object)bills)) {
            return new DynamicObject[0];
        }
        if (StringUtils.isBlank((CharSequence)filterExpression)) {
            return bills;
        }
        MainEntityType mainEntityType = (MainEntityType)bills[0].getDataEntityType();
        return (DynamicObject[])Stream.of(bills).filter(item -> BillFilter.checkHighCondition(mainEntityType, item, filterExpression)).toArray(DynamicObject[]::new);
    }

    public static boolean checkHighCondition(MainEntityType mainEntityType, DynamicObject dynamicObject, String filterExpression) {
        if (StringUtils.isBlank((CharSequence)filterExpression)) {
            return true;
        }
        String entryName = dynamicObject.getDataEntityType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, mainEntityType);
        ExpressionParameter expressionParameter = new ExpressionParameter(filterExpression, rowDataModel);
        expressionParameter.setFcunLib(FunctionManage.get());
        expressionParameter.setActiveRow((Object)dynamicObject);
        return (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)expressionParameter);
    }

    public static QFilter generateQFilter(String entityNumber, String jsonFilter) {
        if (StringUtils.isBlank((CharSequence)jsonFilter)) {
            return null;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonFilter, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }
}

