/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.form.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.formula.FormulaEngine;

public class FilterConditionEditPlugin
extends FormulaEdit
implements TreeNodeClickListener {
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition fc = filterGridState.getFilterCondition();
            fc.getFilterRow().clear();
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setFilterColumns(filterColumns);
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.SetValue(fc);
            this.getView().updateView("filtergridap");
        }
    }

    public void afterBindData(EventObject e) {
        CRCondition crCondition;
        super.afterBindData(e);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (StringUtils.isNotBlank((CharSequence)filterJson) && (crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterJson, CRCondition.class)) != null) {
            FilterCondition filterCondition = crCondition.getFilterCondition();
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    protected CRFormula deserialize(String json) {
        CRCondition conditionObj = null;
        conditionObj = StringUtils.isBlank((CharSequence)json) ? new CRCondition() : (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
        return conditionObj;
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        super.getFormulaObj(formulaObj);
        CRCondition conditionObj = (CRCondition)formulaObj;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        conditionObj.setFilterCondition(filterGridState.getFilterCondition());
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = super.tranFormula(formulaObj);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>(10);
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                String script = scripts[1];
                String scriptExpr = script.replace(" and ", ResManager.loadKDString((String)"\u4e14", (String)"FilterConditionEditPlugin_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
                descs.add(scriptExpr);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)(" " + ResManager.loadKDString((String)"\u4e14", (String)"FilterConditionEditPlugin_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]) + " "));
        }
        return tranExpr;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if ("".equals(currNodeId) || "billentrykey".equals(currNodeId) || "billsubentrykey".equals(currNodeId) || currNodeId.equals(entityNumber) || "billhead".equals(currNodeId)) {
            return;
        }
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)currNodeId);
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length != 0 && !StringUtils.isBlank((CharSequence)vars[0])) {
            String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
            TreeNode rootNode = new TreeNode();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            }
            ArrayList<String> orderVars = new ArrayList<String>(10);
            int len = vars.length;
            String varElement2 = "";
            for (int m = 0; m < len; ++m) {
                varElement2 = vars[m];
                orderVars.add(varElement2);
            }
            orderVars.sort((o1, o2) -> {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return o1.length() < o2.length() ? 1 : o2.compareTo((String)o1);
            });
            HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
            len = 1;
            for (String varElement2 : orderVars) {
                String tempVariable = String.format("###%s###", len);
                List childPathNodes = rootNode.getChildPathNodes(varElement2);
                StringBuilder chineseContent = new StringBuilder();
                int pathCount = childPathNodes.size();
                for (int k = 0; k < pathCount; ++k) {
                    TreeNode tn;
                    if (k == 0 || "billhead".equals((tn = (TreeNode)childPathNodes.get(k)).getId())) continue;
                    chineseContent.append(tn.getText());
                    if (k >= pathCount - 1) continue;
                    chineseContent.append('.');
                }
                tmpVariables.put(tempVariable, chineseContent.toString());
                expressionDesc = expressionDesc.replace(varElement2, tempVariable);
                ++len;
            }
            for (Map.Entry tmpVariable : tmpVariables.entrySet()) {
                expressionDesc = expressionDesc.replace((CharSequence)tmpVariable.getKey(), (CharSequence)tmpVariable.getValue());
            }
            return expressionDesc;
        }
        return expression;
    }
}

