/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.biz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;

public class LotMainFileOperateGenerator {
    private static Long ERRORLOTID = -1L;
    private static Long NOTGENLOTID = 0L;
    private boolean dynamicObjectMode = false;
    private DynamicObject cfg;
    private List<Long> billIds;
    private Map<String, Set<Long>> hasHandleBillMap;
    private Set<Long> hasHandleBillIds;
    private Set<Long> handleBillIds;
    private DynamicObject billObj;
    private Long pseudoEntryid = -1L;
    private Long masterfiletypeid;
    private String billtype;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private String parantEntrypath;
    private String billnocol;
    private String seqcol;
    private String parantSeqcol;
    private String lotidcol;
    private String lotnumcol;
    private String materialcol;
    private String materialmastercol;
    private String materialtype;
    private String invorgcol;
    private LinkedHashMap<String, DynamicObject> lotmainfMaps;
    private Map<Long, DynamicObject> billentriesMap;
    private Integer unqCtrl;

    public static LotMainFileOperateGenerator build(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        return new LotMainFileOperateGenerator(cfg, billIds, operate, hasHandleBillMap);
    }

    public static LotMainFileOperateGenerator buildBySingleDynamicObject(DynamicObject cfg, DynamicObject billObj, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        return new LotMainFileOperateGenerator(cfg, billObj, operate, hasHandleBillMap);
    }

    private LotMainFileOperateGenerator(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        this.cfg = cfg;
        this.billIds = billIds;
        this.hasHandleBillMap = hasHandleBillMap;
        this.buildOperator();
    }

    private LotMainFileOperateGenerator(DynamicObject cfg, DynamicObject billObj, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        this.cfg = cfg;
        this.billIds = Collections.singletonList((Long)billObj.getPkValue());
        this.hasHandleBillMap = hasHandleBillMap;
        this.dynamicObjectMode = true;
        this.billObj = billObj;
        this.buildOperator();
    }

    private void buildOperator() {
        this.masterfiletypeid = this.cfg.getDynamicObject("masterfiletype").getLong("id");
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.entrytype = this.cfg.getString("srcbillentry");
        this.parantEntrypath = LotMainFileConfigHelper.getParentEntryName(this.billtype, this.entrytype);
        if (this.parantEntrypath != null) {
            this.parantSeqcol = this.parantEntrypath + ".seq";
            this.entrypath = this.parantEntrypath + '.' + this.entrytype;
        } else {
            this.entrypath = this.entrytype;
        }
        this.entrypathId = this.entrypath + ".id";
        this.seqcol = this.entrypath + ".seq";
        this.lotidcol = this.cfg.getString("lotidfield");
        this.hasHandleBillIds = this.hasHandleBillMap.getOrDefault(this.lotidcol, new HashSet(this.billIds.size()));
        this.handleBillIds = new HashSet<Long>(this.billIds);
        this.handleBillIds.removeAll(this.hasHandleBillIds);
        if (this.handleBillIds.isEmpty()) {
            this.billentriesMap = Collections.emptyMap();
            return;
        }
        this.billnocol = "billno";
        this.materialcol = LotMainFileConfigHelper.getParamField(this.cfg, "material");
        this.materialmastercol = this.materialcol + ".masterid";
        this.materialtype = LotMainFileConfigHelper.getBasedataTabletype(this.billtype, this.materialcol);
        this.invorgcol = LotMainFileConfigHelper.getParamField(this.cfg, "createorg");
        this.lotnumcol = LotMainFileConfigHelper.getParamField(this.cfg, "number");
        this.lotmainfMaps = LotMainFileConfigHelper.getLotmainfMaps(this.cfg);
        this.lotmainfMaps.remove("material");
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = null;
        if (this.dynamicObjectMode) {
            Map<String, Object> colDefaultValues = LotMainFileConfigHelper.getColDefaultValues(this.lotmainfMaps);
            billentries = this.buildBillentriesFromSingleDynamicObj(billSelectProps, colDefaultValues);
        } else {
            QFilter filter = this.buildBillFilter();
            billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        }
        this.billentriesMap = new HashMap<Long, DynamicObject>(billentries.size());
        if (billentries != null && billentries.size() > 0) {
            this.handleBillIds.clear();
            for (DynamicObject billentry : billentries) {
                Long billId = billentry.getLong("id");
                Long entryId = billentry.getLong(this.entrypathId);
                this.hasHandleBillIds.add(billId);
                this.handleBillIds.add(billId);
                this.billentriesMap.put(entryId, billentry);
            }
            if (!this.hasHandleBillMap.containsKey(this.entrytype)) {
                this.hasHandleBillMap.put(this.entrytype, this.hasHandleBillIds);
            }
        }
    }

    private QFilter buildBillFilter() {
        QFilter filter = new QFilter("id", "in", this.handleBillIds);
        if ("bd_materialinventoryinfo".equals(this.materialtype)) {
            filter.and(this.materialcol + ".enablelot", "=", (Object)Boolean.TRUE);
        }
        filter.and(this.lotidcol, "=", (Object)0);
        filter.and(this.lotnumcol, "is not null", null);
        filter.and(this.lotnumcol, "!=", (Object)"");
        QFilter cfgFilter = LotMainFileConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype);
        if (cfgFilter != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private Set<String> getBillDynamicCols() {
        HashSet<String> selectSourceCols = new HashSet<String>(this.lotmainfMaps.size() + 1);
        selectSourceCols.add(this.billnocol);
        if (this.lotmainfMaps.size() > 0) {
            for (Map.Entry<String, DynamicObject> entry : this.lotmainfMaps.entrySet()) {
                selectSourceCols.add(entry.getValue().getString("mainfsrcbillcol"));
            }
        }
        return selectSourceCols;
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId);
        selectPropsBuilder.append(',').append(this.seqcol);
        if (this.parantEntrypath != null) {
            selectPropsBuilder.append(',').append(this.parantSeqcol);
        }
        Set<String> selectSourceCols = this.getBillDynamicCols();
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        selectPropsBuilder.append(',').append(this.materialmastercol);
        return selectPropsBuilder.toString();
    }

    public void genLotMainFileExec(Map<String, Map<String, Long>> allLotnumMap, Map<String, Map<String, Map<String, Long>>> allLotMatchMap) {
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        this.unqCtrl = LotMainFileConfigHelper.getUnqctrl();
        try (TXHandle tx = TX.requiresNew();
             DataSet lotMainFileDataSet = this.getBillLotMainFileDataSet();){
            this.saveLotMainFileData(lotMainFileDataSet, allLotnumMap, allLotMatchMap);
        }
    }

    private DataSet getBillLotMainFileDataSet() {
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("billid", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("seq", (DataType)DataType.IntegerType), new Field("parentseq", (DataType)DataType.IntegerType), new Field("materialmasterid", (DataType)DataType.LongType), new Field("invorgid", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType), new Field("lotnumUnq", (DataType)DataType.StringType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<String> lotnums = new HashSet<String>(this.billentriesMap.size());
        for (DynamicObject billentry : this.billentriesMap.values()) {
            Long materialmasterid = billentry.getLong(this.materialmastercol);
            Long invorgid = billentry.getLong(this.invorgcol);
            String lotnum = billentry.getString(this.lotnumcol);
            String lotnumUnq = this.buildUnqstr(lotnum, materialmasterid, invorgid);
            Long billid = billentry.getLong("id");
            String billno = billentry.getString(this.billnocol);
            Long billentryid = billentry.getLong(this.entrypathId);
            Integer seq = billentry.getInt(this.seqcol);
            Integer parentseq = 0;
            if (this.parantEntrypath != null) {
                parentseq = billentry.getInt(this.parantSeqcol);
            }
            lotnums.add(lotnum);
            billentryDsBuilder.append(new Object[]{billentryid, billid, billno, seq, parentseq, materialmasterid, invorgid, lotnum, lotnumUnq});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        if (lotnums.isEmpty()) {
            return billentryDataSet;
        }
        DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mfnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "in", lotnums).and("masterfiletype", "=", (Object)this.masterfiletypeid).toArray(), (String)"");
        JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mfnumber");
        if (this.unqCtrl == 2 || this.unqCtrl == 4) {
            tempDataSet.on("materialmasterid", "mfmaterialid");
        }
        if (this.unqCtrl == 3 || this.unqCtrl == 4) {
            tempDataSet.on("invorgid", "mfinvorg");
        }
        DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
        return billLotRelWithMatDataSet;
    }

    private void saveLotMainFileData(DataSet lotMainFileDataSet, Map<String, Map<String, Long>> allLotnumMap, Map<String, Map<String, Map<String, Long>>> allLotMatchMap) {
        Boolean genlot = this.cfg.getBoolean("genlot");
        String lotMainfInsertSql = this.buildLotMainFileInsertSql();
        ArrayList<Object[]> lotMainFileInsertParams = new ArrayList<Object[]>(1000);
        long[] mainfileids = null;
        int mainfileidsIdx = 0;
        String lotidIdent = LotMainFileConfigHelper.getIdent(this.lotidcol);
        for (Row row : lotMainFileDataSet) {
            Long mfmaterialid;
            String billno = row.getString("billno");
            Integer seq = row.getInteger("seq");
            Integer parentseq = row.getInteger("parentseq");
            String billentrykey = null;
            billentrykey = this.parantEntrypath != null ? this.parantEntrypath + '.' + parentseq + '.' + this.entrytype + '.' + seq : this.entrytype + '.' + seq;
            Map billMatchMap = allLotMatchMap.getOrDefault(billno, new HashMap());
            Map billentryMatchMap = billMatchMap.getOrDefault(billentrykey, new HashMap());
            Long mainfileid = row.getLong("mainfileid");
            Long materialmasterid = row.getLong("materialmasterid");
            String lotnumUnq = row.getString("lotnumUnq");
            if (allLotnumMap.containsKey(lotnumUnq)) {
                Map<String, Long> lotnumAttrs = allLotnumMap.get(lotnumUnq);
                mainfileid = lotnumAttrs.get("mainfileid");
                mfmaterialid = lotnumAttrs.get("materialmasterid");
                if (!materialmasterid.equals(mfmaterialid)) {
                    billentryMatchMap.put(lotidIdent, ERRORLOTID);
                } else {
                    billentryMatchMap.put(lotidIdent, mainfileid);
                }
            } else {
                boolean recLotnumMap = true;
                if (LotMainFileOperateGenerator.isEmpty(mainfileid)) {
                    if (genlot.booleanValue()) {
                        if (mainfileids == null) {
                            mainfileids = LotMainFileConfigHelper.batchGenId("t_bd_lot", this.billentriesMap.size());
                        }
                        mainfileid = mainfileidsIdx < mainfileids.length ? Long.valueOf(mainfileids[mainfileidsIdx]) : Long.valueOf(LotMainFileConfigHelper.genId("t_bd_lot"));
                        ++mainfileidsIdx;
                        Object[] snmainfInsertParam = this.genLotMainFileInsertParam(row, mainfileid);
                        lotMainFileInsertParams.add(snmainfInsertParam);
                        if (lotMainFileInsertParams.size() == 1000) {
                            LotMainFileOperateGenerator.executeBatchSql(lotMainFileInsertParams, lotMainfInsertSql);
                        }
                        billentryMatchMap.put(lotidIdent, mainfileid);
                    } else {
                        billentryMatchMap.putIfAbsent(lotidIdent, NOTGENLOTID);
                        recLotnumMap = false;
                    }
                } else {
                    mfmaterialid = row.getLong("mfmaterialid");
                    if (!materialmasterid.equals(mfmaterialid)) {
                        billentryMatchMap.put(lotidIdent, ERRORLOTID);
                        materialmasterid = mfmaterialid;
                    } else {
                        billentryMatchMap.put(lotidIdent, mainfileid);
                    }
                }
                if (recLotnumMap) {
                    HashMap<String, Long> lotnumAttrs = new HashMap<String, Long>(2);
                    lotnumAttrs.put("materialmasterid", materialmasterid);
                    lotnumAttrs.put("mainfileid", mainfileid);
                    allLotnumMap.put(lotnumUnq, lotnumAttrs);
                }
            }
            if (!billMatchMap.containsKey(billentrykey)) {
                billMatchMap.put(billentrykey, billentryMatchMap);
            }
            if (allLotMatchMap.containsKey(billno)) continue;
            allLotMatchMap.put(billno, billMatchMap);
        }
        if (lotMainFileInsertParams.size() > 0) {
            LotMainFileOperateGenerator.executeBatchSql(lotMainFileInsertParams, lotMainfInsertSql);
        }
    }

    private String buildUnqstr(String lotnum, Long materialmasterid, Long invorgid) {
        StringBuilder unqstrbuilder = new StringBuilder(lotnum);
        if (this.unqCtrl == 2 || this.unqCtrl == 4) {
            unqstrbuilder.append('.').append(materialmasterid);
        } else {
            unqstrbuilder.append(".0");
        }
        if (this.unqCtrl == 3 || this.unqCtrl == 4) {
            unqstrbuilder.append('.').append(invorgid);
        } else {
            unqstrbuilder.append(".0");
        }
        return unqstrbuilder.toString();
    }

    private Object[] genLotMainFileInsertParam(Row row, Long mainfileid) {
        Object[] lotMainFileInsertParam = new Object[9 + this.lotmainfMaps.size()];
        lotMainFileInsertParam[0] = mainfileid;
        lotMainFileInsertParam[1] = "B";
        lotMainFileInsertParam[2] = row.getLong("materialmasterid");
        lotMainFileInsertParam[3] = "1";
        lotMainFileInsertParam[4] = "C";
        lotMainFileInsertParam[5] = new Date();
        lotMainFileInsertParam[6] = this.masterfiletypeid;
        lotMainFileInsertParam[7] = mainfileid;
        Long entryid = row.getLong("billentryid");
        DynamicObject billentry = this.billentriesMap.get(entryid);
        int i = 9;
        DynamicObject orgColumn = this.lotmainfMaps.get("createorg");
        for (Map.Entry<String, DynamicObject> entry : this.lotmainfMaps.entrySet()) {
            String lotMainFileCol = entry.getKey();
            String srcBillCol = entry.getValue().getString("mainfsrcbillcol");
            if (orgColumn != null && lotMainFileCol.equals(orgColumn.getString("mainfcol"))) {
                lotMainFileInsertParam[8] = billentry.get(srcBillCol);
            }
            lotMainFileInsertParam[i] = billentry.get(srcBillCol);
            ++i;
        }
        if (lotMainFileInsertParam[8] == null) {
            lotMainFileInsertParam[8] = 0L;
        }
        return lotMainFileInsertParam;
    }

    private String buildLotMainFileInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_lot(").append("fid,flotstatus,fmaterialid,fenable,fstatus,fcreatetime,fmasterfiletypeid,fmasterid,fcurrentorgid");
        if (this.lotmainfMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lot").getAllFields();
            for (String tarcol : this.lotmainfMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(9 + this.lotmainfMaps.size(), "?"))).append(')');
        return builder.toString();
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }

    private DynamicObjectCollection buildBillentriesFromSingleDynamicObj(String billSelectProps, Map<String, Object> colDefaultValues) {
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])new QFilter("id", "=", (Object)-1).toArray());
        if (this.parantEntrypath != null) {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(this.parantEntrypath)) {
                for (DynamicObject subentryObj : entryObj.getDynamicObjectCollection(this.entrytype)) {
                    this.fillDynamicValToBillentries(billentries, this.billObj, subentryObj, entryObj.getInt("seq"), colDefaultValues);
                }
            }
        } else {
            for (DynamicObject entryObj : this.billObj.getDynamicObjectCollection(this.entrytype)) {
                this.fillDynamicValToBillentries(billentries, this.billObj, entryObj, null, colDefaultValues);
            }
        }
        return billentries;
    }

    private void fillDynamicValToBillentries(DynamicObjectCollection billentries, DynamicObject billObj, DynamicObject entryObj, Integer parantseq, Map<String, Object> colDefaultValues) {
        Object materialObj = LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, this.materialcol, false);
        if (materialObj != null) {
            DynamicObject material = (DynamicObject)materialObj;
            if ("bd_materialinventoryinfo".equals(this.materialtype) && !material.getBoolean("enablelot")) {
                return;
            }
            Long lotid = (Long)LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, this.lotidcol, true);
            String lotnum = (String)LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, this.lotnumcol, true);
            if (LotMainFileOperateGenerator.isEmpty(lotid) && !StringUtils.isEmpty((String)lotnum)) {
                DynamicObject billentry = billentries.addNew();
                billentry.set("id", billObj.get("id"));
                Long entryid = (Long)LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, this.entrypathId, true);
                if (LotMainFileOperateGenerator.isEmpty(entryid)) {
                    entryid = this.pseudoEntryid;
                    Long l = this.pseudoEntryid;
                    Long l2 = this.pseudoEntryid = Long.valueOf(this.pseudoEntryid - 1L);
                }
                billentry.set(this.entrypathId, (Object)entryid);
                billentry.set(this.seqcol, LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, this.seqcol, true));
                if (this.parantEntrypath != null) {
                    billentry.set(this.parantSeqcol, (Object)parantseq);
                }
                for (String col : this.getBillDynamicCols()) {
                    billentry.set(col, LotMainFileConfigHelper.getDynamicVal(billObj, entryObj, col, true));
                    Object realValue = billentry.get(col);
                    if (realValue != null) continue;
                    billentry.set(col, colDefaultValues.get(col));
                }
                billentry.set(this.materialmastercol, (Object)material.getDynamicObject("masterid").getLong("id"));
            }
        }
    }
}

