/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.biz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;

public class LotMainFileOperator {
    private DynamicObject cfg;
    private List<Long> billIds;
    private Map<String, Set<Long>> hasHandleBillMap;
    private Set<Long> hasHandleBillIds;
    private Set<Long> handleBillIds;
    private String billtype;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private String lotidcol;
    private String seqcol;
    private String materialcol;
    private String materialtype;
    private String firstindatecol;
    private LinkedHashMap<String, DynamicObject> lotmainfMaps;
    private LinkedHashMap<String, String> trackMaps;
    private Map<Long, DynamicObject> billentriesMap;
    private static final String mainFileColFlag = "m_";

    public static LotMainFileOperator build(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        return new LotMainFileOperator(cfg, billIds, operate, hasHandleBillMap);
    }

    private LotMainFileOperator(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        this.cfg = cfg;
        this.billIds = billIds;
        this.hasHandleBillMap = hasHandleBillMap;
        this.buildOperator();
    }

    private void buildOperator() {
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.entrytype = this.cfg.getString("srcbillentry");
        this.entrypath = LotMainFileConfigHelper.getEntryPath(this.billtype, this.entrytype);
        this.entrypathId = this.entrypath + ".id";
        this.lotidcol = this.cfg.getString("lotidfield");
        this.seqcol = this.entrypath + ".seq";
        this.materialcol = LotMainFileConfigHelper.getParamField(this.cfg, "material");
        this.materialtype = LotMainFileConfigHelper.getBasedataTabletype(this.billtype, this.materialcol);
        this.firstindatecol = LotMainFileConfigHelper.getParamField(this.cfg, "instockdate");
        String identkey = this.lotidcol + '-' + this.cfg.getString("movedirection");
        this.hasHandleBillIds = this.hasHandleBillMap.getOrDefault(identkey, new HashSet(this.billIds.size()));
        this.handleBillIds = new HashSet<Long>(this.billIds);
        this.handleBillIds.removeAll(this.hasHandleBillIds);
        if (this.handleBillIds.isEmpty()) {
            this.billentriesMap = Collections.emptyMap();
            return;
        }
        this.lotmainfMaps = LotMainFileConfigHelper.getLotmainfMaps(this.cfg);
        this.lotmainfMaps.remove("number");
        this.lotmainfMaps.remove("material");
        this.lotmainfMaps.remove("createorg");
        this.lotmainfMaps.remove("creator");
        this.lotmainfMaps.remove("instockdate");
        this.trackMaps = LotMainFileConfigHelper.getTrackMaps(this.cfg);
        QFilter filter = this.buildBillFilter();
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        this.billentriesMap = new HashMap<Long, DynamicObject>(billentries.size());
        if (billentries != null && billentries.size() > 0) {
            this.handleBillIds.clear();
            for (DynamicObject billentry : billentries) {
                Long billId = billentry.getLong("id");
                Long entryId = billentry.getLong(this.entrypathId);
                this.hasHandleBillIds.add(billId);
                this.handleBillIds.add(billId);
                this.billentriesMap.put(entryId, billentry);
            }
            if (!this.hasHandleBillMap.containsKey(identkey)) {
                this.hasHandleBillMap.put(identkey, this.hasHandleBillIds);
            }
        }
    }

    private QFilter buildBillFilter() {
        QFilter filter = new QFilter("id", "in", this.handleBillIds);
        if ("bd_materialinventoryinfo".equals(this.materialtype)) {
            filter.and(this.materialcol + ".enablelot", "=", (Object)Boolean.TRUE);
        }
        filter.and(this.lotidcol, "!=", (Object)0);
        QFilter cfgFilter = LotMainFileConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype);
        if (cfgFilter != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId);
        HashSet<String> selectSourceCols = new HashSet<String>(this.lotmainfMaps.size() + this.trackMaps.size() + 3);
        selectSourceCols.add(this.lotidcol);
        selectSourceCols.add(this.firstindatecol);
        selectSourceCols.add(this.seqcol);
        if (this.lotmainfMaps.size() > 0) {
            for (Map.Entry<String, DynamicObject> entry : this.lotmainfMaps.entrySet()) {
                selectSourceCols.add(entry.getValue().getString("mainfsrcbillcol"));
            }
        }
        if (this.trackMaps.size() > 0) {
            selectSourceCols.addAll(this.trackMaps.values());
        }
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        return selectPropsBuilder.toString();
    }

    public void operateExec() {
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();
             DataSet billLotDataSet = this.getDataSet();){
            this.operateData(billLotDataSet);
        }
    }

    private DataSet getDataSet() {
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("lotid", (DataType)DataType.LongType), new Field("entryseq", (DataType)DataType.IntegerType), new Field("billid", (DataType)DataType.LongType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<Long> lotids = new HashSet<Long>(this.billentriesMap.size());
        for (DynamicObject billentry : this.billentriesMap.values()) {
            Long billentryid = billentry.getLong(this.entrypathId);
            Long lotid = billentry.getLong(this.lotidcol);
            Integer entryseq = billentry.getInt(this.seqcol);
            Long billid = billentry.getLong("id");
            lotids.add(lotid);
            billentryDsBuilder.append(new Object[]{billentryid, lotid, entryseq, billid});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        StringBuilder selectCol = new StringBuilder();
        selectCol.append("id as mainfileid,lotstatus,instockdate, currentorgid as srcbizorg");
        if (this.lotmainfMaps != null && this.lotmainfMaps.size() > 0) {
            for (String col : this.lotmainfMaps.keySet()) {
                selectCol.append(",").append(col).append(" as ").append(mainFileColFlag).append(col);
            }
        }
        DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lot", (String)selectCol.toString(), (QFilter[])new QFilter("id", "in", lotids).toArray(), (String)"");
        DataSet billLotDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotid", "mainfileid").select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
        DataSet moveTrackDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lotmovetrack", (String)"id as trackid,lot as track_lotid,billentryid as track_billentryid", (QFilter[])new QFilter("lot", "in", lotids).and("billid", "in", this.handleBillIds).and("billentity", "=", (Object)this.billtype).and("billentrytype", "=", (Object)this.entrytype).and("movedirect", "=", (Object)this.cfg.getString("movedirection")).and("lotidfield", "=", (Object)this.lotidcol).toArray(), (String)"");
        billLotDataSet = billLotDataSet.leftJoin(moveTrackDataSet).on("lotid", "track_lotid").on("billentryid", "track_billentryid").select(billLotDataSet.getRowMeta().getFieldNames(), new String[]{"trackid"}).finish();
        return billLotDataSet.orderBy(new String[]{"billid", "entryseq desc"});
    }

    private void operateData(DataSet billLotDataSet) {
        String movedirection = this.cfg.getString("movedirection");
        Boolean genlot = this.cfg.getBoolean("genlot");
        String mainfUpdateSql = this.buildMainfUpdateSql();
        ArrayList<Object[]> mainfUpdateParams = new ArrayList<Object[]>(1000);
        String trackInsertSql = this.buildTrackInsertSql();
        ArrayList<Object[]> trackInsertParams = new ArrayList<Object[]>(1000);
        String trackUpdateSql = this.buildTrackUpdateSql();
        ArrayList<Object[]> trackUpdateParams = new ArrayList<Object[]>(1000);
        HashSet<Long> lotids = new HashSet<Long>(this.billentriesMap.size());
        long[] trackids = null;
        int trackidsIdx = 0;
        for (Row row : billLotDataSet) {
            Long entryid = row.getLong("billentryid");
            Long lotid = row.getLong("lotid");
            Long hisTrackid = row.getLong("trackid");
            Integer entryseq = row.getInteger("entryseq");
            Long srcbizorg = row.getLong("srcbizorg");
            if (genlot.booleanValue()) {
                if (!lotids.contains(lotid)) {
                    String lotstatus = row.getString("lotstatus");
                    Date instockdate = row.getDate("instockdate");
                    Object[] mainfUpdateParam = this.genMainfUpdateParam(row, lotid, entryid, lotstatus, instockdate, movedirection, srcbizorg);
                    mainfUpdateParams.add(mainfUpdateParam);
                    if (mainfUpdateParams.size() == 1000) {
                        LotMainFileOperator.executeBatchSql(mainfUpdateParams, mainfUpdateSql);
                    }
                }
                lotids.add(lotid);
            }
            if (this.trackMaps.size() <= 0) continue;
            if (hisTrackid != null && !hisTrackid.equals(0L)) {
                Object[] trackUpdateParam = this.genTrackUpdateParam(hisTrackid, movedirection, entryid);
                trackUpdateParams.add(trackUpdateParam);
                if (trackUpdateParams.size() != 1000) continue;
                LotMainFileOperator.executeBatchSql(trackUpdateParams, trackUpdateSql);
                continue;
            }
            if (trackids == null) {
                trackids = LotMainFileConfigHelper.batchGenId("t_bd_lotmovetrack", this.billentriesMap.size());
            }
            long trackid = trackidsIdx < trackids.length ? trackids[trackidsIdx] : LotMainFileConfigHelper.genId("t_bd_lotmovetrack");
            ++trackidsIdx;
            Object[] trackInsertParam = this.genTrackInsertParam(trackid, lotid, movedirection, entryid, entryseq);
            trackInsertParams.add(trackInsertParam);
            if (trackInsertParams.size() != 1000) continue;
            LotMainFileOperator.executeBatchSql(trackInsertParams, trackInsertSql);
        }
        if (mainfUpdateParams.size() > 0) {
            LotMainFileOperator.executeBatchSql(mainfUpdateParams, mainfUpdateSql);
        }
        if (trackInsertParams.size() > 0) {
            LotMainFileOperator.executeBatchSql(trackInsertParams, trackInsertSql);
        }
        if (trackUpdateParams.size() > 0) {
            LotMainFileOperator.executeBatchSql(trackUpdateParams, trackUpdateSql);
        }
    }

    private String buildMainfUpdateSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_lot set flotstatus = ?,finstockdate = ?, fcurrentorgid = ?");
        if (this.lotmainfMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lot").getAllFields();
            for (String tarcol : this.lotmainfMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias()).append(" = ?");
            }
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private Object[] genMainfUpdateParam(Row row, Long lotid, Long entryid, String lotstatus, Date instockdate, String movedirection, Long srcbizorg) {
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] mainfUpdateParam = new Object[4 + this.lotmainfMaps.size()];
        mainfUpdateParam[0] = "A";
        mainfUpdateParam[1] = "B".equals(lotstatus) ? billentry.get(this.firstindatecol) : instockdate;
        mainfUpdateParam[2] = "A".equals(movedirection) && this.trackMaps.size() > 0 ? billentry.get(this.trackMaps.get("srcbizorg")) : srcbizorg;
        int i = 3;
        Map mainFileProperties = EntityMetadataCache.getDataEntityType((String)"bd_lot").getAllFields();
        for (Map.Entry<String, DynamicObject> entry : this.lotmainfMaps.entrySet()) {
            String lotMainFileCol = entry.getKey();
            DynamicObject value = entry.getValue();
            String billCol = value.getString("mainfsrcbillcol");
            if ("2".equals(value.getString("updateconditon"))) {
                Object mainFileValue = row.get(mainFileColFlag + lotMainFileCol);
                IDataEntityProperty mainFileProperty = (IDataEntityProperty)mainFileProperties.get(lotMainFileCol);
                if (mainFileProperty instanceof LongProp) {
                    if (mainFileValue != null && !mainFileValue.equals(0L)) {
                        mainfUpdateParam[i++] = mainFileValue;
                        continue;
                    }
                } else if (mainFileProperty instanceof TextProp) {
                    if (mainFileValue != null && StringUtils.isNotEmpty((String)((String)mainFileValue))) {
                        mainfUpdateParam[i++] = mainFileValue;
                        continue;
                    }
                } else if (mainFileProperty instanceof DecimalProp) {
                    int scale = ((DecimalProp)mainFileProperty).getScale();
                    if (mainFileValue != null && !((BigDecimal)mainFileValue).setScale(scale, RoundingMode.HALF_UP).equals(BigDecimal.ZERO.setScale(scale, RoundingMode.HALF_UP))) {
                        mainfUpdateParam[i++] = mainFileValue;
                        continue;
                    }
                } else if (mainFileValue != null) {
                    mainfUpdateParam[i++] = mainFileValue;
                    continue;
                }
            }
            mainfUpdateParam[i++] = billentry.get(billCol);
        }
        mainfUpdateParam[i] = lotid;
        return mainfUpdateParam;
    }

    private String buildTrackInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_lotmovetrack(fid,flotid,fmovedirect,fbillentityid,fbillid,fbillentrytype,fbillentryid,flotidfield,fdseq,flotbillconfid,fcreatetime");
        if (this.trackMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lotmovetrack").getAllFields();
            for (String tarcol : this.trackMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(11 + this.trackMaps.size(), "?"))).append(')');
        return builder.toString();
    }

    private Object[] genTrackInsertParam(Long trackid, Long lotid, String movedirection, Long entryid, Integer entryseq) {
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] trackInsertParam = new Object[11 + this.trackMaps.size()];
        trackInsertParam[0] = trackid;
        trackInsertParam[1] = lotid;
        trackInsertParam[2] = movedirection;
        trackInsertParam[3] = this.billtype;
        trackInsertParam[4] = billentry.getLong("id");
        trackInsertParam[5] = this.entrytype;
        trackInsertParam[6] = entryid;
        trackInsertParam[7] = this.lotidcol;
        trackInsertParam[8] = entryseq;
        trackInsertParam[9] = this.cfg.getPkValue();
        trackInsertParam[10] = new Date();
        int i = 11;
        for (String srccol : this.trackMaps.values()) {
            trackInsertParam[i] = billentry.get(srccol);
            ++i;
        }
        return trackInsertParam;
    }

    private String buildTrackUpdateSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_lotmovetrack set fmovedirect = ?,flotbillconfid = ?");
        if (this.trackMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lotmovetrack").getAllFields();
            for (String tarcol : this.trackMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias()).append(" = ?");
            }
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private Object[] genTrackUpdateParam(Long trackid, String movedirection, Long entryid) {
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] trackUpdateParam = new Object[3 + this.trackMaps.size()];
        trackUpdateParam[0] = movedirection;
        trackUpdateParam[1] = this.cfg.getPkValue();
        int i = 2;
        for (String srccol : this.trackMaps.values()) {
            trackUpdateParam[i] = billentry.get(srccol);
            ++i;
        }
        trackUpdateParam[i] = trackid;
        return trackUpdateParam;
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }
}

