/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.biz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;

public class LotMainFileUnhandleOperator {
    private String billtype;
    private List<Long> handleBillids;
    private Set<Long> lotids;

    public static LotMainFileUnhandleOperator build(String billtype, List<Long> billids, String operate) {
        return new LotMainFileUnhandleOperator(billtype, billids, operate);
    }

    private LotMainFileUnhandleOperator(String billtype, List<Long> billids, String operate) {
        this.billtype = billtype;
        this.handleBillids = billids;
    }

    public void operateExec() {
        block24: {
            try (TXHandle tx = TX.requiresNew();){
                this.lotids = this.getHandleLots();
                DeleteServiceHelper.delete((String)"bd_lotmovetrack", (QFilter[])new QFilter("billid", "in", this.handleBillids).and("billentity", "=", (Object)this.billtype).toArray());
                if (this.lotids.size() <= 0) break block24;
                try (DataSet billLotDataSet = this.getUnauditDataSet();){
                    this.operateDataUnaudit(billLotDataSet);
                }
            }
        }
    }

    private Set<Long> getHandleLots() {
        HashSet<Long> lotids = new HashSet<Long>();
        try (DataSet lotDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lotmovetrack", (String)"lot", (QFilter[])new QFilter("billid", "in", this.handleBillids).and("billentity", "=", (Object)this.billtype).and("movedirect", "=", (Object)"A").toArray(), (String)"");){
            for (Row row : lotDataSet) {
                lotids.add(row.getLong("lot"));
            }
        }
        return lotids;
    }

    private DataSet getUnauditDataSet() {
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("lotid", (DataType)DataType.LongType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        for (Long lotid : this.lotids) {
            billentryDsBuilder.append(new Object[]{lotid});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet lotTrackDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lotmovetrack", (String)"lot as mainfileid,id", (QFilter[])new QFilter("lot", "in", this.lotids).toArray(), (String)"").groupBy(new String[]{"mainfileid"}).count("id").finish();
        DataSet billLotDataSet = billentryDataSet.leftJoin(lotTrackDataSet).on("lotid", "mainfileid").select(new String[]{"lotid", "id as count"}).finish();
        return billLotDataSet;
    }

    private void operateDataUnaudit(DataSet billLotDataSet) {
        HashSet<Long> disableLots = new HashSet<Long>(this.lotids.size());
        HashSet<Long> updateLots = new HashSet<Long>(this.lotids.size());
        for (Row row : billLotDataSet) {
            Long lotid = row.getLong("lotid");
            Integer count = row.getInteger("count");
            if (count == null || count.equals(0)) {
                disableLots.add(lotid);
                continue;
            }
            updateLots.add(lotid);
        }
        if (disableLots.size() > 0) {
            SqlBuilder disableLotSqlBuilder = new SqlBuilder();
            disableLotSqlBuilder.append("update t_bd_lot set flotstatus = ?", new Object[]{"B"}).append(" where ", new Object[0]).appendIn("fid", disableLots.toArray());
            DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)disableLotSqlBuilder);
        }
        if (updateLots.size() > 0) {
            Map<Long, List<Map<String, Long>>> cfgLotEntriesMap = this.getCfgLotEntriesMap(updateLots);
            Map unauditCfgs = BusinessDataServiceHelper.loadFromCache((Object[])cfgLotEntriesMap.keySet().toArray(), (String)"msmod_lotbillconf");
            for (Map.Entry<Long, List<Map<String, Long>>> cfgLotEntry : cfgLotEntriesMap.entrySet()) {
                Long cfgid = cfgLotEntry.getKey();
                DynamicObject unauditCfg = (DynamicObject)unauditCfgs.get(cfgid);
                if (unauditCfg == null) continue;
                List<Map<String, Long>> lotEntriesList = cfgLotEntry.getValue();
                this.handleLotmainfRefresh(unauditCfg, lotEntriesList);
            }
        }
    }

    private Map<Long, List<Map<String, Long>>> getCfgLotEntriesMap(Set<Long> updateLots) {
        HashSet lastTrkIds = new HashSet(updateLots.size());
        try (DataSet lotTrackIdDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lotmovetrack", (String)"lot as lotid,id as trackid", (QFilter[])new QFilter("lot", "in", updateLots).and("movedirect", "=", (Object)"A").toArray(), (String)"").groupBy(new String[]{"lotid"}).max("trackid").finish();){
            lotTrackIdDataSet.forEach(row -> lastTrkIds.add(row.getLong("trackid")));
        }
        HashMap<Long, List<Map<String, Long>>> cfgLotEntriesMap = new HashMap<Long, List<Map<String, Long>>>();
        try (DataSet lotTrackDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lotmovetrack", (String)"lot,lotbillconf,billentity,billid,billentrytype,billentryid,lotidfield,srcbizorg", (QFilter[])new QFilter("id", "in", lastTrkIds).toArray(), (String)"");){
            for (Row row2 : lotTrackDataSet) {
                Long cfgid = row2.getLong("lotbillconf");
                Long lotid = row2.getLong("lot");
                Long billid = row2.getLong("billid");
                Long entryid = row2.getLong("billentryid");
                Long srcbizorg = row2.getLong("srcbizorg");
                List lotEntriesList = cfgLotEntriesMap.getOrDefault(cfgid, new ArrayList());
                HashMap<String, Long> lotEntryItem = new HashMap<String, Long>(3);
                lotEntryItem.put("lotid", lotid);
                lotEntryItem.put("billid", billid);
                lotEntryItem.put("entryid", entryid);
                lotEntryItem.put("srcbizorg", srcbizorg);
                lotEntriesList.add(lotEntryItem);
                if (cfgLotEntriesMap.containsKey(cfgid)) continue;
                cfgLotEntriesMap.put(cfgid, lotEntriesList);
            }
        }
        return cfgLotEntriesMap;
    }

    private void handleLotmainfRefresh(DynamicObject unauditCfg, List<Map<String, Long>> lotEntriesList) {
        LinkedHashMap<String, DynamicObject> lotmainfMaps = this.getLotmainfMaps(unauditCfg);
        if (lotmainfMaps == null || lotmainfMaps.size() == 0) {
            return;
        }
        HashSet<Long> billids = new HashSet<Long>(lotEntriesList.size());
        HashSet<Long> entryids = new HashSet<Long>(lotEntriesList.size());
        HashMap<Long, Long> entrylotMap = new HashMap<Long, Long>(lotEntriesList.size());
        HashMap<Long, Long> entrysrcbizorgMap = new HashMap<Long, Long>(lotEntriesList.size());
        for (Map<String, Long> lotEntryItem : lotEntriesList) {
            Long lotid = lotEntryItem.get("lotid");
            Long billid = lotEntryItem.get("billid");
            Long entryid = lotEntryItem.get("entryid");
            Long srcbizorg = lotEntryItem.get("srcbizorg");
            billids.add(billid);
            entryids.add(entryid);
            entrylotMap.put(entryid, lotid);
            entrysrcbizorgMap.put(entryid, srcbizorg);
        }
        String cfg_billtype = unauditCfg.getDynamicObject("srcbillobj").getString("number");
        String cfg_entrytype = unauditCfg.getString("srcbillentry");
        String cfg_entrypath = LotMainFileConfigHelper.getEntryPath(cfg_billtype, cfg_entrytype);
        String cfg_entrypathId = cfg_entrypath + ".id";
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(cfg_entrypathId);
        HashSet<String> selectSourceCols = new HashSet<String>(lotmainfMaps.size());
        for (Map.Entry<String, DynamicObject> entry : lotmainfMaps.entrySet()) {
            selectSourceCols.add(entry.getValue().getString("mainfsrcbillcol"));
        }
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)cfg_billtype, (String)selectPropsBuilder.toString(), (QFilter[])new QFilter("id", "in", billids).and(cfg_entrypathId, "in", entryids).toArray());
        if (billentries != null && billentries.size() > 0) {
            String mainfUpdateSql = this.buildMainfUpdateSql(lotmainfMaps);
            ArrayList<Object[]> mainfUpdateParams = new ArrayList<Object[]>(1000);
            for (DynamicObject billentry : billentries) {
                Long entryid = billentry.getLong(cfg_entrypathId);
                Long lotid = (Long)entrylotMap.get(entryid);
                Long srcbizorg = (Long)entrysrcbizorgMap.get(entryid);
                Object[] mainfUpdateParam = this.genMainfUpdateParam(lotmainfMaps, lotid, billentry, srcbizorg);
                mainfUpdateParams.add(mainfUpdateParam);
                if (mainfUpdateParams.size() != 1000) continue;
                LotMainFileUnhandleOperator.executeBatchSql(mainfUpdateParams, mainfUpdateSql);
            }
            if (mainfUpdateParams.size() > 0) {
                LotMainFileUnhandleOperator.executeBatchSql(mainfUpdateParams, mainfUpdateSql);
            }
        }
    }

    private LinkedHashMap<String, DynamicObject> getLotmainfMaps(DynamicObject unauditCfg) {
        LinkedHashMap<String, DynamicObject> lotmainfMaps = LotMainFileConfigHelper.getLotmainfMaps(unauditCfg);
        if (lotmainfMaps == null || lotmainfMaps.size() == 0) {
            return null;
        }
        lotmainfMaps.remove("number");
        lotmainfMaps.remove("material");
        lotmainfMaps.remove("creator");
        lotmainfMaps.remove("instockdate");
        return lotmainfMaps;
    }

    private String buildMainfUpdateSql(LinkedHashMap<String, DynamicObject> lotmainfMaps) {
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_lot set flotstatus = ?, fcurrentorgid = ?");
        Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_lot").getAllFields();
        for (String tarcol : lotmainfMaps.keySet()) {
            builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias()).append(" = ?");
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private Object[] genMainfUpdateParam(LinkedHashMap<String, DynamicObject> lotmainfMaps, Long lotid, DynamicObject billentry, Long srcbizorg) {
        Object[] mainfUpdateParam = new Object[3 + lotmainfMaps.size()];
        mainfUpdateParam[0] = "A";
        mainfUpdateParam[1] = srcbizorg;
        int i = 2;
        for (Map.Entry<String, DynamicObject> srccol : lotmainfMaps.entrySet()) {
            mainfUpdateParam[i] = billentry.get(srccol.getValue().getString("mainfsrcbillcol"));
            ++i;
        }
        mainfUpdateParam[i] = lotid;
        return mainfUpdateParam;
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }
}

