/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.formPlugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;

public class SelectLotPlugin
extends AbstractFormPlugin
implements SetFilterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String CONFIRM = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void setFilter(SetFilterEvent paramSetFilterEvent) {
        QFilter filter = this.getQFilter();
        if (filter != null) {
            paramSetFilterEvent.setCustomQFilters(Collections.singletonList(filter));
        }
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        QFilter filter = this.getQFilter();
        if (filter != null) {
            billList.getFilterParameter().setFilter(filter);
        }
    }

    private QFilter getQFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object filterObj = customParams.get("filter");
        if (filterObj != null) {
            QFilter filter = QFilter.fromSerializedString((String)((String)filterObj));
            filter = filter.and("lotstatus", "=", (Object)"A");
            return filter;
        }
        return null;
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "btnok": {
                this.returnSelectedResult();
                break;
            }
        }
    }

    private void returnSelectedResult() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5206\u5f55", (String)"SelectLotPlugin_NotChooseRecord", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String lotidfield = (String)customParams.get("lotidfield");
        String lotnumfield = (String)customParams.get("lotnumfield");
        HashMap<String, Object> lotAttr = new HashMap<String, Object>(4);
        lotAttr.put("lotidfield", LotMainFileConfigHelper.getIdent(lotidfield));
        lotAttr.put("lotnumfield", LotMainFileConfigHelper.getIdent(lotnumfield));
        for (ListSelectedRow listSelectedRow : selectedRows) {
            lotAttr.put("lotid", listSelectedRow.getPrimaryKeyValue());
            lotAttr.put("lotnumber", listSelectedRow.getNumber());
        }
        this.getView().returnDataToParent(lotAttr);
        this.getView().close();
    }
}

